/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.io;

import de.quippy.jflac.util.ByteData;
import de.quippy.jflac.util.CRC16;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream {
    private static final int BITS_PER_BLURB = 8;
    private static final int BITS_PER_BLURB_LOG2 = 3;
    private static final byte BLURB_TOP_BIT_ONE = -128;
    private static final int BUFFER_CHUNK_SIZE = 1024;
    private byte[] buffer = new byte[1024];
    private int putByte = 0;
    private int getByte = 0;
    private int getBit = 0;
    private int availBits = 0;
    private int totalBitsRead = 0;
    private short readCRC16 = 0;
    private InputStream inStream;

    public BitInputStream(InputStream inputStream) {
        this.inStream = inputStream;
    }

    private int readFromStream() throws IOException {
        if (this.getByte > 0 && this.putByte > this.getByte) {
            System.arraycopy(this.buffer, this.getByte, this.buffer, 0, this.putByte - this.getByte);
        }
        this.putByte -= this.getByte;
        this.getByte = 0;
        int n = this.buffer.length - this.putByte;
        if ((n = this.inStream.read(this.buffer, this.putByte, n)) <= 0) {
            throw new EOFException();
        }
        this.putByte += n;
        this.availBits += n << 3;
        return n;
    }

    public void skip(long l) throws IOException {
        while (l > 0L) {
            l -= this.inStream.skip(l);
        }
        this.reset();
    }

    public void reset() {
        this.getByte = 0;
        this.getBit = 0;
        this.putByte = 0;
        this.availBits = 0;
    }

    public void resetReadCRC16(short s) {
        this.readCRC16 = s;
    }

    public short getReadCRC16() {
        return this.readCRC16;
    }

    public boolean isConsumedByteAligned() {
        return (this.getBit & 7) == 0;
    }

    public int bitsLeftForByteAlignment() {
        return 8 - (this.getBit & 7);
    }

    public int getInputBytesUnconsumed() {
        return this.availBits >> 3;
    }

    public void skipBitsNoCRC(int n) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        int n3 = this.getBit & 7;
        if (n3 != 0) {
            n2 = Math.min(8 - n3, n);
            this.readRawUInt(n2);
            n -= n2;
        }
        if ((n2 = n / 8) > 0) {
            this.readByteBlockAlignedNoCRC(null, n2);
            n %= 8;
        }
        if (n > 0) {
            this.readRawUInt(n);
        }
    }

    public int readBit() throws IOException {
        while (true) {
            if (this.availBits > 0) {
                int n = (this.buffer[this.getByte] & 128 >> this.getBit) != 0 ? 1 : 0;
                ++this.getBit;
                if (this.getBit == 8) {
                    this.readCRC16 = CRC16.update(this.buffer[this.getByte], this.readCRC16);
                    ++this.getByte;
                    this.getBit = 0;
                }
                --this.availBits;
                ++this.totalBitsRead;
                return n;
            }
            this.readFromStream();
        }
    }

    public int readBitToInt(int n) throws IOException {
        while (true) {
            if (this.availBits > 0) {
                n <<= 1;
                n |= (this.buffer[this.getByte] & 128 >> this.getBit) != 0 ? 1 : 0;
                ++this.getBit;
                if (this.getBit == 8) {
                    this.readCRC16 = CRC16.update(this.buffer[this.getByte], this.readCRC16);
                    ++this.getByte;
                    this.getBit = 0;
                }
                --this.availBits;
                ++this.totalBitsRead;
                return n;
            }
            this.readFromStream();
        }
    }

    public int peekBitToInt(int n, int n2) throws IOException {
        while (true) {
            if (n2 < this.availBits) {
                n <<= 1;
                n = this.getBit + n2 >= 8 ? (n |= (this.buffer[this.getByte + 1] & 128 >> (n2 = (this.getBit + n2) % 8)) != 0 ? 1 : 0) : (n |= (this.buffer[this.getByte] & 128 >> this.getBit + n2) != 0 ? 1 : 0);
                return n;
            }
            this.readFromStream();
        }
    }

    public long readBitToLong(long l) throws IOException {
        while (true) {
            if (this.availBits > 0) {
                l <<= 1;
                l |= (long)((this.buffer[this.getByte] & 128 >> this.getBit) != 0 ? 1 : 0);
                ++this.getBit;
                if (this.getBit == 8) {
                    this.readCRC16 = CRC16.update(this.buffer[this.getByte], this.readCRC16);
                    ++this.getByte;
                    this.getBit = 0;
                }
                --this.availBits;
                ++this.totalBitsRead;
                return l;
            }
            this.readFromStream();
        }
    }

    public int readRawUInt(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = this.readBitToInt(n2);
            ++n3;
        }
        return n2;
    }

    public int peekRawUInt(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = this.peekBitToInt(n2, n3);
            ++n3;
        }
        return n2;
    }

    public int readRawInt(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = this.readBitToInt(n2);
            ++n3;
        }
        int n4 = 32 - n;
        if (n4 != 0) {
            n3 = n2 <<= n4;
            n3 >>= n4;
        } else {
            n3 = n2;
        }
        return n3;
    }

    public long readRawULong(int n) throws IOException {
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            l = this.readBitToLong(l);
            ++n2;
        }
        return l;
    }

    public int readRawIntLittleEndian() throws IOException {
        int n = this.readRawUInt(8);
        int n2 = this.readRawUInt(8);
        n |= n2 << 8;
        n2 = this.readRawUInt(8);
        n |= n2 << 16;
        n2 = this.readRawUInt(8);
        return n |= n2 << 24;
    }

    public void readByteBlockAlignedNoCRC(byte[] byArray, int n) throws IOException {
        int n2 = n;
        while (n > 0) {
            int n3 = Math.min(n, this.putByte - this.getByte);
            if (n3 == 0) {
                this.readFromStream();
                continue;
            }
            if (byArray != null) {
                System.arraycopy(this.buffer, this.getByte, byArray, n2 - n, n3);
            }
            n -= n3;
            this.getByte += n3;
            this.availBits -= n3 << 3;
            this.totalBitsRead += n3 << 3;
        }
    }

    public int readUnaryUnsigned() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.readBit()) == 0) {
            ++n2;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public void readRiceSignedBlock(int[] var1_1, int var2_2, int var3_3, int var4_4) throws IOException {
        var6_5 = 0;
        var7_6 = 0;
        var8_7 = 0;
        var9_8 = 0;
        var10_9 = 0;
        var13_10 = 0;
        if (var3_3 == 0) {
            return;
        }
        var14_11 = this.getByte;
        var15_12 = this.getByte * 8 + this.getBit;
        if (this.getBit <= 0) ** GOTO lbl123
        var12_14 = var11_13 = this.buffer[var14_11];
        var7_6 = this.getBit;
        var11_13 = (byte)(var11_13 << var7_6);
        while (true) {
            if (var13_10 == 0) {
                if (var11_13 != 0) {
                    var5_15 = 0;
                    while ((var11_13 & -128) == 0) {
                        var11_13 = (byte)(var11_13 << 1);
                        ++var5_15;
                    }
                    var9_8 += var5_15;
                    var11_13 = (byte)(var11_13 << 1);
                    var8_7 = 0;
                    var10_9 = var4_4;
                    ++var13_10;
                    if ((var7_6 += ++var5_15) != 8) continue;
                    var7_6 = 0;
                    this.readCRC16 = CRC16.update(var12_14, this.readCRC16);
                    break;
                }
                var9_8 += 8 - var7_6;
                var7_6 = 0;
                this.readCRC16 = CRC16.update(var12_14, this.readCRC16);
                break;
            }
            var17_16 = 8 - var7_6;
            if (var10_9 >= var17_16) {
                var8_7 <<= var17_16;
                var8_7 |= (var11_13 & 255) >> var7_6;
                var7_6 = 0;
                this.readCRC16 = CRC16.update(var12_14, this.readCRC16);
                if (var10_9 == var17_16) {
                    var1_1[var2_2 + var6_5++] = ((var8_7 |= var9_8 << var4_4) & 1) != 0 ? -(var8_7 >> 1) - 1 : var8_7 >> 1;
                    if (var6_5 == var3_3) break;
                    var9_8 = 0;
                    var13_10 = 0;
                }
                var10_9 -= var17_16;
                break;
            }
            var8_7 <<= var10_9;
            var8_7 |= (var11_13 & 255) >> 8 - var10_9;
            var11_13 = (byte)(var11_13 << var10_9);
            var7_6 += var10_9;
            var1_1[var2_2 + var6_5++] = ((var8_7 |= var9_8 << var4_4) & 1) != 0 ? -(var8_7 >> 1) - 1 : var8_7 >> 1;
            if (var6_5 == var3_3) {
                --var14_11;
                break;
            }
            var9_8 = 0;
            var13_10 = 0;
        }
        this.getByte = ++var14_11;
        this.getBit = var7_6;
        ** GOTO lbl123
        {
            var12_14 = var11_13 = this.buffer[var14_11];
            var7_6 = 0;
            while (true) {
                if (var13_10 == 0) {
                    if (var11_13 != 0) {
                        var5_15 = 0;
                        while ((var11_13 & -128) == 0) {
                            var11_13 = (byte)(var11_13 << 1);
                            ++var5_15;
                        }
                        var9_8 += var5_15;
                        var11_13 = (byte)(var11_13 << 1);
                        var8_7 = 0;
                        var10_9 = var4_4;
                        ++var13_10;
                        if ((var7_6 += ++var5_15) != 8) continue;
                        var7_6 = 0;
                        this.readCRC16 = CRC16.update(var12_14, this.readCRC16);
                        break;
                    }
                    var9_8 += 8 - var7_6;
                    var7_6 = 0;
                    this.readCRC16 = CRC16.update(var12_14, this.readCRC16);
                    break;
                }
                var17_17 = 8 - var7_6;
                if (var10_9 >= var17_17) {
                    var8_7 <<= var17_17;
                    var8_7 |= (var11_13 & 255) >> var7_6;
                    var7_6 = 0;
                    this.readCRC16 = CRC16.update(var12_14, this.readCRC16);
                    if (var10_9 == var17_17) {
                        var1_1[var2_2 + var6_5++] = ((var8_7 |= var9_8 << var4_4) & 1) != 0 ? -(var8_7 >> 1) - 1 : var8_7 >> 1;
                        if (var6_5 == var3_3) break;
                        var9_8 = 0;
                        var13_10 = 0;
                    }
                    var10_9 -= var17_17;
                    break;
                }
                var8_7 <<= var10_9;
                var8_7 |= (var11_13 & 255) >> 8 - var10_9;
                var11_13 = (byte)(var11_13 << var10_9);
                var7_6 += var10_9;
                var1_1[var2_2 + var6_5++] = ((var8_7 |= var9_8 << var4_4) & 1) != 0 ? -(var8_7 >> 1) - 1 : var8_7 >> 1;
                if (var6_5 == var3_3) {
                    --var14_11;
                    break;
                }
                var9_8 = 0;
                var13_10 = 0;
            }
            ++var14_11;
            do {
                if (var14_11 < this.putByte && var6_5 < var3_3) continue block2;
                this.getByte = var14_11;
                this.getBit = var7_6;
                if (var6_5 >= var3_3) continue;
                var17_18 = this.getByte * 8 + this.getBit;
                this.totalBitsRead = (int)((long)this.totalBitsRead + (var17_18 - var15_12));
                this.availBits = (int)((long)this.availBits - (var17_18 - var15_12));
                this.readFromStream();
                var14_11 = 0;
                var15_12 = this.getByte * 8 + this.getBit;
lbl123:
                // 4 sources

            } while (var6_5 < var3_3);
        }
        var17_19 = this.getByte * 8 + this.getBit;
        this.totalBitsRead = (int)((long)this.totalBitsRead + (var17_19 - var15_12));
        this.availBits = (int)((long)this.availBits - (var17_19 - var15_12));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readUTF8Int(ByteData byteData) throws IOException {
        int n;
        int n2 = 0;
        int n3 = this.readRawUInt(8);
        if (byteData != null) {
            byteData.append((byte)n3);
        }
        if ((n3 & 0x80) == 0) {
            n2 = n3;
            n = 0;
        } else if ((n3 & 0xC0) != 0 && (n3 & 0x20) == 0) {
            n2 = n3 & 0x1F;
            n = 1;
        } else if ((n3 & 0xE0) != 0 && (n3 & 0x10) == 0) {
            n2 = n3 & 0xF;
            n = 2;
        } else if ((n3 & 0xF0) != 0 && (n3 & 8) == 0) {
            n2 = n3 & 7;
            n = 3;
        } else if ((n3 & 0xF8) != 0 && (n3 & 4) == 0) {
            n2 = n3 & 3;
            n = 4;
        } else {
            if ((n3 & 0xFC) == 0) return -1;
            if ((n3 & 2) != 0) return -1;
            n2 = n3 & 1;
            n = 5;
        }
        while (n > 0) {
            n3 = this.peekRawUInt(8);
            if ((n3 & 0x80) == 0) return -1;
            if ((n3 & 0x40) != 0) {
                return -1;
            }
            n3 = this.readRawUInt(8);
            if (byteData != null) {
                byteData.append((byte)n3);
            }
            n2 <<= 6;
            n2 |= n3 & 0x3F;
            --n;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long readUTF8Long(ByteData byteData) throws IOException {
        int n;
        long l = 0L;
        int n2 = this.readRawUInt(8);
        if (byteData != null) {
            byteData.append((byte)n2);
        }
        if ((n2 & 0x80) == 0) {
            l = n2;
            n = 0;
        } else if ((n2 & 0xC0) != 0 && (n2 & 0x20) == 0) {
            l = n2 & 0x1F;
            n = 1;
        } else if ((n2 & 0xE0) != 0 && (n2 & 0x10) == 0) {
            l = n2 & 0xF;
            n = 2;
        } else if ((n2 & 0xF0) != 0 && (n2 & 8) == 0) {
            l = n2 & 7;
            n = 3;
        } else if ((n2 & 0xF8) != 0 && (n2 & 4) == 0) {
            l = n2 & 3;
            n = 4;
        } else if ((n2 & 0xFC) != 0 && (n2 & 2) == 0) {
            l = n2 & 1;
            n = 5;
        } else {
            if ((n2 & 0xFE) == 0) return -1L;
            if ((n2 & 1) != 0) return -1L;
            l = 0L;
            n = 6;
        }
        while (n > 0) {
            n2 = this.peekRawUInt(8);
            if ((n2 & 0x80) == 0) return -1L;
            if ((n2 & 0x40) != 0) {
                return -1L;
            }
            n2 = this.readRawUInt(8);
            if (byteData != null) {
                byteData.append((byte)n2);
            }
            l <<= 6;
            l |= (long)(n2 & 0x3F);
            --n;
        }
        return l;
    }

    public int getTotalBytesRead() {
        return (this.totalBitsRead + 7) / 8;
    }
}

