/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3v2FormatException;
import de.quippy.javamod.system.Helpers;

public class ID3v2Frame {
    private static final int FRAME_HEAD_SIZE = 10;
    private static final int FRAME_FLAGS_SIZE = 2;
    private static final int MAX_EXTRA_DATA = 5;
    private static final String[] ENC_TYPES = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
    private String id = null;
    private boolean tagAlterDiscard = false;
    private boolean fileAlterDiscard = false;
    private boolean readOnly = false;
    private boolean grouped = false;
    private boolean compressed = false;
    private boolean encrypted = false;
    private boolean unsynchronised = false;
    private boolean lengthIndicator = false;
    private byte group = 0;
    private byte encrType = 0;
    private int dataLength = -1;
    private byte[] frameData;

    public ID3v2Frame(String string, byte[] byArray) {
        this.id = string;
        this.fileAlterDiscard = this.checkDefaultFileAlterDiscard();
        this.parseData(byArray);
    }

    public ID3v2Frame(String string, byte[] byArray, byte[] byArray2) throws ID3v2FormatException {
        this(string, byArray2);
        this.parseFlags(byArray);
    }

    public ID3v2Frame(String string, byte[] byArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.id = string;
        this.tagAlterDiscard = bl;
        this.fileAlterDiscard = bl2;
        this.readOnly = bl3;
        this.grouped = bl4;
        this.compressed = bl5;
        this.encrypted = bl6;
        this.unsynchronised = bl7;
        this.lengthIndicator = bl8;
        this.group = 0;
        this.encrType = 0;
        this.dataLength = -1;
        this.parseData(byArray);
    }

    private boolean checkDefaultFileAlterDiscard() {
        return this.id.equals("ASPI") || this.id.equals("AENC") || this.id.equals("ETCO") || this.id.equals("EQU2") || this.id.equals("MLLT") || this.id.equals("POSS") || this.id.equals("SEEK") || this.id.equals("SYLT") || this.id.equals("SYTC") || this.id.equals("RVA2") || this.id.equals("TENC") || this.id.equals("TLEN");
    }

    private void parseFlags(byte[] byArray) throws ID3v2FormatException {
        if (byArray.length != 2) {
            throw new ID3v2FormatException("Error parsing flags of frame: " + this.id + ".  Expected 2 bytes.");
        }
        this.tagAlterDiscard = (byArray[0] & 0x40) != 0;
        this.fileAlterDiscard = (byArray[0] & 0x20) != 0;
        this.readOnly = (byArray[0] & 0x10) != 0;
        this.grouped = (byArray[1] & 0x40) != 0;
        this.compressed = (byArray[1] & 8) != 0;
        this.encrypted = (byArray[1] & 4) != 0;
        this.unsynchronised = (byArray[1] & 2) != 0;
        boolean bl = this.lengthIndicator = (byArray[1] & 1) != 0;
        if (this.compressed && !this.lengthIndicator) {
            throw new ID3v2FormatException("Error parsing flags of frame: " + this.id + ".  Compressed bit set without data length bit set.");
        }
    }

    private byte[] getFlagBytes() {
        byte[] byArray = new byte[2];
        if (this.tagAlterDiscard) {
            byArray[0] = (byte)(byArray[0] | 0x40);
        }
        if (this.fileAlterDiscard) {
            byArray[0] = (byte)(byArray[0] | 0x20);
        }
        if (this.readOnly) {
            byArray[0] = (byte)(byArray[0] | 0x10);
        }
        if (this.grouped) {
            byArray[1] = (byte)(byArray[1] | 0x40);
        }
        if (this.compressed) {
            byArray[1] = (byte)(byArray[1] | 8);
        }
        if (this.encrypted) {
            byArray[1] = (byte)(byArray[1] | 4);
        }
        if (this.unsynchronised) {
            byArray[1] = (byte)(byArray[1] | 2);
        }
        if (this.lengthIndicator) {
            byArray[1] = (byte)(byArray[1] | 1);
        }
        return byArray;
    }

    private void parseData(byte[] byArray) {
        int n = 0;
        if (this.grouped) {
            this.group = byArray[n];
            ++n;
        }
        if (this.encrypted) {
            this.encrType = byArray[n];
            ++n;
        }
        if (this.lengthIndicator) {
            this.dataLength = Helpers.convertDWordToInt(byArray, n);
            n += 4;
        }
        this.frameData = new byte[byArray.length - n];
        System.arraycopy(byArray, n, this.frameData, 0, this.frameData.length);
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    public void setFrameData(byte[] byArray) {
        if (!this.readOnly) {
            this.frameData = byArray;
        }
    }

    public int getFrameLength() {
        int n = this.frameData.length + 10;
        if (this.grouped) {
            ++n;
        }
        if (this.encrypted) {
            ++n;
        }
        if (this.lengthIndicator) {
            n += 4;
        }
        return n;
    }

    public byte[] getFrameBytes() {
        int n = this.getFrameLength();
        int n2 = 0;
        byte[] byArray = this.getFlagBytes();
        byte[] byArray2 = this.getExtraDataBytes();
        byte[] byArray3 = new byte[n];
        System.arraycopy(this.id.getBytes(), 0, byArray3, 0, this.id.length());
        System.arraycopy(Helpers.convertIntToDWord(n), 0, byArray3, n2 += this.id.length(), 4);
        System.arraycopy(byArray, 0, byArray3, n2 += 4, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n2 += byArray.length, byArray2.length);
        System.arraycopy(this.frameData, 0, byArray3, n2 += byArray2.length, this.frameData.length);
        n2 += this.frameData.length;
        return byArray3;
    }

    private byte[] getExtraDataBytes() {
        byte[] byArray = new byte[5];
        int n = 0;
        if (this.grouped) {
            byArray[n] = this.group;
            ++n;
        }
        if (this.encrypted) {
            byArray[n] = this.encrType;
            ++n;
        }
        if (this.lengthIndicator) {
            System.arraycopy(Helpers.convertIntToDWord(this.dataLength), 0, byArray, n, 4);
            n += 4;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public boolean getTagAlterDiscard() {
        return this.tagAlterDiscard;
    }

    public boolean getFileAlterDiscard() {
        return this.fileAlterDiscard;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getGrouped() {
        return this.grouped;
    }

    public boolean getCompressed() {
        return this.compressed;
    }

    public boolean getEncrypted() {
        return this.encrypted;
    }

    public boolean getUnsynchronised() {
        return this.unsynchronised;
    }

    public boolean getLengthIndicator() {
        return this.lengthIndicator;
    }

    public byte getGroup() {
        return this.group;
    }

    public byte getEncryptionType() {
        return this.encrType;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getDataString() throws ID3v2FormatException {
        String string = null;
        if (this.frameData.length > 1) {
            try {
                if (this.id.charAt(0) == 'T' || this.id.equals("OWNE")) {
                    string = Helpers.retrieveAsString(this.frameData, 1, this.frameData.length - 1, ENC_TYPES[this.frameData[0]]);
                } else if (this.id.charAt(0) == 'W') {
                    string = new String(this.frameData);
                } else if (this.id.equals("WXXX")) {
                    string = Helpers.retrieveAsString(this.frameData, 1, this.frameData.length - 1, ENC_TYPES[this.frameData[0]]);
                    if (string.length() < this.frameData.length - 1) {
                        string = String.valueOf(string) + '\n';
                        string = String.valueOf(string) + Helpers.retrieveAsString(this.frameData, string.length() + 2, this.frameData.length - 2 - string.length(), ENC_TYPES[this.frameData[0]]);
                    }
                } else if (this.id.equals("USLT") || this.id.equals("COMM") || this.id.equals("USER")) {
                    string = Helpers.retrieveAsString(this.frameData, 4, this.frameData.length - 4, ENC_TYPES[this.frameData[0]]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ID3v2FormatException("Frame: " + this.id + " has not specified a valid encoding type.");
            }
        }
        return string;
    }

    public String toString() {
        try {
            return String.valueOf(this.id) + "\nTagAlterDiscard:\t\t" + this.tagAlterDiscard + "\nFileAlterDiscard:\t\t" + this.fileAlterDiscard + "\nReadOnly:\t\t\t" + this.readOnly + "\nGrouped:\t\t\t" + this.grouped + "\nCompressed:\t\t\t" + this.compressed + "\nEncrypted:\t\t\t" + this.encrypted + "\nUnsynchronised:\t\t\t" + this.unsynchronised + "\nLengthIndicator:\t\t" + this.lengthIndicator + "\nData:\t\t\t\t" + this.getDataString().toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

