/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist;

import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class PlayListEntry {
    private URL file;
    private boolean isActive;
    private boolean isSelected;
    private String songName;
    private Long duration;
    private Long timeIndexInFile;
    private PlayList playList;

    public PlayListEntry(URL uRL, PlayList playList) {
        this.file = uRL;
        this.playList = playList;
    }

    public PlayListEntry(File file, PlayList playList) throws MalformedURLException {
        this(file.toURI().toURL(), playList);
    }

    public PlayListEntry(String string, PlayList playList) throws MalformedURLException {
        this(new URL(string), playList);
    }

    public URL getFile() {
        return this.file;
    }

    public void setFile(URL uRL) {
        this.file = uRL;
    }

    public synchronized void setSongName(String string) {
        this.songName = string;
    }

    public synchronized void setDuration(Long l) {
        this.duration = l;
    }

    public synchronized void setDuration(long l) {
        this.duration = l;
    }

    public synchronized void setTimeIndexInFile(Long l) {
        this.timeIndexInFile = l;
    }

    public synchronized void setTimeIndexInFile(long l) {
        this.timeIndexInFile = l;
    }

    public synchronized String getFormattedName() {
        if (this.songName == null) {
            Object[] objectArray = MultimediaContainerManager.getSongInfosFor(this.file);
            this.songName = (String)objectArray[0];
            if (this.duration == null) {
                this.duration = (Long)objectArray[1];
            }
        }
        return this.songName;
    }

    public synchronized long getDuration() {
        if (this.duration == null) {
            Object[] objectArray = MultimediaContainerManager.getSongInfosFor(this.file);
            this.duration = (Long)objectArray[1];
            if (this.songName == null) {
                this.songName = (String)objectArray[0];
            }
        }
        return this.duration;
    }

    public synchronized String getDurationString() {
        return Helpers.getTimeStringFromMilliseconds(this.getDuration());
    }

    public synchronized String getTimeIndexString() {
        if (this.timeIndexInFile == null) {
            return " ";
        }
        return Helpers.getTimeStringFromMilliseconds(this.timeIndexInFile);
    }

    public synchronized long getTimeIndex() {
        if (this.timeIndexInFile == null) {
            return 0L;
        }
        return this.timeIndexInFile;
    }

    public synchronized String getQuickSongName() {
        if (this.songName == null) {
            return MultimediaContainerManager.getSongNameFromURL(this.getFile());
        }
        return this.getFormattedName();
    }

    public synchronized String getQuickDuration() {
        if (this.duration == null) {
            return " ";
        }
        return this.getDurationString();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public int getIndexInPlaylist() {
        if (this.playList != null) {
            return this.playList.indexOf(this);
        }
        return -1;
    }

    public void setSavedInPlaylist(PlayList playList) {
        this.playList = playList;
    }

    public String toString() {
        return this.file.toString();
    }
}

