//---------------------------------------------------------------------------------
#ifndef G__CONSTANTS_H
#define G__CONSTANTS_H

const double PI = 3.141592653590; // the circular constant

const double G_E0 = 8.854e-12;// absolute permittivity of vacuum (F/m)
const double G_U0 = 4*PI*1e-7; // absolute permeability of vacuum (H/m)

const double G_E = 1.60210e-19; // charge of an electron (C)

const double G_ME = 9.1091e-31; // mass of an electron (kg)
const double G_MA = 1.67252e-27; // mass of a proton (kg)

const double G_C0 = 2.997925e8; // light velocity in vacuum (m/sec)

const double G_KCU = 5.800e7; // cupper consuctivity (moh/m)

const double G_G = 9.807; // gravity accelaration (m/sec^2)

const double G_K = 1.380e-23; // Boltzmann's constant (J/K)
const double G_H = 6.625e-34; // Planck's constant (J*sec)
const double G_N = 6.025e26; // Avogadro's number (1/kg/mol)

#define ZERO 0.0001
#define LJSQR(a) if(a>0) a=pow(a,1.0/2.0);else a=0.0;

double SQRT(double d)
{
	double a = 0;
	if(d>0) 
		a=pow(d, 0.5);
	return a;
}

double max(double d0, double d1)
{
	if(d0 < d1)
		return d1;
	else
		return d0;
}

#endif

double operator^(double d0, double d1)
{
	return pow(d0, d1);
}


//---------------------------------------------------------------------------------
#ifndef G__CSTRING_H
#define G__CSTRING_H

int StringLength(char *pStr)
{
	if(pStr == 0)
		return 0;

	if(pStr != 0 && pStr[0] != '\0')		
		return strlen(pStr); 
	
	return 0;
}

char *StringCopy(char *pStr)
{
	int nCount = StringLength(pStr);
	char *pString = new char[nCount+1]; 
	if(pStr != 0 )
		strcpy(pString, pStr); 
	else
		pString[0] = '\0';
	
	return pString;
}

char *StringMid(char *pStr, unsigned int uiBegin, unsigned int uiLength) 
{ 
	int iLen = StringLength(pStr); 
	
	if(uiBegin>iLen) 
		uiBegin = iLen; 
	if(uiLength>(iLen-uiBegin)) 
		uiLength = iLen-uiBegin; 
	
	char *tmp = new char[uiLength+1]; 	
	strncpy(tmp, pStr + uiBegin, uiLength); 
	tmp[uiLength] = '\0'; 
	
	return tmp; 
} 

char *StringMid(char *pStr, unsigned int uiBegin) 
{
	return StringMid(pStr, uiBegin, StringLength(pStr));
}

int StringFind(char *pStr, char *strKey, unsigned int uiBegin)
{ 		
	int nLength = StringLength(pStr);	
	if (uiBegin > nLength)
		return -1;
	
	// find first matching substring
	char *tmp = strstr(pStr + uiBegin, strKey);		
	return (tmp == 0) ? -1 : (int)(tmp - pStr);
} 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class CString 
{ 
public: 
	
	/*캯 Begin*/ 
	CString(); 
	CString(const char *pStr); 
	CString(CString &CStringSrc); 
	CString(const char ch, const unsigned int uiRepeat = 1); 
	CString(const char *pStr, unsigned int uiLen, unsigned int uiBegin = 0); 
	CString(CString &CStringSrc, unsigned int uiLen, unsigned int uiBegin = 0); 
	/*캯 End*/ 
	
	/* Begin*/ 
	~CString(); 
	/* End*/ 
	
	/*Ա Begin*/ 
	unsigned int GetLength(void); 
	char *GetBuffer(void); 
	bool IsEmpty(void); 
	void Empty(void); 
	char GetAt(unsigned int uiIndex); 
	void SetAt(unsigned int uiIndex, char ch); 
	//ڱȽϵĺ 
	int Compare(const char *str); 
	int Compare(CString &Str); 
	int CompareNoCase(const char *str); 
	int CompareNoCase(CString &Str); 
	//ַȡ 
	CString &Right(unsigned int uiLength); 
	CString &Left(unsigned int uiLength); 
	CString &Mid(unsigned int uiBegin); 
	CString &Mid(unsigned int uiBegin, unsigned int uiLength); 
	//Сת 
	CString &MakeUpper(void); 
	CString &MakeLower(void); 
	CString &MakeReverse(void); 
	//ַ(û,ɾ,ӵ) 
	CString &Replace(char chOld, char chNew); 
	CString &Replace(char *pOld, char *pNew); 
	CString &Insert(unsigned int uiIndex, char ch); 
	CString &Insert(unsigned int uiIndex, char *str); 
	CString &Remove(char ch); 
	CString &Delete(unsigned int uiIndex, unsigned int uiCount = 1); 
	CString &TrimLeft(void); 
	CString &TrimLeft(char ch); 
	CString &TrimLeft(char *str); 
	CString &TrimRight(void); 
	CString &TrimRight(char ch); 
	CString &TrimRight(char *str); 
	//Һ 
	int Find(char ch, unsigned int uiBegin = 0); 
	int Find(char *str, unsigned int uiBegin = 0); 
	int ReverseFind(char ch); 
	int FindOneOf(char *str); 
	/*Ա End*/ 
	
	/*صĲ Begin*/ 
	//ΪԱ 
	CString& operator= (const char ch); 
	CString&   operator= (const char *pStr); 
	CString&   operator= (CString &Str); 
	CString&     operator+=(const char ch); 
	CString&   operator+=(const char *str); 
	CString&   operator+=(CString &Str); 
	const char& operator[](unsigned int n); 
	//ΪԪ 
	friend CString&operator+ (CString &Str1, CString &Str2); 
	friend CString&operator+ (CString &Str, const char *str); 
	friend CString&operator+ (const char *str, CString &Str); 
	friend CString&operator+ (CString &Str, char ch); 
	friend CString&operator+ (char ch, CString &Str); 
	friend bool operator==(CString &Str1, CString &Str2); 
	friend bool operator==(CString &Str, const char *str); 
	friend bool operator==(const char *str, CString &Str); 
	friend bool operator!=(const CString &Str, const CString &Str); 
	friend bool operator!=(const CString &Str, const char *str); 
	friend bool operator!=(const char *str, const CString &Str); 
	friend bool operator< (const CString &Str1, const CString &Str2); 
	friend bool operator< (const CString &Str, const char *str); 
	friend bool operator< (const char *str, const CString &Str); 
	friend bool operator> (const CString &Str1, const CString &Str2); 
	friend bool operator> (const CString &Str, const char *str); 
	friend bool operator> (const char *str, const CString &Str); 
	friend bool operator<=(const CString &Str1, const CString &Str2); 
	friend bool operator<=(const CString &Str, const char *str); 
	friend bool operator<=(const char *str, const CString &Str); 
	friend bool operator>=(const CString &Str1, const CString &Str2); 
	friend bool operator>=(const CString &Str, const char *str); 
	friend bool operator>=(const char *str, const CString &Str); 
	/*صĲ End*/ 

	CString X2S();
	
public: 
	
	char *pString; //ָ洢ռ׵ַ 
	CString &Trim(int mode, char ch); 
}; 

CString CString::X2S()
{
	CString s = *this;
	return s;
}

CString::CString(){ 
	pString = new char[1]; 
	pString[0] = '\0'; 
} 

//pStrַָCString 
CString::CString(const char *pStr){ 
	int nCount = 0;
	if(pStr != 0)
		nCount = strlen(pStr);
	pString = new char[nCount+1]; 
	if(pStr != 0 )
		strcpy(pString, pStr); 
	else
		pString[0] = '\0'; 
} 

//һCString๹µCString 
CString::CString(CString &CStringSrc)
{ 
	if(CStringSrc.pString != 0)
	{
 		pString = new char[CStringSrc.GetLength()+1]; 
 		strcpy(pString, CStringSrc.pString); 
	}
	else
	{
		pString = new char[1]; 
		pString[0] = '\0'; 
	}
} 

//һַchCString,uiRepeatΪַchظ,ʡʹuiRepeatΪ1 
CString::CString(const char ch, const unsigned int uiRepeat){ 
	pString = new char[uiRepeat+1]; 
	int i; 
	for(i=0; i<uiRepeat; i++) 
		pString[i] = ch; 
	
	pString[i] = '\0'; 
} 

//ָpStrַָΪ,ȡдuiBeginλÿʼuiLengthַ,ڹCString 
CString::CString(const char *pStr, //ַܵ 
				 unsigned int uiLength, //ַܵ 
				 unsigned int uiBegin){ //ܵĿʼλ,ĬΪ0,pStrĵһռ俪ʼ 
	unsigned int uiLen = strlen(pStr); 
	
	if(uiBegin>uiLen) 
		uiBegin = uiLen; 
	if(uiLength>uiLen-uiBegin) 
		uiLength = uiLen-uiBegin; 
	
	pString = new char[uiLength+1]; 
	
	strncpy(pString, pStr+uiBegin, uiLength); 
	pString[uiLength] = '\0'; 
} 

//һCStringΪ,ȡ仺дuiBeginλÿʼuiLengthַ,ڹµCString 
CString::CString(CString &CStringSrc, //ܵCString 
				 unsigned int uiLength, //ַܵ 
				 unsigned int uiBegin){ //ܵĿʼλ,ĬΪ0,pStrĵһռ俪ʼ 
	unsigned int uiLen = CStringSrc.GetLength(); 
	
	if(uiBegin>uiLen) 
		uiBegin = uiLen; 
	if(uiLength>uiLen-uiBegin) 
		uiLength = uiLen-uiBegin; 
	
	pString = new char[uiLength+1]; 
	
	strncpy(pString, CStringSrc.pString+uiBegin, uiLength); 
	pString[uiLength] = '\0'; 
} 
/*幹캯 End*/ 

/* Begin*/ 
//CString,ɾʹõĻ 
CString::~CString(){ 
	if(pString){ 
		delete pString; 
	} 
} 
/* End*/ 

/*Ա Begin*/ 
//޲,pStringָĻĴС,'\0' 
unsigned int CString::GetLength(void)
{		
	if(pString != 0 && pString[0] != '\0')		
		return strlen(pString); 

	return 0;
} 

//޲,pStringָ,Ҫ<< 
char *CString::GetBuffer(void){ 
	return pString; 
} 

//޲,жpStringָĻǷΪ,Ϊ򷵻true,򷵻false 
bool CString::IsEmpty(void){ 
	return GetLength()?false:true; 
} 

//޲,pStringַָÿ 
void CString::Empty(void){ 
	if(pString){ 
		delete pString; 
	} 
	pString = new char[1]; 
	pString[0] = '\0'; 
} 

//һֵuiIndex,pString[uiIndex],uiIndexԽ,򷵻pString[GetLength()] 
char CString::GetAt(unsigned int uiIndex){ 
	if(uiIndex>=GetLength()){ 
		uiIndex = GetLength()-1; 
	} 
	
	return *(pString+uiIndex); 
} 

void CString::SetAt(unsigned int uiIndex, char ch){ 
	if(uiIndex>=GetLength()){ 
		uiIndex = GetLength()-1; 
	} 
	
	pString[uiIndex] = ch; 
} 

//ַȽ 
//ָstrַָȽ֮Ľ,ͬ0,Сڷ-1,ڷ1 
int CString::Compare(const char *str){ 
	return strcmp(pString, str); 
} 

//StrȽ֮Ľ,ͬ0,Сڷ-1,ڷ1 
int CString::Compare(CString &Str){ 
	return strcmp(pString, Str.pString); 
} 

//ָstrַָȽ֮Ľ(ԴСд),ͬ0,Сڷ-1,ڷ1 
int CString::CompareNoCase(const char *str){ 
	char *tmp1 = new char[GetLength()+1]; 
	strcpy(tmp1, pString); 
	tmp1 = strlwr(tmp1); 
	
	char *tmp2 = new char[strlen(str)]; 
	strcpy(tmp2, str); 
	tmp2 = strlwr(tmp2); 
	
	int n = strcmp(tmp1, tmp2); 
	
	delete tmp1; 
	delete tmp2; 
	
	return n; 
} 

//StrȽ֮Ľ(ԴСд),ͬ0,Сڷ-1,ڷ1 
int CString::CompareNoCase(CString &Str){ 
	char *tmp1 = new char[GetLength()+1]; 
	strcpy(tmp1, pString); 
	tmp1 = strlwr(tmp1); 
	
	char *tmp2 = new char[Str.GetLength()+1]; 
	strcpy(tmp2, Str.pString); 
	tmp2 = strlwr(tmp2); 
	
	int n = strcmp(tmp1, tmp2); 
	
	delete tmp1; 
	delete tmp2; 
	
	return strcmp(tmp1, tmp2); 
} 

//Ҳ⿪ʼȡǰַ,ΪuiLength 
CString &CString::Right(unsigned int uiLength) 
{ 
	if(uiLength>=GetLength()){ 
		Mid(0, uiLength); 
		return *this; 
	} 
	Mid(this->GetLength()-uiLength, uiLength); 
	return *this; 
} 

//࿪ʼȡǰַ,ΪuiLength 
CString &CString::Left(unsigned int uiLength) 
{ 
	Mid(0, uiLength); 
	return *this; 
} 

//uiBeginʼȡǰַ 
CString &CString::Mid(unsigned int uiBegin){ 
	Mid(uiBegin, GetLength()); 
	return *this; 
} 

//uiBeginʼȡǰַ,ȡuiLength 
CString &CString::Mid(unsigned int uiBegin, unsigned int uiLength) 
{ 
	int iLen = GetLength(); 
	
	if(uiBegin>iLen) 
		uiBegin = iLen; 
	if(uiLength>(iLen-uiBegin)) 
		uiLength = iLen-uiBegin; 
	
	char *tmp = new char[uiLength+1]; 
	
	strncpy(tmp, pString+uiBegin, uiLength); 
	tmp[uiLength] = '\0'; 
	
	delete pString; 
	pString = tmp; 
	return *this; 
} 

//ǰеַȫΪд 
CString &CString::MakeUpper(void){ 
	pString = strupr(pString); 
	return *this; 
} 

//ǰеַȫΪСд 
CString &CString::MakeLower(void){ 
	pString = strlwr(pString); 
	return *this; 
} 

//ǰеַ 
CString &CString::MakeReverse(void){ 
	pString = strrev(pString); 
	return *this; 
} 

//滻ַеַchOldΪchNew 
CString &CString::Replace(char chOld, char chNew){ 
	for(int i = 0;i<GetLength();i++){ 
		if(GetAt(i)==chOld){ 
			SetAt(i, chNew); 
		} 
	} 
	return *this; 
} 

//滻ַеַpOldΪpNew 
CString &CString::Replace(char *pOld, char *pNew){ 
	unsigned int uiTmp; 
	while(true){ 
		uiTmp = Find(pOld); 
		if(uiTmp==-1){ 
			break; 
		} 
		Delete(uiTmp, strlen(pOld)); 
		Insert(uiTmp, pNew); 
	} 
	return *this; 
} 

//ɾַеַch 
CString &CString::Remove(char ch){ 
	bool flag; 
		
	do{ 
		flag = false; 
		for(int i = 0;i<GetLength();i++){ 
			if(GetAt(i)==ch){ 
				Delete(i); 
				flag = true; 
			} 
		} 
	}while(flag); 
	
	return *this; 
} 

//ɾַдuiIndexʼuiCountַ 
CString &CString::Delete(unsigned int uiIndex, unsigned int uiCount){ 
	unsigned int uiLen = GetLength(); 
	
	if(uiIndex>=uiLen){ 
		return *this; 
	} 
	if(uiCount==0){ 
		return *this; 
	} 
	
	if(uiCount>uiLen-uiIndex){ 
		uiCount = uiLen-uiIndex; 
	} 
	
	char *tmp = new char[uiLen-uiCount+1]; 
	
	strncpy(tmp, pString, uiIndex); 
	tmp[uiIndex] = '\0'; 
	strcat(tmp, pString+uiIndex+uiCount); 
	
	delete pString; 
	pString = tmp; 
	return *this; 
} 

//ڶַΪuiIndexĵطַstr 
CString &CString::Insert(unsigned int uiIndex, char *str){ 
	unsigned int thisLen = GetLength(); 
	unsigned int uiLen = strlen(str); 
	
	if(uiIndex > thisLen){ 
		uiIndex = thisLen; 
	} 
	
	char *tmp = new char[thisLen + uiLen + 1]; 
	
	strncpy(tmp, pString, uiIndex); 
	tmp[uiIndex] = '\0'; 
	strcat(tmp, str); 
	strcat(tmp, pString+uiIndex); 
	
	delete pString; 
	
	pString = tmp; 
	return *this; 
} 

//ڶַΪuiIndexĵطַch 
CString &CString::Insert(unsigned int uiIndex, char ch){ 
	unsigned int thisLen = GetLength(); 
	
	if(uiIndex > thisLen){ 
		uiIndex = thisLen; 
	} 
	
	char *tmp = new char[thisLen+1+1]; 
	
	strncpy(tmp, pString, uiIndex); 
	tmp[uiIndex] = ch; 
	tmp[uiIndex+1] = '\0'; 
	strcat(tmp, pString+uiIndex); 
	
	delete pString; 
	
	pString = tmp; 
	return *this; 
} 

//ڶַ,uiBeginʼ,chһγֵλ,ʡuiBeginʹΪĬϵ0,δҵ-1 
int CString::Find(char ch, unsigned int uiBegin){ 
	unsigned int uiTmp; 
	char *tmp = strchr(pString+uiBegin, ch); 
	if(tmp==NULL){ 
		return -1; 
	} 
	uiTmp = GetLength()-strlen(tmp); 
	//delete tmp; 
	return uiTmp; 
} 

//ڶַ,uiBeginʼ,ַstrһγֵλ,ʡuiBeginʹΪĬϵ0,δҵ-1 
int CString::Find(char *str, unsigned int uiBegin)
{ 	
	return StringFind(pString, str, uiBegin);
} 

//ַch,ڶַеλ,δҵ-1 
int CString::ReverseFind(char ch){ 
	CString tmp(*this); 
	tmp.MakeReverse(); 
	if(Find(ch)==-1){ 
		return -1; 
	} 
	return GetLength()-1-tmp.Find(ch); 
} 

//strַַָ,صһγֵֵ,δҵ-1 
int CString::FindOneOf(char *str){ 
	for(int i = 0;i<strlen(str);i++){ 
		if(Find(str[i])==-1){ 
			continue; 
		}else{ 
			return Find(str[i]); 
		} 
	} 
	
	return -1; 
} 

//ȥַַch 
CString &CString::TrimLeft(char ch){ 
	Trim(1, ch); 
	return *this; 
} 

//ȥַĻ,ո,Ʊַ 
CString &CString::TrimLeft(void){ 
	Trim(1, '\n'); 
	Trim(1, ' '); 
	Trim(1, '\t'); 
	return *this; 
} 

//ȥַλstrַָеַ 
CString &CString::TrimLeft(char *str){ 
	for(int i = 0;i<strlen(str);i++){ 
		Trim(1, str[i]); 
	} 
	return *this; 
} 
//ȥַҲĻ,ո,Ʊַ 
CString &CString::TrimRight(void){ 
	Trim(2, '\n'); 
	Trim(2, ' '); 
	Trim(2, '\t'); 
	return *this; 
} 

////ȥַҲַch 
CString &CString::TrimRight(char ch){ 
	Trim(2, ch); 
	return *this; 
} 

//ȥַҲλstrַָеַ 
CString &CString::TrimRight(char *str){ 
	for(int i = 0;i<strlen(str);i++){ 
		Trim(2, str[i]); 
	} 
	return *this; 
} 

//1LEFT,2RIGHT 
CString &CString::Trim(int mode, char ch){ 
	unsigned int uiBegin = 0; 
	unsigned int uiEnd = GetLength()-1; 
	
	if(mode==1){ 
		while(pString[uiBegin]==ch && uiBegin<=uiEnd) 
			uiBegin++; 
	}else if(mode==2){ 
		while(pString[uiEnd]==ch && uiEnd>=uiBegin) 
			uiEnd--; 
	}else{ 
		return *this; 
	} 
	
	unsigned int uiLen = uiEnd-uiBegin+1; 
	char *tmp = new char[uiLen+1]; 
	strncpy(tmp, pString+uiBegin, uiLen); 
	tmp[uiLen] = '\0'; 
	
	delete pString; 
	pString = tmp; 
	return *this; 
} 
/*Ա End*/ 

/*ص Begin*/ 
CString& CString::operator=(const char ch){ 
	if(pString){ 
		delete pString; 
	} 
	
	pString = new char[2]; 
	pString[0] = ch; 
	pString[1] = '\0'; 
	
	return *this; 
} 

CString& CString::operator=(const char *pStr)
{ 
	if(pString){ 
		delete pString; 
	} 

	if(pStr != 0)
	{		
		int nLen = strlen(pStr);
		pString = new char[nLen + 1]; 
		strcpy(pString, pStr); 
	}
	else
	{
		pString = new char[1]; 
		pString[0] = '\0';
	}
	
	return *this; 
} 

CString& CString::operator=(CString &Str){ 
	if(pString){ 
		delete pString; 
	} 

	if(Str.pString != 0 && Str.pString[0] != '\0')
	{
		pString = new char[Str.GetLength()+1]; 
		strcpy(pString, Str.pString); 
	}
	else
	{
		pString = new char[1]; 
		pString[0] = '\0';
	}
	
	return *this; 
} 

CString& operator+(CString &Str, const char *str){ 
	CString *tmp = new CString(Str); 
	*tmp += str; 
	return *tmp; 
} 

CString& operator+(const char *str, CString& Str){ 
	CString *tmp = new CString(str); 
	*tmp+=Str; 
	return *tmp; 
} 

CString& operator+(CString &Str1, CString &Str2){ 
	CString *tmp = new CString(Str1); 
	*tmp += Str2; 
	return *tmp; 
} 

CString& operator+(CString &Str, char ch){ 
	CString *tmp = new CString(Str); 
	*tmp+=ch; 
	return *tmp; 
} 

CString& operator+(char ch, CString &Str){ 
	CString *tmp = new CString; 
	*tmp+=ch; 
	*tmp+=Str; 
	return *tmp; 
} 

CString& CString::operator+=(const char ch){ 
	char *tmp = pString; 
	int thisLen = this->GetLength(); 
	
	pString = new char[thisLen + 2]; 
	
	strcpy(pString, tmp); 
	pString[thisLen] = ch; 
	pString[thisLen+1] = '\0'; 
	
	if(tmp){ 
		delete tmp; 
	} 
	
	return *this; 
} 

CString& CString::operator+=(const char *str){ 
	char *tmp = pString; 
	
	int nLen = 0;
	if(str != 0)
		nLen = strlen(str); 
	
	pString = new char[strlen(tmp) + nLen + 1]; 
	
	strcpy(pString, tmp); 
	strcat(pString, str); 
	
	if(tmp){ 
		delete tmp; 
	} 
	
	return *this; 
} 

CString& CString::operator+=(CString &Str){ 
	char *tmp = pString; 
	pString = new char[strlen(tmp) + Str.GetLength() + 1]; 
	
	strcpy(pString, tmp); 
	strcat(pString, Str.pString); 
	
	if(tmp){ 
		delete tmp; 
	} 
	
	return *this; 
} 

const char &CString::operator[](unsigned int n){ 
	if(n>=GetLength()) 
		n = GetLength()-1; 
	return *(pString + n); 
} 

bool operator==(CString &Str, const char *str){ 
	return strcmp(Str.pString, str)==0; 
} 

bool operator==(const char *str, CString &Str){ 
	return strcmp(str, Str.pString)==0; 
} 

bool operator==(CString &Str1, CString &Str2){ 
	return strcmp(Str1.pString, Str2.pString)==0; 
} 

bool operator!=(const CString &Str, const char *str){ 
	return strcmp(Str.pString, str)!=0; 
} 

bool operator!=(const char *str, const CString &Str){ 
	return strcmp(str, Str.pString)!=0; 
} 

bool operator!=(const CString &Str1, const CString &Str2){ 
	return strcmp(Str1.pString, Str2.pString)!=0; 
} 

bool operator<(const CString &Str, const char *str){ 
	return strcmp(Str.pString, str)<0; 
} 

bool operator<(const char *str, const CString &Str){ 
	return strcmp(str, Str.pString)<0; 
} 

bool operator<(const CString &Str1, const CString &Str2){ 
	return strcmp(Str1.pString, Str2.pString)<0; 
} 

bool operator>(const CString &Str, const char *str){ 
	return strcmp(Str.pString, str)>0; 
} 

bool operator>(const char *str, const CString &Str){ 
	return strcmp(str, Str.pString)>0; 
} 

bool operator>(const CString &Str1, const CString &Str2) { 
	return strcmp(Str1.pString, Str2.pString)>0; 
} 

bool operator<=(const CString &Str, const char *str) { 
	return strcmp(Str.pString, str)<=0; 
} 

bool operator<=(const char *str, const CString &Str){ 
	return strcmp(str, Str.pString)<=0; 
} 

bool operator<=(const CString &Str1, const CString &Str2){ 
	return strcmp(Str1.pString, Str2.pString)<=0; 
} 

bool operator>=(const CString &Str, const char *str){ 
	return strcmp(Str.pString, str)>=0; 
} 

bool operator>=(const char *str, const CString &Str){ 
	return strcmp(str, Str.pString)>=0; 
} 

bool operator>=(const CString &Str1, const CString &Str2){ 
	return strcmp(Str1.pString, Str2.pString)>=0; 
} 

//IO 
ostream& operator<<(ostream &o, CString &Str){ 
	return o<<Str.GetBuffer(); 
} 

istream& operator>>(istream &i, CString &Str){ 
	char tmp[256]; 
	i>>tmp; 
	Str = tmp; 
	return i; 
}


//////////////////////////////////////////////////////////////////////////////////////////////////////
class TString 
{ 
public: 
	TString(); 
	~TString(); 
	
	TString&   operator= (TString &Str); 
	TString&   operator= (CString &Str); 
	TString&   operator=(const char* pStr);
	
	char *GetBuffer(void); 
	char *pString; //ָ洢ռ׵ַ 
};

TString::TString(){ 
	pString = new char[1]; 
	pString[0] = '\0'; 
} 

TString::~TString(){ 
	if(pString){ 
		delete pString; 
	} 
} 

TString& TString::operator=(CString &Str)
{ 
	if(pString){ 
		delete pString; 
	} 
	
	if(Str.pString != 0 && Str.pString[0] != '\0')
	{
		pString = new char[Str.GetLength()+1]; 
		strcpy(pString, Str.pString); 
	}
	else
	{
		pString = new char[1]; 
		pString[0] = '\0';
	}
	
	return *this; 
} 

TString& TString::operator=(TString &Str)
{ 
	if(pString){ 
		delete pString; 
	} 
	
	if(Str.pString != 0 && Str.pString[0] != '\0')
	{		
		int nLen = strlen(Str.pString);
		pString = new char[nLen + 1]; 
		strcpy(pString, Str.pString); 
	}
	else
	{
		pString = new char[1]; 
		pString[0] = '\0';
	}
	
	return *this; 
} 

TString& TString::operator=(const char* pStr)
{ 
	if(pString){ 
		delete pString; 
	} 
	
	if(pStr != 0)
	{		
		int nLen = strlen(pStr);
		pString = new char[nLen + 1]; 
		strcpy(pString, pStr); 
	}
	else
	{
		pString = new char[1]; 
		pString[0] = '\0';
	}
	
	return *this; 
} 

//޲,pStringָ,Ҫ<< 
char *TString::GetBuffer(void){ 
	return pString; 
} 

#endif
//////////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------------
#ifndef CARL_SEN_ARRAY_H
#define CARL_SEN_ARRAY_H

template<typename T>
class array 
{
public:
	unsigned int size;
	T* data;
public:
	//캯
	array(unsigned int _size=0);
	//array(unsigned int count, T data1, ...);

	void add(T& data1);
	void add(array<T>& ar);
	void add(int pos, T& data1);
	//ƿ
	array(const array<T>& ar);
	array& operator=(const array<T>& ar);
	~array() 
	{
		if(data != 0)
		{
			delete[] data;
		}
	}
	//
	T& operator[](unsigned int index);
	const T& operator[](unsigned int index) const;
	
	//getsetԱ
	unsigned int getSize() const 
	{
		if(size == 0)
			return 0;

		return size;
	}
	void setSize(unsigned int newSize);

	T& getAt(unsigned int index);
	const T& getAt(unsigned int index) const;
};

template <typename T>
array<T>::array(unsigned int _size):data(new T[_size]), 
size(_size) 
{
	for(unsigned int i=0; i<size; ++i) 
	{
		data[i]=T();
	}
}

// template <typename T>
// array<T>::array(unsigned int count, T data1, ...):size(count), 
// data(new T[count]) 
// {
// 	va_list ap;
// 	va_start(ap, count);
// 	for(unsigned int i=0; i<size; ++i) 
// 	{
// 		data[i]=va_arg(ap, T);
// 	}
// 	va_end(ap);
// }

template <typename T>
void array<T>::add(T& data1)
{
	int newSize = 1 + size;
	setSize(newSize);
	data[size - 1]=data1;
}

template <typename T>
void array<T>::add(array<T>& ar)
{
	for(int i=0; i<ar.size; ++i) 
	{
		add(ar.data[i]);
	}	
}

template <typename T>
void array<T>::add(int pos, T& data1)
{
	int newSize = 1 + size;
	setSize(newSize);
	if(pos >= size)
	{
		data[size - 1]=data1;
	}
	else
	{
		for(int i = size - 1; i > pos; i--)
		{
			data[i]=data[i - 1];
		}
		data[pos]=data1;
	}	
}

template <typename T>
array<T>::array(const array<T>& ar):size(ar.size), 
data(new T[ar.size]) 
{
	for(unsigned int i=0; i<size; ++i) 
	{
		data[i]=ar.data[i];
	}
}

template <typename T>
array<T>& array<T>::operator=(const array<T>& ar) 
{
	if(&ar!=this) 
	{
		delete[] data;
		data=new T[ar.size];
		size=ar.size;
		for(unsigned int i=0; i<size; ++i) 
		{
			data[i]=ar.data[i];
		}
	}
	return *this;
}

template <typename T>
T& array<T>::operator[](unsigned int index) 
{
	if(index>=size) 
	{
		index = size - 1;
	}
	return data[index];
}

template <typename T>
const T& array<T>::operator[](unsigned int index) const 
{
	if(index>=size) 
	{
		index = size - 1;	
	}
	return data[index];
}

template <typename T>
T& array<T>::getAt(unsigned int index) 
{
	if(index>=size) 
	{
		index = size - 1;
	}
	return data[index];
}

template <typename T>
const T& array<T>::getAt(unsigned int index) const 
{
	if(index>=size) 
	{
		index = size - 1;	
	}
	return data[index];
}

template <typename T>
void array<T>::setSize(unsigned int newSize) 
{
	T* newData=new T[newSize];
 	unsigned int Min = size < newSize ? size:newSize;
 	for(unsigned int i=0; i<Min; ++i) 
 	{
 		newData[i]=data[i];
 	}
 	delete[] data;
 	data=newData;
 	size=newSize;
}

#endif

//ڶͷļarray2d.hǶά̬ģ壺
//array2d.h
#ifndef CARL_SEN_ARRAY2D_H
#define CARL_SEN_ARRAY2D_H

template <typename T>
class array2d 
{
protected:
	unsigned int rows;
	unsigned int cols;
	array<T> ar;
public:
	//캯
	array2d(unsigned int _rows=0, unsigned int _cols=0);
	
	//
	class RowArray;
	RowArray operator[](unsigned int row);
	const RowArray operator[](unsigned int row) const;
	
	//ڶά±Ƕ
	class RowArray 
	{
	private:
		const array2d<T>& ar;
		unsigned int row;
	public:
		RowArray(array2d<T>& _array2D, unsigned int _row=0) : array2d(_array2D), row(_row) 
		{

		}

		RowArray(const array2d<T>& _array2D, unsigned int _row=0) : array2d(_array2D), row(_row) 
		{

		}

		T& operator[](unsigned int col) 
		{ 
			  if(col >= ar.cols) 
			  { 
				  
			  } 
			  return 
				  const_cast<array2d<T>&>(ar).array[row*ar.cols+col]; 
		} 
		
		const T& operator[](unsigned int col) const 
		{ 
			  if(col>=ar.cols) 
			  { 
				  
			  } 
			  return array2d.array[row * ar.cols+col]; 
		} 
	}; 
	friend class RowArray; 
	
	//getset 
	unsigned int getRows() const 
	{ 
		  return rows; 
	} 
	unsigned int getCols() const 
	{ 
		  return cols; 
	} 
}; 

template <typename T> 
array2d<T>::array2d(unsigned int _rows, unsigned int _cols): 
rows(_rows), cols(_cols), array(_rows*_cols)
{ 
	for(unsigned int i=0; i<rows*cols; ++i) 
	{ 
		array[i]=T(); 
	} 
} 

template <typename T> 
array2d<T>::RowArray array2d<T>::operator[](unsigned int row) 
{ 
	if(row>=rows) 
	{ 
		
	} 
	return RowArray(*this, row); 
} 

template <typename T> 
const array2d<T>::RowArray array2d<T>::operator[](unsigned int row) const 
{ 
	if(row>=rows) 
	{ 
		
	} 
	return RowArray(*this, row); 
} 
#endif

//------------------------------------------------------------------------
void StringSplite(char *pStr, char* sSpace, array<CString>& ars)
{
	ars.size = 0;

	if(pStr == 0)
		return;
	
	int nLen = StringLength(pStr);
	if(nLen == 0)
		return;
	
	int nIndex1 = 0;	
	int nIndex2 = StringFind(pStr, sSpace, nIndex1);	

	CString sTemp0 = "";
	CString sTemp1 = pStr;	

	if(nIndex2 == -1)
	{
		ars.add(sTemp1);
		return;
	}
	
	while(nIndex2 > -1)
	{
		sTemp0 = sTemp1;
		CString sTemp = StringMid(sTemp0.GetBuffer(), 0, nIndex2);		
		ars.add(CString(sTemp.GetBuffer()));				
		
		nIndex1 = nIndex2 + StringLength(sSpace);				
		sTemp1 = StringMid(sTemp1.GetBuffer(), nIndex1);
		nIndex1 = 0;
		nIndex2 = StringFind(sTemp1.GetBuffer(), sSpace, nIndex1);
	}
	
	if(sTemp1.GetLength() > 0)
	{		
		ars.add(sTemp1);
	}
}