#include "string.cxx"
#include "public.cxx"
//------------------------------------------------------------------------
static int g_nCurRow = 0;
void ReflashRowNum(int nRow)
{
	g_nCurRow = nRow;
}

int GetScriptRowNum()
{
	return g_nCurRow;
}

//-----------------------------------------------------------------------------
//------------------------------------------------------------------------
X2S(CString &s, array<CString> &ars)
{
	CString sTmp = "";
	for(int i = 0; i < ars.getSize(); i++)
	{	
		if(i == 0)			
		{
			sTmp += ars[i].GetBuffer();
		}
		else
		{
			sTmp += ":";
			sTmp += ars[i].GetBuffer();
		}
	}
	
	s = sTmp;
}

CString X2S(array<TString&>& ars)
{
	CString s;
	X2S(s, ars);
	return s;
}

X2S(CString &s, int n)
{
	char a[32];
	sprintf(a, "%d", n);	
	s = CString(a);
}

X2S(CString &s, double d)
{
	char a[32];
	sprintf(a, "%g", d);	
	s = CString(a);
}

X2S(CString &s, double d, CString sPrecision)
{
	char p[32];
	sprintf(p, "%%%sf", sPrecision.GetBuffer());	
	
	char a[32];
	sprintf(a, p, d);	
	s = CString(a);
}

CString X2S(double d, CString sPrecision)
{
	CString s;
	X2S(s, d, sPrecision);
	
	return s;
}


X2S(CString &s, CString sSrc)
{	
	s = sSrc;
}

CString X2S()
{
	CString s = "";
	return s;
}

CString X2S(int x)
{
	CString s;
	X2S(s, x);
	return s;
}

CString X2S(double x)
{
	CString s;
	X2S(s, x);
	
	return s;
}


CString X2S(CString x)
{	
	CString s = x;
	return s;
}

//------------------------------------------------------------------------
typedef array<int> ints;
X2S(CString &s, ints &arn)
{	
	CString sTmp = "";
	for(int i = 0; i < arn.getSize(); i++)
	{
		char ch[1024];
		sprintf(ch, "%d", arn[i]);
		if(i == 0)			
		{
			sTmp += ch;
		}
		else
		{
			sTmp += ":";
			sTmp += ch;
		}
	}
	
	s = sTmp;
}

CString X2S(ints &arn)
{	
	CString sTmp = "";
	for(int i = 0; i < arn.getSize(); i++)
	{
		char ch[1024];
		sprintf(ch, "%d", arn[i]);
		if(i == 0)			
		{
			sTmp += ch;
		}
		else
		{
			sTmp += ":";
			sTmp += ch;
		}
	}
	
	CString s = sTmp;
	return s;
}
//------------------------------------------------------------------------
typedef array<double> doubles;
X2S(CString &s, doubles &ard)
{	
	CString sTmp = "";
	for(int i = 0; i < ard.getSize(); i++)
	{
		char ch[1024];
		sprintf(ch, "%f", ard[i]);
		if(i == 0)			
		{
			sTmp += ch;
		}
		else
		{
			sTmp += ":";
			sTmp += ch;
		}
	}

	s = sTmp;
}


S2X(CString s, doubles& arpt)
{	
	array<CString> ars;
	StringSplite(s.GetBuffer(), ":", ars);	
	for(int i = 0; i < ars.getSize(); i++)
	{		
		CString sTemp = ars[i];		
		arpt.add(atof(sTemp.GetBuffer()));
	}
}


CString X2S(doubles &ard)
{	
	CString sTmp = "";
	for(int i = 0; i < ard.getSize(); i++)
	{
		char ch[1024];
		sprintf(ch, "%f", ard[i]);
		if(i == 0)			
		{
			sTmp += ch;
		}
		else
		{
			sTmp += ":";
			sTmp += ch;
		}
	}
	
	CString s = sTmp;
	return s;
}


//------------------------------------------------------------------------
typedef int ent;
typedef array<int> ents;

X2S(CString &s, ent id)
{
	char ch[1024];
	sprintf(ch, "%d", id);
	s = ch;
}

X2S(CString &s, ents &arid)
{	
	CString sTmp = "";
	for(int i = 0; i < arid.getSize(); i++)
	{
		char ch[32];
		sprintf(ch, "%d", arid[i]);
		if(i == 0)			
		{
			sTmp += ch;
		}
		else
		{
			sTmp += ":";
			sTmp += ch;
		}
	}
	
	s = sTmp;
}

CString X2S(ents &arid)
{
	CString s;
	X2S(s, arid);
	return s;
}

//------------------------------------------------------------------------
typedef array<CString> CStrings ;
CString X2S(CStrings ars, CString s = SPLITE_ATTVALUE);
CString X2S(CStrings ars, CString s)
{
	CString sRet;
	for(int i = 0;i < ars.getSize(); i++)
	{
		sRet += ars[i];
		if(i != ars.getSize() - 1)
			sRet += s;
	}
	return sRet;
}

#define MB_OK                       0
#define MB_OKCANCEL                 1
#define MB_ABORTRETRYIGNORE         2
#define MB_YESNOCANCEL              3
#define MB_YESNO                    4
#define MB_RETRYCANCEL              5

#define IDOK						1
#define IDCANCEL					2
#define IDABORT						3
#define IDRETRY						4
#define IDIGNORE					5
#define IDYES						6
#define IDNO						7

#define message(a) messagebox(a, 0); return 1;
int messagebox(CString s, int nType)
{
	jmessage(s.GetBuffer(), nType);
	
	return g_nJResult0;
}

double TextWidth(CString s, double dH)
{
	return TextWidth(s.GetBuffer(), "", dH, 1.0);
} 

double TextWidth(CString s, CString sStyle, double dH, double dWFactor)
{		
	CString sVarScript = "";
	sVarScript += X2S(s) + SPLITE_ATTVALUE;
	sVarScript += X2S(sStyle) + SPLITE_ATTVALUE;
	sVarScript += X2S(dH) + SPLITE_ATTVALUE;	
	sVarScript += X2S(dWFactor);
	JCallFunction("GetTextWidth", sVarScript.GetBuffer(), "d");
	
	return g_dJResult0;
} 

double GetProperty(CString sSymbol, CString sItem)
{
	JGetTextStyle(sSymbol.GetBuffer(), sItem.GetBuffer());
	return g_dJResult0;
}

void SetProperty(CString sSymbol, CString sItem, CString sValue)
{
	JSetTextStyle(sSymbol.GetBuffer(), sItem.GetBuffer(), sValue.GetBuffer());
	return g_dJResult0;
}

//------------------------------------------------------------------------
#include "Geometry.cxx"
#include "draw.cxx"
#include "draw3D.cxx"
#include "office.cxx"

/*////////////////////////////////////////////////////////////////////////////////
ⲿűļ
CString sFile - ⲿűļ·
int nAct - űλ
CString sVarScript - ݱ
////////////////////////////////////////////////////////////////////////////////*/
ents call(CString sFile, int nAct, CString sVarScript)
{
	jcall(sFile.GetBuffer(), nAct, sVarScript.GetBuffer());
	return GetLastAddEntId();
}

void outvar(CString sName, CString sValue)
{
	JSetVar(sName.GetBuffer(), sValue.GetBuffer());
}

array<point> points;
points getEntPoint(ent id)
{
	CString s = getEnt(id, "point");
	
	points pts;
	
	array<CString> ars;

	CString sTmp = s;
	StringSplite(sTmp.GetBuffer(), ":", ars);
	
	for(int i = 0; i < ars.getSize(); i++)
	{
		CString sTmp = ars[i];
		point pt;
		pt.SetDataToString(sTmp.GetBuffer());
		pts.add(pt);
	}
	
	return pts;
}

void setview(ents arid)
{
	CString s3 = "";
	X2S(s3, arid);
	
	CString sT = "";
	sT += s3.GetBuffer();
	
	JCallFunction("AcadSetView", sT.GetBuffer(), "");
}

void setview(ent id)
{
	CString s3 = "";
	X2S(s3, id);
	
	CString sT = "";
	sT += s3.GetBuffer();
	
	JCallFunction("AcadSetView", sT.GetBuffer(), "");
}

void setview(point pt1, point pt2)
{
	CString s1 = "";
	X2S(s1, pt1);

	CString s2 = "";
	X2S(s2, pt2);
	
	CString sT = "";
	sT += s1.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s2.GetBuffer();
	
	JCallFunction("AcadSetViewRect", sT.GetBuffer(), "");
}

void radiEnt(ents arid)
{
	CString s3 = "";
	X2S(s3, arid);
	
	CString sT = "";
	sT += s3.GetBuffer();
	
	JCallFunction("AcadRadiEnt", sT.GetBuffer(), "");
}

void radiEnt(ent id)
{
	CString s3 = "";
	X2S(s3, id);
	
	CString sT = "";
	sT += s3.GetBuffer();
	
	JCallFunction("AcadRadiEnt", sT.GetBuffer(), "");
}

void update(ents arid)
{	
	CString s3 = "";
	X2S(s3, arid);
	
	CString sT = "";
	sT += s3.GetBuffer();
	
	JCallFunction("AcadUpdateEnt", sT.GetBuffer(), "");
}

void update(ent id)
{
	if(id < 0)
		return;

	CString s3 = "";
	X2S(s3, id);
	
	CString sT = "";
	sT = s3.GetBuffer();
	
	JCallFunction("AcadUpdateEnt", sT.GetBuffer(), "");
}

CString CurTime(CString sFormat = "%Y-%m-%d %H:%M:%S");
CString CurTime(CString sFormat)
{	
	CString sT = "";
	sT += sFormat.GetBuffer();
	JCallFunction("CurTime", sT.GetBuffer(), "s");

	return g_sJResult0;
}

///--------------------------------------------------------------------
//
// int nD 0 - row 1 - 
int gc(CString sFile, CString sVar, int nD = 0);
int gc(CString sFile, CString sVar, int nD)
{
	CString s3 = "";
	X2S(s3, nD);

	CString sT = "";
	sT += sFile.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sVar.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();

	g_nJResult0 = 0;

	JCallFunction("GroupLength", sT.GetBuffer(), "n");
	
	return g_nJResult0;
}

int gc(CString sVar, int nD = 0);
int gc(CString sVar, int nD)
{
	return gc("", sVar, nD);
}

//ֱ
double gd(CString sFile, CString sVar, int nRow = -1, int nCol = -1);
double gd(CString sFile, CString sVar, int nRow, int nCol)
{
	CString s3 = "";
	X2S(s3, nRow);

	CString s4 = "";
	X2S(s4, nCol);
	
	CString sT = "";
	sT += sFile.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sVar.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s4.GetBuffer();

	g_dJResult0 = 0;

	JCallFunction("GroupDouble", sT.GetBuffer(), "d");
	
	return g_dJResult0;
}

double gd(CString sVar, int nRow = -1, int nCol = -1);
double gd(CString sVar, int nRow, int nCol)
{	
	return gd("", sVar, nRow, nCol);
}

//ֱ
CString gs(CString sFile, CString sVar, int nRow = -1, int nCol = -1);
CString gs(CString sFile, CString sVar, int nRow, int nCol)
{
	CString s3 = "";
	X2S(s3, nRow);
	
	CString s4 = "";
	X2S(s4, nCol);
	
	CString sT = "";
	sT += sFile.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sVar.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s4.GetBuffer();

	g_sJResult0 = "";
	
	JCallFunction("GroupString", sT.GetBuffer(), "s");
	
	return g_sJResult0;
}

CString gs(CString sVar, int nRow = -1, int nCol = -1);
CString gs(CString sVar, int nRow, int nCol)
{	
	return gs("", sVar, nRow, nCol);
}

point gp(CString sFile, CString sVar, int nRow = -1, int nCol = -1);
point gp(CString sFile, CString sVar, int nRow, int nCol)
{
	CString sPt = gs(sFile, sVar, nRow, nCol);
	point pt(sPt);
	return pt;
}

point gp(CString sVar, int nRow = -1, int nCol = -1);
point gp(CString sVar, int nRow, int nCol)
{	
	return gp("", sVar, nRow, nCol);
}

///--------------------------------------------------------------------
///--------------------------------------------------------------------
//
// int nD 0 - row 1 - 
int sc(CString sFile, CString sVar, int nCount, int nD = 0);
int sc(CString sFile, CString sVar, int nCount, int nD)
{
	CString s3 = "";
	X2S(s3, nD);

	CString s4 = "";
	X2S(s4, nCount);
	
	CString sT = "";
	sT += sFile.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sVar.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s4.GetBuffer();
	
	g_nJResult0 = 0;
	
	JCallFunction("SetGroupLength", sT.GetBuffer(), "n");
	
	return g_nJResult0;
}

int sc(CString sVar, int nCount, int nD = 0);
int sc(CString sVar, int nCount, int nD)
{
	return sc("", sVar, nCount, nD);
}

//ֱ
int sd(CString sFile, CString sVar, double dCount, int nRow = -1, int nCol = -1);
int sd(CString sFile, CString sVar, double dCount, int nRow, int nCol)
{
	CString s3 = "";
	X2S(s3, nRow);
	
	CString s4 = "";
	X2S(s4, nCol);

	CString s5 = "";
	X2S(s5, dCount);
	
	CString sT = "";
	sT += sFile.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sVar.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s4.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s5.GetBuffer();
	
	g_nJResult0 = 0;
	
	JCallFunction("SetGroupDouble", sT.GetBuffer(), "n");
	
	return g_nJResult0;
}

int sd(CString sVar, double dCount, int nRow = -1, int nCol = -1);
int sd(CString sVar, double dCount, int nRow, int nCol)
{	
	return sd("", sVar, dCount, nRow, nCol);
}

//ֱ
int ss(CString sFile, CString sVar, CString sCount, int nRow = -1, int nCol = -1);
int ss(CString sFile, CString sVar, CString sCount, int nRow, int nCol)
{
	CString s3 = "";
	X2S(s3, nRow);
	
	CString s4 = "";
	X2S(s4, nCol);
	
	CString sT = "";
	sT += sFile.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sVar.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s4.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sCount.GetBuffer();
	
	g_nJResult0 = 0;
	
	JCallFunction("SetGroupDouble", sT.GetBuffer(), "n");
	
	return g_nJResult0;
}

int ss(CString sVar, CString sCount, int nRow = -1, int nCol = -1);
int ss(CString sVar, CString sCount, int nRow, int nCol)
{	
	return ss("", sVar, sCount, nRow, nCol);
}

int sp(CString sFile, CString sVar, point pt, int nRow = -1, int nCol = -1);
int sp(CString sFile, CString sVar, point pt, int nRow, int nCol)
{	
	CString sPt = X2S(pt);
	return ss(sFile, sVar, sPt, nRow, nCol);
}

int sp(CString sVar, point pt, int nRow = -1, int nCol = -1);
int sp(CString sVar, point pt, int nRow, int nCol)
{		
	return sp("", sVar, pt, nRow, nCol);
}
//--------------------------------------------------------------------

void sleep(int nTime = 1000);
void sleep(int nTime)
{	
	CString sT = "";
	sT += X2S(nTime);
	JCallFunction("JsSleep", sT.GetBuffer(), "");
}

void acprint(CString sT)
{
	JCallFunction("AcadPrintf", sT.GetBuffer(), "");
}

void acmd(CString sT)
{
	JCallFunction("AcadCommand", sT.GetBuffer(), "");
}

double cal(CString sT)
{
	JCalculate(sT.GetBuffer());
	return g_dJResult0;
}

#define MB_OK                       0
#define MB_OKCANCEL                 1
#define MB_ABORTRETRYIGNORE         2
#define MB_YESNOCANCEL              3
#define MB_YESNO                    4
#define MB_RETRYCANCEL              5

#define VAR_DOUBLE	0 // double 
#define VAR_POINT	1 // point
#define VAR_INT		2 // int
#define VAR_STRING	3 // string
#define VAR_ID		4 // id handle
#define VAR_LONG	5 // long
#define VAR_BUFFER	6 // buffer
#define VAR_HANDLE	7 // handle

CString getvar(CString s, int nType = 0);
CString getvar(CString s, int nType)
{
	CString s3 = "";
	X2S(s3, nType);

	CString sT = "";
	sT += s.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();

	JCallFunction("AcadGetVar", sT.GetBuffer(), "s");
	return g_sJResult0;
}

void setvar(CString s, int nType, CString sValue);
void setvar(CString s, int nType, CString sValue)
{
	CString s3 = "";
	X2S(s3, nType);
	
	CString sT = "";
	sT += s.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += sValue.GetBuffer();
	
	JCallFunction("AcadSetVar", sT.GetBuffer(), "");
}

