
static int BoolUnit  = 0;
static int BoolInter = 1; 
static int BoolSub   = 2;

void boolOper(int nType, ent id, ents ids)
{
	CString s1 = "";
	X2S(s1, nType);
	
	CString s2 = "";
	X2S(s2, id);
	
	CString s3 = "";
	X2S(s3, ids);
	
	CString sT = "";
	sT += s1.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s2.GetBuffer();
	sT += SPLITE_ATTVALUE;		
	sT += s3.GetBuffer();
	
	JCallFunction("AcadBoolOper", sT.GetBuffer(), "");
}

void boolOper(int nType, ent id, ent id0)
{
	ents arid;
	arid.add(id0);
	boolOper(nType, id, arid);
}


void slice(ent id, point pt, point vec)
{
	CString s1 = "";
	X2S(s1, id);
	
	CString s2 = "";
	X2S(s2, pt);
	
	CString s3 = "";
	X2S(s3, vec);
	
	CString sT = "";
	sT += s1.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s2.GetBuffer();
	sT += SPLITE_ATTVALUE;		
	sT += s3.GetBuffer();
	
	JCallFunction("AcadBoolSlice", sT.GetBuffer(), "");
}


//
int box(point pt, double xLen, double yLen, double zLen, CString sLayer = "", int nColor = 256);
int box(point pt, double xLen, double yLen, double zLen, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);
	
	char ch[1024];
	//                     1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbBox%s%s%s%f%s%f%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		xLen,
		SPLITE_ATTVALUE,
		yLen,
		SPLITE_ATTVALUE,	
		zLen,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

//Բ̨
int frustum(point pt, double height, double xRadius,double yRadius, double topXRadius, CString sLayer = "", int nColor = 256);
int frustum(point pt, double height, double xRadius,double yRadius, double topXRadius, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);
	
	char ch[1024];
	//                         1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbFrustum%s%s%s%f%s%f%s%f%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		height,
		SPLITE_ATTVALUE,
		xRadius,
		SPLITE_ATTVALUE,	
		yRadius,
		SPLITE_ATTVALUE,	
		topXRadius,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

//
int sphere(point pt, double radius, CString sLayer = "", int nColor = 256);
int sphere(point pt, double radius, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);
	
	char ch[1024];
	//                        1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbSphere%s%s%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		radius,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

//Բ
int torus(point pt, double majorRadius, double minorRadius, CString sLayer = "", int nColor = 256);
int torus(point pt, double majorRadius, double minorRadius, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);
	
	char ch[1024];
	//                       1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbTorus%s%s%s%f%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		majorRadius,
		SPLITE_ATTVALUE,
		minorRadius,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

//Ш
int wedge(point pt, double xLen, double yLen, double zLen, CString sLayer = "", int nColor = 256);
int wedge(point pt, double xLen, double yLen, double zLen, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);
	
	char ch[1024];
	//                       1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbWedge%s%s%s%f%s%f%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		xLen,
		SPLITE_ATTVALUE,
		yLen,
		SPLITE_ATTVALUE,	
		zLen,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

//
int extrude(point pt, ents arid, double height,double taperAngle, CString sLayer = "", int nColor = 256);
int extrude(point pt, ents arid, double height,double taperAngle, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);

	CString s2 = "";
	X2S(s2, arid);
	
	char ch[1024];
	//                         1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbExtrude%s%s%s%s%s%f%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		s2.GetBuffer(),
		SPLITE_ATTVALUE,
		height,
		SPLITE_ATTVALUE,
		taperAngle,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

int extrude(point pt, ent id, double height,double taperAngle, CString sLayer = "", int nColor = 256);
int extrude(point pt, ent id, double height,double taperAngle, CString sLayer, int nColor)
{
	ents arid;
	arid.add(id);
	return extrude(pt, arid, height, taperAngle, sLayer.GetBuffer(), nColor);
}

//·
int extrudePath(point pt, ents arid, ent idPath,double taperAngle, CString sLayer = "", int nColor = 256);
int extrudePath(point pt, ents arid, ent idPath,double taperAngle, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);

	CString s2 = "";
	X2S(s2, arid);

	CString s3 = "";
	X2S(s3, idPath);
	
	char ch[1024];
	//                                  1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbExtrudeAlongPath%s%s%s%s%s%s%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		s2.GetBuffer(),
		SPLITE_ATTVALUE,
		s3.GetBuffer(),
		SPLITE_ATTVALUE,
		taperAngle,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

int extrudePath(point pt, ent id, ent idPath,double taperAngle, CString sLayer = "", int nColor = 256);
int extrudePath(point pt, ent id, ent idPath,double taperAngle, CString sLayer, int nColor)
{
	ents arid;
	arid.add(id);
	return extrudePath(pt, arid, idPath, taperAngle, sLayer.GetBuffer(), nColor);
}

//ת
int revolve(point pt, ents arid, point axisPoint, point axisDir, double angleOfRevolution, CString sLayer = "", int nColor = 256);
int revolve(point pt, ents arid, point axisPoint, point axisDir, double angleOfRevolution, CString sLayer, int nColor)
{
	CString s1 = "";
	X2S(s1, pt);
	
	CString s2 = "";
	X2S(s2, arid);
	
	CString s3 = "";
	X2S(s3, axisPoint);

	CString s4 = "";
	X2S(s4, axisDir);
	
	char ch[1024];
	//                         1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbRevolve%s%s%s%s%s%s%s%s%s%f%s%s%s%d",
		SPLITE_ATTVALUE,
		s1.GetBuffer(),
		SPLITE_ATTVALUE,
		s2.GetBuffer(),
		SPLITE_ATTVALUE,
		s3.GetBuffer(),
		SPLITE_ATTVALUE,
		s4.GetBuffer(),	
		SPLITE_ATTVALUE,
		angleOfRevolution,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

//
int lofted(ents &crossSectionCurves, ents &guideCurves, ent PathCurve, double dThickness = 0.0);
int lofted(ents &crossSectionCurves, ents &guideCurves, ent PathCurve, double dThickness)
{
	CString s1 = "";
	X2S(s1, crossSectionCurves);

	CString s2 = "";
	X2S(s2, guideCurves);

	CString s3 = "";
	X2S(s3, PathCurve);

	CString s4 = "";
	X2S(s4, dThickness);

	CString sT = "AcDbLoftedSolid";
	sT += SPLITE_ATTVALUE;
	sT += s1.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s2.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s3.GetBuffer();
	sT += SPLITE_ATTVALUE;
	sT += s4.GetBuffer();

	outputscript(sT.GetBuffer());	
	return g_nCurId;
}

int revolve(point pt, ent id, point axisPoint, point axisDir, double angleOfRevolution, CString sLayer = "", int nColor = 256);
int revolve(point pt, ent id, point axisPoint, point axisDir, double angleOfRevolution, CString sLayer, int nColor)
{
	ents arid;
	arid.add(id);
	return revolve(pt, arid, axisPoint, axisDir, angleOfRevolution, sLayer.GetBuffer(), nColor);
}

//
int region(ents arid, CString sLayer = "", int nColor = 256);
int region(ents arid, CString sLayer, int nColor)
{
	CString s2 = "";
	X2S(s2, arid);
	
	char ch[1024];
	//                        1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDbRegion%s%s%s%s%s%d",		
		SPLITE_ATTVALUE,
		s2.GetBuffer(),
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

int region(ent id, CString sLayer = "", int nColor = 256);
int region(ent id, CString sLayer, int nColor)
{
	ents arid;
	arid.add(id);
	return region(arid, sLayer, nColor);
}

//3dPolyline
//Poly3dType        { k3dSimplePoly = 0, k3dQuadSplinePoly = 1, k3dCubicSplinePoly = 2 };

int pline3d(points arpt, int nType = 0, int nClose = 0, CString sLayer = "", int nColor = 256);
int pline3d(points arpt, int nType, int nClose, CString sLayer, int nColor)
{
	CString s2 = "";
	X2S(s2, arpt);
	
	CString s = "AcDb3dPolyline";
	s += SPLITE_ATTVALUE;
	s += s2;
	s += SPLITE_ATTVALUE;
	/*
	char ch[1024];
	//            1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "%d%s%d%s%s%s%d",						
		nType,
		SPLITE_ATTVALUE,
		nClose,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);	
	s += ch;
	*/
	s += X2S(nType);
	s += SPLITE_ATTVALUE;
	s += X2S(nClose);
	s += SPLITE_ATTVALUE;
	s += sLayer;
	s += SPLITE_ATTVALUE;
	s += X2S(nColor);
	
	outputscript(s.GetBuffer());	
	return g_nCurId;
}

//2dPolyline
//enum Poly2dType        { k2dSimplePoly = 0, k2dFitCurvePoly = 1, k2dQuadSplinePoly = 2, k2dCubicSplinePoly = 3 };
int pline2d(points arpt, doubles ardBulge, int nType = 0, int nClose = 0, double elevation = 0, double defStartWidth = 0, double defEndWidth = 0, CString sLayer = "", int nColor = 256);
int pline2d(points arpt, doubles ardBulge, int nType, int nClose, double elevation, double defStartWidth, double defEndWidth, CString sLayer, int nColor)
{
	CString s2 = "";
	X2S(s2, arpt);
	CString s3 = "";
	X2S(s3, ardBulge);
	
	char ch[1024];
	//                            1   2   3   4   5   6   7   8   9  10   1   2   3   4   5   6   7   8   9  20
	sprintf(ch, "AcDb2dPolyline%s%s%s%s%s%d%s%d%s%g%s%g%s%g%s%s%s%d",		
		SPLITE_ATTVALUE,
		s2.GetBuffer(),
		SPLITE_ATTVALUE,
		s3.GetBuffer(),
		SPLITE_ATTVALUE,
		nType,
		SPLITE_ATTVALUE,
		nClose,
		SPLITE_ATTVALUE,
		elevation,
		SPLITE_ATTVALUE,
		defStartWidth,
		SPLITE_ATTVALUE,
		defEndWidth,
		SPLITE_ATTVALUE,	
		sLayer.GetBuffer(),
		SPLITE_ATTVALUE,
		nColor);
	
	outputscript(ch);	
	return g_nCurId;
}

int pline2d(points arpt, int nType = 0, int nClose = 0, double elevation = 0, double defStartWidth = 0, double defEndWidth = 0, CString sLayer = "", int nColor = 256);
int pline2d(points arpt, int nType, int nClose, double elevation, double defStartWidth, double defEndWidth, CString sLayer, int nColor)
{
	doubles ardBulge;	
	return pline2d(arpt, ardBulge, nType, nClose, elevation, defStartWidth, defEndWidth, sLayer, nColor);
}