#! /usr/bin/env python

import struct
import zlib

# A tool to inject 'ds.ini' and 'steam_api.dll' in Clickteam Fusion single EXE files.
#
# Author : PapaHapas / DarkSiders
# Note : Currently only for Wallachia, may work for others too
# TODO: make more options, such as extracting files, replacing other files too (in case extra crack is required)
# 

with open('Wallachia.exe', 'rb') as f:
  data = f.read()

data_magic = 'wwww\x49\x87\x47\x12\x20'
data_index = data.index(data_magic)
exe = data[:data_index]
data = data[data_index:]

if data.find(data_magic, 1) != -1:
  raise ValueError('Re-evaluate what the original loader does please! : Double Magic?')

header = data[:0x20]
non_header = data[0x20:]

file_count = struct.unpack('<I', header[-4:])[0]

files = list()
file_index = 0
for file_counter in range(file_count):
  filename_length = struct.unpack('<H', non_header[file_index:file_index + 2])[0]
  file_index = file_index + 2
  filename = non_header[file_index:file_index + filename_length * 2].decode('UTF-16-LE')
  file_index = file_index + filename_length * 2
  unknown = non_header[file_index:file_index + 4]
  file_index = file_index + 4
  compressed_size = struct.unpack('<I', non_header[file_index:file_index + 4])[0]
  file_index = file_index + 4
  compressed_data = non_header[file_index:file_index+compressed_size]
  file_index = file_index + compressed_size
  decompressed_data = zlib.decompress(compressed_data)
  files.append((filename, unknown, compressed_data))
  
  print '%03X : %s %d->%d (0x%08X)' % (file_counter, filename, len(compressed_data), len(decompressed_data), struct.unpack('<I', unknown)[0])

remaining = non_header[file_index:]
if remaining[:0x20][:4] != 'PAMU':
  raise ValueError('Re-evaluate what the original loader does please! : Where is PAMU?')

offset = struct.unpack('<I', header[12:16])[0] - 0x40
if offset != file_index:
  raise ValueError('Re-evaluate what the original loader does please! : Offset Value Mismatch!')

new_file = ('ds.ini', '\x00\x00\x00\x00', zlib.compress(open('ds.ini', 'rb').read(), 9))
for i in range(len(files)):
  filename, unknown, compress_data = files[i]
  if filename == 'steam_api.dll':
    files[i] = filename, '\x00\x00\x00\x00', zlib.compress(open(filename, 'rb').read(), 9)
    files.insert(i, new_file)

new_data = ''
for file_counter, (filename, unknown, compressed_data) in enumerate(files):
  file_header = ''
  file_header = file_header + struct.pack('<H', len(filename))
  file_header = file_header + filename.encode('UTF-16-LE')
  file_header = file_header + unknown
  file_header = file_header + struct.pack('<I', len(compressed_data))
  new_data = new_data + file_header + compressed_data

new_offset = len(new_data) + 0x40
new_header = header[:12] + struct.pack('<I', new_offset) + header[16:][:-4] + struct.pack('<I', len(files))
print(repr(new_header), len(new_header))

with open('Wallachia.exe.new', 'wb') as f:
  f.write(exe + new_header + new_data + remaining)

