/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.relation.RelationService;

public class RelationNotification
extends Notification {
    private static final long oldSerialVersionUID = -2126464566505527147L;
    private static final long newSerialVersionUID = -6871117877523310399L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myNewRoleValue", ArrayList.class), new ObjectStreamField("myOldRoleValue", ArrayList.class), new ObjectStreamField("myRelId", String.class), new ObjectStreamField("myRelObjName", ObjectName.class), new ObjectStreamField("myRelTypeName", String.class), new ObjectStreamField("myRoleName", String.class), new ObjectStreamField("myUnregMBeanList", ArrayList.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("newRoleValue", List.class), new ObjectStreamField("oldRoleValue", List.class), new ObjectStreamField("relationId", String.class), new ObjectStreamField("relationObjName", ObjectName.class), new ObjectStreamField("relationTypeName", String.class), new ObjectStreamField("roleName", String.class), new ObjectStreamField("unregisterMBeanList", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    public static final String RELATION_BASIC_CREATION = "jmx.relation.creation.basic";
    public static final String RELATION_MBEAN_CREATION = "jmx.relation.creation.mbean";
    public static final String RELATION_BASIC_UPDATE = "jmx.relation.update.basic";
    public static final String RELATION_MBEAN_UPDATE = "jmx.relation.update.mbean";
    public static final String RELATION_BASIC_REMOVAL = "jmx.relation.removal.basic";
    public static final String RELATION_MBEAN_REMOVAL = "jmx.relation.removal.mbean";
    private String relationId = null;
    private String relationTypeName = null;
    private ObjectName relationObjName = null;
    private List<ObjectName> unregisterMBeanList = null;
    private String roleName = null;
    private List<ObjectName> oldRoleValue = null;
    private List<ObjectName> newRoleValue = null;

    public RelationNotification(String string, Object object, long l, long l2, String string2, String string3, String string4, ObjectName objectName, List<ObjectName> list) throws IllegalArgumentException {
        super(string, object, l, l2, string2);
        if (!this.isValidBasic(string, object, string3, string4) || !this.isValidCreate(string)) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.relationId = string3;
        this.relationTypeName = string4;
        this.relationObjName = this.safeGetObjectName(objectName);
        this.unregisterMBeanList = this.safeGetObjectNameList(list);
    }

    public RelationNotification(String string, Object object, long l, long l2, String string2, String string3, String string4, ObjectName objectName, String string5, List<ObjectName> list, List<ObjectName> list2) throws IllegalArgumentException {
        super(string, object, l, l2, string2);
        if (!this.isValidBasic(string, object, string3, string4) || !this.isValidUpdate(string, string5, list, list2)) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.relationId = string3;
        this.relationTypeName = string4;
        this.relationObjName = this.safeGetObjectName(objectName);
        this.roleName = string5;
        this.oldRoleValue = this.safeGetObjectNameList(list2);
        this.newRoleValue = this.safeGetObjectNameList(list);
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public ObjectName getObjectName() {
        return this.relationObjName;
    }

    public List<ObjectName> getMBeansToUnregister() {
        List<ObjectName> list = this.unregisterMBeanList != null ? new ArrayList<ObjectName>(this.unregisterMBeanList) : Collections.emptyList();
        return list;
    }

    public String getRoleName() {
        String string = null;
        if (this.roleName != null) {
            string = this.roleName;
        }
        return string;
    }

    public List<ObjectName> getOldRoleValue() {
        List<ObjectName> list = this.oldRoleValue != null ? new ArrayList<ObjectName>(this.oldRoleValue) : Collections.emptyList();
        return list;
    }

    public List<ObjectName> getNewRoleValue() {
        List<ObjectName> list = this.newRoleValue != null ? new ArrayList<ObjectName>(this.newRoleValue) : Collections.emptyList();
        return list;
    }

    private boolean isValidBasic(String string, Object object, String string2, String string3) {
        if (string == null || object == null || string2 == null || string3 == null) {
            return false;
        }
        return object instanceof RelationService || object instanceof ObjectName;
    }

    private boolean isValidCreate(String string) {
        String[] stringArray = new String[]{RELATION_BASIC_CREATION, RELATION_MBEAN_CREATION, RELATION_BASIC_REMOVAL, RELATION_MBEAN_REMOVAL};
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        return hashSet.contains(string);
    }

    private boolean isValidUpdate(String string, String string2, List<ObjectName> list, List<ObjectName> list2) {
        if (!string.equals(RELATION_BASIC_UPDATE) && !string.equals(RELATION_MBEAN_UPDATE)) {
            return false;
        }
        return string2 != null && list2 != null && list != null;
    }

    private ArrayList<ObjectName> safeGetObjectNameList(List<ObjectName> list) {
        ArrayList<ObjectName> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<ObjectName>();
            for (ObjectName objectName : list) {
                arrayList.add(ObjectName.getInstance(objectName));
            }
        }
        return arrayList;
    }

    private ObjectName safeGetObjectName(ObjectName objectName) {
        ObjectName objectName2 = null;
        if (objectName != null) {
            objectName2 = ObjectName.getInstance(objectName);
        }
        return objectName2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        List list;
        List list2;
        List list3;
        ObjectName objectName;
        String string;
        String string2;
        String string3;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        if (compat) {
            string3 = (String)getField.get("myRelId", null);
            string2 = (String)getField.get("myRelTypeName", null);
            string = (String)getField.get("myRoleName", null);
            objectName = (ObjectName)getField.get("myRelObjName", null);
            list3 = (List)Util.cast(getField.get("myNewRoleValue", null));
            list2 = (List)Util.cast(getField.get("myOldRoleValue", null));
            list = (List)Util.cast(getField.get("myUnregMBeanList", null));
        } else {
            string3 = (String)getField.get("relationId", null);
            string2 = (String)getField.get("relationTypeName", null);
            string = (String)getField.get("roleName", null);
            objectName = (ObjectName)getField.get("relationObjName", null);
            list3 = (List)Util.cast(getField.get("newRoleValue", null));
            list2 = (List)Util.cast(getField.get("oldRoleValue", null));
            list = (List)Util.cast(getField.get("unregisterMBeanList", null));
        }
        String string4 = super.getType();
        if (!this.isValidBasic(string4, super.getSource(), string3, string2) || !this.isValidCreate(string4) && !this.isValidUpdate(string4, string, list3, list2)) {
            super.setSource(null);
            throw new InvalidObjectException("Invalid object read");
        }
        this.relationObjName = this.safeGetObjectName(objectName);
        this.newRoleValue = this.safeGetObjectNameList(list3);
        this.oldRoleValue = this.safeGetObjectNameList(list2);
        this.unregisterMBeanList = this.safeGetObjectNameList(list);
        this.relationId = string3;
        this.relationTypeName = string2;
        this.roleName = string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("myNewRoleValue", this.newRoleValue);
            putField.put("myOldRoleValue", this.oldRoleValue);
            putField.put("myRelId", this.relationId);
            putField.put("myRelObjName", this.relationObjName);
            putField.put("myRelTypeName", this.relationTypeName);
            putField.put("myRoleName", this.roleName);
            putField.put("myUnregMBeanList", this.unregisterMBeanList);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -2126464566505527147L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6871117877523310399L;
        }
    }
}

