/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.AuthProvider;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.SecurityPermission;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import sun.security.ec.ECParameters;
import sun.security.pkcs11.Config;
import sun.security.pkcs11.P11Cipher;
import sun.security.pkcs11.P11Digest;
import sun.security.pkcs11.P11ECDHKeyAgreement;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyAgreement;
import sun.security.pkcs11.P11KeyGenerator;
import sun.security.pkcs11.P11KeyPairGenerator;
import sun.security.pkcs11.P11Mac;
import sun.security.pkcs11.P11RSACipher;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Signature;
import sun.security.pkcs11.P11TlsKeyMaterialGenerator;
import sun.security.pkcs11.P11TlsMasterSecretGenerator;
import sun.security.pkcs11.P11TlsPrfGenerator;
import sun.security.pkcs11.P11TlsRsaPremasterSecretGenerator;
import sun.security.pkcs11.Secmod;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;
import sun.security.util.ResourcesMgr;

public final class SunPKCS11
extends AuthProvider {
    private static final long serialVersionUID = -1354835039035306505L;
    static final Debug debug = Debug.getInstance("sunpkcs11");
    private static int dummyConfigId;
    final PKCS11 p11;
    private final String configName;
    final Config config;
    final long slotID;
    private CallbackHandler pHandler;
    private final Object LOCK_HANDLER = new Object();
    final boolean removable;
    final Secmod.Module nssModule;
    final boolean nssUseSecmodTrust;
    private volatile Token token;
    private TokenPoller poller;
    private static final Map<Integer, List<Descriptor>> descriptors;
    private static final String MD = "MessageDigest";
    private static final String SIG = "Signature";
    private static final String KPG = "KeyPairGenerator";
    private static final String KG = "KeyGenerator";
    private static final String AGP = "AlgorithmParameters";
    private static final String KF = "KeyFactory";
    private static final String SKF = "SecretKeyFactory";
    private static final String CIP = "Cipher";
    private static final String MAC = "Mac";
    private static final String KA = "KeyAgreement";
    private static final String KS = "KeyStore";
    private static final String SR = "SecureRandom";

    Token getToken() {
        return this.token;
    }

    public SunPKCS11() {
        super("SunPKCS11-Dummy", 1.7, "SunPKCS11-Dummy");
        throw new ProviderException("SunPKCS11 requires configuration file argument");
    }

    public SunPKCS11(String string) {
        this(SunPKCS11.checkNull(string), null);
    }

    public SunPKCS11(InputStream inputStream) {
        this(SunPKCS11.getDummyConfigName(), SunPKCS11.checkNull(inputStream));
    }

    private static <T> T checkNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    private static synchronized String getDummyConfigName() {
        int n = ++dummyConfigId;
        return "---DummyConfig-" + n + "---";
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SunPKCS11(String string, InputStream inputStream) {
        super("SunPKCS11-" + Config.getConfig(string, inputStream).getName(), 1.7, Config.getConfig(string, inputStream).getDescription());
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.configName = string;
        this.config = Config.removeConfig(string);
        if (debug != null) {
            System.out.println("SunPKCS11 loading " + string);
        }
        String string2 = this.config.getLibrary();
        String string3 = this.config.getFunctionList();
        Object object6 = this.config.getSlotID();
        int n2 = this.config.getSlotListIndex();
        boolean bl = this.config.getNssUseSecmod();
        boolean bl2 = this.config.getNssUseSecmodTrust();
        Secmod.Module module = null;
        if (bl) {
            int n3;
            object5 = Secmod.getInstance();
            object4 = this.config.getNssDbMode();
            try {
                object3 = this.config.getNssLibraryDirectory();
                object2 = this.config.getNssSecmodDirectory();
                n3 = this.config.getHandleStartupErrors();
                boolean n = this.config.getNssOptimizeSpace();
                if (((Secmod)object5).isInitialized()) {
                    if (object2 != null && (object = ((Secmod)object5).getConfigDir()) != null && !((String)object).equals(object2)) {
                        String string4 = "Secmod directory " + (String)object2 + " invalid, NSS already initialized with " + (String)object;
                        if (n3 == 4 || n3 == 2) {
                            throw new UnsupportedOperationException(string4);
                        }
                        throw new ProviderException(string4);
                    }
                    if (object3 != null && (object = ((Secmod)object5).getLibDir()) != null && !((String)object).equals(object3)) {
                        String string5 = "NSS library directory " + (String)object3 + " invalid, NSS already initialized with " + (String)object;
                        if (n3 == 4 || n3 == 2) {
                            throw new UnsupportedOperationException(string5);
                        }
                        throw new ProviderException(string5);
                    }
                } else {
                    if (object4 != Secmod.DbMode.NO_DB) {
                        if (object2 == null) {
                            throw new ProviderException("Secmod not initialized and nssSecmodDirectory not specified");
                        }
                    } else if (object2 != null) {
                        throw new ProviderException("nssSecmodDirectory must not be specified in noDb mode");
                    }
                    ((Secmod)object5).initialize((Secmod.DbMode)((Object)object4), (String)object2, (String)object3, n);
                }
            }
            catch (IOException iOException) {
                throw new ProviderException("Could not initialize NSS", iOException);
            }
            object3 = ((Secmod)object5).getModules();
            if (this.config.getShowInfo()) {
                System.out.println("NSS modules: " + object3);
            }
            if ((object2 = this.config.getNssModule()) == null) {
                module = ((Secmod)object5).getModule(Secmod.ModuleType.FIPS);
                if (module != null) {
                    object2 = "fips";
                } else {
                    Object object7 = object2 = object4 == Secmod.DbMode.NO_DB ? "crypto" : "keystore";
                }
            }
            if (((String)object2).equals("fips")) {
                module = ((Secmod)object5).getModule(Secmod.ModuleType.FIPS);
                bl2 = true;
                string3 = "FC_GetFunctionList";
            } else if (((String)object2).equals("keystore")) {
                module = ((Secmod)object5).getModule(Secmod.ModuleType.KEYSTORE);
                bl2 = true;
            } else if (((String)object2).equals("crypto")) {
                module = ((Secmod)object5).getModule(Secmod.ModuleType.CRYPTO);
            } else if (((String)object2).equals("trustanchors")) {
                module = ((Secmod)object5).getModule(Secmod.ModuleType.TRUSTANCHOR);
                bl2 = true;
            } else if (((String)object2).startsWith("external-")) {
                void var16_22;
                try {
                    n3 = Integer.parseInt(((String)object2).substring("external-".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = -1;
                }
                if (n3 < 1) {
                    throw new ProviderException("Invalid external module: " + (String)object2);
                }
                boolean bl3 = false;
                object = object3.iterator();
                while (object.hasNext()) {
                    Secmod.Module module2 = (Secmod.Module)object.next();
                    if (module2.getType() != Secmod.ModuleType.EXTERNAL || ++var16_22 != n3) continue;
                    module = module2;
                    break;
                }
                if (module == null) {
                    throw new ProviderException("Invalid module " + (String)object2 + ": only " + (int)var16_22 + " external NSS modules available");
                }
            } else {
                throw new ProviderException("Unknown NSS module: " + (String)object2);
            }
            if (module == null) {
                throw new ProviderException("NSS module not available: " + (String)object2);
            }
            if (module.hasInitializedProvider()) {
                throw new ProviderException("Secmod module already configured");
            }
            string2 = module.libraryName;
            n2 = module.slot;
        }
        this.nssUseSecmodTrust = bl2;
        this.nssModule = module;
        object5 = new File(string2);
        if (!((File)object5).getName().equals(string2) && !new File(string2).isFile()) {
            object4 = "Library " + string2 + " does not exist";
            if (this.config.getHandleStartupErrors() == 1) {
                throw new ProviderException((String)object4);
            }
            throw new UnsupportedOperationException((String)object4);
        }
        try {
            if (debug != null) {
                debug.println("Initializing PKCS#11 library " + string2);
            }
            object4 = new CK_C_INITIALIZE_ARGS();
            object3 = this.config.getNssArgs();
            if (object3 != null) {
                ((CK_C_INITIALIZE_ARGS)object4).pReserved = object3;
            }
            ((CK_C_INITIALIZE_ARGS)object4).flags = 2L;
            try {
                object2 = PKCS11.getInstance(string2, string3, (CK_C_INITIALIZE_ARGS)object4, this.config.getOmitInitialize());
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (debug != null) {
                    debug.println("Multi-threaded initialization failed: " + pKCS11Exception);
                }
                if (!this.config.getAllowSingleThreadedModules()) {
                    throw pKCS11Exception;
                }
                if (object3 == null) {
                    object4 = null;
                } else {
                    ((CK_C_INITIALIZE_ARGS)object4).flags = 0L;
                }
                object2 = PKCS11.getInstance(string2, string3, (CK_C_INITIALIZE_ARGS)object4, this.config.getOmitInitialize());
            }
            this.p11 = object2;
            CK_INFO cK_INFO = this.p11.C_GetInfo();
            if (cK_INFO.cryptokiVersion.major < 2) {
                throw new ProviderException("Only PKCS#11 v2.0 and later supported, library version is v" + cK_INFO.cryptokiVersion);
            }
            boolean bl4 = this.config.getShowInfo();
            if (bl4) {
                System.out.println("Information for provider " + this.getName());
                System.out.println("Library info:");
                System.out.println(cK_INFO);
            }
            if (object6 < 0L || bl4) {
                object = this.p11.C_GetSlotList(false);
                if (bl4) {
                    System.out.println("All slots: " + SunPKCS11.toString(object));
                    object = this.p11.C_GetSlotList(true);
                    System.out.println("Slots with tokens: " + SunPKCS11.toString((long[])object));
                }
                if (object6 < 0L) {
                    if (n2 < 0 || n2 >= ((Iterator<E>)object).length) {
                        throw new ProviderException("slotListIndex is " + n2 + " but token only has " + ((Object)object).length + " slots");
                    }
                    object6 = object[n2];
                }
            }
            this.slotID = object6;
            object = this.p11.C_GetSlotInfo((long)object6);
            this.removable = (((CK_SLOT_INFO)object).flags & 2L) != 0L;
            this.initToken((CK_SLOT_INFO)object);
            if (module != null) {
                module.setProvider(this);
            }
        }
        catch (Exception exception) {
            if (this.config.getHandleStartupErrors() == 2) {
                throw new UnsupportedOperationException("Initialization failed", exception);
            }
            throw new ProviderException("Initialization failed", exception);
        }
    }

    private static String toString(long[] lArray) {
        if (lArray.length == 0) {
            return "(none)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static String[] s(String string) {
        return new String[]{string};
    }

    private static String[] s(String string, String string2) {
        return new String[]{string, string2};
    }

    private static int[] m(long l) {
        return new int[]{(int)l};
    }

    private static int[] m(long l, long l2) {
        return new int[]{(int)l, (int)l2};
    }

    private static int[] m(long l, long l2, long l3) {
        return new int[]{(int)l, (int)l2, (int)l3};
    }

    private static int[] m(long l, long l2, long l3, long l4) {
        return new int[]{(int)l, (int)l2, (int)l3, (int)l4};
    }

    private static void d(String string, String string2, String string3, int[] nArray) {
        SunPKCS11.register(new Descriptor(string, string2, string3, null, nArray));
    }

    private static void d(String string, String string2, String string3, String[] stringArray, int[] nArray) {
        SunPKCS11.register(new Descriptor(string, string2, string3, stringArray, nArray));
    }

    private static void register(Descriptor descriptor) {
        for (int i = 0; i < descriptor.mechanisms.length; ++i) {
            int n = descriptor.mechanisms[i];
            Integer n2 = n;
            List<Descriptor> list = descriptors.get(n2);
            if (list == null) {
                list = new ArrayList<Descriptor>();
                descriptors.put(n2, list);
            }
            list.add(descriptor);
        }
    }

    private void createPoller() {
        if (this.poller != null) {
            return;
        }
        TokenPoller tokenPoller = new TokenPoller(this);
        Thread thread = new Thread((Runnable)tokenPoller, "Poller " + this.getName());
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.poller = tokenPoller;
    }

    private void destroyPoller() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller = null;
        }
    }

    private boolean hasValidToken() {
        Token token = this.token;
        return token != null && token.isValid();
    }

    synchronized void uninitToken(Token token) {
        if (this.token != token) {
            return;
        }
        this.destroyPoller();
        this.token = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SunPKCS11.this.clear();
                return null;
            }
        });
        this.createPoller();
    }

    private void initToken(CK_SLOT_INFO cK_SLOT_INFO) throws PKCS11Exception {
        if (cK_SLOT_INFO == null) {
            cK_SLOT_INFO = this.p11.C_GetSlotInfo(this.slotID);
        }
        if (this.removable && (cK_SLOT_INFO.flags & 1L) == 0L) {
            this.createPoller();
            return;
        }
        this.destroyPoller();
        boolean bl = this.config.getShowInfo();
        if (bl) {
            System.out.println("Slot info for slot " + this.slotID + ":");
            System.out.println(cK_SLOT_INFO);
        }
        final Token token = new Token(this);
        if (bl) {
            System.out.println("Token info for token in slot " + this.slotID + ":");
            System.out.println(token.tokenInfo);
        }
        long[] lArray = this.p11.C_GetMechanismList(this.slotID);
        final HashMap<Descriptor, Integer> hashMap = new HashMap<Descriptor, Integer>();
        for (int i = 0; i < lArray.length; ++i) {
            int n;
            Integer n2;
            List<Descriptor> list;
            long l = lArray[i];
            boolean bl2 = this.config.isEnabled(l);
            if (bl) {
                CK_MECHANISM_INFO cK_MECHANISM_INFO = this.p11.C_GetMechanismInfo(this.slotID, l);
                System.out.println("Mechanism " + Functions.getMechanismName(l) + ":");
                if (!bl2) {
                    System.out.println("DISABLED in configuration");
                }
                System.out.println(cK_MECHANISM_INFO);
            }
            if (!bl2 || l >>> 32 != 0L || (list = descriptors.get(n2 = Integer.valueOf(n = (int)l))) == null) continue;
            block1: for (Descriptor descriptor : list) {
                Integer n3 = (Integer)hashMap.get(descriptor);
                if (n3 == null) {
                    hashMap.put(descriptor, n2);
                    continue;
                }
                int n4 = n3;
                for (int j = 0; j < descriptor.mechanisms.length; ++j) {
                    int n5 = descriptor.mechanisms[j];
                    if (n == n5) {
                        hashMap.put(descriptor, n2);
                        continue block1;
                    }
                    if (n4 == n5) continue block1;
                }
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Map.Entry entry : hashMap.entrySet()) {
                    Descriptor descriptor = (Descriptor)entry.getKey();
                    int n = (Integer)entry.getValue();
                    P11Service p11Service = descriptor.service(token, n);
                    SunPKCS11.this.putService(p11Service);
                }
                if ((token.tokenInfo.flags & 1L) != 0L && SunPKCS11.this.config.isEnabled(2147483424L) && !token.sessionManager.lowMaxSessions()) {
                    SunPKCS11.this.putService(new P11Service(token, SunPKCS11.SR, "PKCS11", "sun.security.pkcs11.P11SecureRandom", null, 2147483424L));
                }
                if (SunPKCS11.this.config.isEnabled(2147483425L)) {
                    SunPKCS11.this.putService(new P11Service(token, SunPKCS11.KS, "PKCS11", "sun.security.pkcs11.P11KeyStore", SunPKCS11.s("PKCS11-" + SunPKCS11.this.config.getName()), 2147483425L));
                }
                return null;
            }
        });
        this.token = token;
    }

    @Override
    public void login(Subject subject, CallbackHandler callbackHandler) throws LoginException {
        Object object;
        Object object2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (debug != null) {
                debug.println("checking login permission");
            }
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            throw new LoginException("No token present");
        }
        if ((this.token.tokenInfo.flags & 4L) == 0L) {
            if (debug != null) {
                debug.println("login operation not required for token - ignoring login request");
            }
            return;
        }
        try {
            if (this.token.isLoggedInNow(null)) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        char[] cArray = null;
        if ((this.token.tokenInfo.flags & 0x100L) == 0L) {
            object2 = this.getCallbackHandler(callbackHandler);
            if (object2 == null) {
                throw new LoginException("no password provided, and no callback handler available for retrieving password");
            }
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("PKCS11.Token.providerName.Password."));
            object = new Object[]{this.getName()};
            PasswordCallback passwordCallback = new PasswordCallback(messageFormat.format(object), false);
            Callback[] callbackArray = new Callback[]{passwordCallback};
            try {
                object2.handle(callbackArray);
            }
            catch (Exception exception) {
                LoginException loginException = new LoginException("Unable to perform password callback");
                loginException.initCause(exception);
                throw loginException;
            }
            cArray = passwordCallback.getPassword();
            passwordCallback.clearPassword();
            if (cArray == null && debug != null) {
                debug.println("caller passed NULL pin");
            }
        }
        object2 = null;
        try {
            object2 = this.token.getOpSession();
            this.p11.C_Login(((Session)object2).id(), 1L, cArray);
            if (debug != null) {
                debug.println("login succeeded");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 256L) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
            if (pKCS11Exception.getErrorCode() == 160L) {
                object = new FailedLoginException();
                ((Throwable)object).initCause(pKCS11Exception);
                throw object;
            }
            object = new LoginException();
            ((Throwable)object).initCause(pKCS11Exception);
            throw object;
        }
        finally {
            this.token.releaseSession((Session)object2);
            if (cArray != null) {
                Arrays.fill(cArray, ' ');
            }
        }
    }

    @Override
    public void logout() throws LoginException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            return;
        }
        if ((this.token.tokenInfo.flags & 4L) == 0L) {
            if (debug != null) {
                debug.println("logout operation not required for token - ignoring logout request");
            }
            return;
        }
        try {
            if (!this.token.isLoggedInNow(null)) {
                if (debug != null) {
                    debug.println("user not logged in");
                }
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.p11.C_Logout(session.id());
            if (debug != null) {
                debug.println("logout succeeded");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 257L) {
                if (debug != null) {
                    debug.println("user not logged in");
                }
                return;
            }
            LoginException loginException = new LoginException();
            loginException.initCause(pKCS11Exception);
            throw loginException;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            this.pHandler = callbackHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandler getCallbackHandler(CallbackHandler callbackHandler) {
        if (callbackHandler != null) {
            return callbackHandler;
        }
        if (debug != null) {
            debug.println("getting provider callback handler");
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            if (this.pHandler != null) {
                return this.pHandler;
            }
            try {
                CallbackHandler callbackHandler2;
                if (debug != null) {
                    debug.println("getting default callback handler");
                }
                this.pHandler = callbackHandler2 = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                    @Override
                    public CallbackHandler run() throws Exception {
                        String string = Security.getProperty("auth.login.defaultCallbackHandler");
                        if (string == null || string.length() == 0) {
                            if (debug != null) {
                                debug.println("no default handler set");
                            }
                            return null;
                        }
                        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                        return (CallbackHandler)clazz.newInstance();
                    }
                });
                return callbackHandler2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (debug != null) {
                    debug.println("Unable to load default callback handler");
                    privilegedActionException.printStackTrace();
                }
            }
        }
        return null;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SunPKCS11Rep(this);
    }

    static {
        descriptors = new HashMap<Integer, List<Descriptor>>();
        String string = "sun.security.pkcs11.P11Digest";
        String string2 = "sun.security.pkcs11.P11MAC";
        String string3 = "sun.security.pkcs11.P11KeyPairGenerator";
        String string4 = "sun.security.pkcs11.P11KeyGenerator";
        String string5 = "sun.security.pkcs11.P11RSAKeyFactory";
        String string6 = "sun.security.pkcs11.P11DSAKeyFactory";
        String string7 = "sun.security.pkcs11.P11DHKeyFactory";
        String string8 = "sun.security.pkcs11.P11KeyAgreement";
        String string9 = "sun.security.pkcs11.P11SecretKeyFactory";
        String string10 = "sun.security.pkcs11.P11Cipher";
        String string11 = "sun.security.pkcs11.P11RSACipher";
        String string12 = "sun.security.pkcs11.P11Signature";
        SunPKCS11.d(MD, "MD2", string, SunPKCS11.m(512L));
        SunPKCS11.d(MD, "MD5", string, SunPKCS11.m(528L));
        SunPKCS11.d(MD, "SHA1", string, SunPKCS11.s("SHA", "SHA-1"), SunPKCS11.m(544L));
        SunPKCS11.d(MD, "SHA-256", string, SunPKCS11.m(592L));
        SunPKCS11.d(MD, "SHA-384", string, SunPKCS11.m(608L));
        SunPKCS11.d(MD, "SHA-512", string, SunPKCS11.m(624L));
        SunPKCS11.d(MAC, "HmacMD5", string2, SunPKCS11.m(529L));
        SunPKCS11.d(MAC, "HmacSHA1", string2, SunPKCS11.m(545L));
        SunPKCS11.d(MAC, "HmacSHA256", string2, SunPKCS11.m(593L));
        SunPKCS11.d(MAC, "HmacSHA384", string2, SunPKCS11.m(609L));
        SunPKCS11.d(MAC, "HmacSHA512", string2, SunPKCS11.m(625L));
        SunPKCS11.d(MAC, "SslMacMD5", string2, SunPKCS11.m(896L));
        SunPKCS11.d(MAC, "SslMacSHA1", string2, SunPKCS11.m(897L));
        SunPKCS11.d(KPG, "RSA", string3, SunPKCS11.m(0L));
        SunPKCS11.d(KPG, "DSA", string3, SunPKCS11.m(16L));
        SunPKCS11.d(KPG, "DH", string3, SunPKCS11.s("DiffieHellman"), SunPKCS11.m(32L));
        SunPKCS11.d(KPG, "EC", string3, SunPKCS11.m(4160L));
        SunPKCS11.d(KG, "ARCFOUR", string4, SunPKCS11.s("RC4"), SunPKCS11.m(272L));
        SunPKCS11.d(KG, "DES", string4, SunPKCS11.m(288L));
        SunPKCS11.d(KG, "DESede", string4, SunPKCS11.m(305L, 304L));
        SunPKCS11.d(KG, "AES", string4, SunPKCS11.m(4224L));
        SunPKCS11.d(KG, "Blowfish", string4, SunPKCS11.m(4240L));
        SunPKCS11.d(KF, "RSA", string5, SunPKCS11.m(0L, 1L, 3L));
        SunPKCS11.d(KF, "DSA", string6, SunPKCS11.m(16L, 17L, 18L));
        SunPKCS11.d(KF, "DH", string7, SunPKCS11.s("DiffieHellman"), SunPKCS11.m(32L, 33L));
        SunPKCS11.d(KF, "EC", string7, SunPKCS11.m(4160L, 4176L, 4161L, 4162L));
        SunPKCS11.d(AGP, "EC", "sun.security.ec.ECParameters", SunPKCS11.s("1.2.840.10045.2.1"), SunPKCS11.m(4160L, 4176L, 4161L, 4162L));
        SunPKCS11.d(KA, "DH", string8, SunPKCS11.s("DiffieHellman"), SunPKCS11.m(33L));
        SunPKCS11.d(KA, "ECDH", "sun.security.pkcs11.P11ECDHKeyAgreement", SunPKCS11.m(4176L));
        SunPKCS11.d(SKF, "ARCFOUR", string9, SunPKCS11.s("RC4"), SunPKCS11.m(273L));
        SunPKCS11.d(SKF, "DES", string9, SunPKCS11.m(290L));
        SunPKCS11.d(SKF, "DESede", string9, SunPKCS11.m(307L));
        SunPKCS11.d(SKF, "AES", string9, SunPKCS11.m(4226L));
        SunPKCS11.d(SKF, "Blowfish", string9, SunPKCS11.m(4241L));
        SunPKCS11.d(CIP, "ARCFOUR", string10, SunPKCS11.s("RC4"), SunPKCS11.m(273L));
        SunPKCS11.d(CIP, "DES/CBC/NoPadding", string10, SunPKCS11.m(290L));
        SunPKCS11.d(CIP, "DES/CBC/PKCS5Padding", string10, SunPKCS11.m(293L, 290L));
        SunPKCS11.d(CIP, "DES/ECB/NoPadding", string10, SunPKCS11.m(289L));
        SunPKCS11.d(CIP, "DES/ECB/PKCS5Padding", string10, SunPKCS11.s("DES"), SunPKCS11.m(289L));
        SunPKCS11.d(CIP, "DESede/CBC/NoPadding", string10, SunPKCS11.m(307L));
        SunPKCS11.d(CIP, "DESede/CBC/PKCS5Padding", string10, SunPKCS11.m(310L, 307L));
        SunPKCS11.d(CIP, "DESede/ECB/NoPadding", string10, SunPKCS11.m(306L));
        SunPKCS11.d(CIP, "DESede/ECB/PKCS5Padding", string10, SunPKCS11.s("DESede"), SunPKCS11.m(306L));
        SunPKCS11.d(CIP, "AES/CBC/NoPadding", string10, SunPKCS11.m(4226L));
        SunPKCS11.d(CIP, "AES/CBC/PKCS5Padding", string10, SunPKCS11.m(4229L, 4226L));
        SunPKCS11.d(CIP, "AES/ECB/NoPadding", string10, SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES/ECB/PKCS5Padding", string10, SunPKCS11.s("AES"), SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES/CTR/NoPadding", string10, SunPKCS11.m(4230L));
        SunPKCS11.d(CIP, "Blowfish/CBC/NoPadding", string10, SunPKCS11.m(4241L));
        SunPKCS11.d(CIP, "Blowfish/CBC/PKCS5Padding", string10, SunPKCS11.m(4241L));
        SunPKCS11.d(CIP, "RSA/ECB/PKCS1Padding", string11, SunPKCS11.s("RSA"), SunPKCS11.m(1L));
        SunPKCS11.d(CIP, "RSA/ECB/NoPadding", string11, SunPKCS11.m(3L));
        SunPKCS11.d(SIG, "RawDSA", string12, SunPKCS11.s("NONEwithDSA"), SunPKCS11.m(17L));
        SunPKCS11.d(SIG, "DSA", string12, SunPKCS11.s("SHA1withDSA"), SunPKCS11.m(18L, 17L));
        SunPKCS11.d(SIG, "NONEwithECDSA", string12, SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA1withECDSA", string12, SunPKCS11.s("ECDSA"), SunPKCS11.m(4162L, 4161L));
        SunPKCS11.d(SIG, "SHA256withECDSA", string12, SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA384withECDSA", string12, SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA512withECDSA", string12, SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "MD2withRSA", string12, SunPKCS11.m(4L, 1L, 3L));
        SunPKCS11.d(SIG, "MD5withRSA", string12, SunPKCS11.m(5L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA1withRSA", string12, SunPKCS11.m(6L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA256withRSA", string12, SunPKCS11.m(64L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA384withRSA", string12, SunPKCS11.m(65L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA512withRSA", string12, SunPKCS11.m(66L, 1L, 3L));
        SunPKCS11.d(KG, "SunTlsRsaPremasterSecret", "sun.security.pkcs11.P11TlsRsaPremasterSecretGenerator", SunPKCS11.m(880L, 884L));
        SunPKCS11.d(KG, "SunTlsMasterSecret", "sun.security.pkcs11.P11TlsMasterSecretGenerator", SunPKCS11.m(881L, 885L, 883L, 887L));
        SunPKCS11.d(KG, "SunTlsKeyMaterial", "sun.security.pkcs11.P11TlsKeyMaterialGenerator", SunPKCS11.m(882L, 886L));
        SunPKCS11.d(KG, "SunTlsPrf", "sun.security.pkcs11.P11TlsPrfGenerator", SunPKCS11.m(888L, 2147484531L));
    }

    private static class SunPKCS11Rep
    implements Serializable {
        static final long serialVersionUID = -2896606995897745419L;
        private final String providerName;
        private final String configName;

        SunPKCS11Rep(SunPKCS11 sunPKCS11) throws NotSerializableException {
            this.providerName = sunPKCS11.getName();
            this.configName = sunPKCS11.configName;
            if (Security.getProvider(this.providerName) != sunPKCS11) {
                throw new NotSerializableException("Only SunPKCS11 providers installed in java.security.Security can be serialized");
            }
        }

        private Object readResolve() throws ObjectStreamException {
            SunPKCS11 sunPKCS11 = (SunPKCS11)Security.getProvider(this.providerName);
            if (sunPKCS11 == null || !sunPKCS11.configName.equals(this.configName)) {
                throw new NotSerializableException("Could not find " + this.providerName + " in installed providers");
            }
            return sunPKCS11;
        }
    }

    private static final class P11Service
    extends Provider.Service {
        private final Token token;
        private final long mechanism;

        P11Service(Token token, String string, String string2, String string3, String[] stringArray, long l) {
            super(token.provider, string, string2, string3, P11Service.toList(stringArray), null);
            this.token = token;
            this.mechanism = l & 0xFFFFFFFFL;
        }

        private static List<String> toList(String[] stringArray) {
            return stringArray == null ? null : Arrays.asList(stringArray);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            if (!this.token.isValid()) {
                throw new NoSuchAlgorithmException("Token has been removed");
            }
            try {
                return this.newInstance0(object);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new NoSuchAlgorithmException(pKCS11Exception);
            }
        }

        public Object newInstance0(Object object) throws PKCS11Exception, NoSuchAlgorithmException {
            String string = this.getAlgorithm();
            String string2 = this.getType();
            if (string2 == SunPKCS11.MD) {
                return new P11Digest(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.CIP) {
                if (string.startsWith("RSA")) {
                    return new P11RSACipher(this.token, string, this.mechanism);
                }
                return new P11Cipher(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.SIG) {
                return new P11Signature(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.MAC) {
                return new P11Mac(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.KPG) {
                return new P11KeyPairGenerator(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.KA) {
                if (string.equals("ECDH")) {
                    return new P11ECDHKeyAgreement(this.token, string, this.mechanism);
                }
                return new P11KeyAgreement(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.KF) {
                return this.token.getKeyFactory(string);
            }
            if (string2 == SunPKCS11.SKF) {
                return new P11SecretKeyFactory(this.token, string);
            }
            if (string2 == SunPKCS11.KG) {
                if (string == "SunTlsRsaPremasterSecret") {
                    return new P11TlsRsaPremasterSecretGenerator(this.token, string, this.mechanism);
                }
                if (string == "SunTlsMasterSecret") {
                    return new P11TlsMasterSecretGenerator(this.token, string, this.mechanism);
                }
                if (string == "SunTlsKeyMaterial") {
                    return new P11TlsKeyMaterialGenerator(this.token, string, this.mechanism);
                }
                if (string == "SunTlsPrf") {
                    return new P11TlsPrfGenerator(this.token, string, this.mechanism);
                }
                return new P11KeyGenerator(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.SR) {
                return this.token.getRandom();
            }
            if (string2 == SunPKCS11.KS) {
                return this.token.getKeyStore();
            }
            if (string2 == SunPKCS11.AGP) {
                return new ECParameters();
            }
            throw new NoSuchAlgorithmException("Unknown type: " + string2);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (object == null || !this.token.isValid()) {
                return false;
            }
            if (!(object instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String string = this.getAlgorithm();
            String string2 = this.getType();
            Key key = (Key)object;
            String string3 = key.getAlgorithm();
            if (string2 == SunPKCS11.CIP && string.startsWith("RSA") || string2 == SunPKCS11.SIG && string.endsWith("RSA")) {
                if (!string3.equals("RSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof RSAPrivateKey || key instanceof RSAPublicKey;
            }
            if (string2 == SunPKCS11.KA && string.equals("ECDH") || string2 == SunPKCS11.SIG && string.endsWith("ECDSA")) {
                if (!string3.equals("EC")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            if (string2 == SunPKCS11.SIG && string.endsWith("DSA")) {
                if (!string3.equals("DSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DSAPrivateKey || key instanceof DSAPublicKey;
            }
            if (string2 == SunPKCS11.CIP || string2 == SunPKCS11.MAC) {
                return this.isLocalKey(key) || "RAW".equals(key.getFormat());
            }
            if (string2 == SunPKCS11.KA) {
                if (!string3.equals("DH")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DHPrivateKey || key instanceof DHPublicKey;
            }
            throw new AssertionError((Object)("SunPKCS11 error: " + string2 + ", " + string));
        }

        private boolean isLocalKey(Key key) {
            return key instanceof P11Key && ((P11Key)key).token == this.token;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + Functions.getMechanismName(this.mechanism) + ")";
        }
    }

    private static class TokenPoller
    implements Runnable {
        private final SunPKCS11 provider;
        private volatile boolean enabled;

        private TokenPoller(SunPKCS11 sunPKCS11) {
            this.provider = sunPKCS11;
            this.enabled = true;
        }

        @Override
        public void run() {
            int n = this.provider.config.getInsertionCheckInterval();
            while (this.enabled) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!this.enabled) break;
                try {
                    this.provider.initToken(null);
                }
                catch (PKCS11Exception pKCS11Exception) {}
            }
        }

        void disable() {
            this.enabled = false;
        }
    }

    private static final class Descriptor {
        final String type;
        final String algorithm;
        final String className;
        final String[] aliases;
        final int[] mechanisms;

        private Descriptor(String string, String string2, String string3, String[] stringArray, int[] nArray) {
            this.type = string;
            this.algorithm = string2;
            this.className = string3;
            this.aliases = stringArray;
            this.mechanisms = nArray;
        }

        private P11Service service(Token token, int n) {
            return new P11Service(token, this.type, this.algorithm, this.className, this.aliases, n);
        }

        public String toString() {
            return this.type + "." + this.algorithm;
        }
    }
}

