-- language settings for addon.
-- English is default and does not have to been set in a separate table.
local _, namespace = ...
local L = setmetatable({}, { __index = function(t, k)
	local v = tostring(k)
	rawset(t, k, v)
	return v
end })
namespace.L = L
-------------------------------------
local LOCALE = GetLocale()
-- local LOCALE = "deDE"
-------------------------------------
if LOCALE:match("^en") then
return end
-------------------------------------
if LOCALE == "deDE" then
	-- German translations go here
	L["All to"] = "Allzu"
	L["Big incoming at"] = "Grossen ankommenden an"
	L["A few incoming at"] = "Ein paar eingehende an"
	L["Safe is"] = "Wieder sicher ist"
	-- Arathi Basin
	L["BS"] = "Schmiede"
	L["Farm"] = "Hof"
	L["LM"] = "Sägewerk"
	L["Mine"] = "Mine"
	L["Stable"] = "Stall"
	-- Alterac Valley horde offense bar
	L["Stoneheart"] = "Stoneheart"
	L["Icewing"] = "Icewing"
	L["Bal"] = "Bal"
	L["North Bunker"] = "North Bunker"
	L["South Bunker"] = "South Bunker"
	L["Frostwolf Keep"] = "Frostwolf Keep"
	L["Van"] = "Van"
	-- Alterac Valley alliance offense bar
	L["Iceblood"] = "Iceblood"
	L["TP"] = "TP"
	L["Galv"] = "Galv"
	L["West Tower"] = "West Turm"
	L["East Tower"] = "East Turm"
	L["Dun Baldar"] = "Dun Baldar"
	L["Drek"] = "Drek"
	-- Warsong Gulch
	L["horde flag carrier"] = "horde flag carrier"
	L["alliance flag carrier"] = "alliance flag carrier"
return end
-------------------------------------
if LOCALE == "frFR" then
	-- French translations go here
	L["Hello!"] = "Bonjour!"
return end
-------------------------------------
if LOCALE == "esES" or LOCALE == "esMX" then
	-- Spanish translations go here
	L["Hello!"] = "¡Hola!"
return end
-------------------------------------
if LOCALE == "ptBR" then
	-- Brazilian Portuguese translations go here
	L["Hello!"] = "Olá!"
return end
-------------------------------------
if LOCALE == "ruRU" then
	-- Russian translations go here
	L["Hello!"] = "ÐŸÑ€Ð¸Ð²ÐµÑ‚!"
return end
-------------------------------------
if LOCALE == "koKR" then
	-- Korean translations go here
	L["Hello!"] = "ì•ˆë…•í•˜ì„¸ìš”!"
return end
-------------------------------------
if LOCALE == "zhCN" then
	-- Simplified Chinese translations go here
	L["All to"] = "全都来"
	L["Big incoming at"] = "大量敌人来"
	L["A few incoming at"] = "少量敌人来"
	L["Safe is"] = "已清理完"
	-- 阿拉希盆地
	L["BS"] = "铁匠"
	L["Farm"] = "农场"
	L["LM"] = "伐木"
	L["Mine"] = "矿洞"
	L["Stable"] = "兽栏"
	-- 奥山部落条
	L["Stonehearth"] = "石炉塔"
	L["Icewing"] = "冰翼塔"
	L["Bal"] = "女人"
	L["North Bunker"] = "北塔"
	L["South Bunker"] = "南塔"
	L["Frostwolf Keep"] = "部落急救"
	L["Van"] = "将军"
	--奥山联盟条
	L["Iceblood"] = "冰血"
	L["TP"] = "哨高"
	L["Galv"] = "男人"
	L["West Tower"] = "西塔"
	L["East Tower"] = "东塔"
	L["Dun Baldar"] = "联盟急救"
	L["Drek"] = "督军"
	-- 战歌峡谷
	L["horde flag carrier"] = "部落旗危险"
	L["alliance flag carrier"] = "联盟旗危险"
return end
-------------------------------------
if LOCALE == "zhTW" then
	-- Traditional Chinese translations go here
	L["Hello!"] = "æ‚¨å¥½!"
return end
--END--------------------------------