-- Author      : Txty
-- Create Date : 9/23/2014 12:27:36 AM
-------------------------------------
local ADDON_NAME, namespace = ...
local L = namespace.L
local cf = {}
namespace.cf = cf
-----------------------------------
-- Frame
-------------------------------------
local function SetupBGFrame(frame)
   frame:SetMovable(true)
   frame:EnableMouse(true)
   frame:RegisterForDrag("LeftButton")
   frame:SetScript("OnDragStart", frame.StartMoving)
   frame:SetScript("OnDragStop", frame.StopMovingOrSizing)
   frame:SetPoint("CENTER", UIParent, "CENTER")
-- The code below makes the frame visible
   frame:SetBackdrop({
		bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background-Dark", tile = true, tileSize = 20,
		edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
		insets = { left = 10, right = 10, top = 10, bottom = 10 }
		})
     frame:SetBackdropColor(0.8,0.8,0.8,1)
     frame:SetBackdropBorderColor(0.8,0.8,0.8,1)
		if (frame:GetName() == 'avhorde' or frame:GetName() == 'avally') then
			frame:SetSize(40+18, 7*40+18)
		elseif (frame:GetName() == 'wGulch') then
			frame:SetSize(40+18, 2*40+18)
		else
			frame:SetSize(40+18, 5*40+18)
		end
  return frame
end
-------------------------------------
-- Buttons
-------------------------------------
-- this function returns a value if you are raid leader (rank=2), assistant (rank=1) or else (rank=0)
local function getPlayerRank()
local playerName = UnitName("player")
	for i = 1, MAX_RAID_MEMBERS do
		local name, rank = GetRaidRosterInfo(i)
		if name == playerName then
			return rank
		end
	end
	return 0
end
-------------------------------------
local function LocationButton_OnClick(self, mouseButton)
--   BGCallouts:Print(self:GetParent():GetName())
   local name = self.location
   local icon, message
   if IsShiftKeyDown() and mouseButton == "LeftButton" then
      icon, message = "{rt8}", L["Big incoming at"]
   elseif IsShiftKeyDown() and mouseButton == "RightButton" then
      icon, message = "{rt2}", L["All to"]
   elseif mouseButton == "LeftButton" then
      icon, message = "{rt7}", L["A few incoming at"]      
   else
      icon, message = "{rt4}", L["Safe is"]
   end
   if (getPlayerRank()>=1 and cf.rw==1) then -- true if you are raid leader or assistant
	  SendChatMessage(format("%s %s %s", icon, message, name), "RAID_WARNING")
	  SendChatMessage(format("%s %s %s", icon, message, name), "INSTANCE_CHAT")	  
   else
	  SendChatMessage(format("%s %s %s", icon, message, name), "INSTANCE_CHAT")
   end
end
-------------------------------------
local function AddLocationButton(bgFrame, name, texture)
   local button = CreateFrame("Button", nil, bgFrame)
   button:SetSize(40, 40)
   button:RegisterForClicks("LeftButtonUp", "RightButtonUp")
   button:SetScript("OnClick", LocationButton_OnClick)

   -- Store the location name on the button:
   button.location = name
   -- Apply the specified texture:
   button:SetNormalTexture("Interface/AddOns/BGCallouts/Icons/"..texture)

   -- Store the button on the frame:
   bgFrame.locations = bgFrame.locations or {}
   tinsert(bgFrame.locations, button)

   -- Automatically place the button:
   local i = #bgFrame.locations
   if i == 1 then
      -- This is the first button on this frame, attach it to the top:
      button:SetPoint("TOPLEFT", 9, -10)
   else
      -- Attach it to the bottom of the previous button:
      button:SetPoint("TOPLEFT", bgFrame.locations[i-1], "BOTTOMLEFT")
   end	
   return button
end
-------------------------------------
-- Create Frames and Buttons
-------------------------------------
function cf.createFrames(name)
	for i,v in pairs(name) do
		name[i] = CreateFrame("FRAME", v, UIParent)
		SetupBGFrame(name[i])
	end
--------------
-- Buttons	
--------------
	-- Arathi Basin
	AddLocationButton(ab, L["Farm"], "farm")
	AddLocationButton(ab, L["Mine"], "gm")
	AddLocationButton(ab, L["BS"], "blacksmith")
	AddLocationButton(ab, L["LM"], "lumbermill")
	AddLocationButton(ab, L["Stable"], "stable")
	-- Alterac Valley Alliance
	AddLocationButton(avally, L["Stonehearth"], "sh")
	AddLocationButton(avally, L["Icewing"], "iw")
	AddLocationButton(avally, L["Bal"], "balinda")
	AddLocationButton(avally, L["North Bunker"], "bunker1")
	AddLocationButton(avally, L["South Bunker"], "bunker2")
	AddLocationButton(avally, L["Dun Baldar"], "akeep")
	AddLocationButton(avally, L["Van"], "vanndar")
	-- Alterac Valley Horde
	AddLocationButton(avhorde, L["Iceblood"], "ib")
	AddLocationButton(avhorde, L["TP"], "tp")
	AddLocationButton(avhorde, L["Galv"], "galvangar")
	AddLocationButton(avhorde, L["West Tower"], "tower1")
	AddLocationButton(avhorde, L["East Tower"], "tower2")
	AddLocationButton(avhorde, L["Frostwolf Keep"], "hkeep")
	AddLocationButton(avhorde, L["Drek"], "drek")
	-- Warsong Gulch
	AddLocationButton(wGulch, L["alliance flag carrier"], "AFC")
	AddLocationButton(wGulch, L["horde flag carrier"], "HFC")
end
-- END ------------------------------