-- =====================================
-- Author      : Txty
-- Create Date : 9/23/2014 12:27:36 AM
-- =====================================
local ADDON_NAME, namespace = ...
local cf = namespace.cf
local BGFrame = {"ab","wGulch","avhorde","avally"}
-------------------------------------
local DEFAULT_SETTINGS = {
    -- We will use the "char" section, which is specific to each character
    char = {
        -- No need to append "default" to all names
		setPointx = nil,
		setPointy = nil,
	}
}
-------------------------------------
BGCallouts = LibStub("AceAddon-3.0"):NewAddon("BGCallouts", "AceConsole-3.0", "AceEvent-3.0" );
-------------------------------------
function BGCallouts:OnInitialize()
	-- Called when the addon is loaded
	BGCallouts:Print("Loaded")
	cf.createFrames(BGFrame)
	cf.rw = 1 -- raid warning enabled but you still need to be assistant or raidleader too.
	BGCallouts:Print("Raid warnings is enabled if you are assistant or raid leader.")
	-- Initialize the database
		for i=1, #BGFrame do
			BGFrame[i].db = LibStub('AceDB-3.0'):New("BGCalloutsDB", DEFAULT_SETTINGS)
			BGFrame[i]:SetPoint("CENTER", UIParent, "CENTER", BGFrame[i].db.char.setPointx, BGFrame[i].db.char.setPointy)
		end
end
-------------------------------------
local function showFrames()
	for i=1, #BGFrame do
		BGFrame[i]:Show(true)
	end
return end
-------------------------------------
local function hideFrames()
	for i=1, #BGFrame do
		BGFrame[i]:Hide(true)
	end
return end
-------------------------------------
BGCallouts.func = function(self,n,_,_,_,_,_,_,iid)
	 --  BGCallouts:Print(iid)
	if (iid==529 or iid==1681 or iid==2177 or iid==2107) then
		ab:Show(true)
	elseif (iid==30) then
		avhorde:Show(true)
		avally:Show(true)
	--elseif (iid==30) then
	--	wGulch:Show(true)
	else
		hideFrames()
	end
return end
-------------------------------------
-- Slash commands
SLASH_BGC1 = "/BGCallouts"
SlashCmdList["BGC"] = function (msg)
	if (msg=="show") then
		showFrames()	
	elseif (msg=="hide") then
		hideFrames()
	elseif (msg=="rwoff") then
		cf.rw = 0
		BGCallouts:Print("Raid warnings is now disabled.")
	else
		BGCallouts:Print("Only works with 'show', 'hide' or 'rwoff'.")
	end
end
-------------------------------------
function BGCallouts:OnEnable()
		-- Called when the addon is enabled
		-- Print a message to the chat frame
		-- self:Print("OnEnable Event Fired: Hello, again ;)")
		hideFrames()
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
		BGCallouts:func(GetInstanceInfo())
end
-------------------------------------
function BGCallouts:OnDisable()
		-- Called when the addon is disabled
end
-------------------------------------
function BGCallouts:ZONE_CHANGED_NEW_AREA()
	BGCallouts:func(GetInstanceInfo())
end
-- END ------------------------------
