local addonName, addon = ...
local _G = _G

-- luacheck: globals UIDropDownMenu_AddButton

addon.combatProtected = {
	-- List of cvars that can't be modified in combat
	["alwaysShowActionBars"] = true,
	["colorblindSimulator"] = true,
	["colorblindWeaknessFactor"] = true,
	["daltonize"] = true,
	["fullSizeFocusFrame"] = true,
	["garrisonCompleteTalent"] = true,
	["garrisonCompleteTalentType"] = true,
	["nameplateClassResourceTopInset"] = true,
	["nameplateGlobalScale"] = true,
	["NamePlateHorizontalScale"] = true,
	["nameplateLargeBottomInset"] = true,
	["nameplateLargerScale"] = true,
	["nameplateLargeTopInset"] = true,
	["nameplateMaxAlpha"] = true,
	["nameplateMaxAlphaDistance"] = true,
	["nameplateMaxDistance"] = true,
	["nameplateMaxScale"] = true,
	["nameplateMaxScaleDistance"] = true,
	["nameplateMinAlpha"] = true,
	["nameplateMinAlphaDistance"] = true,
	["nameplateMinScale"] = true,
	["nameplateMinScaleDistance"] = true,
	["nameplateMotion"] = true,
	["nameplateMotionSpeed"] = true,
	["nameplateOtherAtBase"] = true,
	["nameplateOtherBottomInset"] = true,
	["nameplateOtherTopInset"] = true,
	["nameplateOverlapH"] = true,
	["nameplateOverlapV"] = true,
	["NameplatePersonalHideDelayAlpha"] = true,
	["nameplatePersonalHideDelaySeconds"] = true,
	["nameplatePersonalShowAlways"] = true,
	["nameplatePersonalShowInCombat"] = true,
	["nameplatePersonalShowWithTarget"] = true,
	["nameplateResourceOnTarget"] = true,
	["nameplateSelectedAlpha"] = true,
	["nameplateSelectedScale"] = true,
	["nameplateSelfAlpha"] = true,
	["nameplateSelfBottomInset"] = true,
	["nameplateSelfScale"] = true,
	["nameplateSelfTopInset"] = true,
	["nameplateShowAll"] = true,
	["nameplateShowEnemies"] = true,
	["nameplateShowEnemyGuardians"] = true,
	["nameplateShowEnemyMinions"] = true,
	["nameplateShowEnemyMinus"] = true,
	["nameplateShowEnemyPets"] = true,
	["nameplateShowEnemyTotems"] = true,
	["nameplateShowFriendlyGuardians"] = true,
	["nameplateShowFriendlyMinions"] = true,
	["nameplateShowFriendlyNPCs"] = true,
	["nameplateShowFriendlyPets"] = true,
	["nameplateShowFriendlyTotems"] = true,
	["nameplateShowFriends"] = true,
	["nameplateShowSelf"] = true,
	["nameplateTargetBehindMaxDistance"] = true,
	["NamePlateVerticalScale"] = true,
	["showArenaEnemyFrames"] = true,
	["showArenaEnemyPets"] = true,
	["showPartyPets"] = true,
	["showTargetOfTarget"] = true,
	["splashScreenBoost"] = true,
	["splashScreenNormal"] = true,
	["targetOfTargetMode"] = true,
	["uiScale"] = true,
	["uiScaleMultiplier"] = true,
	["UnitNameGuildTitle"] = true,
	["useCompactPartyFrames"] = true,
	["useUiScale"] = true,
}

addon.hiddenOptions = {
	-- Names
	["UnitNameOwn"] = { prettyName = UNIT_NAME_OWN, description = OPTION_TOOLTIP_UNIT_NAME_OWN, type = "boolean" },
	["UnitNameNPC"] = { prettyName = UNIT_NAME_NPC, description = OPTION_TOOLTIP_UNIT_NAME_NPC, type = "boolean" },
	["UnitNameNonCombatCreatureName"] = { prettyName = UNIT_NAME_NONCOMBAT_CREATURE, description = OPTION_TOOLTIP_UNIT_NAME_NONCOMBAT_CREATURE, type = "boolean" },
	["UnitNamePlayerGuild"] = { prettyName = UNIT_NAME_GUILD, description = OPTION_TOOLTIP_UNIT_NAME_GUILD, type = "boolean" },
	["UnitNameGuildTitle"] = { prettyName = UNIT_NAME_GUILD_TITLE, description = OPTION_TOOLTIP_UNIT_NAME_GUILD_TITLE , type = "boolean" },
	["UnitNamePlayerPVPTitle"] = { prettyName = UNIT_NAME_PLAYER_TITLE, description = OPTION_TOOLTIP_UNIT_NAME_PLAYER_TITLE, type = "boolean" },
	["UnitNameFriendlyPlayerName"] = { prettyName = UNIT_NAME_FRIENDLY, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY, type = "boolean" },
	["UnitNameFriendlyPetName"] = { prettyName = UNIT_NAME_FRIENDLY_PETS, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY_PETS, type = "boolean" },
	["UnitNameFriendlyGuardianName"] = { prettyName = UNIT_NAME_FRIENDLY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY_GUARDIANS, type = "boolean" },
	["UnitNameFriendlyTotemName"] = { prettyName = UNIT_NAME_FRIENDLY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY_TOTEMS, type = "boolean" },
	["UnitNameFriendlyMinionName"] = { prettyName = UNIT_NAME_FRIENDLY_MINIONS, description = "", type = "boolean" },
	["UnitNameEnemyPlayerName"] = { prettyName = UNIT_NAME_ENEMY, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY, type = "boolean" },
	["UnitNameEnemyPetName"] = { prettyName = UNIT_NAME_ENEMY_PETS, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY_PETS, type = "boolean" },
	["UnitNameEnemyGuardianName"] = { prettyName = UNIT_NAME_ENEMY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY_GUARDIANS, type = "boolean" },
	["UnitNameEnemyTotemName"] = { prettyName = UNIT_NAME_ENEMY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY_TOTEMS, type = "boolean" },
	["UnitNameEnemyMinionName"] = { prettyName = UNIT_NAME_ENEMY_MINIONS, description = "", type = "boolean" },
	["UnitNameForceHideMinus"] = { prettyName = UNIT_NAME_HIDE_MINUS, description = OPTION_TOOLTIP_UNIT_NAME_HIDE_MINUS, type = "boolean" },
	["UnitNameFriendlySpecialNPCName"] = { prettyName = NPC_NAMES_DROPDOWN_TRACKED, description = NPC_NAMES_DROPDOWN_TRACKED_TOOLTIP, type = "boolean" },
	["UnitNameHostleNPC"] = { prettyName = "敌对NPC", description = "敌对NPC显示名字", type = "boolean" },
	["UnitNameInteractiveNPC"] = { prettyName = "交互式NPC", description = "交互式NPC显示名字", type = "boolean" },
	-- Nameplates
	["nameplateShowFriends"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDS, type = "boolean" },
	["nameplateShowFriendlyPets"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDLY_PETS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDLY_PETS, type = "boolean" },
	["nameplateShowFriendlyGuardians"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDLY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDLY_GUARDIANS, type = "boolean" },
	["nameplateShowFriendlyTotems"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDLY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDLY_TOTEMS, type = "boolean" },
	["nameplateShowFriendlyNPCs"] = { prettyName = "友方NPC", description = "始终显示友方的NPC的姓名板", type = "boolean" },
	["nameplateShowEnemies"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMIES, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMIES, type = "boolean" },
	["nameplateShowEnemyPets"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_PETS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_PETS, type = "boolean" },
	["nameplateShowEnemyGuardians"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_GUARDIANS, type = "boolean" },
	["nameplateShowEnemyTotems"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_TOTEMS, type = "boolean" },
	["nameplateShowEnemyMinus"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_MINUS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_MINUS, type = "boolean" },
	["nameplateOtherAtBase"] = { prettyName = "底部姓名板", description = "将其他姓名板移到底部而不是头上,2=under unit, 0=over unit", type = "boolean" },
	["nameplateOverlapH"] = { prettyName = "姓名板重叠 (水平)", description = "姓名板水平重叠百分比", type = "number" },
	["nameplateOverlapV"] = { prettyName = "姓名板重叠 (垂直)", description = "姓名板垂直重叠百分比", type = "number" },
	["nameplateMaxDistance"] = { prettyName = "姓名板距离", description = "显示姓名板的最大距离", type = "number" },
	["nameplateTargetBehindMaxDistance"] = { prettyName = "目标姓名板盲区距离", description = "当目标位于镜头后面时显示目标姓名板的最大距离", type = "number" },
	["nameplateGlobalScale"] = { prettyName = "姓名板大小", description = "全局应用非自己的姓名板的大小", type = "number" },
	["nameplateMinScale"] = { prettyName = "姓名板最小缩放", description = "姓名板最小缩放", type = "number" },
	["nameplateMaxScale"] = { prettyName = "姓名板最大缩放", description = "姓名板最大缩放", type = "number" },
	["nameplateLargerScale"] = { prettyName = "姓名板放大", description = "为重要的怪物的姓名板进行一个特别缩放.", type = "number" },
	["nameplateMinScaleDistance"] = { prettyName = "姓名板最小缩放距离", description = "距姓名板最大距离将达到最小缩放.", type = "number" },
	["nameplateMaxScaleDistance"] = { prettyName = "姓名板最大缩放距离", description = "距姓名板最大距离将达到最大缩放", type = "number" },
	["nameplateMinAlpha"] = { prettyName = "姓名板最小透明度", description = "姓名板最小透明度.", type = "number" },
	["nameplateMaxAlpha"] = { prettyName = "姓名板最大透明度", description = "姓名板最大透明度", type = "number" },
	["nameplateMinAlphaDistance"] = { prettyName = "姓名板最小透明度距离", description = "距姓名板最大距离将达到最小透明度.", type = "number" },
	["nameplateMaxAlphaDistance"] = { prettyName = "姓名板最大透明度距离", description = "距姓名板最大距离将达到最大透明度.", type = "number" },
	["nameplateSelectedScale"] = { prettyName = "被选到的姓名板大小", description = "被选到的姓名板大小.", type = "number" },
	["nameplateSelectedAlpha"] = { prettyName = "被选到的姓名板透明度", description = "被选到的姓名板透明度.", type = "number" },
	["nameplateSelfScale"] = { prettyName = "自身姓名板大小", description = "自身姓名板大小", type = "number" },
	["nameplateSelfAlpha"] = { prettyName = "自身姓名板透明度", description = "自身姓名板透明度", type = "number" },
	["nameplateSelfBottomInset"] = { prettyName = "自身姓名板底部嵌入", description = "从底部（以屏幕百分比为单位）插入自身姓名板", type = "number" },
	["nameplateSelfTopInset"] = { prettyName = "自身姓名板顶部嵌入", description = "从顶部（以屏幕百分比为单位）插入自身姓名板", type = "number" },
	["nameplateOtherBottomInset"] = { prettyName = "其他姓名板底部嵌入", description = "从底部（以屏幕百分比为单位）插入其他人的姓名板", type = "number" },
	["nameplateOtherTopInset"] = { prettyName = "其他姓名板顶部嵌入", description = "从顶部（以屏幕百分比为单位）插入其他人的姓名板", type = "number" },
	["nameplateLargeBottomInset"] = { prettyName = "大姓名板板底部嵌入", description = "从底部（以屏幕百分比为单位）插入大姓名板", type = "number" },
	["nameplateLargeTopInset"] = { prettyName = "大姓名板板顶部嵌入", description = "从顶部（以屏幕百分比为单位）插入大姓名板", type = "number" },
	["nameplateClassResourceTopInset"] = { prettyName = "姓名板职业资源顶部嵌入", description = "当职业资源显示在它们上面时从顶部插入（以屏幕百分比表示）", type = "number" },
	["NamePlateHorizontalScale"] = { prettyName = "姓名板水平大小", description = "适用于所有姓名板的水平大小", type = "number" },
	["NamePlateVerticalScale"] = { prettyName = "姓名板垂直大小", description = "适用于所有姓名板的垂直大小", type = "number" },
	["nameplateResourceOnTarget"] = { prettyName = "目标姓名板显示资源", description = "姓名版显示职业资源覆盖. 0=self, 1=target", type = "number" },
	["nameplateShowSelf"] = { prettyName = "显示姓名板资源条", description = "显示姓名板资源条. 0=off 1=on", type = "number" },
	["nameplateShowAll"] = { prettyName = "总是显示姓名板", description = "总是显示姓名板", type = "number" },
	["nameplateMotion"] = { prettyName = "姓名板移动类型", description = "0 = Overlapping - 1 = Stacking", type = "number" },
	["namePlateFriendlySize"] = { prettyName = "", description = "", type = "number" },
	["namePlateEnemySize"] = { prettyName = "", description = "", type = "number" },
	["namePlateSelfClickThrough"] = { prettyName = "", description = "", type = "number" },
	["namePlateFriendlyClickThrough"] = { prettyName = "", description = "", type = "number" },
	["namePlateEnemyClickThrough"] = { prettyName = "", description = "", type = "number" },
	["nameplatePersonalShowAlways"] = { prettyName = "", description = "始终显示个人姓名板", type = "boolean" },
	["nameplatePersonalShowInCombat"] = { prettyName = "", description = "在战斗中始终显示个人姓名板", type = "boolean" },
	["nameplatePersonalShowWithTarget"] = { prettyName = "", description = "始终显示带敌对目标的姓名板", type = "boolean" },
	["nameplatePersonalHideDelaySeconds"] = { prettyName = "", description = "在隐藏姓名板之前等待的延迟", type = "boolean" },
	["ShowNamePlateLoseAggroFlash"] = { prettyName = nil, description = "启用后，如果你是一个坦克角色并且失去了仇恨，姓名板会短暂闪烁.", type = "boolean" },
	["ShowClassColorInNameplate"] = { prettyName = SHOW_CLASS_COLOR_IN_V_KEY, description = OPTION_TOOLTIP_SHOW_CLASS_COLOR_IN_V_KEY, type = "boolean" },
	["ShowClassColorInFriendlyNameplate"] = { prettyName = "着色友方职业姓名板", description = "着色友方职业姓名板", type = "boolean" },
	
	["nameplateTargetRadialPosition"] = { prettyName = nil, description = "当目标离开屏幕时，将其姓名板沿径向放置在侧面和底部", type = "number"},
	["nameplateOccludedAlphaMult"] = { prettyName = nil, description = "目标的铭牌的透明度乘数", type = "number"},


	["reverseCleanupBags"] = { prettyName = REVERSE_CLEAN_UP_BAGS_TEXT, description = OPTION_TOOLTIP_REVERSE_CLEAN_UP_BAGS, type = "boolean" },
	["lootLeftmostBag"] = { prettyName = REVERSE_NEW_LOOT_TEXT, description = OPTION_TOOLTIP_REVERSE_NEW_LOOT, type = "boolean" },
	["stopAutoAttackOnTargetChange"] = { prettyName = STOP_AUTO_ATTACK, description = OPTION_TOOLTIP_STOP_AUTO_ATTACK, type = "boolean" },
	["assistAttack"] = { prettyName = ASSIST_ATTACK, description = OPTION_TOOLTIP_ASSIST_ATTACK, type = "boolean" },
	["autoSelfCast"] = { prettyName = AUTO_SELF_CAST_TEXT, description = OPTION_TOOLTIP_SELF_CAST_TEXT, type = "boolean" },
	["ActionButtonUseKeyDown"] = { prettyName = ACTION_BUTTON_USE_KEY_DOWN, description = OPTION_TOOLTIP_ACTION_BUTTON_USE_KEY_DOWN, type = "boolean" },
	["mapFade"] = { prettyName = MAP_FADE_TEXT, description = OPTION_TOOLTIP_MAP_FADE, type = "boolean" },
	["trackQuestSorting"] = { type = "table", options = {"proximity", "top" } },
	["removeChatDelay"] = { prettyName = REMOVE_CHAT_DELAY_TEXT, description = OPTION_TOOLTIP_REMOVE_CHAT_DELAY_TEXT, type = "boolean" },
	["secureAbilityToggle"] = { prettyName = SECURE_ABILITY_TOGGLE, description = OPTION_TOOLTIP_SECURE_ABILITY_TOGGLE, type = "boolean" },
	["scriptErrors"] = { prettyName = SHOW_LUA_ERRORS, description = OPTION_TOOLTIP_SHOW_LUA_ERRORS, type = "boolean" },
	["lootUnderMouse"] = { prettyName = LOOT_UNDER_MOUSE_TEXT, description = OPTION_TOOLTIP_LOOT_UNDER_MOUSE_TEXT, type = "boolean" },
	["ShowQuestUnitCircles"] = { prettyName = "任务单位圆圈", description = "确定与任务相关的单位是否在地面上显示指示器", type = "boolean" },
	["autoLootDefault"] = { prettyName = AUTO_LOOT_DEFAULT_TEXT, description = OPTION_TOOLTIP_AUTO_LOOT_DEFAULT, type = "boolean" },
	["threatShowNumeric"] = { prettyName = SHOW_NUMERIC_THREAT, description = OPTION_TOOLTIP_SHOW_NUMERIC_THREAT, type = "boolean" },
	["showLootSpam"] = { prettyName = SHOW_LOOT_SPAM, description = OPTION_TOOLTIP_SHOW_LOOT_SPAM, type = "boolean" },
	["advancedWatchFrame"] = { prettyName = ADVANCED_OBJECTIVES_TEXT, description = OPTION_TOOLTIP_ADVANCED_OBJECTIVES_TEXT, type = "" },
	["watchFrameIgnoreCursor"] = { prettyName = OBJECTIVES_IGNORE_CURSOR_TEXT, description = OPTION_TOOLTIP_OBJECTIVES_IGNORE_CURSOR, type = "boolean" },
	["guildMemberNotify"] = { prettyName = GUILDMEMBER_ALERT, description = OPTION_TOOLTIP_GUILDMEMBER_ALERT, type = "boolean" },
	["showArenaEnemyFrames"] = { prettyName = SHOW_ARENA_ENEMY_FRAMES_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_FRAMES, type = "boolean" },
	["autoClearAFK"] = { prettyName = nil, description = OPTION_TOOLTIP_CLEAR_AFK, type = "boolean" },
	["colorblindWeaknessFactor"] = { prettyName = nil, description = OPTION_TOOLTIP_ADJUST_COLORBLIND_STRENGTH, type = "boolean" },
	["autoLootDefault"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_LOOT_DEFAULT, type = "boolean" },
	["autoLootRate"] = { prettyName = "自动拾取速度", description = "以毫秒为单位的自动拾取速度", type = "number" },
	["ChatAmbienceVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_, type = "boolean" },
	["threatShowNumeric"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_NUMERIC_THREAT, type = "boolean" },
	["rightActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR3, type = "boolean" },
	["emphasizeMySpellEffects"] = { prettyName = nil, description = OPTION_TOOLTIP_EMPHASIZE_MY_SPELLS, type = "boolean" },
	["chatBubblesParty"] = { prettyName = nil, description = OPTION_TOOLTIP_PARTY_CHAT_BUBBLES, type = "boolean" },
	["enableTwitter"] = { prettyName = nil, description = OPTION_TOOLTIP_SOCIAL_ENABLE_TWITTER_FUNCTIONALITY, type = "boolean" },
	["threatPlaySounds"] = { prettyName = nil, description = OPTION_TOOLTIP_PLAY_AGGRO_SOUNDS, type = "boolean" },
	-- Toasts mmhhh...Toast.
	["showToastOnline"] = { prettyName = SHOW_TOAST_ONLINE_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_ONLINE, type = "boolean" },
	["showToastOffline"] = { prettyName = SHOW_TOAST_OFFLINE_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_OFFLINE, type = "boolean" },
	["showToastBroadcast"] = { prettyName = SHOW_TOAST_BROADCAST_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_BROADCAST, type = "boolean" },
	["showToastFriendRequest"] = { prettyName = SHOW_TOAST_FRIEND_REQUEST_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_FRIEND_REQUEST, type = "boolean" },
	["showToastConversation"] = { prettyName = SHOW_TOAST_CONVERSATION_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_CONVERSATION, type = "boolean" },
	["showToastWindow"] = { prettyName = SHOW_TOAST_WINDOW_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_WINDOW, type = "boolean" },
	["toastDuration"] = { prettyName = nil, description = OPTION_TOOLTIP_TOAST_DURATION, type = "number" },

	["enableMouseSpeed"] = { prettyName = ENABLE_MOUSE_SPEED, description = OPTION_TOOLTIP_ENABLE_MOUSE_SPEED, type = "boolean" },
	["mouseInvertPitch"] = { prettyName = INVERT_MOUSE, description = OPTION_TOOLTIP_INVERT_MOUSE, type = "boolean" },
	["enableWoWMouse"] = { prettyName = WOW_MOUSE, description = OPTION_TOOLTIP_WOW_MOUSE, type = "boolean" },
	["autointeract"] = { prettyName = CLICK_TO_MOVE, description = OPTION_TOOLTIP_CLICK_TO_MOVE, type = "boolean" },
	["mouseSpeed"] = { prettyName = MOUSE_SENSITIVITY, description = OPTION_TOOLTIP_MOUSE_SENSITIVITY, type = "number" },

	["wholeChatWindowClickable"] = { prettyName = nil, description = OPTION_TOOLTIP_CHAT_WHOLE_WINDOW_CLICKABLE, type = "boolean" },
	["useEnglishAudio"] = { prettyName = nil, description = OPTION_TOOLTIP_USE_ENGLISH_AUDIO, type = "boolean" },
	["ChatSoundVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_, type = "number" },
	--["reducedLagTolerance"] = { prettyName = "Custom Lag Tolerance", description = OPTION_TOOLTIP_REDUCED_LAG_TOLERANCE, type = "boolean" },
	["EnableMicrophone"] = { prettyName = nil, description = OPTION_TOOLTIP_ENABLE_MICROPHONE, type = "boolean" },
	["autoOpenLootHistory"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_OPEN_LOOT_HISTORY, type = "boolean" },
	["showVKeyCastbarOnlyOnTarget"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR_IN_V_KEY_ONLY_ON_TARGET, type = "boolean" },
	["displaySpellActivationOverlays"] = { prettyName = nil, description = OPTION_TOOLTIP_DISPLAY_SPELL_ALERTS, type = "boolean" },
	["hdPlayerModels"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_HD_MODELS, type = "boolean" },
	["autoLootKey"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_LOOT_KEY, type = "boolean" }, -- TODO TYPE
	["SpellQueueWindow"] = { prettyName = LAG_TOLERANCE, description = "Determines how far ahead of the \'end of a spell\' start-recovery spell system can be, before allowing spell request to be sent to the server. Ie this controls the built-in lag for the ability queuing system. Ideally, you\'ll want to set this to your in-game latency.", type = "number" },
	["advancedCombatLogging"] = { prettyName = nil, description = OPTION_TOOLTIP_ADVANCED_COMBAT_LOGGING, type = "boolean" },
	["disableServerNagle"] = { prettyName = nil, description = OPTION_TOOLTIP_OPTIMIZE_NETWORK_SPEED, type = "boolean" },
	-- Camera
	["cameraYawSmoothSpeed"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_FOLLOW_SPEED, type = "number" },
	["cameraWaterCollision"] = { prettyName = nil, description = OPTION_TOOLTIP_WATER_COLLISION, type = "boolean" },
	["cameraBobbing"] = { prettyName = nil, description = OPTION_TOOLTIP_HEAD_BOB, type = "boolean" },
	["cameraPivot"] = { prettyName = nil, description = OPTION_TOOLTIP_SMART_PIVOT, type = "boolean" },
	["cameraDistanceMaxZoomFactor"] = { prettyName = MAX_FOLLOW_DIST, description = OPTION_TOOLTIP_MAX_FOLLOW_DIST, type = "number" },
	["cameraYawMoveSpeed"] = { prettyName = MOUSE_LOOK_SPEED, description = OPTION_TOOLTIP_MOUSE_LOOK_SPEED, type = "number" },
	["cameraTerrainTilt"] = { prettyName = nil, description = OPTION_TOOLTIP_FOLLOW_TERRAIN, type = "boolean" },
	["cameraHeadMovementStrength"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeadMovementWhileStanding"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeadMovementRange"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeadMovementSmoothRate"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDynamicPitch"] = { prettyName = nil, description = nil, type = "number" },
	-- ["cameraDynamicPitchBaseFovPad"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDynamicPitchBaseFovPadFlying"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDynamicPitchSmartPivotCutoffDist"] = { prettyName = nil, description = nil, type = "number" },
	["cameraOverShoulder"] = { prettyName = nil, description = nil, type = "number" },
	["cameraLockedTargetFocusing"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDistanceMoveSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraPitchMoveSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraBobbingSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraFoVSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDistanceSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraGroundSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeightSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraPitchSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraTargetSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	-- ["cameraFlyingMountHeightSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraViewBlendStyle"] = { prettyName = nil, description = nil, type = "number" },
	["camerasmooth"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothPitch"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothYaw"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothStyle"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothTrackingStyle"] = { prettyName = nil, description = nil, type = "number" },

	["chatBubbles"] = { prettyName = nil, description = OPTION_TOOLTIP_CHAT_BUBBLES, type = "boolean" },
	["autoDismountFlying"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_DISMOUNT_FLYING, type = "boolean" },
	["bottomRightActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR2, type = "boolean" },
	["showPartyBackground"] = { prettyName = SHOW_PARTY_BACKGROUND_TEXT, description = OPTION_TOOLTIP_SHOW_PARTY_BACKGROUND, type = "boolean" },
	["showPartyPets"] = { prettyName = SHOW_PARTY_PETS_TEXT, description = OPTION_TOOLTIP_SHOW_PARTY_PETS, type = "boolean" },
	["showArenaEnemyFrames"] = { prettyName = SHOW_ARENA_ENEMY_FRAMES_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_FRAMES, type = "boolean" },
	["showArenaEnemyCastbar"] = { prettyName = SHOW_ARENA_ENEMY_CASTBAR_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_CASTBAR, type = "boolean" },
	["showArenaEnemyPets"] = { prettyName = SHOW_ARENA_ENEMY_PETS_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_PETS, type = "boolean" },
	["fullSizeFocusFrame"] = { prettyName = FULL_SIZE_FOCUS_FRAME_TEXT, description = OPTION_TOOLTIP_FULL_SIZE_FOCUS_FRAME, type = "boolean" },
	["spamFilter"] = { prettyName = nil, description = OPTION_TOOLTIP_SPAM_FILTER, type = "boolean" },
	["profanityFilter"] = { prettyName = nil, description = OPTION_TOOLTIP_PROFANITY_FILTER, type = "boolean" },
	["EnableVoiceChat"] = { prettyName = nil, description = OPTION_TOOLTIP_ENABLE_VOICECHAT, type = "boolean" },
	["rightTwoActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR4, type = "boolean" },
	["rotateMinimap"] = { prettyName = nil, description = OPTION_TOOLTIP_ROTATE_MINIMAP, type = "boolean" },
	["blockTrades"] = { prettyName = nil, description = OPTION_TOOLTIP_BLOCK_TRADES, type = "boolean" },
	["movieSubtitle"] = { prettyName = nil, description = OPTION_TOOLTIP_CINEMATIC_SUBTITLES, type = "boolean" },
	["displayFreeBagSlots"] = { prettyName = nil, description = OPTION_TOOLTIP_DISPLAY_FREE_BAG_SLOTS, type = "boolean" },
	["lockActionBars"] = { prettyName = nil, description = OPTION_TOOLTIP_LOCK_ACTIONBAR, type = "boolean" },
	["screenEdgeFlash"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_FULLSCREEN_STATUS, type = "boolean" },
	["showVKeyCastbar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR_IN_V_KEY, type = "boolean" },
	["chatMouseScroll"] = { prettyName = CHAT_MOUSE_WHEEL_SCROLL, description = OPTION_TOOLTIP_CHAT_MOUSE_WHEEL_SCROLL, type = "boolean" },
	["InboundChatVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_VOICE_OUTPUT_VOLUME, type = "number" },
	["spellActivationOverlayOpacity"] = { prettyName = nil, description = OPTION_TOOLTIP_SPELL_ALERT_OPACITY, type = "number" },
	["PushToTalkSound"] = { prettyName = nil, description = OPTION_TOOLTIP_PUSHTOTALK_SOUND, type = "boolean" },
	["countdownForCooldowns"] = { prettyName = nil, description = OPTION_TOOLTIP_COUNTDOWN_FOR_COOLDOWNS, type = "boolean" },
	["VoiceActivationSensitivity"] = { prettyName = nil, description = OPTION_TOOLTIP_VOICE_ACTIVATION_SENSITIVITY, type = "number" },
	["alwaysShowActionBars"] = { prettyName = nil, description = OPTION_TOOLTIP_ALWAYS_SHOW_MULTIBARS, type = "boolean" },
	["OutboundChatVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_VOICE_INPUT_VOLUME, type = "number" },
	["autoQuestWatch"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_QUEST_WATCH, type = "boolean" },
	["SpellTooltip_DisplayAvgValues"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_POINTS_AS_AVG, type = "boolean" },
	["bottomLeftActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR1, type = "boolean" },
	["showVKeyCastbarSpellName"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR_IN_V_KEY_SPELL_NAME, type = "boolean" },
	["buffDurations"] = { prettyName = SHOW_BUFF_DURATION_TEXT, description = OPTION_TOOLTIP_SHOW_BUFF_DURATION, type = "boolean" },
	["showDispelDebuffs"] = { prettyName = SHOW_DISPELLABLE_DEBUFFS_TEXT, description = OPTION_TOOLTIP_SHOW_DISPELLABLE_DEBUFFS, type = "boolean" },
	["showCastableBuffs"] = { prettyName = SHOW_CASTABLE_BUFFS_TEXT, description = OPTION_TOOLTIP_SHOW_CASTABLE_BUFFS, type = "boolean" },
	["deselectOnClick"] = { prettyName = nil, description = OPTION_TOOLTIP_GAMEFIELD_DESELECT, type = "boolean" },
	["autoQuestProgress"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_QUEST_PROGRESS, type = "boolean" },
	["UberTooltips"] = { prettyName = USE_UBERTOOLTIPS, description = OPTION_TOOLTIP_USE_UBERTOOLTIPS, type = "boolean" },
	-- Sound
	["Sound_EnableAllSound"] = { prettyName = ENABLE_SOUND, description = OPTION_TOOLTIP_ENABLE_SOUND, type = "boolean" },
	["Sound_EnableDSPEffects"] = { prettyName = ENABLE_DSP_EFFECTS, description = OPTION_TOOLTIP_ENABLE_DSP_EFFECTS, type = "boolean" },
	["Sound_SFXVolume"] = { prettyName = SOUND_VOLUME, description = OPTION_TOOLTIP_SOUND_VOLUME, type = "number" },
	["Sound_ZoneMusicNoDelay"] = { prettyName = ENABLE_MUSIC_LOOPING, description = OPTION_TOOLTIP_ENABLE_MUSIC_LOOPING, type = "boolean" },
	["Sound_EnableDialog"] = { prettyName = ENABLE_DIALOG, description = OPTION_TOOLTIP_ENABLE_DIALOG, type = "boolean" },
	["Sound_EnableSoundWhenGameIsInBG"] = { prettyName = ENABLE_BGSOUND, description = OPTION_TOOLTIP_ENABLE_BGSOUND, type = "boolean" },
	["Sound_EnableEmoteSounds"] = { prettyName = ENABLE_EMOTE_SOUNDS, description = OPTION_TOOLTIP_ENABLE_EMOTE_SOUNDS, type = "boolean" },
	["Sound_EnableAmbience"] = { prettyName = ENABLE_AMBIENCE, description = OPTION_TOOLTIP_ENABLE_AMBIENCE, type = "boolean" },
	["Sound_DialogVolume"] = { prettyName = DIALOG_VOLUME, description = OPTION_TOOLTIP_DIALOG_VOLUME, type = "number" },
	["Sound_EnablePetBattleMusic"] = { prettyName = ENABLE_PET_BATTLE_MUSIC, description = OPTION_TOOLTIP_ENABLE_PET_BATTLE_MUSIC, type = "boolean" },
	["Sound_MusicVolume"] = { prettyName = MUSIC_VOLUME, description = OPTION_TOOLTIP_MUSIC_VOLUME, type = "number" },
	["Sound_EnableReverb"] = { prettyName = ENABLE_REVERB, description = OPTION_TOOLTIP_ENABLE_REVERB, type = "boolean" },
	["Sound_MasterVolume"] = { prettyName = MASTER_VOLUME, description = OPTION_TOOLTIP_MASTER_VOLUME, type = "number" },
	["Sound_EnableMusic"] = { prettyName = ENABLE_MUSIC, description = OPTION_TOOLTIP_ENABLE_MUSIC, type = "boolean" },
	["Sound_AmbienceVolume"] = { prettyName = AMBIENCE_VOLUME, description = OPTION_TOOLTIP_AMBIENCE_VOLUME, type = "number" },
	["Sound_EnableErrorSpeech"] = { prettyName = ENABLE_ERROR_SPEECH, description = OPTION_TOOLTIP_ENABLE_ERROR_SPEECH, type = "boolean" },
	["Sound_EnableSFX"] = { prettyName = ENABLE_SOUNDFX, description = OPTION_TOOLTIP_ENABLE_SOUNDFX, type = "boolean" },
	["Sound_ListenerAtCharacter"] = { prettyName = ENABLE_SOUND_AT_CHARACTER, description = OPTION_TOOLTIP_ENABLE_SOUND_AT_CHARACTER, type = "boolean" },
	["Sound_EnablePetSounds"] = { prettyName = ENABLE_PET_SOUNDS, description = OPTION_TOOLTIP_ENABLE_PET_SOUNDS, type = "boolean" },
	["Sound_EnablePositionalLowPassFilter"] = { prettyName = ENABLE_SOFTWARE_HRTF, description = OPTION_TOOLTIP_ENABLE_SOFTWARE_HRTF, type = "boolean" },

	["showTargetOfTarget"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_OF_TARGET, type = "boolean" },
	["guildMemberNotify"] = { prettyName = nil, description = OPTION_TOOLTIP_GUILDMEMBER_ALERT, type = "boolean" },
	["showTutorials"] = { prettyName = SHOW_TUTORIALS, description = OPTION_TOOLTIP_SHOW_TUTORIALS, type = "boolean" },
	["lossOfControl"] = { prettyName = nil, description = OPTION_TOOLTIP_LOSS_OF_CONTROL, type = "boolean" },
	["blockChannelInvites"] = { prettyName = nil, description = OPTION_TOOLTIP_BLOCK_CHAT_CHANNEL_INVITE, type = "boolean" },
	["showTargetCastbar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR, type = "boolean" },
	["enablePetBattleCombatText"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_PETBATTLE_COMBAT, type = "boolean" },
	["colorblindMode"] = { prettyName = nil, description = OPTION_TOOLTIP_USE_COLORBLIND_MODE, type = "boolean" },
	["useIPv6"] = { prettyName = USEIPV6, description = OPTION_TOOLTIP_USEIPV6, type = "boolean" },
	["interactOnLeftClick"] = { prettyName = INTERACT_ON_LEFT_CLICK_TEXT, description = OPTION_TOOLTIP_INTERACT_ON_LEFT_CLICK, type = "boolean" },
	["enableMovePad"] = { prettyName = MOVE_PAD, description = OPTION_TOOLTIP_MOVE_PAD, type = "boolean" },
	["colorblindSimulator"] = { prettyName = nil, description = OPTION_TOOLTIP_COLORBLIND_FILTER, type = "boolean" },

	["noBuffDebuffFilterOnTarget"] = { prettyName = "不过滤目标的debuff", description = "不过滤目标的debuff", type = "boolean" },
	["showHonorAsExperience"] = { prettyName = nil, description = "将荣誉栏作为常规栏来替代经验栏", type = "boolean" },
	-- Tab-Targetting
	["TargetNearestUseNew"] = { prettyName = nil, description = "使用7.2“最近目标”功能", type = "boolean" },
	--["TargetPriorityAllowAnyOnScreen"] = { prettyName = nil, description = "If set, and no 100% correct target is available, allow selecting any valid in-range target (2 = also out-of-range)", type = "boolean" },
	["TargetPriorityCombatLock"] = { prettyName = nil, description = "1=当进入战斗时锁定目标. 2=进一步限制在与玩家的战斗中.", type = "boolean" },
	["TargetPriorityCombatLockHighlight"] = { prettyName = nil, description = "1=当进入战斗时锁定目标. 2=进一步限制在与玩家的战斗中. (同时保持目标)", type = "boolean" },
	--["TargetPriorityHoldHighlightDelay"] = { prettyName = nil, description = "Delay in Milliseconds before priority target highlight starts when holding the button", type = "number" },
	--["TargetPriorityIncludeBehind"] = { prettyName = nil, description = "If set, include target's behind the player in priority target selection", type = "boolean" },
	["TargetPriorityPvp"] = { prettyName = nil, description = "在pvp中，优先考虑玩家和重要的pvp目标 (2 = 所有PVP目标, 3 = 仅玩家)", type = "boolean" },
	--["TargetPriorityPvpLock"] = { prettyName = nil, description = "Lock to important pvp targets when starting from a pvp target.", type = "boolean" },
	--["TargetPriorityPvpLockHighlight"] = { prettyName = nil, description = "Lock to players when starting from a player target in pvp. (while doing hold-to-target)", type = "boolean" },
	--["TargetPriorityValueBank"] = { prettyName = nil, description = "Selects the scoring values bank for calculating target priority order", type = "boolean" },
	["TargetPriorityCombatLockContextualRelaxation"] = { prettyName = nil, description = "1=Enables relaxation of combat lock based on context (eg. no in-combat target infront)", type = "number" },

	["unitClutter"] = { prettyName = nil, description = "启用/禁用单位混肴", type = "boolean" },
	["unitClutterInstancesOnly"] = { prettyName = nil, description = "是否只在副本或战场中使用单位混肴（0或1）", type = "boolean" },
	["unitClutterPlayerThreshold"] = { prettyName = nil, description = "必须在附近才能触发单位混肴的玩家数量", type = "boolean" },

	["comboPointLocation"] = { prettyName = nil, description = "连击点在UI中的位置. 1=目标, 2=自己", type = "number" },
	["doNotFlashLowHealthWarning"] = { prettyName = nil, description = "血量过低时，不将屏幕闪烁为红色.", type = "boolean" },
	["findYourselfAnywhere"] = { prettyName = nil, description = "总是高亮你的角色", type = "boolean" },
	["findYourselfAnywhereOnlyInCombat"] = { prettyName = nil, description = "只在战斗中高亮你的的角色", type = "boolean" },
	["findYourselfInBG"] = { prettyName = nil, description = "只在战场中高亮你的角色", type = "boolean" },
	["findYourselfInBGOnlyInCombat"] = { prettyName = "只在战场中(战斗中)高亮你的的角色", description = "", type = "boolean" },
	["findYourselfInRaid"] = { prettyName = nil, description = "只在团队中高亮你的角色", type = "boolean" },
	["findYourselfInRaidOnlyInCombat"] = { prettyName = nil, description = "只在团队中(战斗中)高亮你的的角色", type = "boolean" },
	["findYourselfMode"] = { prettyName = nil, description = "高亮你的角色. 0 = 圆圈, 1 = 圆圈 & 轮廓", type = "boolean" },
	["flashErrorMessageRepeats"] = { prettyName = nil, description = "如果触发相同的消息，则闪烁中央屏幕的红色错误文本.", type = "boolean" },
	-- Floating Combat Text
	["enableFloatingCombatText"] = { prettyName = SHOW_COMBAT_TEXT_TEXT, description = OPTION_TOOLTIP_SHOW_COMBAT_TEXT , type = "boolean" },
	["floatingCombatTextAllSpellMechanics"] = { prettyName = nil, description = "", type = "boolean" },
	["floatingCombatTextAuras"] = { prettyName = COMBAT_TEXT_SHOW_AURAS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_AURAS , type = "boolean" },
	["floatingCombatTextCombatDamage"] = { prettyName = SHOW_DAMAGE_TEXT, description = OPTION_TOOLTIP_SHOW_DAMAGE, type = "boolean" },
	["floatingCombatTextCombatDamageAllAutos"] = { prettyName = nil, description = "显示所有自动攻击数, 而不是隐藏非事件数", type = "boolean" },
	["floatingCombatTextCombatDamageDirectionalOffset"] = { prettyName = nil, description = "Amount to offset directional damage numbers when they start", type = "boolean" },
	["floatingCombatTextCombatDamageDirectionalScale"] = { prettyName = "Directional Scale", description = "Directional damage numbers movement scale (disabled = no directional numbers)", type = "boolean" },
	["floatingCombatTextCombatHealing"] = { prettyName = SHOW_COMBAT_HEALING, description = OPTION_TOOLTIP_SHOW_COMBAT_HEALING, type = "boolean" },
	["floatingCombatTextCombatHealingAbsorbSelf"] = { prettyName = SHOW_COMBAT_HEALING_ABSORB_SELF.." (自身)", description = OPTION_TOOLTIP_SHOW_COMBAT_HEALING_ABSORB_SELF, type = "boolean" },
	["floatingCombatTextCombatHealingAbsorbTarget"] = { prettyName = SHOW_COMBAT_HEALING_ABSORB_TARGET.." (目标)" , description = OPTION_TOOLTIP_SHOW_COMBAT_HEALING_ABSORB_TARGET, type = "boolean" },
	["floatingCombatTextCombatLogPeriodicSpells"] = { prettyName = LOG_PERIODIC_EFFECTS, description = OPTION_TOOLTIP_LOG_PERIODIC_EFFECTS, type = "boolean" },
	["floatingCombatTextCombatState"] = { prettyName = COMBAT_TEXT_SHOW_COMBAT_STATE_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_COMBAT_STATE, type = "boolean" },
	["floatingCombatTextComboPoints"] = { prettyName = COMBAT_TEXT_SHOW_COMBO_POINTS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_COMBO_POINTS , type = "boolean" },
	["floatingCombatTextDamageReduction"] = { prettyName =COMBAT_TEXT_SHOW_RESISTANCES_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_RESISTANCES, type = "boolean" },
	["floatingCombatTextDodgeParryMiss"] = { prettyName = COMBAT_TEXT_SHOW_DODGE_PARRY_MISS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_DODGE_PARRY_MISS, type = "boolean" },
	["floatingCombatTextEnergyGains"] = { prettyName = COMBAT_TEXT_SHOW_ENERGIZE_TEXT.." & "..COMBAT_TEXT_SHOW_COMBO_POINTS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_ENERGIZE, type = "boolean" },
	["floatingCombatTextFloatMode"] = { prettyName = COMBAT_TEXT_FLOAT_MODE_LABEL, description = OPTION_TOOLTIP_COMBAT_TEXT_MODE, type = "number" },
	["floatingCombatTextFriendlyHealers"] = { prettyName = COMBAT_TEXT_SHOW_FRIENDLY_NAMES_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_FRIENDLY_NAMES, type = "boolean" },
	["floatingCombatTextHonorGains"] = { prettyName = COMBAT_TEXT_SHOW_HONOR_GAINED_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_HONOR_GAINED, type = "boolean" },
	["floatingCombatTextLowManaHealth"] = { prettyName = COMBAT_TEXT_SHOW_LOW_HEALTH_MANA_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_LOW_HEALTH_MANA, type = "boolean" },
	["floatingCombatTextPeriodicEnergyGains"] = { prettyName = COMBAT_TEXT_SHOW_PERIODIC_ENERGIZE_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_PERIODIC_ENERGIZE, type = "boolean" },
	["floatingCombatTextPetMeleeDamage"] = { prettyName = SHOW_PET_MELEE_DAMAGE, description = OPTION_TOOLTIP_SHOW_PET_MELEE_DAMAGE, type = "boolean" },
	["floatingCombatTextPetSpellDamage"] = { prettyName = SHOW_PET_SPELL_DAMAGE, description = "显示宠物法术伤害", type = "boolean" },
	["floatingCombatTextReactives"] = { prettyName = COMBAT_TEXT_SHOW_REACTIVES_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_REACTIVES, type = "boolean" },
	["floatingCombatTextRepChanges"] = { prettyName = COMBAT_TEXT_SHOW_REPUTATION_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_REPUTATION, type = "boolean" },
	["floatingCombatTextSpellMechanics"] = { prettyName = SHOW_TARGET_EFFECTS, description = OPTION_TOOLTIP_SHOW_TARGET_EFFECTS, type = "boolean" },
	["floatingCombatTextSpellMechanicsOther"] = { prettyName = SHOW_OTHER_TARGET_EFFECTS, description = OPTION_TOOLTIP_SHOW_OTHER_TARGET_EFFECTS, type = "boolean" },
	-- Status Text
	["statusText"] = { prettyName = STATUS_TEXT, description = "状态栏是否显示血量/法力数值", type = "boolean"},
	["statusTextDisplay"] = { prettyName = STATUS_TEXT, description = OPTION_TOOLTIP_STATUS_TEXT_DISPLAY, type = "boolean"},
	["playerStatusText"] = { prettyName = STATUS_TEXT_PLAYER, description = OPTION_TOOLTIP_STATUS_TEXT_PLAYER , type = "boolean"}, -- removed
	["petStatusText"] = { prettyName = STATUS_TEXT_PET, description = OPTION_TOOLTIP_STATUS_TEXT_PET, type = "boolean"}, -- removed
	["partyStatusText"] = { prettyName = STATUS_TEXT_PARTY, description = OPTION_TOOLTIP_STATUS_TEXT_PARTY, type = "boolean"}, -- removed
	["targetStatusText"] = { prettyName = STATUS_TEXT_TARGET, description = OPTION_TOOLTIP_STATUS_TEXT_TARGET, type = "boolean"}, -- removed
	["alternateResourceText"] = { prettyName = ALTERNATE_RESOURCE_TEXT, description = OPTION_TOOLTIP_ALTERNATE_RESOURCE, type = "boolean"}, -- removed
	["xpBarText"] = { prettyName = XP_BAR_TEXT, description = OPTION_TOOLTIP_XP_BAR, type = "boolean" },

	["violenceLevel"] = { prettyName = "游戏质量程度", description = "设置游戏质量等级", type = "number" },
	["ffxGlow"] = { prettyName = "FFX 高亮", description = "全屏高亮效果", type = "boolean" },
	["ffxNether"] = { prettyName = "FFX Nether", description = "full screen nether / glow effect", type = "boolean" },
	["releaseUITextures"] = { prettyName = "释放UI纹理", description = "默认情况下释放隐藏的UI纹理", type = "boolean" },
	["alwaysCompareItems"] = { prettyName = "总是比较物品", description = "始终显示物品比较工具提示", type = "boolean" },
	["showSpenderFeedback"] = { prettyName= "显示资源消耗反馈", description = "在资源栏中显示/隐藏消耗怒气/法力等后的闪光.", type = "boolean" },
	-- Loss of Control UI
	["lossOfControlFull"] = { prettyName = "失去控制(CC): 全部", description = "被控制技能影响时的设置类型. (0 = Off, 1 = 仅警报, 2 = 显示完整持续时间)", type = "number" },
	["lossOfControlSilence"] = { prettyName = "失去控制(CC): 沉默", description = "被控制技能影响时的设置类型. (0 = Off, 1 = 仅警报, 2 = 显示完整持续时间)", type = "number" },
	["lossOfControlInterrupt"] = { prettyName = "失去控制(CC): 打断", description = "被控制技能影响时的设置类型. (0 = Off, 1 = 仅警报, 2 = 显示完整持续时间)", type = "number" },
	["lossOfControlDisarm"] = { prettyName = "失去控制(CC): 缴械", description = "被控制技能影响时的设置类型. (0 = Off, 1 = 仅警报, 2 = 显示完整持续时间)", type = "number" },
	["lossOfControlRoot"] = { prettyName = "失去控制(CC): 根须", description = "被控制技能影响时的设置类型. (0 = Off, 1 = 仅警报, 2 = 显示完整持续时间)", type = "number" },
	["synchronizeMacros"] = { prettyName = "同步宏", description = "打开/关闭服务器同步宏", type = "boolean" },
	["synchronizeConfig"] = { prettyName = "同步配置", description = "打开/关闭服务器时切换同步设置", type = "boolean" },
	["cursorsizepreferred"] = { prettyName = "鼠标大小", description = "0 = 32x32, 1 = 48x48, 2 = 64x64, -1 = autodetect", type = "number" },
	["ffxDeath"] = { prettyName = "FFX 死亡", description = "启用全屏死亡(黑白屏幕)", type = "boolean" },
	["WorldTextScale"] = { prettyName = "世界文本比例", description = "世界范围内伤害数量、xp获取、物品获取等文本的比例", type = "number" },


	-- 7.1.5 dump (1/16/17)
	["BrowserNavigateLog"] = { description = "启用浏览器请求的记录 (需要 /reload)" },
	--["CACHE-WGOB-GameObjectsHotfixCount"] = {},
	--["CACHE-WGOB-GameObjectsRecordCount"] = {},
	--["CACHE-WQST-QuestObjectiveHotfixCount"] = {},
	--["CACHE-WQST-QuestObjectiveRecordCount"] = {},
	--["CACHE-WQST-QuestObjectiveXEffectHotfixCount"] = {},
	--["CACHE-WQST-QuestObjectiveXEffectRecordCount"] = {},
	--["CACHE-WQST-QuestV2HotfixCount"] = {},
	--["CACHE-WQST-QuestV2RecordCount"] = {},
	["ChatMusicVolume"] = {},
	["CombatHealingAbsorbSelf"] = {},
	["DepthBasedOpacity"] = {},
	["DesktopGamma"] = {},
	-- ["EJDungeonDifficulty"] = { description = "Stores the last dungeon difficulty viewed in the encounter journal" },
	-- ["EJLootClass"] = { description = "Stores the last class that loot was filtered by in the encounter journal" },
	-- ["EJLootSpec"] = { description = "Stores the last spec that loot was filtered by in the encounter journal" },
	-- ["EJRaidDifficulty"] = { description = "Stores the last raid difficulty viewed in the encounter journal" },
	["EmitterCombatrange"] = { description = "Range to stop shoulder/weapon emissions during combat" },
	-- ["ErrorFilter"] = {},
	-- ["ErrorLevelMax"] = {},
	-- ["ErrorLevelMin"] = {},
	-- ["Errors"] = {},
	["FootstepSounds"] = { description = "播放脚步声" },
	["Gamma"] = {},
	["LodLiquid"] = { description = "使用LOD液体渲染" },
	["M2ForceAdditiveParticleSort"] = { description = "强制所有粒子进行排序" },
	["M2UseInstancing"] = { description = "使用硬件系统" },
	["M2UseLOD"] = { description = "使用LOD模型" },
	["M2UseThreads"] = { description = "多线程模型动画" },
	["MSAAAlphaTest"] = { description = "启用MSAA" },
	["MSAAQuality"] = { description = "多重采样AA质量" },
	["MaxObservedPetBattles"] = { description = "" },
	["NameplatePersonalHideDelayAlpha"] = { description = "" },
	["NonEmitterCombatRange"] = { description = "" },
	["ObjectSelectionCircle"] = {},
	["OutlineEngineMode"] = {},
	-- ["Outline"] = { description="Outline Mode" }, -- don't know what this does aside from make you flash when it's set
	["POIShiftComplete"] = {},
	-- ["PraiseTheSun"] = {},
	["PushToTalkButton"] = { description = "按键通话按钮" },
	["RAIDDepthBasedOpacity"] = {},
	["RAIDLightMode"] = {},
	["RAIDOutlineEngineMode"] = {},
	["RAIDSSAO"] = {},
	["RAIDSSAOBlur"] = {},
	["RAIDWaterDetail"] = {},
	["RAIDcomponentTextureLevel"] = {},
	["RAIDenvironmentDetail"] = {},
	["RAIDfarclip"] = {},
	["RAIDgraphicsQuality"] = {},
	["RAIDgroundEffectDensity"] = {},
	["RAIDgroundEffectDist"] = {},
	["RAIDgroundEffectFade"] = { description = "" },
	["RAIDhorizonStart"] = { description = "" },
	["RAIDlodObjectCullDist"] = {},
	["RAIDlodObjectCullSize"] = {},
	["RAIDlodObjectMinSize"] = {},
	["RAIDlodObjectFadeScale"] = {},
	["RAIDparticleDensity"] = {},
	["RAIDparticleMTDensity"] = {},
	["RAIDprojectedTextures"] = {},
	["RAIDreflectionMode"] = {},
	["RAIDrefraction"] = {},
	["RAIDrippleDetail"] = {},
	["RAIDsettingsEnabled"] = { description = "有可用的RAID图形设置" },
	["RAIDsettingsInit"] = {},
	["RAIDshadowMode"] = {},
	["RAIDshadowSoft"] = {},
	["RAIDshadowTextureSize"] = {},
	["RAIDsunShafts"] = {},
	["RAIDterrainLodDist"] = {},
	["RAIDterrainMipLevel"] = {},
	["RAIDterrainTextureLod"] = {},
	["RAIDtextureFilteringMode"] = {},
	["RAIDweatherDensity"] = {},
	["RAIDwmoLodDist"] = {},
	["RAIDworldBaseMip"] = {},
	["RenderScale"] = { description = "渲染比例 (用于超采样或欠采样)" },
	["ResampleQuality"] = { description = "重采样质量" },
	["SSAO"] = {},
	["SSAOBlur"] = {},
	["SSAODistance"] = { description = "SSAO距离" },
	["SkyCloudLOD"] = {},
	["SoundPerf_VariationCap"] = { description = "限制声音套件的变化以减少32位计算机上的内存使用和磁盘读取" },
	["SoundUseNewBusSystem"] = { description = "使用新的总线结构或回退到旧的总线结构" },
	["Sound_DSPBufferSize"] = { description = "声音缓冲大小，默认为0" },
	["Sound_EnableArmorFoleySoundForOthers"] = {},
	["Sound_EnableArmorFoleySoundForSelf"] = {},
	["Sound_EnableMixMode2"] = {},
	["Sound_EnableMode2"] = {},
	["Sound_MaxCacheSizeInBytes"] = { description = "最大缓存大小（字节）" },
	["Sound_MaxCacheableSizeInBytes"] = { description = "缓存最大声音大小,更大的文件将改为流媒体处理" },
	["Sound_NumChannels"] = {},
	["Sound_OutputDriverIndex"] = {},
	["Sound_OutputDriverName"] = {},
	["Sound_OutputSampleRate"] = { description = "输出采样率" },
	["Sound_VoiceChatInputDriverIndex"] = {},
	["Sound_VoiceChatInputDriverName"] = {},
	["Sound_VoiceChatOutputDriverIndex"] = {},
	["Sound_VoiceChatOutputDriverName"] = {},
	["SplineOpt"] = { description = "优化样条优化" },
	["StartTalkingDelay"] = {},
	["StartTalkingTime"] = {},
	["StopTalkingDelay"] = {},
	["StopTalkingTime"] = {},
	["TargetPriorityValueBank"] = { description = "选择主动目标值库计算目标优先顺序" },
	["VoiceChatMode"] = { description = "按键通话（0）或按键激活（1）" },
	["VoiceChatSelfMute"] = { description = "关掉技能声音" },
	["WorldTextCritScreenY"] = {},
	["WorldTextGravity"] = {},
	["WorldTextNonRandomZ"] = {},
	["WorldTextRampDuration"] = {},
	["WorldTextRampPow"] = {},
	["WorldTextRampPowCrit"] = {},
	["WorldTextRandomXY"] = {},
	["WorldTextRandomZMax"] = {},
	["WorldTextRandomZMin"] = {},
	["WorldTextScreenY"] = {},
	["WorldTextStartPosRandomness"] = {},
	-- ["accounttype"] = {},
	-- ["actionedAdventureJournalEntries"] = { description = "Which adventure journal entries flagged with ADVENTURE_JOURNAL_HIDE_AFTER_ACTION the user acted upon" },
	-- ["activeCUFProfile"] = { description = "The last active CUF Profile." },
	-- ["addFriendInfoShown"] = { description = "The info for Add Friend has been shown" },
	-- ["advJournalLastOpened"] = { description = "Last time the Adventure Journal opened" },
	-- ["agentUID"] = { description = "The UID provided by Battle.net to be passed to Agent" },
	["allowCompareWithToggle"] = {},
	["allowD3D9BackingStore"] = { description = "" },
	["animFrameSkipLOD"] = { description = "动画将跳过框架的距离" },
	["asyncHandlerTimeout"] = { description = "引擎选项：异步读取主线程超时" },
	["asyncThreadSleep"] = { description = "引擎选项：异步读取线程休眠" },
	["auctionDisplayOnCharacter"] = { description = "纸娃娃系统上显示拍卖物" },
	["audioLocale"] = { description = "为音频内容设置本地化" },
	["autoCompleteResortNamesOnRecency"] = { description = "在“自动完成”列表中显示最近交谈过的人" },
	["autoCompleteUseContext"] = { description = "输入/gpromote时显示你的公会中的人同时名称不会被删除" },
	["autoCompleteWhenEditingFromCenter"] = { description = "" },
	["autoDismount"] = { description = "自动下马" },
	-- ["autoFilledMultiCastSlots"] = { description = "Bitfield that saves whether multi-cast slots have been automatically filled." },
	-- ["autoQuestPopUps"] = { description = "Saves current pop-ups for quests that are automatically acquired or completed." },
	["autoStand"] = { description = "自动站立" },
	["autoUnshift"] = { description = "自动取消变形形态" },
	["autojoinBGVoice"] = { description = "在战场聊天中自动加入语音会话" },
	["autojoinPartyVoice"] = { description = "在小队/团队聊天中自动加入语音会话" },
	-- ["bloatTest"] = {},
	-- ["bloatnameplates"] = {},
	-- ["bloatthreat"] = {},
	["bodyQuota"] = { description = "一次看到的最大物体的数量" },
	["breakUpLargeNumbers"] = { description = "使用逗号" },
	["bspcache"] = { description = "BSP节点缓存" },
	["calendarShowBattlegrounds"] = { description = "战场节日出现在日历中" },
	["calendarShowDarkmoon"] = { description = "暗月马戏团出现在日历上" },
	["calendarShowLockouts"] = { description = "日历中显示RAID的CD" },
	["calendarShowResets"] = { description = "日历中显示RAID重置" },
	["calendarShowWeeklyHolidays"] = { description = "日历中出现周末假期" },
	["cameraCustomViewSmoothing"] = {},
	["cameraDistanceMax"] = {},
	["cameraDistanceMaxFactor"] = {},
	["cameraDistanceRateMult"] = {},
	["cameraDive"] = {},
	["cameraHeightIgnoreStandState"] = {},
	["cameraPitchSmoothMax"] = {},
	["cameraPitchSmoothMin"] = {},
	["cameraPivotDXMax"] = {},
	["cameraPivotDYMin"] = {},
	-- ["cameraSavedDistance"] = {},
	-- ["cameraSavedPetBattleDistance"] = {},
	-- ["cameraSavedPitch"] = {},
	-- ["cameraSavedVehicleDistance"] = {},
	-- ["cameraView"] = {},
	["cameraYawSmoothMax"] = {},
	["cameraYawSmoothMin"] = {},
	["cameraZDamp"] = {},
	["cameraZoomSpeed"] = {},
	-- ["characterFrameCollapsed"] = {},
	["chatStyle"] = { description = "聊天框的编辑框样式. 可用: \"classic\", \"im\"" },
	["checkAddonVersion"] = {},
	["cloakFixEnabled"] = {},
	-- ["closedInfoFrames"] = { description = "Bitfield for which help frames have been acknowledged by the user" },
	["colorChatNamesByClass"] = { description = "一个在聊天中说话的玩家的名字将根据他的职业被涂上颜色." },
	["combatLogReducedRetentionTime"] = { description = "当内存不足时，保留战斗日志项的最长持续时间（秒）" },
	["combatLogRetentionTime"] = { description = "保留战斗日志项的最长持续时间（秒）" },
	["combatTextFloatMode"] = {},
	["componentCompress"] = { description = "字符分量纹理压缩" },
	["componentEmissive"] = { description = "" },
	["componentSpecular"] = { description = "" },
	["componentTexCacheSize"] = { description = "角色部位纹理缓存大小（MB）" },
	["componentTexLoadLimit"] = { description = "每个框架的角色部位纹理加载限制" },
	["componentTextureLevel"] = {},
	["componentThread"] = { description = "多线程角色部位处理" },
	-- ["currencyCategoriesCollapsed"] = { description = "Internal CVar for tracking collapsed currency categories." },
	-- ["currencyTokensBackpack1"] = { description = "Currency token types shown on backpack." },
	-- ["currencyTokensBackpack2"] = { description = "Currency token types shown on backpack." },
	-- ["currencyTokensUnused1"] = { description = "Currency token types marked as unused." },
	-- ["currencyTokensUnused2"] = { description = "Currency token types marked as unused." },
	["daltonize"] = { description = "尝试纠正色盲（将ColorBlindSimulator设置为色盲类型）" },
	-- ["dangerousShipyardMissionWarningAlreadyShown"] = { description = "Boolean indicating whether the shipyard's dangerous mission warning has been shown" },
	-- ["debugSoundPlayerSpellsOnlyOnPlayerBus"] = {},
	["detailDoodadInstancing"] = { description = "Doodad实例细节" },
	["digSites"] = { description = "" },
	["disableAutoRealmSelect"] = { description = "禁用登录时自动选择服务器" },
	["displayWorldPVPObjectives"] = { description = "是否显示世界PVP目标" },
	-- ["displayedRAFFriendInfo"] = { description = "Stores whether we already told a recruited person about their new BattleTag friend" },
	["dontShowEquipmentSetsOnItems"] = { description = "不显示与装备关联的套装" },
	["doodadLodDist"] = { description = "细节层次距离" },
	["doodadUnloadDist"] = {},
	["enableBGDL"] = { description = "后台下载" },
	-- ["enableCombatText"] = {},
	["enablePVPNotifyAFK"] = { description = "关闭AFK通知系统" },
	["enablePetBattleFloatingCombatText"] = { description = "是否显示宠物战斗的浮动战斗文本" },
	-- ["engineSurvey"] = {},
	["enterWorld"] = {},
	["entityLodDist"] = { description = "实体详细程度距离" },
	["environmentDetail"] = {},
	["expandUpgradePanel"] = {},
	["farclip"] = {},
	["fctCombatState"] = {},
	-- ["fctFriendlyHealers"] = {},
	["ffxAntiAliasingMode"] = { description = "消除混叠模式" },
	["ffxRectangle"] = { description = "对全屏效果使用矩形纹理" },
	-- ["flaggedTutorials"] = { description = "Internal cvar for saving completed tutorials in order" },
	["flightAngleLookAhead"] = { description = "在飞行过程中实现更动态的姿态调整" },
	-- ["floatingCombatTextCombatDamageStyle"] = { description = "No longer used" },
	["forceEnglishNames"] = {},
	["forceLODCheck"] = { description = "将跳过检查dbc的lod计数，并且每个m2将扫描文件夹中的外观配置文件" },
	-- ["friendInvitesCollapsed"] = { description = "Whether friend invites are hidden in the friends list" },
	["friendsSmallView"] = { description = "是否使用好友列表中较小的按钮" },
	["friendsViewButtons"] = { description = "是否显示好友列表查看按钮" },
	["fullDump"] = { description = "当崩溃时，生成一个完整的内存转储" },
	["gameTip"] = {},
	["garrisonCompleteTalent"] = {},
	["garrisonCompleteTalentType"] = {},
	["graphicsDepthEffects"] = { description = "图形设置的UI值" },
	["graphicsEnvironmentDetail"] = {},
	["graphicsLightingQuality"] = { description = "图形设置的UI值" },
	["graphicsLiquidDetail"] = { description = "图形设置的UI值" },
	["graphicsOutlineMode"] = { description = "图形设置的UI值" },
	["graphicsParticleDensity"] = {},
	["graphicsProjectedTextures"] = { description = "图形设置的UI值" },
	["graphicsQuality"] = {},
	["graphicsSSAO"] = { description = "图形设置的UI值" },
	["graphicsShadowQuality"] = {},
	["graphicsSunshafts"] = { description = "图形设置的UI值" },
	["graphicsTextureFiltering"] = {},
	["graphicsTextureResolution"] = {},
	["graphicsViewDistance"] = {},
	["groundEffectDensity"] = {},
	["groundEffectDist"] = {},
	["groundEffectFade"] = { description = "地面效果衰减" },
	-- ["guildNewsFilter"] = { description = "Stores the guild news filters" },
	["guildRewardsCategory"] = { description = "显示公会奖励类别" },
	["guildRewardsUsable"] = { description = "仅显示可用公会奖励" },
	-- ["guildRosterView"] = { description = "The current guild roster display mode" },
	["guildShowOffline"] = { description = "在公会用户界面中显示离线公会成员" },
	["gxAFRDevicesCount"] = { description = "强制设置AFR设备的数量" },
	["gxAdapter"] = { description = "强制运行指定的适配器索引（-1 允许客户端选择）" },
	-- ["gxApi"] = {},
	["gxAspect"] = { description = "约束窗口纵横比" },
	["gxCursor"] = { description = "切换硬件光标" },
	["gxDepthResolveHandleCaching"] = { description = "缓存深度处理的目标句柄" },
	["gxFixLag"] = { description = "防止光标延迟" },
	["gxFullscreenResolution"] = { description = "分辨率" },
	["gxMaxFrameLatency"] = { description = "CPU帧数" },
	["gxMaximize"] = {},
	["gxMonitor"] = { description = "显示屏" },
	["gxNewResolution"] = { description = "要设置的分辨率" },
	["gxPreferWindowedFullscreen"] = { description = "首选切换的全屏模式" },
	-- ["gxRefresh"] = {},
	["gxStereoConvergence"] = { description = "设置立体渲染收敛深度" },
	["gxStereoEnabled"] = { description = "启用立体渲染" },
	["gxStereoSeparation"] = { description = "设置立体渲染分离百分比" },
	["gxTextureCacheSize"] = { description = "GX纹理缓存大小" },
	["gxTripleBuffer"] = { description = "三重缓冲" },
	["gxVSync"] = { description = "垂直同步打开或关闭" },
	["gxWindow"] = {},
	["gxWindowedResolution"] = {},
	-- ["hardTrackedQuests"] = { description = "Internal cvar for saving hard (user manually selected) tracked quests in order" },
	-- ["hardTrackedWorldQuests"] = { description = "Internal cvar for saving hard tracked world quests" },
	["hbaoBias"] = { description = "HBAO偏压" },
	["hbaoBlurSharp"] = { description = "HBAO模糊清晰度" },
	["hbaoNormals"] = { description = "" },
	["hbaoPowerExp"] = { description = "HBAO功率指数" },
	["hbaoRadius"] = { description = "HBAO半径" },
	-- ["heirloomCollectedFilters"] = { description = "Bitfield for which collected filters are applied in the heirloom journal" },
	-- ["heirloomSourceFilters"] = { description = "Bitfield for which source filters are applied in the heirloom journal" },
	["hideAdventureJournalAlerts"] = { description = "" },
	["horizonStart"] = {},
	["hotReloadModels"] = { description = "当在bin文件夹中检测到新版本时，允许重新加载活动模型。如果禁用此选项，则只有在删除使用模型的所有游戏对象后，才会刷新模型数据" },
	["hwDetect"] = {},
	["hwPCF"] = { description = "硬件PCF过滤" },
	["incompleteQuestPriorityThresholdDelta"] = {},
	["initialRealmListTimeout"] = { description = "登录失败前等待初始服务器列表的时间（秒）" },
	["installLocale"] = {},
	--["installType"] = {},
	-- ["lastAddonVersion"] = {},
	-- ["lastCharacterIndex"] = {},
	-- ["lastGarrisonMissionTutorial"] = { description = "Stores the last garrison mission tutorial the player has accepted" },
	-- ["lastReadEULA"] = {},
	-- ["lastReadTOS"] = {},
	-- ["lastReadTerminationWithoutNotice"] = {},
	-- ["lastTalkedToGM"] = { description = "Stores the last GM someone was talking to in case they reload the UI while the GM chat window is open." },
	-- ["lastTransmogOutfitID"] = { description = "SetID of the last loaded transmog outfit" },
	-- ["lastVoidStorageTutorial"] = { description = "Stores the last void storage tutorial the player has accepted" },
	["launchAgent"] = { description = "" },
	-- ["lfGuildComment"] = { description = "Stores the player's Looking For Guild comment" },
	-- ["lfGuildSettings"] = { description = "Bit field of Looking For Guild player settings" },
	-- ["lfdCollapsedHeaders"] = { description = "Stores which LFD headers are collapsed." },
	-- ["lfdSelectedDungeons"] = { description = "Stores which LFD dungeons are selected." },
	["lfgAutoFill"] = { description = "查找小队时是否自动添加小队成员" },
	["lfgAutoJoin"] = { description = "在寻找小队时自动加入一个小队" },
	-- ["lfgListSearchLanguages"] = { description = "A simple bitfield for what languages we want to search in." },
	-- ["lfgSelectedRoles"] = { description = "Stores what roles the player is willing to take on." },
	["lightMode"] = {},
	["locale"] = { description = "设置游戏本地化" },
	["lockedWorldMap"] = { description = "缩小后是否锁定世界地图" },
	["lodObjectCullDist"] = {},
	["lodObjectCullSize"] = {},
	["lodObjectMinSize"] = {},
	["lodTerrainDiv"] = { description = "地形LOD除数" },
	["mapAnimDuration"] = { description = "动画的持续时间" },
	["mapAnimMinAlpha"] = { description = "当玩家在打开世界地图窗口的的情况下移动时要设置动画的alpha值" },
	["mapAnimStartDelay"] = { description = "动画的启动延迟" },
	["mapQuestDifficulty"] = {},
	-- ["maxAnimThreads"] = {},
	["maxFPS"] = { description = "设置fps限制" },
	["maxFPSBk"] = { description = "设置后台fps限制" },
	["maxLightCount"] = { description = "要渲染的最大灯光数" },
	["maxLightDist"] = { description = "渲染灯光的最大距离" },
	["miniWorldMap"] = { description = "" },
	["minimapAltitudeHintMode"] = { description = "" },
	["minimapInsideZoom"] = { description = "当前小地图缩放级别" },
	["minimapPortalMax"] = { description = "" },
	-- ["minimapShapeshiftTracking"] = { description = "Stores shapeshift-specific tracking spells that were active last session." },
	["minimapShowArchBlobs"] = { description = "" },
	["minimapShowQuestBlobs"] = { description = "" },
	-- ["minimapTrackedInfo"] = {},
	-- ["minimapTrackedInfov2"] = { description = "Stores the minimap tracking that was active last session." },
	["minimapZoom"] = { description = "室外小地图缩放级别" },
	["missingTransmogSourceInItemTooltips"] = { description = "" },
	-- ["mountJournalFilters"] = { description = "Bitfield for which collected filters are applied in the mount journal" },
	-- ["mountJournalSourceFilters"] = { description = "Bitfield for which source filters are applied in the mount journal" },
	["mouseInvertYaw"] = {},
	["mtParticles"] = { description = "" },
	["nameplateMotionSpeed"] = { description = "控制姓名板动画到目标位置的速率[0.0-1.0]" },
	["nameplateShowEnemyMinions"] = {},
	["nameplateShowFriendlyMinions"] = {},
	["nearclip"] = { description = "" },
	-- ["orderHallMissionTutorial"] = { description = "Stores information about which order hall mission tutorials the player has seen" },
	["outdoorMinAltitudeDistance"] = { description = "" },
	["outlineMouseOverFadeDuration"] = {},
	["outlineSelectionFadeDuration"] = {},
	["overrideArchive"] = { description = "客户端是否加载备用数据" },
	["particleDensity"] = {},
	["particleMTDensity"] = {},
	["partyBackgroundOpacity"] = { description = "小队背景的透明度" },
	["pathSmoothing"] = { description = "" },
	-- ["pendingInviteInfoShown"] = { description = "The info for pending invites has been shown" },
	-- ["petJournalFilters"] = { description = "Bitfield for which collected filters are applied in the pet journal" },
	-- ["petJournalSort"] = { description = "Sorting value for the pet journal" },
	-- ["petJournalSourceFilters"] = { description = "Bitfield for which source filters are applied in the pet journal" },
	-- ["petJournalTab"] = { description = "Stores the last tab the pet journal was opened to" },
	-- ["petJournalTypeFilters"] = { description = "Bitfield for which type filters are applied in the pet journal" },
	["physicsLevel"] = { description = "物理世界相互作用等级" },
	["playIntroMovie"] = {},
	--["playerStatLeftDropdown"] = { description = "The player stat selected in the left dropdown" },
	--["playerStatRightDropdown"] = { description = "The player stat selected in the right dropdown" },
	-- ["portal"] = { description = "Name of Battle.net portal to use" },
	["predictedHealth"] = { description = "是否在用户界面中使用预测的血量" },
	["preloadLoadingDistObject"] = { description = "加载时对象预加载距离" },
	["preloadLoadingDistTerrain"] = { description = "加载时地形预加载距离" },
	["preloadPlayerModels"] = { description = "将所有本地种族模型预加载到内存中" },
	["preloadStreamingDistObject"] = { description = "流媒体处理时对象预加载距离" },
	["preloadStreamingDistTerrain"] = { description = "流媒体传输时地形预加载距离" },
	["primaryProfessionsFilter"] = { description = "" },
	["processAffinityMask"] = { description = "设置哪些核心wow可以执行-更改需要重新启动才能生效" },
	["projectedTextures"] = {},
	["pvpBlacklistMaps0"] = { description = "黑名单pvp地图" },
	["pvpBlacklistMaps1"] = { description = "黑名单pvp地图" },
	-- ["pvpSelectedRoles"] = { description = "Stores what roles the player will fulfill in a BG." },
	-- ["questLogCollapseFilter"] = {},
	-- ["questLogCollapseHeaderFilter"] = {},
	-- ["questLogOpen"] = { description = "Whether the quest log appears the side of the windowed map. " },
	["questPOI"] = { description = "将使用任务POI系统" },
	["raidFramesDisplayAggroHighlight"] = { description = "是否在RAID框上显示仇恨高亮" },
	["raidFramesDisplayClassColor"] = { description = "在团队框上着色职业颜色" },
	["raidFramesDisplayOnlyDispellableDebuffs"] = { description = "是否在团队框上只显示可驱散的debuff" },
	["raidFramesDisplayPowerBars"] = { description = "是否在团队框架上显示怒气，蓝等等" },
	["raidFramesHealthText"] = { description = "在团队框架上显示血量文本" },
	["raidFramesHeight"] = { description = "单个RAID框的高度" },
	["raidFramesPosition"] = { description = "应将RAID框放置在何处" },
	["raidFramesWidth"] = { description = "单个RAID框的宽度" },
	["raidGraphicsDepthEffects"] = {},
	["raidGraphicsEnvironmentDetail"] = {},
	["raidGraphicsGroundClutter"] = {},
	["raidGraphicsLightingQuality"] = {},
	["raidGraphicsLiquidDetail"] = {},
	["raidGraphicsOutlineMode"] = {},
	["raidGraphicsParticleDensity"] = {},
	["raidGraphicsProjectedTextures"] = {},
	["raidGraphicsSSAO"] = {},
	["raidGraphicsShadowQuality"] = {},
	["raidGraphicsSunshafts"] = {},
	["raidGraphicsTextureFiltering"] = {},
	["raidGraphicsTextureResolution"] = {},
	["raidGraphicsViewDistance"] = {},
	["raidOptionDisplayMainTankAndAssist"] = { description = "是否在RAID帧中显示主坦克和主辅助" },
	["raidOptionDisplayPets"] = { description = "是否在团队框上显示宠物" },
	["raidOptionIsShown"] = { description = "是否显示RAID框" },
	["raidOptionKeepGroupsTogether"] = { description = "对RAID帧进行分组的方式" },
	["raidOptionLocked"] = { description = "是否锁定RAID框" },
	["raidOptionShowBorders"] = { description = "显示RAID帧周围的边框." },
	["raidOptionSortMode"] = { description = "对RAID框进行排序的方式" },
	["raidOrBattleCount"] = {},
	["rawMouseAccelerationEnable"] = { description = "" },
	["rawMouseEnable"] = { description = "" },
	["rawMouseRate"] = { description = "" },
	["rawMouseResolution"] = { description = "" },
	--["readContest"] = {},
	--["readEULA"] = {},
	--["readScanning"] = {},
	--["readTOS"] = {},
	--["readTerminationWithoutNotice"] = {},
	-- ["realmName"] = {},
	["reflectionDownscale"] = { description = "反射尺度" },
	["reflectionMode"] = {},
	["refraction"] = {},
	["repositionfrequency"] = {},
	-- ["reputationsCollapsed"] = { description = "List of reputation categories that have been collapsed in the Reputation tab" },
	["rippleDetail"] = {},
	["sceneOcclusionEnable"] = { description = "" },
	["screenshotFormat"] = {},
	["screenshotQuality"] = {},
	["scriptProfile"] = { description = "是否启用脚本分析" },
	["scriptWarnings"] = { description = "用户界面是否显示Lua警告" },
	["secondaryProfessionsFilter"] = { description = "" },
	-- ["seenAsiaCharacterUpgradePopup"] = { description = "Seen the free character upgrade popup (Asia)" },
	-- ["seenCharacterUpgradePopup"] = {},
	-- ["serverAlert"] = { description = "Get the glue-string tag for the URL" },
	-- ["serviceTypeFilter"] = { description = "Which trainer services to show" },
	["shadowCull"] = { description = "启用阴影截锥剔除" },
	["shadowInstancing"] = { description = "渲染阴影贴图时启用实例" },
	["shadowMode"] = {},
	["shadowScissor"] = { description = "渲染阴影贴图时启用剪切" },
	["shadowSoft"] = {},
	["shadowTextureSize"] = {},
	-- ["shipyardMissionTutorialAreaBuff"] = { description = "Stores whether the player has accepted the first area buff mission tutorial" },
	-- ["shipyardMissionTutorialBlockade"] = { description = "Stores whether the player has accepted the first blockade mission tutorial" },
	-- ["shipyardMissionTutorialFirst"] = { description = "Stores whether the player has accepted the first mission tutorial" },
	["showAllEnemyDebuffs"] = {},
	["showArtifactXPBar"] = { description = "" },
	["showBattlefieldMinimap"] = { description = "是否显示战场地图" },
	["showBuilderFeedback"] = { description = "" },
	["showErrors"] = {},
	["showKeyring"] = {},
	["showNPETutorials"] = { description = "显示NPE教程" },
	["showNewbieTips"] = {},
	["showQuestObjectivesOnMap"] = { description = "在主地图上显示任务POI." },
	["showQuestTrackingTooltips"] = { description = "单位和对象工具提示显示任务跟踪信息" },
	["showSpectatorTeamCircles"] = { description = "确定团队颜色圈在观看或评论游戏时是否可见" },
	["showTamers"] = { description = "宠物战斗图标将显示在世界地图上" },
	["showTimestamps"] = { description = "聊天时间戳的格式或 \"none\"" },
	-- ["showTokenFrame"] = { description = "The token UI has been shown" },
	-- ["showTokenFrameHonor"] = { description = "The token UI has shown Honor" },
	-- ["showToolsUI"] = {},
	["showfootprintparticles"] = { description = "足迹粒子的渲染开关" },
	["simd"] = { description = "启用SIMD功能 (如 SSE)" },
	["skipStartGear"] = { description = "是否应该在角色创建上显示起始装备" },
	["smoothUnitPhasing"] = { description = "客户将尝试在不同阶段的模型上相同阶段之间平稳切换." },
	["smoothUnitPhasingActorPurgatoryTimeMs"] = { description = "" },
	["smoothUnitPhasingAliveTimeoutMs"] = { description = "" },
	["smoothUnitPhasingDestroyedPurgatoryTimeMs"] = { description = "" },
	["smoothUnitPhasingDistThreshold"] = { description = "有效平滑单元相位的距离阈值." },
	["smoothUnitPhasingEnableAlive"] = { description = "" },
	["smoothUnitPhasingUnseenPurgatoryTimeMs"] = { description = "" },
	["smoothUnitPhasingVehicleExtraTimeoutMs"] = { description = "" },
	["spellBookSort"] = {},
	["spellClutter"] = { description = "" },
	["spellClutterDefaultTargetScalar"] = { description = "起始目标标量值 (min 0.1)" },
	["spellClutterHostileScalar"] = { description = "应用于敌对生物法术的标量 (min 0.001)" },
	["spellClutterMinSpellCount"] = { description = "" },
	["spellClutterPartySizeScalar"] = { description = "" },
	["spellClutterPlayerScalarMultiplier"] = { description = "" },
	["spellClutterRangeConstant"] = { description = "在优先权加倍之前有多少码 (min 1.0)" },
	["splashScreenBoost"] = { description = "显示Boost启动屏幕ID " },
	["splashScreenNormal"] = { description = "显示普通启动屏幕ID" },
	-- ["statCategoriesCollapsed"] = {},
	-- ["statCategoriesCollapsed_2"] = {},
	-- ["statCategoryOrder"] = {},
	-- ["statCategoryOrder_2"] = {},
	["streamBeams"] = { description = "对光线使用顶点流 (gfx驱动程序). 0=Auto Detect, 1=Never Stream, 2=Always Stream" },
	["streamStatusMessage"] = { description = "流媒体时是否显示状态消息" },
	["streamingCameraLookAheadTime"] = { description = "" },
	["streamingCameraMaxRadius"] = { description = "" },
	["streamingCameraRadius"] = { description = "" },
	["sunShafts"] = {},
	["superTrackerDist"] = {},
	["synchronizeBindings"] = {},
	["synchronizeChatFrames"] = {},
	["synchronizeSettings"] = { description = "客户端设置是否应存储在服务器上" },
	["taintLog"] = {},
	-- ["talentFrameShown"] = { description = "The talent UI has been shown" },
	["talentPointsSpent"] = { description = "" },
	["targetOfTargetMode"] = { description = "显示目标目标的条件" },
	["terrainAlphaBitDepth"] = { description = "地图位深度" },
	["terrainHoles"] = { description = "地形孔影响遮挡" },
	["terrainLodDist"] = {},
	["terrainMipLevel"] = {},
	["terrainTextureLod"] = {},
	["test_cameraDynamicPitch"] = { description = "分镜相机" },
	["test_cameraDynamicPitchBaseFovPad"] = { description = "分镜相机" },
	["test_cameraDynamicPitchBaseFovPadDownScale"] = { description = "分镜相机" },
	["test_cameraDynamicPitchBaseFovPadFlying"] = { description = "分镜相机" },
	["test_cameraDynamicPitchSmartPivotCutoffDist"] = { description = "分镜相机" },
	["test_cameraHeadMovementDeadZone"] = { description = "分镜相机" },
	["test_cameraHeadMovementFirstPersonDampRate"] = { description = "分镜相机" },
	["test_cameraHeadMovementMovingDampRate"] = { description = "分镜相机" },
	["test_cameraHeadMovementMovingStrength"] = { description = "分镜相机" },
	["test_cameraHeadMovementRangeScale"] = { description = "分镜相机" },
	["test_cameraHeadMovementStandingDampRate"] = { description = "分镜相机" },
	["test_cameraHeadMovementStandingStrength"] = { description = "分镜相机" },
	["test_cameraHeadMovementStrength"] = { description = "分镜相机" },
	["test_cameraLockedTargetFocusing"] = { description = "分镜相机" },
	["test_cameraOverShoulder"] = { description = "分镜相机" },
	["test_cameraTargetFocusEnemyEnable"] = { description = "分镜相机" },
	["test_cameraTargetFocusEnemyStrengthPitch"] = { description = "分镜相机" },
	["test_cameraTargetFocusEnemyStrengthYaw"] = { description = "分镜相机" },
	["test_cameraTargetFocusInteractEnable"] = { description = "分镜相机" },
	["test_cameraTargetFocusInteractStrengthPitch"] = { description = "分镜相机" },
	["test_cameraTargetFocusInteractStrengthYaw"] = { description = "分镜相机" },
	["textLocale"] = { description = "为文本设置游戏本地语言" },
	["textureFilteringMode"] = {},
	["threatWarning"] = { description = "是否显示仇恨警告用户界面 (0 = off, 1 = in dungeons, 2 = in party/raid, 3 = always)" },
	["threatWorldText"] = { description = "在战斗中是否显示仇恨漂浮" },
	["timeMgrAlarmEnabled"] = { description = "" },
	["timeMgrAlarmMessage"] = { description = "时间管理器的警报消息" },
	["timeMgrAlarmTime"] = { description = "时间管理器的警报时间（分钟）" },
	["timeMgrUseLocalTime"] = { description = "使用服务器时间或系统时间" },
	["timeMgrUseMilitaryTime"] = { description = "显示12或24小时时间" },
	["timingMethod"] = { description = "游戏计时方法" },
	-- ["timingTestError"] = { description = "Error reported by the timing validation system" }, -- read-only
	-- ["toyBoxCollectedFilters"] = { description = "Bitfield for which collected filters are applied in the toybox" },
	-- ["toyBoxSourceFilters"] = { description = "Bitfield for which source filters are applied in the toybox" },
	-- ["trackedAchievements"] = { description = "Internal cvar for saving tracked achievements in order" },
	-- ["trackedQuests"] = { description = "Internal cvar for saving automatically tracked quests in order" },
	-- ["trackedWorldQuests"] = { description = "Internal cvar for saving tracked world quests" },
	-- ["trackerFilter"] = {},
	-- ["trackerSorting"] = {},
	["transmogCurrentSpecOnly"] = { description = "" },
	-- ["transmogrifyShowCollected"] = { description = "Whether to show collected transmogs in the at the transmogrifier" }, -- read-only
	-- ["transmogrifyShowUncollected"] = { description = "Whether to show uncollected transmogs in the at the transmogrifier" }, -- read-only
	-- ["transmogrifySourceFilters"] = { description = "Bitfield for which source filters are applied in the wardrobe at the transmogrifier" },
	["twitterCharactersPerMedia"] = { description = "" },
	-- ["twitterGetConfigTime"] = { description = "Last time that we got Twitter configuration data successfully" },
	["twitterShortUrlLength"] = { description = "非https URL缩短字符数" },
	["twitterShortUrlLengthHttps"] = { description = "httpsURL缩短字符数" },
	["uiScale"] = {},
	["uiScaleMultiplier"] = { description = "默认用户界面比例的乘数. -1=determine based on system/monitor DPI, 0.5-2.0=multiplier to use when calculating UI scale. Only applied when useUIScale is 0." },
	["unitHighlights"] = { description = "是否应显示单位周围的高亮显示圆" },
	["useCompactPartyFrames"] = { description = "为队伍使用新的RAID框架" },
	["useUiScale"] = {},
	["videoOptionsVersion"] = {},
	-- ["wardrobeShowCollected"] = { description = "Whether to show collected transmogs in the wardrobe" }, -- read-only
	-- ["wardrobeShowUncollected"] = { description = "Whether to show uncollected transmogs in the wardrobe" }, -- read-only
	-- ["wardrobeSourceFilters"] = { description = "Bitfield for which source filters are applied in the wardrobe in the collection journal" },
	["warp"] = { description = "图形设置的UI值" },
	["warpScreenSize"] = { description = "显示器大小" },
	["warpViewDistance"] = { description = "从观看者到监视器的物理距离" },
	["warpViewTilt"] = { description = "" },
	["watchFrameBaseAlpha"] = { description = "目标帧透明度." },
	-- ["watchFrameState"] = { description = "Stores Objectives frame locked and collapsed states" },
	["waterDetail"] = {},
	["weatherDensity"] = {},
	["webChallengeURLTimeout"] = { description = "等待Web质询URL的时间（秒） 0表示永远等待" },
	["whisperMode"] = { description = "新私聊模式: \"跳出\", \"串联式\", \"两者\"" },
	["windowResizeLock"] = { description = "防止在窗口模式下调整大小" },
	["wmoDoodadDist"] = { description = "" },
	["wmoLodDist"] = {},
	["worldBaseMip"] = {},
	["worldLoadSort"] = { description = "加载时按距离对对象排序" },
	["worldMapOpacity"] = { description = "缩小世界地图的透明度" },
	["worldMaxMipLevel"] = { description = "世界最大纹理MIP级别" },
	["worldPoolUsage"] = { description = "使用静态/动态/流" },
	["worldPreloadHighResTextures"] = { description = "" },
	["worldPreloadNonCritical"] = { description = "预加载时需要在非临界流半径中加载对象" },
	["worldPreloadSort"] = { description = "预加载时按距离排序对象" },
	["worldQuestFilterArtifactPower"] = { description = "带有神器能量奖励的世界任务将显示在地图上" },
	["worldQuestFilterEquipment"] = { description = "装备奖励的世界任务将显示在地图上" },
	["worldQuestFilterGold"] = { description = "获得金钱奖励的世界任务将显示在地图上" },
	["worldQuestFilterOrderResources"] = { description = "带有资源奖励的世界任务将显示在地图上" },
	["worldQuestFilterProfessionMaterials"] = { description = "带有职业物质奖励的世界任务将显示在地图上" },
	["CastTimingEnhancements"] = { prettyName = nil, description = "预判瞄准定时施放", type = "boolean" },
	["autoAcceptQuickJoinRequests"] = { prettyName = "自动接受快速加入请求", description = "", type = "boolean" },
	
	["AimingStrafeLeftUsesMoveBackwards"] = { description = "使用向后移动动画，当使用一个远程武器并向左转时" },
	["DebugTorsoTwist"] = { description = "调试身体躯干扭曲的可视化: 1 = Player, 2 = Target, 3 = All" },
	
	["lodObjectFadeScale"] = {},
}

local CategoryNames = { -- not sure how meaningful these really are (/Blizzard_Console/Blizzard_Console_AutoComplete.lua Enum.ConsoleCategory)
	[0] = "Debug",
	[1] = "Graphics",
	[2] = "Console",
	[3] = "Combat",
	[4] = "Game",
	[5] = "Default",
	[6] = "Net",
	[7] = "Sound",
	[8] = "GM",
	[9] = "None",
}

--[[
	C_Console.GetAllCommands() returns a list of tables in this format:
		category: number from 0 to 9 representing a category above
		command: cvar name
		commandType: 0 seems to represent a cvar, 1 is a script command (like quit)
		help: cvar description text
--]]

for _, info in pairs(C_Console.GetAllCommands()) do
	if not addon.hiddenOptions[info.command]
	  and info.commandType == 0 -- cvar, rather than script
	  and info.category ~= 0 -- ignore debug category
	  and not strfind(info.command:lower(), 'debug') -- a number of commands with "debug" in their name are inexplicibly not in the "debug" category
	  and info.category ~= 8 -- ignore GM category
	then
		local value = GetCVar(info.command)
		local optionTable = {
			-- prettyName = info.command, -- the api doesn't provide pretty names, so the only way to keep these would be to create a table for them
			description = info.help,		
		}
		addon.hiddenOptions[info.command] = optionTable
	end
end


-- Allow case-insensitive lookup of cvars in our table (relatively slow, so match the case when possible)
local NoCase = {
	__index = function(t, mk) -- get
		if mk and mk.lower then
			local mk = mk:lower()
			for k,v in pairs(t) do
				if k:lower() == mk then
					return v
				end
			end
		end
	end,
	__newindex = function(t, mk, mv) -- set
		if mk and mk.lower then
			local mk = mk:lower()
			for k,v in pairs(t) do
				if k:lower() == mk then
					t[k] = mv
					return
				end
			end
		end
	end,
}
setmetatable(addon.hiddenOptions, NoCase)
