#version 120
#extension GL_ARB_shader_texture_lod : enable

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/



////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////

#define NORMAL_MAP_MAX_ANGLE 1.0   		//The higher the value, the more extreme per-pixel normal mapping (bump mapping) will be.
#define TILE_RESOLUTION 128

#define PARALLAX			//POM, need supported texture pack to get 3D look to blocks

#define SPECULARITY
	#define SPEC_BRIGHTNESS		0.6	// default is 1.0 - lower this number to increase the specular brightness for New specular
		//---for Resource pack Faithful recommended 1.0, for Ovos Rustic and Chromahills recommended 0.7---//

	#define SPEC_BRIGHTNESS_OLD		1.75	//default is 1.0 if not using a supported texture pack - higher this number lowers the specular best for supported texture packs

// OLD_SPECULAR					// add back the #define to enable, Old specular from 1st SEUS complete, works best for our custom specular maps for ChromaHills
#define NEW_SPECULAR					// New specular from SEUS 10.1 and 10.2 preview

///////////////////////////////////////////////////END OF ADJUSTABLE VARIABLES///////////////////////////////////////////////////

/* DRAWBUFFERS:0123 */

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D normals;
uniform sampler2D specular;
uniform sampler2D noisetex;
uniform float wetness;
uniform float frameTimeCounter;
uniform vec3 sunPosition;
uniform vec3 upPosition;

uniform int   isEyeInWater;

uniform float rainStrength;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 worldPosition;
varying vec4 vertexPos;
varying mat3 tbnMatrix;

varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;
varying vec3 worldNormal;

varying float materialIDs;

varying float distance;
varying float idCheck;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

const float bump_distance = 78.0;
const float fademult = 0.1;

vec4 cubic(float x)
{
    float x2 = x * x;
    float x3 = x2 * x;
    vec4 w;
    w.x =   -x3 + 3*x2 - 3*x + 1;
    w.y =  3*x3 - 6*x2       + 4;
    w.z = -3*x3 + 3*x2 + 3*x + 1;
    w.w =  x3;
    return w / 6.f;
}

vec4 BicubicTexture(in sampler2D tex, in vec2 coord)
{
	int resolution = 64;

	coord *= resolution;

	float fx = fract(coord.x);
    float fy = fract(coord.y);
    coord.x -= fx;
    coord.y -= fy;

    vec4 xcubic = cubic(fx);
    vec4 ycubic = cubic(fy);

    vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
    vec4 s = vec4(xcubic.x + xcubic.y, xcubic.z + xcubic.w, ycubic.x + ycubic.y, ycubic.z + ycubic.w);
    vec4 offset = c + vec4(xcubic.y, xcubic.w, ycubic.y, ycubic.w) / s;

    vec4 sample0 = texture2D(tex, vec2(offset.x, offset.z) / resolution);
    vec4 sample1 = texture2D(tex, vec2(offset.y, offset.z) / resolution);
    vec4 sample2 = texture2D(tex, vec2(offset.x, offset.w) / resolution);
    vec4 sample3 = texture2D(tex, vec2(offset.y, offset.w) / resolution);

    float sx = s.x / (s.x + s.y);
    float sy = s.z / (s.z + s.w);

    return mix( mix(sample3, sample2, sx), mix(sample1, sample0, sx), sy);
}


vec2 OffsetCoord(in vec2 coord, in vec2 offset, in int level)
{
	int tileResolution = TILE_RESOLUTION;
	ivec2 atlasTiles = ivec2(32, 32);
	ivec2 atlasResolution = tileResolution * atlasTiles;

	coord *= atlasResolution;

	vec2 offsetCoord = coord + mod(offset.xy * atlasResolution, vec2(tileResolution));

	vec2 minCoord = vec2(coord.x - mod(coord.x, tileResolution), coord.y - mod(coord.y, tileResolution));
	vec2 maxCoord = minCoord + tileResolution;

	if (offsetCoord.x > maxCoord.x) {
		offsetCoord.x -= tileResolution;
	} else if (offsetCoord.x < minCoord.x) {
		offsetCoord.x += tileResolution;
	}

	if (offsetCoord.y > maxCoord.y) {
		offsetCoord.y -= tileResolution;
	} else if (offsetCoord.y < minCoord.y) {
		offsetCoord.y += tileResolution;
	}

	offsetCoord /= atlasResolution;

	return offsetCoord;
}

vec3 Get3DNoise(in vec3 pos)
{
	pos.z += 0.0;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
		 f = f * f * (3.0 - 2.0 * f);

	vec2 uv =  (p.xy + p.z * vec2(17.0, 37.0)) + f.xy;
	vec2 uv2 = (p.xy + (p.z + 1.0) * vec2(17.0, 37.0)) + f.xy;
	vec2 coord =  (uv  + 0.5) / 64.0;
	vec2 coord2 = (uv2 + 0.5) / 64.0;
	vec3 xy1 = texture2D(noisetex, coord).xyz;
	vec3 xy2 = texture2D(noisetex, coord2).xyz;
	return mix(xy1, xy2, vec3(f.z));
}

vec3 Get3DNoiseNormal(in vec3 pos)
{
	float center = Get3DNoise(pos + vec3( 0.0, 0.0, 0.0)).x * 2.0 - 1.0;
	float left 	 = Get3DNoise(pos + vec3( 0.1, 0.0, 0.0)).x * 2.0 - 1.0;
	float up     = Get3DNoise(pos + vec3( 0.0, 0.1, 0.0)).x * 2.0 - 1.0;

	vec3 noiseNormal;
		 noiseNormal.x = center - left;
		 noiseNormal.y = center - up;

		 noiseNormal.x *= 0.2;
		 noiseNormal.y *= 0.2;

		 noiseNormal.b = sqrt(1.0 - noiseNormal.x * noiseNormal.x - noiseNormal.g * noiseNormal.g);
		 noiseNormal.b = 0.0;

	return noiseNormal.xyz;
}


vec3 CalculateRainBump(in vec3 pos)
{



	pos.y += frameTimeCounter * 3.0;
	pos.xz *= 1.0;

	pos.y += Get3DNoise(pos.xyz * vec3(1.0, 0.0, 1.0)).y * 2.0;


	vec3 p = pos;
	vec3 noiseNormal = Get3DNoiseNormal(p);	p.y += 0.25;
		 noiseNormal += Get3DNoiseNormal(p); p.y += 0.5;
		 noiseNormal += Get3DNoiseNormal(p); p.y += 0.75;
		 noiseNormal += Get3DNoiseNormal(p);
		 noiseNormal /= 4.0;

	return Get3DNoiseNormal(pos).xyz;
}

float GetModulatedRainSpecular(in vec3 pos)
{
	pos.xz *= 1.0;
	pos.y *= 0.2;

	vec3 p = pos;

	float n = Get3DNoise(p).y;
		  n += Get3DNoise(p / 2.0).x * 2.0;
		  n += Get3DNoise(p / 4.0).x * 4.0;

		  n /= 6.0;

	return n;
}


vec4 GetTexture(in sampler2D tex, in vec2 coord)
{
	#ifdef PARALLAX
		vec4 t = vec4(0.0);
		if (distance < 10.0)
		{
			t = texture2DLod(tex, coord, 0);
		}
		else
		{
			t = texture2D(tex, coord);
		}
		return t;
	#else
		return texture2D(tex, coord);
	#endif
}


vec2 CalculateParallaxCoord(in vec2 coord, in vec3 viewVector)
{
	vec2 parallaxCoord = coord.st;
	const int maxSteps = 112;
	vec3 stepSize = vec3(0.002, 0.002, 0.2);

	float parallaxDepth = 0.5;

	if (materialIDs > 2.5 && materialIDs < 3.5)
		parallaxDepth = 2.0;

	stepSize.xy *= parallaxDepth;

#ifdef LQ_POM
	float heightmap = GetTexture(normals, coord.st).a;
#else
	float heightmap = texture2D(normals, coord.st).a;
#endif

		vec3 pCoord = vec3(0.0, 0.0, 1.0);

		//make "pop out"
		//pCoord.st += (viewVector.xy * stepSize.xy) / (viewVector.z * stepSize.z);

		if (heightmap < 1.0)
		{
			vec3 step = viewVector * stepSize;
	#ifdef LQ_POM
			float distAngleWeight = ((distance * 0.6) * (2.1 - viewVector.z)) * 0.070;
	#else
			float distAngleWeight = ((distance * 0.6) * (2.1 - viewVector.z)) / 16.0;
	#endif
				 step *= distAngleWeight;
			#ifdef LQ_POM
				 step *= 2.0;
			#endif

			float sampleHeight = heightmap;

			for (int i = 0; sampleHeight < pCoord.z && i < 240; ++i)
			{
				//if (heightmap < pCoord.z)
				pCoord.xy = mix(pCoord.xy, pCoord.xy + step.xy, clamp((pCoord.z - sampleHeight) / (stepSize.z * 1.0 * distAngleWeight / (-viewVector.z + 0.05)), 0.0, 1.0));
				pCoord.z += step.z;
			#ifdef LQ_POM
				sampleHeight = GetTexture(normals, OffsetCoord(coord.st, pCoord.st, 0)).a;
			#else
				sampleHeight = texture2D(normals, OffsetCoord(coord.st, pCoord.st, 0)).a;
			#endif

			}


			parallaxCoord.xy = OffsetCoord(coord.st, pCoord.st, 0);
		}


	return parallaxCoord;
}


void main() {

	vec4 modelView = (gl_ModelViewMatrix * vertexPos);


	vec3 viewVector = normalize(tbnMatrix * modelView.xyz);
		 viewVector.x /= 2.0;

		 viewVector = normalize(viewVector);

	vec2 parallaxCoord = texcoord.st;
	#ifdef PARALLAX
		if (distance < 50.0)
		 parallaxCoord = CalculateParallaxCoord(texcoord.st, viewVector);
	#endif

	float height = GetTexture(normals, parallaxCoord).a;


	float w = wetness;



	vec4 spec = GetTexture(specular, parallaxCoord.st);
	vec4 specs = texture2D(specular, parallaxCoord.st);

	float wet = GetModulatedRainSpecular(worldPosition.xyz);

#ifdef OLD_SPECULAR
	float wetAngle = dot(worldNormal, vec3(0.0, 1.0, 0.0)) * 0.5 + 0.5;

	if (abs(materialIDs - 20.0) < 0.1 || abs(materialIDs - 21.0) < 0.1)
	{

	}
	else
	{
		 specs.g += max(0.0, clamp((wet * 1.0 + 0.2), 0.0, 1.0) - (SPEC_BRIGHTNESS_OLD - w) * 1.0);
		 specs.b += max(0.0, (wet) - (1.0 - w) * 1.0) * w;
	}
#endif

#ifdef NEW_SPECULAR
	float wetAngle = dot(worldNormal, vec3(0.0, 1.0, 0.0)) * 0.5 + 0.5;

	if (abs(materialIDs - 20.0) < 0.1 || abs(materialIDs - 21.0) < 0.1)
	{
		spec.g = 0.0;
	}
	else
	{
		 spec.g *= max(0.0, clamp((wet * 1.0 + 0.2), 0.0, 1.0) - (SPEC_BRIGHTNESS - w) * 1.0);
		 spec.b += max(0.0, (wet) - (1.0 - w) * 1.0) * w;
	}
#endif

	vec4 mclightmap = vec4(0.0, 0.0, 0.0, 1.0);
	vec4 mclightmaps = vec4(0.0, 0.0, 0.0, 1.0);

	//Separate lightmap types
	mclightmap.r = clamp((lmcoord.s * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);

	if (isEyeInWater > 0.9 || rainStrength > 0.9) {

		mclightmap.b = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
		mclightmaps.b = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);

	} else {

		mclightmap.b = texture2D(lightmap, vec2(0.0/16., lmcoord.t)).r*2.85 * pow(1-rainStrength, -0.27);

	}

	mclightmaps.b = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);


	mclightmap.b = pow(mclightmap.b, 1.0);
	mclightmap.r = pow(mclightmap.r, 3.0);


	 float wetfactor = clamp(mclightmaps.b * 1.05 - 0.9, 0.0, 0.1) / 0.1;
	 	   wetfactor *= w;

	 spec.g *= wetfactor;

#ifdef OLD_SPECULAR
	 specs.g *= wetfactor;
#endif






	vec4 frag2;

	if (distance < bump_distance) {

			vec3 bump = texture2DLod(normals, parallaxCoord.st, 2.0).rgb * 2.0 - 1.0;

			float bumpmult = clamp(bump_distance * fademult - distance * fademult, 0.0, 1.0) * NORMAL_MAP_MAX_ANGLE;
	              bumpmult *= 1.0 - (clamp(spec.g * 1.0 - 0.0, 0.0, 1.0) * 0.75);

			bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0, 0.0, 1.0 - bumpmult);


			frag2 = vec4(bump * tbnMatrix * 0.5 + 0.5, 1.0);

	} else {

			frag2 = vec4((normal) * 0.5 + 0.5, 1.0);
	}

	//Diffuse
	vec4 albedo = GetTexture(texture, parallaxCoord.st) * color;



	vec3 upVector = normalize(upPosition);

	float darkFactor = clamp(spec.g, 0.0, 0.2) / 0.2;

	albedo.rgb = pow(albedo.rgb, vec3(mix(1.0, 1.25, darkFactor)));



		float metallicMask = 0.0;

		if (   abs(materialIDs - 20.0) < 0.1
			|| abs(materialIDs - 21.0) < 0.1
			|| abs(materialIDs - 22.0) < 0.1
			|| abs(materialIDs - 23.0) < 0.1) {
			metallicMask = 1.0;
		}




	float mats_1 = materialIDs;
		  mats_1 += 0.1;



	gl_FragData[0] = albedo;

	//Depth
	gl_FragData[1] = vec4(mats_1/255.0, mclightmap.r, mclightmap.b, 1.0);

	//normal
	gl_FragData[2] = frag2;

#ifdef SPECULARITY
	//specularity
	#ifdef NEW_SPECULAR
	gl_FragData[3] = vec4(spec.r + spec.g, spec.b, 0.0, 1.0);
	#endif
	#ifdef OLD_SPECULAR
	gl_FragData[4] = vec4(specs.r + specs.g, specs.b, 0.0, 1.0);
	#endif
#endif

}
