#version 120

#define SHADOW_MAP_BIAS 0.8

//#define Water_TempFix

varying vec4 texcoord;
varying vec4 color;
varying vec3 normal;

varying float materialIDs;
varying float iswater;

uniform sampler2D noisetex;
uniform float frameTimeCounter;
uniform int worldTime;
uniform float rainStrength;
uniform vec3 cameraPosition;
uniform mat4 shadowProjectionInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowModelView;

attribute vec4 mc_Entity;

#define WAVING_VINES
#define ENTITY_VINES        106.0

vec4 cubic(float x) {
    float x2 = x * x;
    float x3 = x2 * x;
    vec4 w;
    w.x =   -x3 + 3*x2 - 3*x + 1;
    w.y =  3*x3 - 6*x2       + 4;
    w.z = -3*x3 + 3*x2 + 3*x + 1;
    w.w =  x3;
    return w / 6.f;
}

vec4 BicubicTexture(in sampler2D tex, in vec2 coord) {
	int resolution = 64;

	coord *= resolution;

	float fx = fract(coord.x);
  float fy = fract(coord.y);
  coord.x -= fx;
  coord.y -= fy;

  vec4 xcubic = cubic(fx);
  vec4 ycubic = cubic(fy);

  vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
  vec4 s = vec4(xcubic.x + xcubic.y, xcubic.z + xcubic.w, ycubic.x + ycubic.y, ycubic.z + ycubic.w);
  vec4 offset = c + vec4(xcubic.y, xcubic.w, ycubic.y, ycubic.w) / s;

  vec4 sample0 = texture2D(tex, vec2(offset.x, offset.z) / resolution);
  vec4 sample1 = texture2D(tex, vec2(offset.y, offset.z) / resolution);
  vec4 sample2 = texture2D(tex, vec2(offset.x, offset.w) / resolution);
  vec4 sample3 = texture2D(tex, vec2(offset.y, offset.w) / resolution);

  float sx = s.x / (s.x + s.y);
  float sy = s.z / (s.z + s.w);

  return mix(mix(sample3, sample2, sx), mix(sample1, sample0, sx), sy);
}

void main() {
	gl_Position = ftransform();

	vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	texcoord = gl_MultiTexCoord0;

	vec4 position = gl_Position;

	position = shadowProjectionInverse * position;
	position = shadowModelViewInverse * position;
	position.xyz += cameraPosition.xyz;

	materialIDs = 0.0;

	iswater = 0.0;

	if (mc_Entity.x == 1971.0) {
		iswater = 1.0;
	}

	if (mc_Entity.x == 8 || mc_Entity.x == 9) {
		iswater = 1.0;
	}

  if (mc_Entity.x == 160.0) {				//stained glass pane
		materialIDs = max(materialIDs, 89114.0);		//disabled
	}

	if (mc_Entity.x == 95.0) {			//stained glass
		materialIDs = max(materialIDs, 89114.0);		//disabled
	}

  if (mc_Entity.x == 51.0) {				//Fire
		materialIDs = max(materialIDs, 89224.0);		//disabled
	}

	//Grass
	if  (  mc_Entity.x == 31.0

		|| mc_Entity.x == 38.0 	//Rose
		|| mc_Entity.x == 37.0 	//Flower
		|| mc_Entity.x == 1925.0 	//Biomes O Plenty: Medium Grass
		|| mc_Entity.x == 1920.0 	//Biomes O Plenty: Thorns, barley
		|| mc_Entity.x == 1921.0 	//Biomes O Plenty: Sunflower
		|| mc_Entity.x == 188.0 	//Biomes O Plenty: Medium Grass
		|| mc_Entity.x == 176.0 	//Biomes O Plenty: Desert Grass
		|| mc_Entity.x == 177.0 	//Biomes O Plenty: Desert Grass
		|| mc_Entity.x == 178.0 	//Lavender
		) {
			materialIDs = max(materialIDs, 2.0);
	}

	//Wheat
	if (mc_Entity.x == 59.0) {
		materialIDs = max(materialIDs, 2.0);
	}

  //Vines
  if(mc_Entity.x == 106.0) {
    materialIDs = max(materialIDs, 66);
  }

	//Leaves
	if   ( mc_Entity.x == 18.0

		|| mc_Entity.x == 161.0
		|| mc_Entity.x == 1962.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1924.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1923.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1926.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1936.0 //Biomes O Plenty: Giant Flower Leaves
		|| mc_Entity.x == 184.0  //Yellow autumn leaves
		|| mc_Entity.x == 185.0  //Dying leaves
		|| mc_Entity.x == 186.0  //maple leaves
		|| mc_Entity.x == 187.0  //maple leaves
		|| mc_Entity.x == 192.0  //maple leaves
		|| mc_Entity.x == 249.0  //Willow leaves
		|| mc_Entity.x == 248.0  //Sacred Oak Leaves

		 ) {
		materialIDs = max(materialIDs, 3.0);
	}

	//Ice
	if (  mc_Entity.x == 79.0
	   || mc_Entity.x == 174.0) {
		 materialIDs = max(materialIDs, 4.0);
	}

	//Cobweb
	if ( mc_Entity.x == 30.0) {
		materialIDs = max(materialIDs, 11.0);
	}

	float grassWeight = mod(texcoord.t * 16.0, 1.0 / 16.0);

	float lightWeight = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
	lightWeight *= 1.1;
	lightWeight -= 0.1;
	lightWeight = max(0.0, lightWeight);
	lightWeight = pow(lightWeight, 5.0);

	if(grassWeight < 0.01) {
	   grassWeight = 1.0;
	} else {
	   grassWeight = 0.0;
	}

	//Waving grass
	if (materialIDs == 2.0) {
		vec2 angleLight = vec2(0.0);
		vec2 angleHeavy = vec2(0.0);
		vec2 angle 		= vec2(0.0);

		vec3 pn0 = position.xyz;
		pn0.x -= frameTimeCounter / 3.0;

		vec3 stoch = BicubicTexture(noisetex, pn0.xz / 64.0).xyz;
		vec3 stochLarge = BicubicTexture(noisetex, position.xz / (64.0 * 6.0)).xyz;

		vec3 pn = position.xyz;
		pn.x *= 2.0;
		pn.x -= frameTimeCounter * 15.0;
		pn.z *= 8.0;

		vec3 stochLargeMoving = BicubicTexture(noisetex, pn.xz / (64.0 * 10.0)).xyz;

		vec3 p = position.xyz;
		p.x += sin(p.z / 2.0) * 1.0;
		p.xz += stochLarge.rg * 5.0;

		float windStrength = mix(0.85, 1.0, rainStrength);
		float windStrengthRandom = stochLargeMoving.x;
	  windStrengthRandom = pow(windStrengthRandom, mix(2.0, 1.0, rainStrength));
		windStrength *= mix(windStrengthRandom, 0.5, rainStrength * 0.25);
		//windStrength = 1.0;

		//heavy wind
		float heavyAxialFrequency 			= 8.0;
		float heavyAxialWaveLocalization 	= 0.9;
		float heavyAxialRandomization 		= 13.0;
		float heavyAxialAmplitude 			= 15.0;
		float heavyAxialOffset 				= 15.0;

		float heavyLateralFrequency 		= 6.732;
		float heavyLateralWaveLocalization 	= 1.274;
		float heavyLateralRandomization 	= 1.0;
		float heavyLateralAmplitude 		= 6.0;
		float heavyLateralOffset 			= 0.0;

		//light wind
		float lightAxialFrequency 			= 5.5;
		float lightAxialWaveLocalization 	= 1.1;
		float lightAxialRandomization 		= 21.0;
		float lightAxialAmplitude 			= 5.0;
		float lightAxialOffset 				= 5.0;

		float lightLateralFrequency 		= 5.9732;
		float lightLateralWaveLocalization 	= 1.174;
		float lightLateralRandomization 	= 0.0;
		float lightLateralAmplitude 		= 1.0;
		float lightLateralOffset 			= 0.0;

		float windStrengthCrossfade = clamp(windStrength * 2.0 - 1.0, 0.0, 1.0);
		float lightWindFade = clamp(windStrength * 2.0, 0.2, 1.0);

		angleLight.x += sin(frameTimeCounter * lightAxialFrequency 		- p.x * lightAxialWaveLocalization		+ stoch.x * lightAxialRandomization) 	* lightAxialAmplitude 		+ lightAxialOffset;
		angleLight.y += sin(frameTimeCounter * lightLateralFrequency 	- p.x * lightLateralWaveLocalization 	+ stoch.x * lightLateralRandomization) 	* lightLateralAmplitude  	+ lightLateralOffset;

		angleHeavy.x += sin(frameTimeCounter * heavyAxialFrequency 		- p.x * heavyAxialWaveLocalization		+ stoch.x * heavyAxialRandomization) 	* heavyAxialAmplitude 		+ heavyAxialOffset;
		angleHeavy.y += sin(frameTimeCounter * heavyLateralFrequency 	- p.x * heavyLateralWaveLocalization 	+ stoch.x * heavyLateralRandomization) 	* heavyLateralAmplitude  	+ heavyLateralOffset;

		angle = mix(angleLight * lightWindFade, angleHeavy, vec2(windStrengthCrossfade));
		angle *= 2.0;

		// //Rotate block pivoting from bottom based on angle
		position.x += (sin((angle.x / 180.0) * 3.141579)) * grassWeight * lightWeight						* 1.0	;
		position.z += (sin((angle.y / 180.0) * 3.141579)) * grassWeight * lightWeight						* 1.0	;
		position.y += (cos(((angle.x + angle.y) / 180.0) * 3.141579) - 1.0)  * grassWeight * lightWeight	* 1.0	;
	}

	float tick = frameTimeCounter;
	const float pi = 3.14159265;

	//waving leaves
  if(materialIDs == 3.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
    float speed = 0.05;

    float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.30 * lightWeight;
    magnitude *= lightWeight;
    float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
    float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
    float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
    float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
    position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0 + rainStrength * 1.0);
    position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0 + rainStrength * 1.0);
    position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0 + rainStrength * 1.0);
  }


  //lower leaf movement
  if(materialIDs == 3.0) {
    float speed = 0.075;

    float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.075 * lightWeight;
    magnitude *= lightWeight;
    float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
    float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
    float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
    float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
    position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
    position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
    position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0);
  }

  #ifdef WAVING_VINES
    //large scale movement
    if ( mc_Entity.x == ENTITY_VINES ) {
        float speed = 1.0;
        float magnitude = (sin(((position.y + position.x)/2.0 + worldTime * pi / ((88.0)))) * 0.05 + 0.15) * 0.26;

        float d0 = sin(worldTime * pi / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(worldTime * pi / (152.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(worldTime * pi / (192.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(worldTime * pi / (142.0 * speed)) * 3.0 - 1.5;

        position.x += sin((worldTime * pi / (16.0 * speed)) + (position.x + d0)*0.5 + (position.z + d1)*0.5 + (position.y)) * magnitude;
        position.z += sin((worldTime * pi / (18.0 * speed)) + (position.z + d2)*0.5 + (position.x + d3)*0.5 + (position.y)) * magnitude;
    }

    //small scale movement
    if (mc_Entity.x == 106.0 && texcoord.t < 0.20) {
      float speed = 1.1;
      float magnitude = (sin(((position.y + position.x)/8.0 + worldTime * pi / ((88.0)))) * 0.15 + 0.05) * 0.22;

      float d0 = sin(worldTime * pi / (112.0 * speed)) * 3.0 + 0.5;
      float d1 = sin(worldTime * pi / (142.0 * speed)) * 3.0 + 0.5;
      float d2 = sin(worldTime * pi / (112.0 * speed)) * 3.0 + 0.5;
      float d3 = sin(worldTime * pi / (142.0 * speed)) * 3.0 + 0.5;

      position.x += sin((worldTime * pi / (18.0 * speed)) + (-position.x + d0) * 1.6 + (position.z + d1) * 1.6) * magnitude;
      position.z += sin((worldTime * pi / (18.0 * speed)) + (position.z + d2) * 1.6 + (-position.x + d3) * 1.6) * magnitude;
      position.y += sin((worldTime * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/4.0);
    }
  #endif


  if(iswater > 0.5) {
	  position.xyz += 10000.0;
  }

	position.xyz -= cameraPosition.xyz;
	position = shadowModelView * position;
	position = shadowProjection * position;

	normal = normalize(gl_NormalMatrix * gl_Normal);

	position.z += pow(max(0.0, 1.0 - normal.z), 4.0) * 0.01;

	gl_Position = position;

	float dist = sqrt(dot(gl_Position.xy, gl_Position.xy));

	vec2 pos = abs(gl_Position.xy * 1.165);
	dist = pow(pow(pos.x, 8) + pow(pos.y, 8), 1.0 / 8.0);
	float distortFactor = (1.0 - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;

	gl_Position.xy *= 1.0 / distortFactor;
	gl_Position.z /= 4.0;

	gl_FrontColor = gl_Color;
	color = gl_Color;
}
