#version 120

uniform sampler2D tex;

varying vec4 texcoord;
varying vec4 color;
varying vec3 normal;

varying float materialIDs;
varying float iswater;

void main() {

	vec4 tex = texture2D(tex, texcoord.st, 0) * color;

	if (iswater > 0.5) {
		vec4 albedo = tex;
		float lum = albedo.r + albedo.g + albedo.b;
		lum /= 3.0;

		lum = pow(lum, 1.0) * 1.0;
		lum += 0.0;

		vec3 waterColor = color.rgb;

		waterColor = normalize(waterColor);

		tex = vec4(0.1, 0.7, 1.0, 210.0/255.0);
		tex.rgb *= 0.4 * waterColor.rgb;
		tex.rgb *= vec3(lum);
	}

	vec3 toLight = normal.xyz;

	vec3 shadowNormal = normal.xyz;

	bool isTranslucent = abs(materialIDs - 3.0) < 0.1 || abs(materialIDs - 4.0) < 0.1;

	if (isTranslucent) {
		shadowNormal = vec3(0.0, 0.0, 0.0);
	}

	bool isGlassFix = abs(materialIDs - 89114.0) < 0.1;

	gl_FragData[0] = vec4(tex.rgb, tex.a);
	gl_FragData[1] = vec4(shadowNormal.xyz * 0.5 + 0.5, 1.0);
}
