#version 120

#define Water_DepthFog
#define PARALLAX_WATER		//Turn on 3D waves in water

#define Color_Red 0.2			//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]
#define Color_Green 0.7			//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]
#define Color_Blue 0.95			//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.95 1.0 1.1 1.2]

#ifdef Water_DepthFog
	#define Water_DepthFog_Transparency 100.0		//[50 70 85 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240 250]
#else
	#define Transparency 200.0		//[50 70 85 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240 250]
#endif

#define NEW_WATER_WAVES		//disable to go back to old parallax water waves, these new ones are faster
#define WAVE_HEIGHT 0.80
#define WAVE_HEIGHT_RAIN 1.97

#define Dynamic_Weather


uniform sampler2D texture;
uniform sampler2D specular;
uniform sampler2D normals;
uniform sampler2D noisetex;

uniform float frameTimeCounter;

uniform float rainStrength;
uniform int moonPhase;
uniform int worldTime;

varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;
varying vec3 viewVector;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 worldPosition;
varying vec4 vertexPos;
varying float distance;

varying float iswater;
varying float isice;

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//#define RAIN_WATER_SPEED

//#define SMOOTH_WATER		//adds a little extra smoothness to the water waves, turn off to save a few fps

#define ANIMATION_SPEED 0.6



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define FRAME_TIME frameTimeCounter * ANIMATION_SPEED

vec4 textureSmooth(in sampler2D tex, in vec2 coord) {
	vec2 res = vec2(64.0, 64.0);

	coord *= res;
	coord += 0.5;

	vec2 whole = floor(coord);
	vec2 part  = fract(coord);

	part.x = part.x * part.x * (3.0 - 2.0 * part.x);
	part.y = part.y * part.y * (3.0 - 2.0 * part.y);

	#ifdef SMOOTH_WATER
		part.x = 1.0 - (cos(part.x * 3.1415) * 0.5 + 0.5);
		part.y = 1.0 - (cos(part.y * 3.1415) * 0.5 + 0.5);
	#endif

	coord = whole + part;

	coord -= 0.5;
	coord /= res;

	return texture2D(tex, coord);
}

float AlmostIdentity(in float x, in float m, in float n) {
	if (x > m) return x;

	float a = 2.0 * n - m;
	float b = 2.0 * m - 3.0 * n;
	float t = x / m;

	return (a * t + b) * t * t + n;
}

float GetWaves(vec3 position, in float scale) {
	#ifdef NEW_WATER_WAVES
  	float speed = 0.7;

  	speed = mix(speed, 0.0, isice);

  	vec2 p = position.xz / 20.0;

  	p.xy -= position.y / 20.0;
  	p.x = -p.x;

  	p.x += (FRAME_TIME / 40.0) * speed;
  	p.y -= (FRAME_TIME / 40.0) * speed;

  	float weight = 1.0;
  	float weights = weight;

  	float allwaves = 0.0;

  	float wave = textureSmooth(noisetex, (p * vec2(2.0, 1.2))  + vec2(0.0,  p.x * 2.1) ).x; 			p /= 2.1; 	/*p *= pow(2.0, 1.0);*/ 	p.y -= (FRAME_TIME / 20.0) * 0.6; p.x -= (FRAME_TIME / 30.0) * speed;
  	allwaves += wave;

  	weight = 4.1;
  	weights += weight;

    wave = textureSmooth(noisetex, (p * vec2(2.0, 1.4))  + vec2(0.0,  -p.x * 2.1) ).x;	p /= 1.5;/*p *= pow(2.0, 2.0);*/ 	p.x += (FRAME_TIME / 20.0) * speed;
    wave *= weight;

  	allwaves += wave;

  	weight = 17.25;
  	weights += weight;
    wave = (textureSmooth(noisetex, (p * vec2(1.0, 0.75))  + vec2(0.0,  p.x * 1.1) ).x);		p /= 1.5; 	p.x -= (FRAME_TIME / 55.0) * speed;
    wave *= weight;
  	allwaves += wave;

  	weight = 15.25;
  	weights += weight;
    wave = (textureSmooth(noisetex, (p * vec2(1.0, 0.75))  + vec2(0.0,  -p.x * 1.7) ).x);		p /= 1.9; 	p.x += (FRAME_TIME / 155.0) * 0.8;
    wave *= weight;
  	allwaves += wave;

  	weight = 29.25;
  	weights += weight;
    wave = abs(textureSmooth(noisetex, (p * vec2(1.0, 0.8))  + vec2(0.0,  -p.x * 1.7) ).x * 2.0 - 1.0);		p /= 2.0; 	p.x += (FRAME_TIME / 155.0) * speed;
    wave = 1.0 - AlmostIdentity(wave, 0.2, 0.1);
    wave *= weight;
  	allwaves += wave;

  	allwaves /= weights;

  	return allwaves;

	#else
  	float speed = 0.7;
		speed = mix(speed, 0.0, isice);
		vec2 p = position.xz / 40.0;

		p.xy -= position.y / 40.0;
		p.x = -p.x;

		p.x += (FRAME_TIME / 20.0) * speed;
		p.y -= (FRAME_TIME / 20.0) * speed;

		#ifdef RAIN_WATER_SPEED
			p.x += (FRAME_TIME / 9.0) * speed * rainStrength;
			p.y -= (FRAME_TIME / 9.0) * speed * rainStrength;
		#endif

		float weight = 1.0;
		float weights = weight;

		float allwaves = 0.0;

		float wave = textureSmooth(noisetex, (p * vec2(2.0, 1.2)) + vec2(0.0,  p.x * 2.1)).x; p /= 2.1; p.y -= (FRAME_TIME / 50.0) * speed; p.x -= (FRAME_TIME / 30.0) * speed;
		allwaves += wave;
		weight = 2.1;
		weights += weight;

		wave = textureSmooth(noisetex, (p * vec2(2.0, 1.4))  + vec2(0.0,  -p.x * 2.1) ).x;	p /= 1.5; p.x += (FRAME_TIME / 20.0) * speed;
		wave *= weight;
		allwaves += wave;

		weight = 7.25;
		weights += weight;
		wave = abs(textureSmooth(noisetex, (p * vec2(1.0, 0.75))  + vec2(0.0,  p.x * 1.1) ).x);		p /= 1.3; 	p.x -= (FRAME_TIME / 25.0) * speed;

		wave *= weight;
		allwaves += wave;

		weight = 9.25;
		weights += weight;
		wave = abs(textureSmooth(noisetex, (p * vec2(1.0, 0.75))  + vec2(0.0,  -p.x * 1.7) ).x);		p /= 1.9; 	p.x += (FRAME_TIME / 155.0) * speed;

		wave *= weight;
		allwaves += wave;

		allwaves /= weights;
		return allwaves;
	#endif
}

vec3 GetWaterParallaxCoord(in vec3 position, in vec3 viewVector) {
	vec3 parallaxCoord = position.xyz;

	float dynWave = 1.0;

	#ifdef Dynamic_Weather
		float next_moon_phase = moonPhase + 1;

		if(float(moonPhase) == 7) {
			next_moon_phase = 0;
		}

		float moon_phase_smooth = mix(moonPhase, next_moon_phase, float(worldTime) / 24000.0);

		dynWave = ((abs(float(moon_phase_smooth) - 3) + 1) / 7) + 0.5;
	#endif

	vec3 stepSize = vec3(0.6 * WAVE_HEIGHT * dynWave, 0.6 * WAVE_HEIGHT * dynWave, 0.6);
	stepSize += vec3(0.2 * WAVE_HEIGHT_RAIN, 0.2 * WAVE_HEIGHT_RAIN, 0.2) * rainStrength;

	float waveHeight = GetWaves(position, 1.0);

	vec3 pCoord = vec3(0.0, 0.0, 1.0);

	vec3 step = viewVector * stepSize;
	float distAngleWeight = ((distance * 0.2) * (2.1 - viewVector.z)) / 2.0;
	distAngleWeight = 1.0;
	step *= distAngleWeight;

	float sampleHeight = waveHeight;

	for(int i = 0; sampleHeight < pCoord.z && i < 120; ++i) {
		pCoord.xy = mix(pCoord.xy, pCoord.xy + step.xy, clamp((pCoord.z - sampleHeight) / (stepSize.z * 0.2 * distAngleWeight / (-viewVector.z + 0.05)), 0.0, 1.0));
		pCoord.z += step.z;

		sampleHeight = GetWaves(position + vec3(pCoord.x, 0.0, pCoord.y), 1.0);
	}

	parallaxCoord = position.xyz + vec3(pCoord.x, 0.0, pCoord.y);

	return parallaxCoord;
}

vec3 GetWavesNormal(vec3 position, in float scale, in mat3 tbnMatrix) {
	vec4 modelView = (gl_ModelViewMatrix * vertexPos);

	vec3 viewVector = normalize(tbnMatrix * modelView.xyz);

	viewVector = normalize(viewVector);

	#ifdef PARALLAX_WATER
		position = GetWaterParallaxCoord(position, viewVector);
	#endif

	const float sampleDistance = 4.0;

	position -= vec3(0.005, 0.0, 0.005) * sampleDistance;

	float wavesCenter = GetWaves(position, scale);
	float wavesLeft = GetWaves(position + vec3(0.01 * sampleDistance, 0.0, 0.0), scale);
	float wavesUp   = GetWaves(position + vec3(0.0, 0.0, 0.01 * sampleDistance), scale);

	vec3 wavesNormal;
	wavesNormal.r = wavesCenter - wavesLeft;
	wavesNormal.g = wavesCenter - wavesUp;

	wavesNormal.r *= 25.0 * WAVE_HEIGHT / sampleDistance;
	wavesNormal.g *= 25.0 * WAVE_HEIGHT / sampleDistance;

	wavesNormal.b = sqrt(1.0 - wavesNormal.r * wavesNormal.r - wavesNormal.g * wavesNormal.g);
	wavesNormal.rgb = normalize(wavesNormal.rgb);

	return wavesNormal.rgb;
}

void main() {
	vec4 tex = texture2D(texture, texcoord.st);

	float zero = 1.0;
	float transx = 0.0;
	float transy = 0.0;

	float texblock = 0.0625;

	bool backfacing = false;

	if (viewVector.z > 0.0) {
		backfacing = true;
	} else {
		backfacing = false;
	}

	if (iswater > 0.5 && !backfacing) {
		vec4 albedo = texture2D(texture, texcoord.st).rgba;
		float lum = albedo.r + albedo.g + albedo.b;
		lum /= 3.0;

		lum = pow(lum, 1.5) * 1.5;
		lum += 0.0;

		vec3 waterColor = color.rgb;

		waterColor = normalize(waterColor);

		#ifdef Water_DepthFog
			tex = vec4(Color_Red, Color_Green, Color_Blue, Water_DepthFog_Transparency/255.0);
		#else
			tex = vec4(Color_Red, Color_Green, Color_Blue, Transparency/255.0);
		#endif

		tex.rgb *= 1.0 * waterColor.rgb;
		tex.rgb *= vec3(lum);

		} else if (iswater > 0.5 && backfacing) {
			tex = vec4(0.0, 0.0, 0.0, 30.0 / 255.0);
		}

	//Separate lightmap types
	vec4 lightmap = vec4(0.0, 0.0, 0.0, 1.0);
	lightmap.r = clamp((lmcoord.s * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
	lightmap.b = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);

	lightmap.b = pow(lightmap.b, 2.0);
	lightmap.r = pow(lightmap.r, 3.0);

	//lightmap.b = 0.75;
	float matID = 4.0;

	for (int i = 0; i < 16; i++) {
		if (iswater > 0.5 && lightmap.b >= i / 16.0 && lightmap.b < (i + 1) / 16.0)
			matID = 35.0 + i;
	}

	if (isice > 0.5) {
		matID = 4;
	}

	matID += 0.1;

	gl_FragData[0] = vec4(tex.rgb, tex.a);
	gl_FragData[1] = vec4(matID / 255.0, lightmap.r, lightmap.b, 1.0);

	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x, tangent.y, binormal.y, normal.y, tangent.z, binormal.z, normal.z);

	vec3 wavesNormal = GetWavesNormal(worldPosition, 1.0, tbnMatrix);

	vec3 waterNormal = wavesNormal * tbnMatrix;
	vec3 iceNormal = texture2D(normals, texcoord.st).rgb * 2.0 - 1.0;
	iceNormal = iceNormal * tbnMatrix;

	waterNormal = mix(waterNormal, iceNormal, isice);

	gl_FragData[2] = vec4(waterNormal.rgb * 0.5 + 0.5, 1.0);

	vec4 spec = texture2D(specular, texcoord.st);

	gl_FragData[3] = vec4(spec.r, spec.b, 0.0, 1.0);
}
