#version 120
#extension GL_ARB_shader_texture_lod : enable

//#define OLD_LIGHTING_FIX		//In newest versions of the shaders mod/optifine, old lighting isn't removed properly. If OldLighting is On and this is enabled, you'll get proper results in any shaders mod/minecraft version.


#define Dynamic_Weather
#define Dynamic_Terrain

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 worldPosition;
uniform int moonPhase;

attribute vec4 mc_Entity;
attribute vec4 at_tangent;

uniform int worldTime;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform float frameTimeCounter;
uniform float rainStrength;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
varying vec3 vectorLight;

uniform sampler2D noisetex;

varying vec3 normal;

varying float distance;

varying float materialIDs;

varying mat3 tbnMatrix;
varying vec4 vertexPos;

//If you're using 1.7.2, it has a texture glitch where certain sides of blocks are mirrored. Enable the following to compensate and keep lighting correct
//#define TEXTURE_FIX	//If you're using 1.7.2, it has a texture glitch where certain sides of blocks are mirrored. Enable the following to compensate and keep lighting correct

#define WAVING_GRASS
#define WAVING_WHEAT
#define WAVING_LEAVES
#define WAVING_VINES
#define WAVING_LILIES
#define WAVING_LAVA

#define ENTITY_VINES        106.0

vec4 cubic(float x) {
    float x2 = x * x;
    float x3 = x2 * x;
    vec4 w;
    w.x =   -x3 + 3*x2 - 3*x + 1;
    w.y =  3*x3 - 6*x2       + 4;
    w.z = -3*x3 + 3*x2 + 3*x + 1;
    w.w =  x3;
    return w / 6.f;
}

vec4 BicubicTexture(in sampler2D tex, in vec2 coord) {
	int resolution = 64;

	coord *= resolution;

	float fx = fract(coord.x);
  float fy = fract(coord.y);
  coord.x -= fx;
  coord.y -= fy;

  vec4 xcubic = cubic(fx);
  vec4 ycubic = cubic(fy);

  vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
  vec4 s = vec4(xcubic.x + xcubic.y, xcubic.z + xcubic.w, ycubic.x + ycubic.y, ycubic.z + ycubic.w);
  vec4 offset = c + vec4(xcubic.y, xcubic.w, ycubic.y, ycubic.w) / s;

  vec4 sample0 = texture2D(tex, vec2(offset.x, offset.z) / resolution);
  vec4 sample1 = texture2D(tex, vec2(offset.y, offset.z) / resolution);
  vec4 sample2 = texture2D(tex, vec2(offset.x, offset.w) / resolution);
  vec4 sample3 = texture2D(tex, vec2(offset.y, offset.w) / resolution);

  float sx = s.x / (s.x + s.y);
  float sy = s.z / (s.z + s.w);

  return mix( mix(sample3, sample2, sx), mix(sample1, sample0, sx), sy);
}

vec3 calcLavaMove(in vec3 pos) {
	float fy = fract(pos.y + 0.001);
  float PIs = 3.1415927;
	if (fy > 0.002) {
		float wave = 0.05 * sin(2 * PIs / 4 * frameTimeCounter / 3 + 2 * PIs * 2 / 16 * pos.x + 2 * PIs * 5 / 16 * pos.z)
				   + 0.05 * sin(2 * PIs / 3 * frameTimeCounter / 3 - 2 * PIs * 3 / 16 * pos.x + 2 * PIs * 4 / 16 * pos.z);
		return vec3(0, clamp(wave, -fy, 1.0-fy), 0);
	} else {
		return vec3(0);
	}
}

float dynWeather(in float scale) {
  float dynWeather = 1.0;

  #ifdef Dynamic_Weather
	  #ifdef Dynamic_Terrain
      float next_moon_phase = moonPhase + 1;

      if(float(moonPhase) == 7) {
        next_moon_phase = 0;
      }

      float moon_phase_smooth = mix(moonPhase, next_moon_phase, float(worldTime) / 24000.0);

      dynWeather = ((abs(float(moon_phase_smooth) - 2) + 1) / scale) + 0.5;
	  #endif
  #endif

  return dynWeather;
}

void main() {
	texcoord = gl_MultiTexCoord0;
	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
  float dynWeatherScaler = dynWeather(5);

	vec4 viewpos = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	vec4 position = viewpos;

	worldPosition = viewpos.xyz + cameraPosition.xyz;

	//Gather materials
	materialIDs = 1.0;

	//Grass
	if(mc_Entity.x == 31.0
		|| mc_Entity.x == 38.0 	//Rose
		|| mc_Entity.x == 37.0 	//Flower
		|| mc_Entity.x == 1925.0 	//Biomes O Plenty: Medium Grass
		|| mc_Entity.x == 1920.0 	//Biomes O Plenty: Thorns, barley
		|| mc_Entity.x == 1921.0 	//Biomes O Plenty: Sunflower
		) {
		materialIDs = max(materialIDs, 2.0);
	}

	//Wheat
	if (mc_Entity.x == 59.0
		|| mc_Entity.x == 141.0
		|| mc_Entity.x == 142.0
		|| mc_Entity.x == 115.0

		) {
		materialIDs = max(materialIDs, 2.0);
	}

	//Leaves
	if(mc_Entity.x == 18.0
    || mc_Entity.x == 161.0
		|| mc_Entity.x == 1962.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1924.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1923.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1926.0 //Biomes O Plenty: Leaves
		|| mc_Entity.x == 1936.0 //Biomes O Plenty: Giant Flower Leaves

		 ) {
		materialIDs = max(materialIDs, 3.0);
	}

  //Double Tall
  if(mc_Entity.x == 175.0
    ) {
      materialIDs = max(materialIDs, 65.0);
    }
	//Gold block
	if (mc_Entity.x == 41) {
		materialIDs = max(materialIDs, 20.0);
	}

	//Iron block
	if (mc_Entity.x == 42) {
		materialIDs = max(materialIDs, 21.0);
	}

	//Diamond Block
	if (mc_Entity.x == 57) {
		materialIDs = max(materialIDs, 22.0);
	}

	//Emerald Block
	if (mc_Entity.x == -123) {
		materialIDs = max(materialIDs, 23.0);
	}

	//sand
	if (mc_Entity.x == 12) {
		materialIDs = max(materialIDs, 24.0);
	}

	//sandstone
	if (mc_Entity.x == 24 || mc_Entity.x == -128) {
		materialIDs = max(materialIDs, 25.0);
	}

	//stone
	if (mc_Entity.x == 1) {
		materialIDs = max(materialIDs, 26.0);
	}

	//cobblestone
	if (mc_Entity.x == 4) {
		materialIDs = max(materialIDs, 27.0);
	}

	//wool
	if (mc_Entity.x == 35) {
		materialIDs = max(materialIDs, 28.0);
	}

	//torch
	if (mc_Entity.x == 50) {
		materialIDs = max(materialIDs, 30.0);
	}

	//lava
	if (mc_Entity.x == 10 || mc_Entity.x == 11) {
		materialIDs = max(materialIDs, 31.0);
	}

	//glowstone and lamp
	if (mc_Entity.x == 89 || mc_Entity.x == 124) {
		materialIDs = max(materialIDs, 32.0);
	}

	//fire
	if (mc_Entity.x == 51) {
		materialIDs = max(materialIDs, 33.0);
	}

	float tick = frameTimeCounter;

  float grassWeight = mod(texcoord.t * 16.0, 1.0 / 16.0);
  float vineweight = mod(texcoord.t * 1.0, 1.0 / 0.20);

  float lightWeight = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
	lightWeight *= 1.1;
	lightWeight -= 0.1;
	lightWeight = max(0.0, lightWeight);
	lightWeight = pow(lightWeight, 5.0);

	if (grassWeight < 0.01) {
	  grassWeight = 1.0;
	} else {
	  grassWeight = 0.0;
	}

  const float pi = 3.14159265;

  position.xyz += cameraPosition.xyz;

  #ifdef WAVING_GRASS
    //Waving grass
    if(materialIDs == 2.0) {
		  vec2 angleLight = vec2(0.0);
		  vec2 angleHeavy = vec2(0.0);
      vec2 angle 		= vec2(0.0);

      vec3 pn0 = position.xyz;
			pn0.x -= frameTimeCounter / 3.0;

      vec3 stoch = BicubicTexture(noisetex, pn0.xz / 64.0).xyz;
      vec3 stochLarge = BicubicTexture(noisetex, position.xz / (64.0 * 6.0)).xyz;

      vec3 pn = position.xyz;
			pn.x *= 2.0;
			pn.x -= frameTimeCounter * 15.0;
			pn.z *= 8.0;

      vec3 stochLargeMoving = BicubicTexture(noisetex, pn.xz / (64.0 * 10.0)).xyz;

		  vec3 p = position.xyz;
		 	p.x += sin(p.z / 2.0) * 1.0;
		 	p.xz += stochLarge.rg * 5.0;

		  float windStrength = mix(0.85 * dynWeatherScaler, 1.0, rainStrength);
      float windStrengthRandom = stochLargeMoving.x;
			windStrengthRandom = pow(windStrengthRandom, mix(2.0, 1.0, rainStrength));
			windStrength *= mix(windStrengthRandom, 0.5, rainStrength * dynWeatherScaler * 0.25);

		  //heavy wind
		  float heavyAxialFrequency 			= 8.0;
		  float heavyAxialWaveLocalization 	= 0.9;
		  float heavyAxialRandomization 		= 13.0;
	    float heavyAxialAmplitude 			= 15.0;
		  float heavyAxialOffset 				= 15.0;

		  float heavyLateralFrequency 		= 6.732;
		  float heavyLateralWaveLocalization 	= 1.274;
	    float heavyLateralRandomization 	= 1.0;
		  float heavyLateralAmplitude 		= 6.0;
	    float heavyLateralOffset 			= 0.0;

		  //light wind
		  float lightAxialFrequency 			= 5.5;
	    float lightAxialWaveLocalization 	= 1.1;
      float lightAxialRandomization 		= 21.0;
      float lightAxialAmplitude 			= 5.0;
      float lightAxialOffset 				= 5.0;

      float lightLateralFrequency 		= 5.9732;
      float lightLateralWaveLocalization 	= 1.174;
      float lightLateralRandomization 	= 0.0;
      float lightLateralAmplitude 		= 1.0;
      float lightLateralOffset 			= 0.0;

      float windStrengthCrossfade = clamp(windStrength * 2.0 - 1.0, 0.0, 1.0);
      float lightWindFade = clamp(windStrength * 2.0, 0.2, 1.0);

      angleLight.x += sin(frameTimeCounter * lightAxialFrequency 		- p.x * lightAxialWaveLocalization		+ stoch.x * lightAxialRandomization) 	* lightAxialAmplitude 		+ lightAxialOffset;
      angleLight.y += sin(frameTimeCounter * lightLateralFrequency 	- p.x * lightLateralWaveLocalization 	+ stoch.x * lightLateralRandomization) 	* lightLateralAmplitude  	+ lightLateralOffset;

      angleHeavy.x += sin(frameTimeCounter * heavyAxialFrequency 		- p.x * heavyAxialWaveLocalization		+ stoch.x * heavyAxialRandomization) 	* heavyAxialAmplitude 		+ heavyAxialOffset;
      angleHeavy.y += sin(frameTimeCounter * heavyLateralFrequency 	- p.x * heavyLateralWaveLocalization 	+ stoch.x * heavyLateralRandomization) 	* heavyLateralAmplitude  	+ heavyLateralOffset;

      angle = mix(angleLight * lightWindFade, angleHeavy, vec2(windStrengthCrossfade));
      angle *= 2.0;

		  ////Rotate block pivoting from bottom based on angle
		  position.x += (sin((angle.x / 180.0) * 3.141579)) * grassWeight * lightWeight						* 1.0	;
      position.z += (sin((angle.y / 180.0) * 3.141579)) * grassWeight * lightWeight						* 1.0	;
      position.y += (cos(((angle.x + angle.y) / 180.0) * 3.141579) - 1.0)  * grassWeight * lightWeight	* 1.0	;
	  }
  #endif

  #ifdef WAVING_WHEAT
    if (mc_Entity.x == 296 && texcoord.t < 0.35) {
		  float speed = 0.03;

      float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.12 + 0.02;
			magnitude *= grassWeight * 0.2;
			magnitude *= lightWeight;
		  float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
      float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
      float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
      float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
      position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * dynWeatherScaler;
      position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * dynWeatherScaler;
    }

	  //small leaf movement
	  if(mc_Entity.x == 59.0 && texcoord.t < 0.35) {
		  float speed = 0.04;

		  float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.025 + 0.075) * 0.2;
			magnitude *= grassWeight;
			magnitude *= lightWeight;
		  float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
	    float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
      float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
      float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
      position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0 + rainStrength * 2.0) * dynWeatherScaler;
      position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0 + rainStrength * 2.0) * dynWeatherScaler;
      position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0 + rainStrength * 2.0) * dynWeatherScaler;
	  }
  #endif

  #ifdef WAVING_LEAVES
	  if(materialIDs == 3.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		  float speed = 0.05;

		  float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.30 * lightWeight;
		  magnitude *= lightWeight;
		  float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		  float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		  float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		  float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		  position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0 + rainStrength * 1.0) * dynWeatherScaler;
	    position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0 + rainStrength * 1.0) * dynWeatherScaler;
		  position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0 + rainStrength * 1.0) * dynWeatherScaler;
	  }


	  //lower leaf movement
	  if(materialIDs == 3.0) {
		  float speed = 0.075 * dynWeatherScaler;

		  float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.075 * lightWeight;
			magnitude *= lightWeight;
		  float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		  float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		  float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		  float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		  position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude * dynWeatherScaler;
		  position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude * dynWeatherScaler;
		  position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0) * dynWeatherScaler;
	  }
  #endif

  #ifdef WAVING_VINES
    //large scale movement
    if(mc_Entity.x == ENTITY_VINES ) {
      float speed = 1.0 * dynWeatherScaler;
      float magnitude = (sin(((position.y + position.x)/2.0 + worldTime * 3.14159265358979323846264 / ((88.0)))) * 0.05 + 0.15) * 0.26;
			magnitude *= vineweight;
			magnitude *= lightWeight;
		  float d0 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5;
      float d1 = sin(worldTime * 3.14159265358979323846264 / (152.0 * speed)) * 3.0 - 1.5;
      float d2 = sin(worldTime * 3.14159265358979323846264 / (192.0 * speed)) * 3.0 - 1.5;
      float d3 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;
      position.x += sin((worldTime * 3.14159265358979323846264 / (16.0 * speed)) + (position.x + d0)*0.5 + (position.z + d1)*0.5 + (position.y)) * magnitude;
      position.z += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (position.z + d2)*0.5 + (position.x + d3)*0.5 + (position.y)) * magnitude;
    }

    //small scale movement
    if(mc_Entity.x == 106.0 && texcoord.t < 0.20) {
      float speed = 1.1 * dynWeatherScaler;
      float magnitude = (sin(((position.y + position.x)/8.0 + worldTime * 3.14159265358979323846264 / ((88.0)))) * 0.15 + 0.05) * 0.22;
      float d0 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 + 0.5;
      float d1 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 + 0.5;
      float d2 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 + 0.5;
      float d3 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 + 0.5;
      position.x += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;
      position.z += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;
      position.y += sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/4.0);
    }
  #endif

  #ifdef WAVING_LILIES
    //flowing water
    if(mc_Entity.x == 111.0 && texcoord.t > 0.05) {
      float speed = 2.7 * dynWeatherScaler;
      float magnitude = (sin((worldTime * 3.14159265358979323846264 / ((28.0) * speed))) * 0.05 + 0.15) * 0.17;
      float d0 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      float d1 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      float d2 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      float d3 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      position.x += sin((worldTime * 3.14159265358979323846264 / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
      position.y += sin((worldTime * 3.14159265358979323846264 / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * magnitude;
      position.y -= 0.04;
    }

    //still water
    if(mc_Entity.x == 111.0 && texcoord.t > 0.05) {
      float speed = 2.7 * dynWeatherScaler;
      float magnitude = (sin((worldTime * 3.14159265358979323846264 / ((28.0) * speed))) * 0.05 + 0.15) * 0.17;
      float d0 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      float d1 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      float d2 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      float d3 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
      position.x += sin((worldTime * 3.14159265358979323846264 / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
      position.y += sin((worldTime * 3.14159265358979323846264 / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * magnitude;
      position.y -= 0.04;
    }
  #endif

  #ifdef WAVING_LAVA
    if(mc_Entity.x == 10.0 || mc_Entity.x == 11.0 ) {
      position.xyz += calcLavaMove(position.xyz + cameraPosition) * 0.25;
    }
  #endif

	vec4 locposition = gl_ModelViewMatrix * gl_Vertex;

	distance = length(locposition.xyz);

	position.xyz -= cameraPosition.xyz;

	gl_Position = gl_ProjectionMatrix * gbufferModelView * position;

	color = gl_Color;

	gl_FogFragCoord = gl_Position.z;

	normal = normalize(gl_NormalMatrix * gl_Normal);

  vec3 tangent	= normalize(gl_NormalMatrix * at_tangent.xyz );
	vec3 binormal	= normalize(gl_NormalMatrix * -cross(gl_Normal, at_tangent.xyz));

	tbnMatrix	= mat3(tangent.x, binormal.x, normal.x,
						       tangent.y, binormal.y, normal.y,
						       tangent.z, binormal.z, normal.z);

	vertexPos = gl_Vertex;

  if (worldTime < 12700 || worldTime > 23250) {
    vectorLight = normalize(sunPosition);
  } else {
    vectorLight = normalize(moonPosition);
  }
}
