#version 120
#extension GL_ARB_shader_texture_lod : enable
/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/



////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////

#define NORMAL_MAP_MAX_ANGLE 1.0   		//The higher the value, the more extreme per-pixel normal mapping (bump mapping) will be.

#define PARALLAX			//POM, need supported texture pack to get 3D look to blocks
#define TEXTURE_PACK_RESOLUTION 128      //[32 64 128 256 512]

///////////////////////////////////////////////////END OF ADJUSTABLE VARIABLES///////////////////////////////////////////////////

/* DRAWBUFFERS:01235 */

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D normals;
uniform sampler2D specular;
uniform sampler2D noisetex;
uniform float wetness;
uniform vec3 upPosition;
uniform ivec2 atlasSize;		// Pretty sure this is in pixels
uniform int terrainIconSize;	// Same here

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 worldPosition;
varying vec4 vertexPos;
varying mat3 tbnMatrix;
varying vec3 vectorLight;

varying vec3 normal;

varying float materialIDs;

varying float distance;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

const float bump_distance = 78.0;
const float fademult = 0.1;

const float parallaxRes = exp2(8 - log2(float(TEXTURE_PACK_RESOLUTION)));

vec2 OffsetCoord(in vec2 coord, in vec2 offset, in int level) {
	int tileResolution = terrainIconSize;
	vec2 atlasTiles = atlasSize;
	// 64 = 4, 128 = 8
	vec2 atlasResolution = atlasTiles * parallaxRes / terrainIconSize;

	coord *= atlasResolution;

	vec2 offsetCoord = coord + mod(offset.xy * atlasResolution, vec2(tileResolution));

	vec2 minCoord = vec2(coord.x - mod(coord.x, tileResolution), coord.y - mod(coord.y, tileResolution));
	vec2 maxCoord = minCoord + tileResolution;

	if (offsetCoord.x > maxCoord.x) {
		offsetCoord.x -= tileResolution;
	} else if (offsetCoord.x < minCoord.x) {
		offsetCoord.x += tileResolution;
	}

	if (offsetCoord.y > maxCoord.y) {
		offsetCoord.y -= tileResolution;
	} else if (offsetCoord.y < minCoord.y) {
		offsetCoord.y += tileResolution;
	}

	offsetCoord /= atlasResolution;

	return offsetCoord;
}

vec3 Get3DNoise(in vec3 pos) {
	pos.z += 0.0;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
	f = f * f * (3.0 - 2.0 * f);

	vec2 uv =  (p.xy + p.z * vec2(17.0, 37.0)) + f.xy;
	vec2 uv2 = (p.xy + (p.z + 1.0) * vec2(17.0, 37.0)) + f.xy;
	vec2 coord =  (uv  + 0.5) / 64.0;
	vec2 coord2 = (uv2 + 0.5) / 64.0;
	vec3 xy1 = texture2D(noisetex, coord).xyz;
	vec3 xy2 = texture2D(noisetex, coord2).xyz;
	return mix(xy1, xy2, vec3(f.z));
}

float GetModulatedRainSpecular(in vec3 pos) {
	pos.xz *= 1.0;
	pos.y *= 0.2;

	vec3 p = pos;

	float n = Get3DNoise(p).y;
	n += Get3DNoise(p / 2.0).x * 2.0;
	n += Get3DNoise(p / 4.0).x * 4.0;

	n /= 6.0;

	return n;
}

vec4 GetTexture(in sampler2D tex, in vec2 coord) {
	#ifdef PARALLAX
		vec4 t = vec4(0.0);
		if (distance < 10) {
			t = texture2DLod(tex, coord, 0);
		} else {
			t = texture2D(tex, coord);
		}

		return t;

	#else
		return texture2D(tex, coord);
	#endif
}

vec2 CalculateParallaxCoord(in vec2 coord, in vec3 viewVector) {
	vec2 parallaxCoord = coord.st;
	const int maxSteps = 112;
	vec3 stepSize = vec3(0.002, 0.002, 0.2);

	float parallaxDepth = 1.0;

	if(TEXTURE_PACK_RESOLUTION == 512) {
		parallaxDepth = 4.0;
	}

	stepSize.xy *= parallaxDepth;

	float heightmap = texture2D(normals, coord.st).a;

	vec3 pCoord = vec3(0.0, 0.0, 1.0);

	if(heightmap < 1.0 && heightmap != 0.0) {
		vec3 step = viewVector * stepSize;
		float distAngleWeight = ((distance * 0.6) * (2.1 - viewVector.z)) / 32.0;

		step *= distAngleWeight;

		float sampleHeight = heightmap;

		for (int i = 0; sampleHeight < pCoord.z && i < 240; ++i) {
			pCoord.xy = mix(pCoord.xy, pCoord.xy + step.xy, clamp((pCoord.z - sampleHeight) / (stepSize.z * 1.0 * distAngleWeight / (-viewVector.z + 0.05)), 0.0, 1.0));
			pCoord.z += step.z;

			sampleHeight = GetTexture(normals, OffsetCoord(coord.st, pCoord.st, 0)).a;
		}
		parallaxCoord.xy = OffsetCoord(coord.st, pCoord.st, 0);
	}
	return parallaxCoord;
}

void main() {
	vec4 modelView = (gl_ModelViewMatrix * vertexPos);

	vec3 viewVector = normalize(tbnMatrix * modelView.xyz);
	vec3 lightVector = vectorLight;
	lightVector = normalize(tbnMatrix * lightVector);

	if(atlasSize.x != atlasSize.y) {
		viewVector.x /= 2;
	}

	vec2 parallaxCoord = texcoord.st;

	#ifdef PARALLAX
		if (distance < 50.0) {
			parallaxCoord = CalculateParallaxCoord(texcoord.st, viewVector);
		}
	#endif

	vec4 spec = GetTexture(specular, parallaxCoord.st);

	//store lightmap in auxilliary texture. r = torch light. g = lightning. b = sky light.
	vec4 lightmap = vec4(0.0, 0.0, 0.0, 1.0);

	//Separate lightmap types
	lightmap.r = clamp((lmcoord.s * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
	lightmap.b = clamp((lmcoord.t), 0.0, 1.0);

	lightmap.r = pow(lightmap.r, 3.0);

	float wetfactor = clamp(lightmap.b * 1.05 - 0.9, 0.0, 0.1) / 0.1;
	wetfactor *= wetness;
	float wet = GetModulatedRainSpecular(worldPosition.xyz);

	vec4 frag2;

	if (distance < bump_distance) {
		vec3 bump = GetTexture(normals, parallaxCoord.st).rgb * 2.0 - 1.0;

		float bumpmult = clamp(bump_distance * fademult - distance * fademult, 0.0, 1.0) * NORMAL_MAP_MAX_ANGLE;
	  bumpmult *= 1.0 - (clamp(spec.g * 1.0 - 0.0, 0.0, 1.0) * 0.75);

		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0, 0.0, 1.0 - bumpmult);
		frag2 = vec4(bump * tbnMatrix * 0.5 + 0.5, 1.0);

	} else {
		frag2 = vec4((normal) * 0.5 + 0.5, 1.0);
	}

	//Diffuse
	vec4 albedo = texture2D(texture, parallaxCoord.st) * color;
	vec3 upVector = normalize(upPosition);
	float darkFactor = clamp(spec.g, 0.0, 0.2) / 0.2;
	albedo.rgb = pow(albedo.rgb, vec3(mix(1.0, 1.25, darkFactor)));

	//Roughness
	vec4 specularData = texture2DLod(specular, parallaxCoord.st, 0);
	specularData.r *= 0.8;
	specularData.r *= 1 + (wetfactor * 0.7) * (1 - specularData.g) * (wet * wetfactor);
	specularData.r = clamp(specularData.r, 0.0, 0.9);

	float metallicMask = 0.0;

	if (abs(materialIDs - 20.0) < 0.1
	|| abs(materialIDs - 21.0) < 0.1
	|| abs(materialIDs - 22.0) < 0.1
	|| abs(materialIDs - 23.0) < 0.1) {
		metallicMask = 1.0;
	}

	float mats_1 = materialIDs;
	mats_1 += 0.1;

	gl_FragData[0] = albedo;

	//Depth
	gl_FragData[1] = vec4(mats_1/255.0, lightmap.r, lightmap.b, 1.0);

	//normal
	gl_FragData[2] = frag2;

	// red = shininess
	// green = metallic
	// blue = emissive
	// alpha = ao
	gl_FragData[3] = specularData;

	gl_FragData[4] = frag2;
}
