#version 120
#extension GL_ARB_shader_texture_lod : enable

////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////

#define NORMAL_MAP_MAX_ANGLE 0.95   		//The higher the value, the more extreme per-pixel normal mapping (bump mapping) will be.

///////////////////////////////////////////////////END OF ADJUSTABLE VARIABLES///////////////////////////////////////////////////

/* DRAWBUFFERS:01235 */

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D normals;
uniform sampler2D specular;
uniform float wetness;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;

varying float distance;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

const float bump_distance = 78.0;
const float fademult = 0.1;

void main() {

	vec4 spec = texture2D(specular, texcoord.st);

	//store lightmap in auxilliary texture. r = torch light. g = lightning. b = sky light.
	vec4 lightmap = vec4(0.0, 0.0, 0.0, 1.0);

	//Separate lightmap types
	lightmap.r = clamp((lmcoord.s * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
	lightmap.b = clamp((lmcoord.t * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
	lightmap.r = pow(lightmap.r, 3.0);

	float wetfactor = clamp(lightmap.b - 0.9, 0.0, 0.1) / 0.1;

	vec4 frag2;

	if (distance < bump_distance) {
		vec3 bump = texture2D(normals, texcoord.st).rgb * 2.0 - 1.0;

		float bumpmult = clamp(bump_distance * fademult - distance * fademult, 0.0, 1.0) * NORMAL_MAP_MAX_ANGLE;
	  bumpmult *= 1.0 - (spec.r * 0.9 * wetness * wetfactor);

		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0, 0.0, 1.0 - bumpmult);

		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
								  				tangent.y, binormal.y, normal.y,
						     	  			tangent.z, binormal.z, normal.z);

		frag2 = vec4(bump * tbnMatrix * 0.5 + 0.5, 1.0);

	} else {
		frag2 = vec4((normal) * 0.5 + 0.5, 1.0);
	}

	//Diffuse
	vec4 albedo = texture2D(texture, texcoord.st) * color;

	gl_FragData[0] = albedo;


	float mats_1 = 5.0;
	mats_1 += 0.1;

	//Depth
	gl_FragData[1] = vec4(mats_1/255.0, lightmap.r, lightmap.b, 1.0);

	//normal
	gl_FragData[2] = frag2;

	//specularity
	vec4 specularData = texture2DLod(specular, texcoord.st, 0);
	specularData.r *= 0.8;
	specularData.r = clamp(specularData.r, 0.0, 0.9);

	gl_FragData[3] = specularData;

	gl_FragData[4] = frag2;
}
