#version 120

#define VERTEX_SCALING //Much faster on nVidia cards, causes white screen on amd.
#define COMPOSITE3_SCALE vec2(0.25 + pixelSize.x * 2.0, 0.375 + pixelSize.y * 4.0)

uniform float viewWidth;
uniform float viewHeight;

varying vec4 texcoord;

void main() {
	gl_Position = ftransform();

	texcoord = gl_MultiTexCoord0;


	vec2 pixelSize = 1.0 / vec2(viewWidth, viewHeight);

	#ifdef VERTEX_SCALING
		gl_Position.xy = ((gl_Position.xy * 0.5 + 0.5) * COMPOSITE3_SCALE) * 2.0 - 1.0;    // Crop the vertex to only cover the areas that are being used
		texcoord.st *= COMPOSITE3_SCALE;
	#endif
}
