#version 120

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

This work is licensed under the Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-nd/4.0/.

*/

#define BANDING_FIX_FACTOR 1.0

const bool gnormalMipmapEnabled = true;

/* DRAWBUFFERS:0 */

uniform sampler2D gnormal;
uniform sampler2D composite;

uniform float viewWidth;
uniform float viewHeight;

varying vec4 texcoord;


/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
float	GetEmission(in vec2 coord) {
	return texture2D(composite, coord.st).b;
}

float cubesmooth(in float x) {
	return x * x * (3.0 - 2.0 * x);
}

vec3 ComputeBloomTile(int scale, vec2 offset) {    // Computes a single bloom tile, the tile's blur level is inversely proportional to its size
	// Each bloom tile uses (1.0 / scale) per-unit of the screen + (pixelSize * 2.0)

	vec2  pixelSize = 1.0 / vec2(viewWidth, viewHeight);

	vec2 coord  = texcoord.st;
	coord -= offset + pixelSize;    // A pixel is added to the offset to give the bloom tile a padding
	coord *= scale;

	vec2 padding = pixelSize * scale;

	if (coord.s <= -padding.s || coord.s >= 1.0 + padding.s
	 || coord.t <= -padding.t || coord.t >= 1.0 + padding.t)
		return vec3(0.0);



	float range       = 2.0 * scale;    // Sample radius has to be adjusted based on the scale of the bloom tile
	float interval    = 1.0 * scale;
	float maxLength   = length(vec2(range));

	vec3  bloom       = vec3(0.0);
	float totalWeight = 0.0;

	for (float i = -range; i <= range; i += interval) {
		for (float j = -range; j <= range; j += interval) {
			float weight  = 1.0 - length(vec2(i, j)) / maxLength;
			weight *= weight;
			weight  = cubesmooth(weight);    // Apply a faux-gaussian falloff

			vec2 offset = vec2(i, j) * pixelSize;

			bloom += pow(texture2D(gnormal, coord + offset).rgb, vec3(2.2)) * weight;
		//	bloom += (GetEmission(coord + offset) * 2 - 1) * weight;
			totalWeight += weight;
		}
	}

	return bloom / totalWeight;
}

vec2[10] get_poisson_sample() {
	vec2[10] samples = vec2[10](
		vec2(-0.2459187f, -0.1581953f),
		vec2(0.2986978f, -0.3292528f),
		vec2(0.0003356389f, -0.9516421f),
		vec2(-0.3959138f, 0.6139205f),
		vec2(0.1995933f, 0.1803252f),
		vec2(-0.7674255f, 0.1604463f),
		vec2(0.3842987f, 0.7318898f),
		vec2(0.7620342f, 0.3162887f),
		vec2(0.8750712f, -0.328813f),
		vec2(-0.6032044f, -0.7409599f)
		);

	return samples;
}

vec3 ComputeBloom() {
	vec2 pixelSize = 1.0 / vec2(viewWidth, viewHeight);

	vec2[10] samples = get_poisson_sample();

	vec3 bloom  = ComputeBloomTile(4, vec2(0.0, 0.0));

	for(int index = 1; index < samples.length(); index++) {
		bloom += ComputeBloomTile(4, samples[index] * 0.0005);
	}

	bloom /= samples.length();

	return bloom * 1000;
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main() {
	gl_FragData[0] = vec4(pow(ComputeBloom(), vec3(1.0 / 2.2)), 1.0);
}
