#version 120

/////////ADJUSTABLE VARIABLES//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////ADJUSTABLE VARIABLES//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define SKY_DESATURATION 0.0

#define NIGHT_LIGHT 0.3			// [0.00015 0.0015 0.015 0.15 0.3 0.5 0.75 1.0]
// increase for brighter nights 0.00015 is default, best is 0.15 for brighter night

#define Torch_Color_Red 1.0			//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]
#define Torch_Color_Green 0.22			//[0.1 0.2 0.22 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]
#define Torch_Color_Blue 0.00			//[0.00 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.95 1.0 1.1 1.2]

/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////


varying vec4 texcoord;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform float rainStrength;

uniform int worldTime;

varying vec3 lightVector;
varying vec3 upVector;

varying float timeSunrise;
varying float timeNoon;
varying float timeSunset;
varying float timeSunriseSunset;
varying float timeMidnight;
varying float timeSkyDark;
varying float transition_fading;

varying vec3 colorSunlight;
varying vec3 colorSkylight;
varying vec3 colorBouncedSunlight;
varying vec3 colorScatteredSunlight;
varying vec3 colorTorchlight;
varying vec3 colorWaterMurk;
varying vec3 colorWaterBlue;


void main() {
	gl_Position = ftransform();

	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	} else {
		lightVector = normalize(moonPosition);
	}

	upVector = normalize(upPosition);

	float timePow = 2.0;
	float timefract = worldTime;

	timeSunrise = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
	timeNoon = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
	timeSunset = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
	timeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);
	timeSkyDark = ((clamp(timefract, 12000.0, 16000.0) - 12000.0) / 4000.0) - ((clamp(timefract, 22000.0, 24000.0) - 22000.0) / 2000.0);
	timeSkyDark = pow(timeSkyDark, 3.0);

	timeSunrise = pow(timeSunrise, 1.0);
	timeNoon = pow(timeNoon, 1.0/timePow);
	timeSunset = pow(timeSunset, 1.0);
	timeMidnight = pow(timeMidnight, 1.0/timePow);
	timeSunriseSunset = 1.0 - timeNoon;
	timeSunriseSunset *= 1.0 - timeMidnight;

	transition_fading = 1.0-(clamp((timefract-12000.0)/300.0,0.0,1.0)-clamp((timefract-13000.0)/300.0,0.0,1.0) + clamp((timefract-23000.0)/200.0,0.0,1.0)-clamp((timefract-23400.0)/200.0,0.0,1.0));

	const float rayleigh = 0.1;

	colorWaterMurk = vec3(0.2, 1.0, 0.95);
	colorWaterBlue = vec3(0.2, 1.0, 0.95);
	colorWaterBlue = mix(colorWaterBlue, vec3(1.0), vec3(0.5));

	//colors for shadows/sunlight and sky

	vec3 sunrise_sun;
	sunrise_sun.r = 1.00 * timeSunrise;
	sunrise_sun.g = 0.56 * timeSunrise;
	sunrise_sun.b = 0.00 * timeSunrise;
	sunrise_sun *= 0.45;

	vec3 sunrise_amb;
	sunrise_amb.r = 0.85 * timeSunrise;
	sunrise_amb.g = 0.40 * timeSunrise;
	sunrise_amb.b = 0.95 * timeSunrise;
	sunrise_amb = mix(sunrise_amb, vec3(1.0), 0.2);

	vec3 noon_sun;
	noon_sun.r = mix(1.00, 1.00, rayleigh) * timeNoon;
	noon_sun.g = mix(1.00, 0.48, rayleigh) * timeNoon;
	noon_sun.b = mix(1.00, 0.00, rayleigh) * timeNoon;

	vec3 noon_amb;
	noon_amb.r = 0.00 * timeNoon * 1.0;
	noon_amb.g = 0.23 * timeNoon * 1.0;
	noon_amb.b = 0.999 * timeNoon * 1.0;

	vec3 sunset_sun;
	sunset_sun.r = 1.0 * timeSunset;
	sunset_sun.g = 0.48 * timeSunset;
	sunset_sun.b = 0.0 * timeSunset;
	sunset_sun *= 0.55;

	vec3 sunset_amb;
	sunset_amb.r = 0.752 * timeSunset;
	sunset_amb.g = 0.427 * timeSunset;
	sunset_amb.b = 0.700 * timeSunset;

	vec3 midnight_sun;
	midnight_sun.r = 0.45 * timeMidnight;
	midnight_sun.g = 0.6 * timeMidnight;
	midnight_sun.b = 0.8 * timeMidnight;
	midnight_sun *= 0.07;

	vec3 midnight_amb;
	midnight_amb.r = 0.0 * timeMidnight;
	midnight_amb.g = 0.23 * timeMidnight;
	midnight_amb.b = 0.99 * timeMidnight;
	midnight_amb *= 0.04;


	colorSunlight;
	colorSunlight.r = sunrise_sun.r + noon_sun.r + sunset_sun.r + midnight_sun.r;
	colorSunlight.g = sunrise_sun.g + noon_sun.g + sunset_sun.g + midnight_sun.g;
	colorSunlight.b = sunrise_sun.b + noon_sun.b + sunset_sun.b + midnight_sun.b;

	colorSkylight;
	colorSkylight.r = sunrise_amb.r + noon_amb.r + sunset_amb.r + midnight_amb.r;
	colorSkylight.g = sunrise_amb.g + noon_amb.g + sunset_amb.g + midnight_amb.g;
	colorSkylight.b = sunrise_amb.b + noon_amb.b + sunset_amb.b + midnight_amb.b;
	colorSkylight.g *= 0.95;
	colorSkylight = mix(colorSkylight, vec3(dot(colorSkylight, vec3(1.0))), SKY_DESATURATION);

	 float sun_fill = 0.01;

	 colorSkylight = mix(colorSkylight, colorSunlight, sun_fill);
	 vec3 colorSkylight_rain = vec3(2.0, 2.0, 2.38) * 0.35 * (1.0 - timeMidnight * 0.009995); //rain
	 colorSkylight = mix(colorSkylight, colorSkylight_rain, rainStrength); //rain

	//Saturate sunlight colors
	colorSunlight = pow(colorSunlight, vec3(2.0));

	colorBouncedSunlight = mix(colorSunlight, colorSkylight, 0.15);
	colorScatteredSunlight = mix(colorSunlight, colorSkylight, 0.15);


	//Make ambient light darker when not day time
	colorSkylight = mix(colorSkylight, colorSkylight * 0.5, timeSunrise);
	colorSkylight = mix(colorSkylight, colorSkylight * 1.0, timeNoon);
	colorSkylight = mix(colorSkylight, colorSkylight * 1.5, timeSunset);
	colorSkylight = mix(colorSkylight, colorSkylight * 0.0010, timeMidnight);

	//Make sunlight darker when not day time
	colorSunlight = mix(colorSunlight, colorSunlight * 1.0, timeSunrise);
	colorSunlight = mix(colorSunlight, colorSunlight * 1.0, timeNoon);
	colorSunlight = mix(colorSunlight, colorSunlight * 2.0, timeSunset);
	colorSunlight = mix(colorSunlight, colorSunlight * NIGHT_LIGHT, timeMidnight);

	//Make reflected light darker when not day time
	colorBouncedSunlight = mix(colorBouncedSunlight, colorBouncedSunlight * 0.5, timeSunrise);
	colorBouncedSunlight = mix(colorBouncedSunlight, colorBouncedSunlight * 1.0, timeNoon);
	colorBouncedSunlight = mix(colorBouncedSunlight, colorBouncedSunlight * 0.5, timeSunset);
	colorBouncedSunlight = mix(colorBouncedSunlight, colorBouncedSunlight * 0.00015, timeMidnight);

	//Make scattered light darker when not day time
	colorScatteredSunlight = mix(colorScatteredSunlight, colorScatteredSunlight * 0.5, timeSunrise);
	colorScatteredSunlight = mix(colorScatteredSunlight, colorScatteredSunlight * 1.0, timeNoon);
	colorScatteredSunlight = mix(colorScatteredSunlight, colorScatteredSunlight * 0.5, timeSunset);
	colorScatteredSunlight = mix(colorScatteredSunlight, colorScatteredSunlight * 0.00015, timeMidnight);

	float colorSunlightLum = colorSunlight.r + colorSunlight.g + colorSunlight.b;
	colorSunlightLum /= 3.0;

	colorSunlight = mix(colorSunlight, vec3(colorSunlightLum), vec3(rainStrength));

	//Torchlight color
	float torchWhiteBalance = 0.02;
	colorTorchlight = vec3(Torch_Color_Red, Torch_Color_Green, Torch_Color_Blue);
	colorTorchlight = mix(colorTorchlight, vec3(1.0), vec3(torchWhiteBalance));

	colorTorchlight = pow(colorTorchlight, vec3(0.99));
}
