#version 120

#define VERTEX_SCALING //Much faster on nVidia cards, causes white screen on amd.

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelViewInverse;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 previousCameraPosition;

uniform float rainStrength;
uniform float sunAngle;
uniform float far;

uniform int worldTime;

varying vec3 lightVector;

varying vec2 texcoord;

varying float fogEnabled;

const float sunPathRotation = -40.0;


void main() {
	texcoord = gl_MultiTexCoord0.st;
	gl_Position	= ftransform();

	#ifdef VERTEX_SCALING
		gl_Position.xy = ((gl_Position.xy * 0.5 + 0.5) * 0.5) * 2.0 - 1.0;
	#else
		texcoord = texcoord * 2.0;
	#endif

	fogEnabled = float(gl_Fog.start / far < 0.65);

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	} else {
		lightVector = normalize(moonPosition);
	}
}
