#version 120

//disabling is done by adding "//" to the beginning of a line.

//***************************ADJUSTABLE VARIABLES//***************************
//***************************ADJUSTABLE VARIABLES//***************************
//***************************ADJUSTABLE VARIABLES//***************************

//***************************SHADOWS***************************//
	const int 		shadowMapResolution 	= 2048;		//[516 1024 2048 4096]	//shadowmap resolution
	const float 	shadowDistance 				= 120;		//[50 120 180 250] //draw distance of shadows

	#define SHADOW_DARKNESS 2.0 //[0.0 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]	//shadow darkness levels, lower values mean darker shadows, see .vsh for colors

	#define SHADOW_FILTER						//smooth shadows

//***************************LIGHTNING***************************//
	#define DYNAMIC_HANDLIGHT
		#define HANDLIGHT_AMOUNT 1.0

	#define SUNLIGHTAMOUNT 1.25	//[0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]	//change sunlight strength , see .vsh for colors.

	//Torch Color//
	#define TORCH_COLOR 0.8,0.17,0.06		//RGB - Red, Green, Blue
	#define TORCH_COLOR2 0.8,0.17,0.02	//RGB - Red, Green, Blue

	#define TORCH_ATTEN 4.0					//how much the torch light will be attenuated (decrease if you want the torches to cover a bigger area)
	#define TORCH_INTENSITY 0.5

	//Minecraft lightmap (used for sky)
	#define ATTENUATION 4.0
	#define MIN_LIGHT 0.0025

//***************************VISUALS***************************//
	//#define GODRAYS
		const float density = .9;
		const int NUM_SAMPLES = 5;			//increase this for better quality at the cost of performance
		const float grnoise = 1;		//amount of noise

	//#define SSAO
	const int nbdir = 6;	           //qualtiy
	const float sampledir = 6;	      //quality
	const float ssaorad = 0.5;	 //strength

//***************************VOLUMETRIC LIGHT***************************//
	#define VOLUMETRIC_LIGHT
		#define VL_QUALITY 	1.0		  		// Quality of the Volumetric Light. 1.0 is default, 10.0 recommended for quality, 20.0 best quality you can get. But eats a lot of FPS.

//***************************BUILD IN FUNCTIONS***************************//

const float 	wetnessHalflife 		= 70; //[10 20 30 40 50 60 70]	//number of seconds for the wetness to fade out
const float 	drynessHalflife 		= 70;	//[10 20 30 40 50 60 70] //number of seconds for the dryness to fade out

const float 	centerDepthHalflife 	= 4; //[1 2 3 4 5 6 7 8 9 10] //number of seconds for the depth to fade out

const float 	eyeBrightnessHalflife 	= 7; //[1 2 3 4 5 6 7 8 9 10] //number of seconds for being under cover to fade out

const bool 		gcolorMipmapEnabled 	= true; //gcolor texture mipmapping
//const bool 		gdepthMipmapEnabled 	= true;

const bool 		shadowHardwareFiltering = true;

const float		sunPathRotation			= -40; //[1 10 20 30 40 -40 -30 -20 -10]	//rotation of the sun in degrees

const float		ambientOcclusionLevel	= 1; //[0 0.2 0.4 0.6 0.8 1]	//amount of default minecraft Ambient Occlusion


const int 		RA8					= 0;
const int 		RGBA8 				= 0;
const int 		RGBA16 				= 0;
const int 		RGB16 				= 0;
const int 		RGB8 				= 0;

const int 		gcolorFormat 		= RGBA16;
const int 		gaux1Format 		= RGBA16;
const int 		gaux2Format 		= RGB8;
const int 		gnormalFormat 		= RGB16;
const int 		compositeFormat 	= RGBA16;

const int 		noiseTextureResolution  = 1024; //[516 1024 2048 4096]

//***************************END OF BUILD IN FUNCTIONS***************************//

//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//

#define SHADOW_MAP_BIAS 0.85 //[0.6 0.65 0.7 0.75 0.8 0.85] //accuracy of the shadows

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying vec3 moonlight;
varying vec3 sunlight;

varying float handItemLight;
varying float eyeAdapt;

varying float moonVisibility;

uniform sampler2D gcolor;
uniform sampler2D depthtex1;
uniform sampler2D depthtex0;
uniform sampler2D gnormal;
uniform sampler2DShadow shadow;
uniform sampler2D gaux1;
uniform sampler2D gaux3;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;

uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;

uniform ivec2 eyeBrightnessSmooth;

uniform int isEyeInWater;
uniform int worldTime;

float comp = 1.0-near/far/far;			//distance above that are considered as sky

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 25000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);

	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22000.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;


struct shadingStruct
{
	float shadows;
	float ao;
	float Phong;
	float specMap;
	float volumeLight;
	float godRays;
	float handlight;
	float roughness;
	float rainSkyGrad;
	float skyAb;
	float sss;
	float sunLD;
	float sunGlow;

	vec3 torchmap;
	vec3 skyGrad;
	vec3 underwaterFog;
	vec3 eGlow;
	vec3 rainSkyColorAdd;
	vec3 finalShading;

} shading;


struct lightMapStruct
{
	float skyLightMap;
	float shadowLightMap;
	float isWetness;
	float fresnel;

} lightMap;


struct positionStruct
{
	vec4 fragposition;
	vec4 wpos;
	vec4 sworldposition;

	vec3 worldSpace;
	vec3 fragpos;
	vec3 texDepth;

	vec2 lightPos;

	float waterDepth;

} position;


struct vlStruct {

	vec4 fragpos;
	vec4 worldposition;

	vec3 pos;

	vec2 pushback;

	float Quality;
	float steps;
	float ditherPattern;
	float maxDist;
	float minDist;
	float d;
	float distb;
	float distortFactor;
	float VolumetricRays;
	float weight;

} vl;

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}

vec3  	GetNormals(in vec2 coord) {				//Function that retrieves the screen space surface normals. Used for lighting calculations
	return texture2D(gnormal, coord.st).rgb * 2.0f - 1.0f;
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float distx(float dist){
	return (((dist - near) * far) / ((far - near) * dist));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

vec4 aux = texture2D(gaux1, texcoord.st);

vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
float shadowdepth = texture2D(depthtex1,texcoord.xy).x;

vec3 texcoordDepth = vec3(texcoord.st, pixeldepth);

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;


const float speed = 2.5;
float light_jitter = 1.0-sin(frameTimeCounter*1.4*speed+cos(frameTimeCounter*1.9*speed))*0.05;			//little light variations
float torch_lightmap = pow(aux.b*light_jitter,TORCH_ATTEN)*TORCH_INTENSITY;
float torch_lightmap2 = pow(aux.b,TORCH_ATTEN*6)*TORCH_INTENSITY*100;

vec3 torchcolor = vec3(TORCH_COLOR)*eyeAdapt*.1*TORCH_INTENSITY;
vec3 torchcolor2 = vec3(TORCH_COLOR2)*eyeAdapt*.1*TORCH_INTENSITY;

vec3 specular = texture2D(gaux3,texcoord.xy).rgb;

const vec2 offsets[30] = vec2[30](  vec2( 0.0000, 0.2500 ),
         vec2( -0.2165, 0.1250 ),
         vec2( -0.2165, -0.1250 ),
         vec2( -0.0000, -0.2500 ),
         vec2( 0.2165, -0.1250 ),
         vec2( 0.2165, 0.1250 ),
         vec2( 0.0000, 0.5000 ),
         vec2( -0.2500, 0.4330 ),
         vec2( -0.4330, 0.2500 ),
         vec2( -0.5000, 0.0000 ),
         vec2( -0.4330, -0.2500 ),
         vec2( -0.2500, -0.4330 ),
         vec2( -0.0000, -0.5000 ),
         vec2( 0.2500, -0.4330 ),
         vec2( 0.4330, -0.2500 ),
         vec2( 0.5000, -0.0000 ),
         vec2( 0.4330, 0.2500 ),
         vec2( 0.2500, 0.4330 ),
         vec2( 0.0000, 0.7500 ),
         vec2( -0.2565, 0.7048 ),
         vec2( -0.4821, 0.5745 ),
         vec2( -0.6495, 0.3750 ),
         vec2( -0.7386, 0.1302 ),
         vec2( -0.7386, -0.1302 ),
         vec2( -0.6495, -0.3750 ),
         vec2( -0.4821, -0.5745 ),
         vec2( -0.2565, -0.7048 ),
         vec2( -0.0000, -0.7500 ),
         vec2( 0.2565, -0.7048 ),
         vec2( 0.4821, -0.5745 ));


float Blinn_Phong(in positionStruct position, vec3 lvector, vec3 normal, float gloss, in lightMapStruct lightmap, float glossyNess)  {
	vec3 lightDir = vec3(lvector);

	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
		  cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);

	vec3 viewDirection = normalize(position.fragposition.xyz);

	vec3 halfAngle = normalize(lightDir - viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);

	float normalDotEye = dot(normal, normalize(position.fragposition.xyz));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
		  fresnel = fresnel*0.5 + 0.5 * (1.0-fresnel);

	float pi = 3.1415927;
	float n =  pow(glossyNess,gloss*13.0);
	return clamp((pow(blinnTerm, n )*((n+8.0)/(8*pi))) * pow(lightMap.skyLightMap, 50.0), 0.0, 1.0);
}

float diffuseorennayar(vec3 pos, vec3 lvector, vec3 normal, float spec, float roughness) {

    vec3 v = normalize(pos);
	vec3 l = normalize(lvector);
	vec3 n = normalize(normal);

	float vdotn = dot(v,n);
	float ldotn = dot(l,n);
	float cos_theta_r = vdotn;
	float cos_theta_i = ldotn;
	float cos_phi_diff = dot(normalize(v-n*vdotn),normalize(l-n*ldotn));
	float cos_alpha = min(cos_theta_i,cos_theta_r); // alpha=max(theta_i,theta_r);
	float cos_beta = max(cos_theta_i,cos_theta_r); // beta=min(theta_i,theta_r)

	float r2 = roughness*roughness;
	float a = 1.0-0.5*r2/(r2+0.33);
	float b_term;

	if(cos_phi_diff>=0.0) {
		float b = 0.45*r2/(r2+0.09);
		b_term = b*sqrt((1.0-cos_alpha*cos_alpha)*(1.0-cos_beta*cos_beta))/cos_beta*cos_phi_diff;
		b_term = b*sin(cos_alpha)*tan(cos_beta)*cos_phi_diff;
	}
	else b_term = 0.0;

	return clamp(cos_theta_i*(a+b_term),0.0,1.0);
}

float getWaterDepth(inout positionStruct position){

	vec3 uPos = vec3(.0);

	float uDepth = texture2D(depthtex1,texcoord.xy).x;
	uPos = nvec3(gbufferProjectionInverse * vec4(vec3(texcoord.xy,uDepth) * 2.0 - 1.0, 1.0));

	vec3 uVec = position.fragposition.xyz-uPos;
	float UNdotUP = abs(dot(normalize(uVec),normal));
	float depth = length(uVec)*UNdotUP;

	return depth;

}


// dirived from: http://devlog-martinsh.blogspot.nl/2011/03/glsl-8x8-bayer-matrix-dithering.html
float find_closest(vec2 pos, float sample)
{

		float dither[64] = float[64](
		0, 32, 8, 40, 2, 34, 10, 42, /* 8x8 Bayer ordered dithering */
		48, 16, 56, 24, 50, 18, 58, 26, /* pattern. Each input pixel */
		12, 44, 4, 36, 14, 46, 6, 38, /* is scaled to the 0..63 range */
		60, 28, 52, 20, 62, 30, 54, 22, /* before looking in this table */
		3, 35, 11, 43, 1, 33, 9, 41, /* to determine the action. */
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

	vec2 texMod = pos;
	vec2 aspectCorrect = vec2(viewWidth, viewHeight);
	texMod = mod(texMod * aspectCorrect, sqrt(64));
	float limit;

	for (int i = 0; i < (int(texMod.x) + int(texMod.y)*sqrt(64)); i++) {
			limit = (dither[i])/sqrt(64 * 64);
	}
	return limit * sample;
}


float noisepattern(vec2 pos, float sample) {
	float noise = abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

	noise *= sample;
	return noise;
}

vec2 lightpos() {

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);

	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;

	return lightPos;
}


float dynamicExposure()
{
		return mix(1.0,0.0,(pow(eyeBrightnessSmooth.y / 240.0f, 3.0f)));
}

float getSkyLightMap()
{
	return pow(aux.r,ATTENUATION);
}

float getIsWet(lightMapStruct lightmap)
{
	return wetness*pow(lightmap.skyLightMap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));
}

float getShadowLightMap(in lightMapStruct lightmap)
{
	return lightmap.skyLightMap;
}

float getSpecmap(in lightMapStruct lightmap)
{
		return specular.r*(1.0-specular.b)+specular.g*lightmap.isWetness+specular.b*0.85;
}

float getFresnelPow(in lightMapStruct lightmap)
{
	return pow(1.0-(specular.b+specular.g)/2.0,1.25+lightmap.isWetness*0.75)*3.5;
}


#ifdef VOLUMETRIC_LIGHT

float GetVolumetricRays() {

	///////////////////////Setting up functions///////////////////////

		vl.Quality = 4.0 / VL_QUALITY;
		vl.steps = vl.Quality;

		vl.ditherPattern = find_closest(texcoord.st, vl.steps);

		vl.maxDist = (30.0);
		vl.minDist = (0.01);

		vl.minDist += vl.ditherPattern;
		vl.weight = (vl.maxDist / vl.steps);

		vl.pushback = vec2(0.001, -0.001);	// Fixes light leakage from walls

		for (vl.minDist; vl.minDist < vl.maxDist;) {

		///////////////////////MAKING VL NOT GO THROUGH WALLS///////////////////////

			if (getDepth(pixeldepth) < vl.minDist){
				break;
			}

		///////////////////////Getting worldpositon///////////////////////

			vl.d = distx(vl.minDist);
			vl.fragpos = nvec4(convertScreenSpaceToWorldSpace(texcoord.st, vl.d) * 1.0);
			vl.worldposition = vec4(gbufferModelViewInverse * vl.fragpos);

		///////////////////////Converting ScreenSpace to ShadowSpace///////////////////////

			vl.worldposition = (shadowModelView * vl.worldposition);
			vl.worldposition = (shadowProjection * vl.worldposition);

		///////////////////////Rescaling ShadowMaps///////////////////////

			vl.distb = sqrt(vl.worldposition.r*vl.worldposition.r + vl.worldposition.g*vl.worldposition.g);
			vl.distb *= SHADOW_MAP_BIAS;
			vl.distortFactor = 1.0 - SHADOW_MAP_BIAS;
			vl.distortFactor -= vl.distb * - 1.0;

			vl.pos = vl.worldposition.rgb;
			vl.pos.rg /= (sqrt(vl.distortFactor / vl.distortFactor) * (vl.distortFactor));

		///////////////////////Projecting shadowmaps on a linear depth plane///////////////////////

			vl.VolumetricRays += (shadow2D(shadow, vec3(vl.pos.rg, vl.pos.b + vl.pushback.r) * 0.5 + 0.5).z);

			vl.minDist = vl.minDist + vl.steps;
	}

	///////////////////////Returning the program///////////////////////

		vl.VolumetricRays /= vl.weight;
		vl.VolumetricRays *= 0.15;

		return mix(vl.VolumetricRays, clamp(vl.VolumetricRays, 0.0, 0.1), dynamicExposure());
		//return vl.VolumetricRays;
}


#else
float GetVolumetricRays(){

	return 0.0;
}
#endif

vec4 getFpos(){

		vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
			fragposition /= fragposition.w;

		return fragposition;
}

vec4 getWpos(in positionStruct position){

		vec4 worldposition = vec4(0.0);
			worldposition = gbufferModelViewInverse * position.fragposition;

		return worldposition;

}

vec3 getFragpos(in positionStruct position){

	return nvec3(gbufferProjectionInverse * nvec4(position.texDepth * 2.0 - 1.0));
}

vec4 getShadowWorldPos(){

	vec4 sfragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * shadowdepth - 1.0f, 1.0f);
	 	sfragposition /= sfragposition.w;

	vec4 sworldposition = vec4(0.0);
		sworldposition = gbufferModelViewInverse * sfragposition;

		/*--reprojecting into shadow space --*/
				sworldposition = shadowModelView * sworldposition;
				float comparedepth = abs(sworldposition.z);
				sworldposition = shadowProjection * sworldposition;
				sworldposition /= sworldposition.w;
				/*---------------------------------*/

	return sworldposition;

}

float getShadows(float shading, in positionStruct position, in lightMapStruct lightMap, float iswater, float translucent){

			vec4 sworldposition = position.sworldposition;
			float distb = sqrt(dot(sworldposition.xy , sworldposition.xy));
			float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
			sworldposition.xy *= 1.0f / distortFactor;
			sworldposition = sworldposition * 0.5f + 0.5f;

			float step = 3.0/shadowMapResolution/distortFactor*(1.0+rainx*5.0);
			float NdotL = dot(normal, lightVector);

			float diffthresh = (pow(distortFactor*1.2,2.0)*(0.2/148.0)*(tan(acos(abs(NdotL)))) + (0.02/148.0))*(1.0+iswater*2.0);
			diffthresh = mix(diffthresh,0.001,translucent)*(1.+0.1*clamp(tan(acos(abs(NdotL))),0.0,2.));

			if (sworldposition.s < 0.99 && sworldposition.s > 0.01 && sworldposition.t < 0.99 && sworldposition.t > 0.01 ) {

				if (NdotL < 0.0 && translucent < 0.1) {
						shading = 0.0;
					}

				else {

				/*--------------------------------*/
				step = 0.625/shadowMapResolution*(1.0+rainx*5.0);
				#ifdef SHADOW_FILTER

					shading = shadow2D(shadow,vec3(sworldposition.st, sworldposition.z-diffthresh)).x;
					shading += shadow2D(shadow,vec3(sworldposition.st + vec2(0.0,step), sworldposition.z-diffthresh)).x;
					shading += shadow2D(shadow,vec3(sworldposition.st + vec2(step,0.0), sworldposition.z-diffthresh)).x;
					shading += shadow2D(shadow,vec3(sworldposition.st + vec2(0.0,-step), sworldposition.z-diffthresh)).x;
					shading += shadow2D(shadow,vec3(sworldposition.st + vec2(-step,0.0), sworldposition.z-diffthresh)).x;


					shading /= 5.0;
				#endif
				/*--------------------------------*/
				#ifndef SHADOW_FILTER
					shading = shadow2D(shadow,vec3(sworldposition.st, sworldposition.z-diffthresh)).x;
				#endif

				/*--------------------------------*/
				}
			} else shading = 1.0;
			shading *= 1-isEyeInWater;

			if (translucent < 0.9)
			shading *= mix(1.0,NdotL,1.0 - lightMap.skyLightMap);

			return shading;
}

#ifdef SSAO

	float getSSAO(in float ao, float land, float iswater, float hand){

			if (land > 0.9 && iswater < 0.9 && hand < 0.9) {


				vec3 norm = texture2D(gnormal,texcoord.xy).rgb*2.0-1.0;
				vec3 projpos = convertScreenSpaceToWorldSpace(texcoord.xy,pixeldepth);

				float progress = 0.0;
				ao = 0.0;

				float projrad = clamp(distance(convertCameraSpaceToScreenSpace(projpos + vec3(ssaorad,ssaorad,ssaorad)).xy,texcoord.xy),7.5*pw,60.0*pw);

				for (int i = 1; i < nbdir; i++) {
					for (int j = 1; j < sampledir; j++) {
						vec2 samplecoord = vec2(cos(progress),sin(progress))*(j/sampledir)*projrad + texcoord.xy;
						float sample = texture2D(depthtex0,samplecoord).x;
						vec3 sprojpos = convertScreenSpaceToWorldSpace(samplecoord,sample);
						float angle = pow(min(1.0-dot(norm,normalize(sprojpos-projpos)),1.0),2.0);
						float dist = pow(min(abs(ld(sample)-ld(pixeldepth)),0.015)/0.015,2.0);
						float temp = min(dist+angle,1.0);
						ao += pow(temp,3.0);
						//progress += (1.0-temp)/nbdir*3.14;
					}
					progress = i*1.256;
				}

				ao /= (nbdir-1)*(sampledir-1);

				ao = pow(ao, 2.2 * ssaorad);

			}
			return ao;
	}
#else
float getSSAO(in float ao, float land, float iswater, float hand){
	return 1.0;
}

#endif

#ifdef DYNAMIC_HANDLIGHT
float getHandLight(in float hand, in positionStruct position){

	float handlight = handItemLight*0.5*HANDLIGHT_AMOUNT;

	handlight = (handItemLight*10.0*HANDLIGHT_AMOUNT)*hand;
	handlight += (handItemLight*1.0*HANDLIGHT_AMOUNT);

	handlight = (handlight)/pow(length(position.fragposition.xyz),1.0);

	return handlight;

}
#else
float getHandLight(in float hand, in positionStruct position){
	return 0.0;
}
#endif

vec3 getTorchMap(in positionStruct position, in shadingStruct shading){


		float handlightDistance = 13.0f;
		float handlightDistance2 = 5.0f;

	vec3 Torchlight_lightmap = (torch_lightmap+shading.handlight*2.0*pow(max(handlightDistance-length(position.fragposition.xyz),0.0)/handlightDistance,4.0)*max(dot(-position.fragposition.xyz,normal),0.0)) *  torchcolor ;
	Torchlight_lightmap += (torch_lightmap2+shading.handlight*pow(max(handlightDistance2-length(position.fragposition.xyz),0.0)/handlightDistance2,4.0)*max(dot(-position.fragposition.xyz,normal),0.0)) * torchcolor2;

	return Torchlight_lightmap;
}

float getRoughness(in lightMapStruct lightMap, in float iswater){


		float roughness = mix(1.0-(pow(specular.g,2.0))+specular.b+lightMap.isWetness*specular.g*0.5,0.05,iswater);
		if (specular.r+specular.g+specular.b > 1.0/255.0) {
			} else if (iswater > 0.09) {
				} else {
					roughness = 0.0;
				}

		return roughness;
}

float getSkyAbsorbance(in positionStruct position, in float iswater){

		return mix(mix(1.0,exp(-position.waterDepth/4.5),iswater),1.0,isEyeInWater);
}

vec3 getUnderwaterFog(){

	vec3 Ucolor = normalize(vec3(ambient_color));

	return (Ucolor*length(ambient_color)*0.02)*(1-TimeMidnight*.99)*(1-rainx);

}

float getSSS(in positionStruct position, in float translucent){


			float sss_transparency = mix(0,1,translucent);		//subsurface scattering amount

			float sss = 0.0;
			vec3 npos = normalize(position.fragposition.xyz);

			sss += pow(max(dot(npos, lightVector),0.0),50.0)*sss_transparency*translucent*1.0;

			return sss;
}

float getSunlightDirect(in shadingStruct shading, in positionStruct position, in float translucent){

			float sunlight_direct = 1.0;

				sunlight_direct = diffuseorennayar(position.fragposition.xyz, lightVector, normal, shading.specMap, shading.roughness+0.01);
				sunlight_direct = mix(sunlight_direct,0.5*SUNLIGHTAMOUNT,translucent);

		return sunlight_direct;
}

vec3 getEmessiveGlow(in vec3 color, in float emissive){

			color.rgb += (color * ((5.0)) ) * clamp(pow(length(vec3(color.rgb)), 10.0), 0.0, 1.0) * emissive;
			color.rgb -= (vec3(color)/1.5) * (1-clamp(pow(length(vec3(color.rgb)), 10.0), 0.0, 1.0)) * emissive * (1-isEyeInWater);

			return color;
}

float getSunGlow(positionStruct position, bool land){

	float horizon = max(pow(position.wpos.y, 1.0) - texcoord.y,0.0);

	float sunGlow = pow(max(dot(normalize(position.fragpos),sunVec),0.0),5000.0);

	if (!land)
	return sunGlow * max(horizon,0.0);
}

vec3 getRainSkyColorAdd(in shadingStruct shading){

	vec3 color;
	color = mix(color,vec3(0.1,0.1,0.1),0.1*(1-TimeMidnight*0.75)*rainx);

	color = mix(color,color,(shading.rainSkyGrad))*rainx*(1-TimeMidnight*0.5);

	return color;
}


vec3 getSkyGrad(vec3 color, bool land,in positionStruct position) {

		if (!land) {

			float time = float(worldTime);
									float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22000.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));

									//////////////////////////////////////////////////////////////////////////////////////////////////////

									vec4 worldposition = vec4(0.0);
										 worldposition = gbufferModelViewInverse * vec4(position.fragpos,1.0);

									float horizon = max(pow(worldposition.y, 1.0) - texcoord.y,0.0);
									float horizon2 = max(abs(pow(worldposition.y, 1.0) - texcoord.y),0.0);

									//////////////////////////////////////////////////////////////////////////////////////////////////////

									float limit = max(pow(max(1.0 - horizon/600.0, 0.0), 8.0), 0.0)*(1-TimeSunrise*(transition_fading))*(1-TimeSunset*(transition_fading));
									float limit_ss_sr = max(pow(max(1.0 - horizon/500.0, 0.0), 8.0), 0.0)*(1.0-TimeNoon)*(1.0-TimeMidnight);
									float limit_ss_sr2 = max(pow(max(1.0 - horizon/600.0, 0.0), 8.0), 0.0)*(1.0-TimeNoon)*(1.0-TimeMidnight);
									float limit_ss_sr3 = (max(pow(max(1.0 - horizon/300.0, 0.0), 8.0), 0.0));

									float limit_tf = max(pow(max(1.0 - horizon/500.0, 0.0), 8.0), 0.0);
									float limit_tf2 = max(pow(max(1.0 - horizon/650.0, 0.0), 8.0), 0.0);

									float scatterLim = max(pow(max(1.0 - horizon2/400.0, 0.0), 8.0), 0.0);

									float volumetric_cone = pow(max(dot(normalize(position.fragpos),sunVec),0.0),10.0);
									float volumetric_cone2 = pow(max(dot(normalize(position.fragpos),sunVec),0.0),2.0);
									float volumetric_cone3 = pow(max(dot(normalize(position.fragpos),sunVec),0.0),10.0*400.0);
									float volumetric_cone4 = pow(max(dot(normalize(position.fragpos),moonVec),0.0),10.0*1000.0);
									float volumetric_cone5 = pow(max(dot(normalize(position.fragpos),sunVec),0.0),10.0*5.0);
									float volumetric_cone6 = pow(max(dot(normalize(position.fragpos),moonVec),0.0),10.0);


									//Get Positions in sky//
									float upsky = pow(max(dot(normalize(position.fragpos),upVec),0.0),1.5);

									vec3 pos = vec3(1.0);
										pos = mix(pos.rgb, vec3(.5), upsky * (1- (TimeNoon + TimeSunset + TimeSunrise) * 0.25));

									float SkyGradient = max(pow(max(1.0 - horizon/2500.0, 0.01), 8.0), 0.0)*(1.0-limit_ss_sr2);
										SkyGradient = clamp(SkyGradient, 0.05, 1.0);
										SkyGradient = pow(SkyGradient, 0.8);

									//////////////////////////////////////////////////////////////////////////////////////////////////////

									vec3 limitcsssr = vec3(88,10,0)/(120);
										 limitcsssr.r = limitcsssr.r + ((limitcsssr.g + limitcsssr.b)/2.0)*-(0.1);
										 limitcsssr.g = limitcsssr.g + ((limitcsssr.r + limitcsssr.b)/2.0)*-(0.1);
										 limitcsssr.b = limitcsssr.b + ((limitcsssr.r + limitcsssr.g)/2.0)*-(0.1);

									vec3 limitcsssr2 = vec3(5,10,0)/(50);
										limitcsssr2.r = limitcsssr2.r + ((limitcsssr2.g + limitcsssr2.b)/2.0)*-(0.1);
										limitcsssr2.g = limitcsssr2.g + ((limitcsssr2.r + limitcsssr2.b)/2.0)*-(0.1);
										limitcsssr2.b = limitcsssr2.b + ((limitcsssr2.r + limitcsssr2.g)/2.0)*-(0.1);

									vec3 skycolor = vec3(ambient_color+1.2);
										 skycolor.g += (skycolor.g*0.1);
										 skycolor.r -= (skycolor.r*0.15)*(TimeNoon);
										 skycolor.r -= (skycolor.r*0.05)*(1-TimeMidnight);
										 skycolor.rgb *= (vec3(0.8,1.25,1.5) * (1-TimeMidnight));


									vec3 limitcn = vec3(0.8,0.8,1.25)/12;
									vec3 limitcnoon = vec3(80,110,200)/400;

									vec3 sclrtf = vec3(limitcsssr)/5*(1-transition_fading)*limit_tf*volumetric_cone2*(1-limit_ss_sr3);
										 sclrtf += vec3(limitcsssr)/11.5*(1-transition_fading)*limit_tf*(1-limit_ss_sr3);
										 sclrtf += vec3(limitcsssr2)/5*(1-transition_fading)*limit_tf2*(1-limit_tf)*(1-limit_ss_sr3);
										 sclrtf += vec3(limitcsssr)/5*(1-transition_fading)*volumetric_cone*(1-limit_ss_sr3)*(limit);
										 sclrtf += pow(limitcn,vec3(1.5))*(1-limit_tf)*TimeMidnight*(1-transition_fading);

										 sclrtf += color.rgb*0.8*(1-transition_fading);
										 sclrtf -= color.rgb*0.5*(1-limit_ss_sr3)*(1-transition_fading);
										 sclrtf *= 1-rainx;

									vec3 scatter = (sunlight_color + (limitcsssr2 * TimeNoon)) * (volumetric_cone2 * (scatterLim)) * (1.0 - TimeMidnight) * 0.25;

									//////////////////////////////////////////////////////////////////////////////////////////////////////

									//sun
									vec3 sunmoon = vec3(sunlight_color)*clamp(volumetric_cone3*100.0, 0.0, 0.9)*(1.0-rainx)*(1-max(limit_ss_sr3, 0.0));
										 sunmoon += max(sunlight_color, 0.0)*volumetric_cone5*0.005*(1.0-rainx)*(1-max(limit_ss_sr3, 0.0));

									//moon
										 sunmoon += (moonlight*1*clamp(volumetric_cone4*1000*100, 0.0, 35)*(1-max(limit_ss_sr3, 0.0)))*moonVisibility*(1-rainx);

									//glow
										sunmoon += max(vec3(1), 0.0)*volumetric_cone*0.01*(1.0-rainx)*TimeNoon*(1-moonVisibility)*(1-max(limit_ss_sr3, 0.0));
										sunmoon += max(vec3(sunlight_color), 0.0)*volumetric_cone*0.1*(1.0-rainx)*(TimeSunset + TimeSunrise)*(1-moonVisibility)*(1-max(limit_ss_sr3, 0.0));

										sunmoon += max(vec3(moonlight), 0.0)*1.5*volumetric_cone6*moonVisibility*(1.0-rainx)*(1-max(limit_ss_sr3, 0.0));

									//////////////////////////////////////////////////////////////////////////////////////////////////////

									color.rgb *= (skycolor * SkyGradient * (1-(TimeSunset + TimeSunrise) * 0.7));
									color.rgb = mix(color.rgb, skycolor * 0.04*(5*TimeMidnight), limit*(1-(TimeSunset+TimeSunrise)));

									//fake atmospheric scattering/////////////////////////////////////////////////////////////////////////////////

									color.rgb += (limitcnoon)*0.05*(TimeSunrise + TimeSunset)*(limit_ss_sr3);
									color.rgb += (limitcsssr-vec3(-0.3,0.6,-0.6))*0.01*(TimeSunrise + TimeSunset)*(limit_ss_sr3);

									color.rgb += clamp((((sunlight_color * limitcsssr)/1.5*limit_ss_sr*max(1-limit_ss_sr3,0.0)*(1-limit_ss_sr2))*(TimeSunrise + TimeSunset)),0.0,1.0);
									color.rgb += clamp((((limitcsssr2)*limit_ss_sr2*pow(1-limit_ss_sr * 1.0,5.0))*(TimeSunrise + TimeSunset)),0.0,1.0);

									color += scatter;

									color += sclrtf;
									color *= pos;

									//////////////////////////////////////////////////////////////////////////////////////////////////////////////

									color.rgb += ((limitcn*0.2)*limit)*TimeMidnight;
									color.rgb -= ((skycolor*0.2)*limit)*TimeMidnight;
									color.rgb -= ((limitcn*0.12)*limit_ss_sr3)*TimeMidnight;

									color.rgb += (vec3(limitcn)*0.05)*TimeMidnight;

									color.rgb += ((limitcnoon)*limit)*TimeNoon;

									color.rgb -= (color.rgb)*TimeNoon*0.25*(limit_ss_sr3);
									color.rgb += (color.g + limitcnoon * 0.2)*(limit_ss_sr3)*(1-TimeSunrise)*(1-TimeSunset)*(1-TimeNoon)*(1-TimeMidnight)*(transition_fading*(1-TimeSunset));

									color += sunmoon;

									//////////////////////////////////////////////////////////////////////////////////////////////////////////////

									//ToneMapping For Sky//

									color.r = color.r + ((color.g + color.b)/2.0)*-(0.2)*(1-(TimeSunrise+TimeSunset)*0.5)*transition_fading;
									color.g = color.g + ((color.r + color.b)/2.0)*-(0.2)*(1-(TimeSunrise+TimeSunset)*0.5)*transition_fading;
									color.b = color.b + ((color.r + color.g)/2.0)*-(0.2)*(1-(TimeSunrise+TimeSunset)*0.5)*transition_fading;

									color.g -= color.g*0.5*TimeNoon;
									color.rgb -= color.rgb*0.75*TimeMidnight;

									color *= mix(mix(1.5,1.0,TimeMidnight),0.5,1.0 - transition_fading);

									//End of Tone For Sky//

					}

		return color.rgb;

}

#ifdef GODRAYS
float getGodrays(in positionStruct position) {

	float gr;

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);

		vec2 deltaTextCoord = vec2( texcoord.st - position.lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;

			float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-position.lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-position.lightPos.y);

			float noise = noisepattern(textCoord,1.0);

			for(int i= 0; i < NUM_SAMPLES ; i++) {
				textCoord -= deltaTextCoord;
				float sample = step(texture2D(gaux1, textCoord+ deltaTextCoord*noise*grnoise).r,0.0);
				gr += sample;
		}
		gr /= NUM_SAMPLES;

	return gr;
}

#else
float getGodrays(in positionStruct position) {

	return 0.0;
}
#endif


float getRainSky(in positionStruct position){

	float wpos = max(position.wpos.y - texcoord.y , 1.0);
	float horizon = (max(pow(max(1.0 - wpos/700.0, 0.01), 8.0), 0.0));

	return horizon;
}


vec3 getFinalShading(in positionStruct position, in shadingStruct shading, in lightMapStruct lightMap){

			float NdotL = dot(lightVector,normal);
			float NdotUp = dot(normal,upVec);

			float dist = length(position.fragposition.xyz);

			float distof = clamp(1.0-dist/(shadowDistance *0.75),0.0,1.0);

			float shadow_fade = clamp(distof*12.0,0.0,1.0);
			float visibility = lightMap.skyLightMap;

		//Apply different lightmaps to image

		vec3 light_col =  mix(pow(sunlight,vec3(2.2)),moonlight,moonVisibility)*(1-rainx);

			vec3 Sunlight_lightmap = (sunlight_color)*mix(pow(visibility,1.5),shading.shadows,shadow_fade)*(1-isEyeInWater)*SUNLIGHTAMOUNT*(1.0-rainx) *shading.sunLD*transition_fading;

			float givisibility = pow(visibility, 3.0);

			float bouncefactor = sqrt((NdotUp*0.4+0.61) * pow(1.01-NdotL*NdotL,2.0)+0.5)*0.66;
			float cfBounce = (-NdotL*0.45+0.56);

			vec3 bounceSunlight = 3.2*cfBounce*(light_col)*visibility*visibility*visibility*SHADOW_DARKNESS*transition_fading;
			vec3 bounceFakeGi;
				//bounceFakeGi = sunlight_color * givisibility;
				//bounceFakeGi = bounceFakeGi * (1-rainx) * (1+TimeMidnight*10) * shadow_fade * transition_fading * SHADOW_DARKNESS;
				//bounceFakeGi = mix(vec3(0), vec3(bounceFakeGi),1.0);

			vec3 sky_light = SHADOW_DARKNESS*pow(ambient_color*(1-TimeMidnight*0.75)*(1+3*(1-TimeMidnight)),vec3(1.0))*(1-rainx*0.8)*shading.ao*visibility*bouncefactor;

			//Add all light elements together
			return (((mix(bounceSunlight, bounceFakeGi,0.0)+(sky_light + MIN_LIGHT)) * (0.1) + shading.torchmap) + Sunlight_lightmap +  shading.sss * Sunlight_lightmap * 0.5 * shading.shadows) * shading.ao * shading.skyAb;
			//return bounceFakeGi;
}


///////////////////////////////VOID MAIN///////////////////////////////
///////////////////////////////VOID MAIN///////////////////////////////
///////////////////////////////VOID MAIN///////////////////////////////

void main() {

	float land 								= float(aux.g > 0.04);
	bool land2 								= texture2D(depthtex0, texcoord.st).r < comp;

	float iswater 						= float(aux.g > 0.04 && aux.g < 0.07);
	float translucent 				= float(aux.g > 0.3 && aux.g < 0.5);
	float hand 								= float(aux.g > 0.75 && aux.g < 0.85);

	float emissive 						= float(aux.a > 0.58 && aux.a < 0.62);

	vec3 color 								= texture2D(gcolor, texcoord.st).rgb;
	if (land < 0.9)	color 		= color * (1-TimeMidnight);

	color 										= pow(color,vec3(2.2));

	//*ADD POSITIONS--------------------------------------------------------------*//

	position.fragposition 		= getFpos();
	position.wpos 						= getWpos(position);
	position.sworldposition 	= getShadowWorldPos();
	position.texDepth 				= texcoordDepth;
	position.fragpos 					= getFragpos(position);
	position.waterDepth 			= getWaterDepth(position);
	position.lightPos 				= lightpos();

	//*ADD LIGHTMAPS--------------------------------------------------------------*//

	lightMap.skyLightMap 			= getSkyLightMap();
	lightMap.shadowLightMap 	= getShadowLightMap(lightMap);
	lightMap.isWetness 				= getIsWet(lightMap);
	lightMap.fresnel 					= getFresnelPow(lightMap);

	//*ADD SHADINGS--------------------------------------------------------------*//

	shading.shadows 					= getShadows(1.0, position, lightMap, iswater, translucent);
	shading.ao 								= getSSAO(1.0, land, iswater, hand);
	shading.Phong 						= Blinn_Phong(position, lightVector, normal, 1.0, lightMap, 1.9) * (1.0-TimeMidnight * 0.75) * (1.0-rainx);
	shading.Phong 						+= Blinn_Phong(position, lightVector, normal, 1.0, lightMap, 1.2) * 25 * (1.0 - TimeMidnight * 0.5) * (1.0-rainx);
	shading.specMap 					= getSpecmap(lightMap);
	shading.volumeLight 			= GetVolumetricRays();
	shading.godRays 					= getGodrays(position);
	shading.handlight 				= getHandLight(hand, position);
	shading.torchmap 					= getTorchMap(position,shading);
	shading.skyGrad 					= getSkyGrad(color.rgb, land2, position);
	shading.roughness 				= getRoughness(lightMap, iswater);
	shading.rainSkyGrad 			= getRainSky(position);
	shading.rainSkyColorAdd 	= getRainSkyColorAdd(shading);
	shading.skyAb 						= getSkyAbsorbance(position, iswater);
	shading.underwaterFog 		= getUnderwaterFog();
	shading.sss 							= getSSS(position, translucent);
	shading.sunLD 						= getSunlightDirect(shading, position, translucent);
	shading.eGlow 						= getEmessiveGlow(color, emissive);
	shading.sunGlow						= getSunGlow(position, land2);
	shading.finalShading 			= getFinalShading(position, shading, lightMap);

	//*SHADINGS--------------------------------------------------------------*//

	float spec 								= shading.Phong;
	float rainSky 						= shading.rainSkyGrad;
	float sky_absorbance 			= shading.skyAb;
	float volumetricRays 			= shading.volumeLight;
	float gr 									= shading.godRays;
	float sunGlow							= shading.sunGlow;

	vec3 skyGradient 					= shading.skyGrad;
	vec3 underwaterFog 				= shading.underwaterFog;
	vec3 emissive_glow 				= shading.eGlow;
	vec3 rainskyColor	 				= shading.rainSkyColorAdd;
	vec3 finalShading 				= shading.finalShading;

	//*POSITIONS--------------------------------------------------------------*//

	float depth 							= position.waterDepth;

	//*FINALIZING COMPOSITE SHADER--------------------------------------------------------------*//

	color 										= skyGradient;

														if (land > 0.9) {
	color 										= emissive_glow;
	color 										= color * finalShading;
	color 										= color * sky_absorbance;
	color 										= mix(underwaterFog,color,exp(-depth/8 * iswater));
														}
												else if (aux.g < 0.02)
	color 										= mix(color,rainskyColor,rainx);

	color 										= pow(color,vec3(.5));
	color 										= clamp(color,0.001,1.0);

	//*PUTTING TO TEXTURES--------------------------------------------------------------*//

/* DRAWBUFFERS:30 */

	gl_FragData[0] 						= vec4(color, spec);
	gl_FragData[1] 						= vec4(gr,volumetricRays,sunGlow,1.0f);
}
