#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/


#define	windyTerrain
#define useDynamicTonemapping
//#define shakingCamera
//#define enableDynamicWeather
float weatherRatioSpeed		= 0.01;

varying vec4 color;
varying vec3 normal;
varying vec2 texcoord;
varying float ambientNdotL;
varying float sunlightMat;
varying float weatherRatio;
varying float skyLightmap;
varying float torchLightmap;
varying float emissiveLight;

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform vec3 upPosition;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform int worldTime;
uniform float frameTimeCounter;
uniform float rainStrength;
uniform int heldBlockLightValue;

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0);
float TimeMidnight		= ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0) 
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));

float dynamicWeather(float speed) {
	
	float value = 1.0;
		  value *= abs(sin(frameTimeCounter * speed * 1.2));
		  value *= abs(cos(frameTimeCounter * speed * 0.5));
		  value *= abs(sin(frameTimeCounter * speed * 2.0));
	
	// Raining.
	value = mix(value, 1.0, rainStrength);
		  
	return value;
	
}

float dynamicTonemapping(float exposureStrength, bool reserveLightmap, bool addExposure, bool dayOnly) {

	float dTonemap = 1.0;

	#ifdef useDynamicTonemapping
	
		float dTlightmap	= pow(eyeBrightnessSmooth.y / 240.0, 2.0);		if (reserveLightmap)	dTlightmap 	= 1.0 - dTlightmap;
			  dTonemap		= dTlightmap * exposureStrength;				if (addExposure)		dTonemap	= 1.0 + dTonemap;		if (dayOnly)	dTonemap = mix(dTonemap, 1.0, TimeMidnight);	// Full exposure on midnight.

	#endif
	
	return dTonemap;

}

float getSkyLightmap(vec2 coord) {

	float minLight = 0.05;

	return clamp(minLight + max(coord.t - 2.0 / 16.0, 0.0) * 1.14285714286, 0.0, 1.0);

}

float getTorchLightmap(vec2 coord, float skyL) {

	float torchlightDistance = 0.6;	// Higher means lower.
	float torchlightExposure = 4.0;
	
	torchlightDistance = mix(torchlightDistance, torchlightDistance * 2.0, skyL * TimeDay);
	torchlightExposure = mix(torchlightExposure, torchlightExposure / 2.0, skyL * TimeDay);

	float modlmap = 16.0 - coord.s * 15.7; 

	return clamp(pow(0.75 / (modlmap * modlmap) - 0.00315, torchlightDistance) * torchlightExposure, 0.0, 1.0);

}

vec3 calcMove(vec3 pos, float mcID, bool isWeldedToGround, float strength, float posRes) {

	#ifdef windyTerrain

		float onGround 	= 0.0;
		if (gl_MultiTexCoord0.t < mc_midTexCoord.t) onGround = 1.0;
		
		float speed = 4.0;
		
		float movementX = sin(frameTimeCounter * speed + pos.z * posRes + cameraPosition.z * posRes);
		float movementY = sin(frameTimeCounter * speed + pos.z * posRes + cameraPosition.z * posRes);
		float movementZ = sin(frameTimeCounter * speed + pos.x * posRes + cameraPosition.x * posRes);
		
		float windfallX = sin(frameTimeCounter * speed * 2.0 + pos.z * posRes + cameraPosition.z * posRes) * 2.0 * (1.0 - sin(frameTimeCounter * 0.6));
		float windfallZ = sin(frameTimeCounter * speed * 2.0 + pos.x * posRes + cameraPosition.x * posRes) * 2.0 * (1.0 - sin(frameTimeCounter * 0.6));
		
		if (isWeldedToGround) {
		
			if (mc_Entity.x == mcID && onGround > 0.9) {
			
				pos.x += (movementX + windfallX) * strength;
				pos.z += movementZ * strength;
				
			}
		
		} else {
		
			if (mc_Entity.x == mcID) {
			
				pos.x += (movementX + windfallX) * strength;
				pos.y += movementY * strength;
				pos.z += (movementZ + windfallZ) * strength;
			
			}
		
		}
	
	#endif
	
	return pos;

}

void main() {
	
	vec4 position		= gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	vec2 lmcoord		= (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	vec3 sunVec			= normalize(sunPosition);
	vec3 upVec			= normalize(upPosition);
	
	normal				= normalize(gl_NormalMatrix * gl_Normal);
	texcoord			= (gl_MultiTexCoord0).xy;
	
	bool istopv			= gl_MultiTexCoord0.t < mc_midTexCoord.t;
	bool translucent	= false;
	emissiveLight		= 0.0;
	
	// Which entities should be translucent.
	if (mc_Entity.x == 6.0 ||	// Saplings.
		mc_Entity.x == 18.0 ||	// Oak leaves.
		mc_Entity.x == 31.0 ||	// Grass.
		mc_Entity.x == 37.0 ||	// Yellow flower.
		mc_Entity.x == 38.0 ||	// Red flower and others.
		mc_Entity.x == 59.0 ||	// Wheat Crops.
		mc_Entity.x == 106.0 ||	// Vines.
		mc_Entity.x == 141.0 ||	// Carrots.
		mc_Entity.x == 142.0 ||	// Potatoes.
		mc_Entity.x == 161.0 ||	// Acacia leaves.
		mc_Entity.x == 175.0	// Large grass, flowers, etc.
		) translucent = true;
		
	color = gl_Color;
	
	if (mc_Entity.x == 89.0 ||	// Glowstone
		mc_Entity.x == 50.0 ||	// Torch
		mc_Entity.x == 51.0 ||	// Fire
		mc_Entity.x == 76.0 ||	// Redstone torch (on)
		mc_Entity.x == 91.0 ||	// Jack o'Lantern
		mc_Entity.x == 124.0 ||	// Redstone Lamp
		mc_Entity.x == 138.0 ||	// Beacon
		mc_Entity.x == 169.0 ||	// Sea Latern
		mc_Entity.x == 10.0 ||	// Lava
		mc_Entity.x == 11.0		// Lava
		) emissiveLight = 1.0;
	
	// Windy terrain.
	position.xyz = calcMove(position.xyz, 6.0, false, 0.01, 5.0);		// Saplings.
	position.xyz = calcMove(position.xyz, 18.0, false, 0.005, 10.0);		// Oak leaves.
	position.xyz = calcMove(position.xyz, 31.0, true, 0.03, 5.0);		// Grass.
	position.xyz = calcMove(position.xyz, 37.0, true, 0.01, 5.0);		// Yellow flower.
	position.xyz = calcMove(position.xyz, 38.0, true, 0.01, 5.0);		// Red flower and others.
	position.xyz = calcMove(position.xyz, 59.0, true, 0.02, 5.0);		// Wheat Crops.
	position.xyz = calcMove(position.xyz, 141.0, true, 0.01, 5.0);		// Carrots.
	position.xyz = calcMove(position.xyz, 142.0, true, 0.01, 5.0);		// Potatoes.
	position.xyz = calcMove(position.xyz, 161.0, false, 0.005, 10.0);	// Acacia leaves.
	
	#ifdef shakingCamera
		position.xy += vec2(0.01 * sin(frameTimeCounter * 2.0), 0.01 * cos(frameTimeCounter * 3.0));
	#endif
	
	gl_Position = gl_ProjectionMatrix * gbufferModelView * position;

	float NdotL = dot(normal, normalize(sunPosition));
		
	if (translucent){
		ambientNdotL	= abs(dot(sunVec, upVec)) * 0.15 + NdotL * 0.15 + 0.7;
		sunlightMat		= 1.0;
	} else {
		ambientNdotL	= (worldTime > 12700 && worldTime < 23250)? -NdotL : NdotL;
		sunlightMat		= 0.0;
	}

	ambientNdotL = max(ambientNdotL, 0.0);
	
	#ifdef enableDynamicWeather
		weatherRatio = dynamicWeather(weatherRatioSpeed);
	#else
		weatherRatio = rainStrength;
	#endif
	
	skyLightmap		= getSkyLightmap(lmcoord);
	torchLightmap	= getTorchLightmap(lmcoord, skyLightmap);
	
}