#version 120

#define SKY_BRIGHTNESS 1.0 

/* DRAWBUFFERS:0124 */
varying vec4 color;
varying vec4 texcoord;
varying vec3 normal;

uniform sampler2D gcolor;

const int FOGMODE_LINEAR = 9729;
const int FOGMODE_EXP = 2048;

uniform int fogMode;
uniform int worldTime;

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);
	
	float SkyExpNoon = 0.8 * TimeNoon;
	float SkyExpSunrise = 0.9 * TimeSunrise;
	float SkyExpSunset = 0.9 * TimeSunset;
	float SkyExpMidnight = 2.0 * TimeMidnight;
	
	vec3 SkyExpNoonvec = vec3(35, 84, 179)/179*TimeSunrise;
	
	float SkyExp = SkyExpNoon + SkyExpSunrise + SkyExpSunset + SkyExpMidnight;

void main() {

	gl_FragData[0] = color*SkyExp;
	gl_FragDepth = 1.0;
	gl_FragData[2] = vec4(0.0, 0.0, 5.0, 1.0);
	gl_FragData[3] = vec4(0.0, 0.0, 5.0, 1.0);

	float fogFactor;
	if (fogMode == FOGMODE_EXP) {
		fogFactor = clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0);
	} else if (fogMode == FOGMODE_LINEAR) {
		fogFactor = 1.0 - clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
	} else {
		fogFactor = 1.0;
	}
		
	gl_FragData[1] = vec4(1.0,1.0,1.0, /*fogFactor*/1.0);
	gl_FragData[0] = mix(gl_FragData[0],gl_Fog.color*SkyExp,1.0-fogFactor);
}