#version 120

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

	//Torch Color//
	vec3 torchcolor = vec3(2.0,3.0,1.0);		//RGB - Red, Green, Blue /
	#define TORCH_ATTEN 4.0						//how much the torch light will be attenuated (decrease if you want that the torches cover a bigger area))
	#define TORCH_INTENSITY 3.0					//torch light intensity

#define GODRAYS
	const float exposure = 0.5;
	const float density = 1.0;
	const int NUM_SAMPLES = 8;			//increase this for better quality at the cost of performance
	const float grnoise = 0.0;		//amount of noise /0.0 is default
#define	GODARYS_SIZE 1.0			//higher values = smaller

#define WATER_REFLECTIONS
	#define REFLECTION_STRENGTH 1.8

#define RAIN_REFLECTION

#define MOTIONBLUR
	#define MOTIONBLUR_AMOUNT 0.005

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const bool gdepthMipmapEnabled = true;



//don't touch these lines if you don't know what you do!
const int maxf = 5;				//number of refinements
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.12;			//refinement multiplier
const float inc = 1.6;			//increasement factor at each step

const int Gmaxf = 4;				//number of refinements
const float Gstp = 1.0;			//size of one step for raytracing algorithm
const float Gref = 0.1;			//refinement multiplier
const float Ginc = 2.4;			//increasement factor at each step


varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform sampler2D composite;
uniform sampler2D gaux4;
uniform sampler2D gaux1;
uniform sampler2D gaux3;
uniform sampler2D gaux2;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D gnormal;
uniform sampler2D gdepth;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;
uniform vec3 previousCameraPosition;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int isEyeInLava;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
float timefract = worldTime;
uniform int fogMode;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float transition_fading = 1.0-(clamp((timefract-12000.0)/300.0,0.0,1.0)-clamp((timefract-13000.0)/300.0,0.0,1.0) + clamp((timefract-22800.0)/200.0,0.0,1.0)-clamp((timefract-23400.0)/200.0,0.0,1.0));


float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

	float matflag = texture2D(gaux1,texcoord.xy).g;


	vec3 fogclr = mix(gl_Fog.color.rgb,vec3(0.2,0.2,0.2),rainStrength)*ambient_color;
	vec3 fogclr2 = fogclr;
	vec3 fogclr3 = fogclr;
	vec3 fogclr4 = fogclr;

    vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
    vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

	float sky_lightmap = texture2D(gaux1,texcoord.xy).r;

	float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));

	vec3 specular = texture2D(gaux3,texcoord.xy).rgb;
	float specmap = specular.r*(1.4-specular.b*1.4)+specular.g*iswet+specular.b*0.85;
    vec4 color = texture2D(composite,texcoord.xy);

	const float speed = 1.5;
	float light_jitter = 1.0-sin(frameTimeCounter*1.4*speed+cos(frameTimeCounter*1.9*speed))*0.025;			//little light variations
	float torch_lightmap = pow(texture2D(gaux1,texcoord.xy).b*light_jitter,TORCH_ATTEN)*TORCH_INTENSITY;


float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.x-0.5),abs(coord.y-0.5))*2.0;
}

float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}

vec4 raytrace(vec3 fragpos, vec3 normal) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < pow(length(vector)*1.85,1.15)){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 5.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;


}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

vec4 raytraceGround(vec3 fragpos, vec3 normal) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = Gstp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
		if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < length(vector)){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=Gref;


}
        vector *= Ginc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

}

float dynamicExposure() {
		return clamp((-eyeBrightnessSmooth.y+230)/100.0,0.0,1.0);
}

vec3 getFog(in vec3 color, in float land, in vec2 pos, in float hand, in float iswater){

	vec3 fragposFog = vec3(pos.st, texture2D(depthtex0, pos.st).r);
	fragposFog = nvec3(gbufferProjectionInverse * nvec4(fragposFog * 2.0 - 1.0));

	vec4 worldposition = vec4(0.0);
		 worldposition = gbufferModelViewInverse * vec4(fragposFog,1.0);
	float horizon = (worldposition.y - (pos.y-cameraPosition.y));

	float calcHeight = (max(pow(max(1.5 - horizon/100.0, 0.0), 1.0)-0.0, 0.0));

	float volumetric_cone = pow(max(dot(normalize(fragposFog),lightVector),0.0),2.5)*transition_fading;
	float volumetric_cone2 = pow(max(dot(normalize(fragposFog),lightVector),0.0),10.0*400.0);
	float volumetric_cone3 = pow(max(dot(normalize(fragposFog),lightVector),0.0),10.0*1000.0)*transition_fading;
	float norain = 1.0-rainx;

	if (isEyeInWater > .9) {
	} else {

		float fog = exp(-pow(sqrt(dot(fragposFog,fragposFog))/far*0.6*(1- dynamicExposure())*(1-(TimeSunrise+TimeSunset)*0.4) ,2.0));
		float fog2 = exp(-pow(sqrt(dot(fragposFog,fragposFog))/90*(1-dynamicExposure()*.8) ,2.0));
		float fog3 = exp(-pow(sqrt(dot(fragposFog,fragposFog))/140 ,2.0));
		float fog4 = exp(-pow(sqrt(dot(fragposFog,fragposFog))/40 ,2.0));
		float fogfactor =  clamp(fog + hand,0.0,1.0);
		float fogfactor2 =  clamp(fog2 + hand,0.0,1.0);
		float fogfactor3 =  clamp(fog3 + hand,0.0,1.0);
		float fogfactor4 =  clamp(fog4 + hand,0.0,1.0)*rainx;

		vec3 rainfogclr = vec3(0.1,0.095,0.1)*rainx*mix(1-TimeMidnight,1.0,(1-transition_fading) * pow(TimeSunrise + TimeSunset, 0.5));

		fogclr2 = rainfogclr*8.0*rainx;
		fogclr2 += mix(color.rgb,ambient_color*0.5,1.0)*rainx*(TimeMidnight + (1-transition_fading));
		fogclr2 = clamp(fogclr2,0.0,1.0*0.2);
		fogclr = mix(color.rgb,ambient_color * 2.0,0.6 + clamp((20000*TimeMidnight), 0.0, 0.25))*(1.0-rainx)*(1.0-TimeMidnight*0.895);
		fogclr = clamp(mix(fogclr, ambient_color, (1-TimeMidnight)*(1+TimeSunrise*.25)*(1+TimeNoon*.5)),0.0,1.0);
		fogclr.g -= fogclr.g*0.15;
		fogclr.rb -= fogclr.rb*0.1*(TimeSunrise+TimeSunset);

		//glow

		fogclr += pow(sunlight,vec3(2.2)) * volumetric_cone*transition_fading*(1.0-TimeMidnight)*(1.0-TimeNoon)*(1.0-rainx*0.4)*2.5;
		fogclr += fogclr * 0.05 * volumetric_cone*2*transition_fading*TimeMidnight*(1.0-rainx)*1.0;

		fogclr = mix(fogclr,sunlight,volumetric_cone*0.5*(1.0-TimeMidnight)*(1.0-TimeSunrise)*(1.0-TimeSunset)*(1.0-rainx)*1.0);

		if (land > 0.9) {
		} else {
			color.rgb = mix(color.rgb,fogclr,(1-fogfactor)*(1-clamp(calcHeight,0.0,1.0))*.5*(1- dynamicExposure()));
			color.rgb = mix(color.rgb,fogclr2,(1-fogfactor2)*rainx*(1-TimeMidnight));
		}

		if (land < 0.9) {
			} else {
				color.rgb += vec3(rainfogclr*rainx)*(1.0*rainx)*(1.0-TimeMidnight);
			}

		color.rgb = mix(color.rgb,fogclr2 * 1.2,min((1-fogfactor2)*rainx*(1- TimeMidnight) * 2.0,1.0));
		color.rgb = mix(color.rgb,fogclr2 / 2.0,(1-fogfactor2)*rainx*(TimeMidnight));

		//altitude fog
		if (land > 0.9) {
			} else {
				color.rgb = mix(color.rgb,fogclr.rgb*(1- rainx),clamp((1-fogfactor)*2.0*(1-rainx)*(1-TimeMidnight)*(clamp((calcHeight), 0.0, 1.0)),0.0,1.0));

				calcHeight = (max(pow(max(0.76 - horizon/300.0, 0.0), 8.0)-0.0, 0.0));
				color.rgb  = mix(color.rgb,clamp(fogclr * 1.5, 0.0, 1.0),clamp(3.0*(clamp((calcHeight) * 100, 0.0, 1.0))*(TimeMidnight)*(1- rainx)*(1-TimeSunrise)*(transition_fading)*(1-fogfactor3),0.0,1.0));
			}

			float volumetric_cone = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5)*transition_fading;
			float volumetric_cone2 = pow(max(dot(normalize(fragpos),lightVector),0.0),4000.0)*transition_fading;
			float volumetric_cone3 = pow(max(dot(normalize(fragpos),lightVector),0.0),10.0*25.0)*transition_fading;
			float volumetric_cone4 = pow(max(dot(normalize(fragpos),lightVector),0.0),100.0*5.0)*transition_fading;

			//sun
			if (land > 0.9) {
			color += volumetric_cone2*100.0*(1.0-TimeMidnight)*(1.0-rainStrength)*(1.0-iswater*0.37);
			color += sunlight*volumetric_cone4*(0.5)*(1.0-TimeMidnight)*(1.0-rainStrength)*(1.0-iswater*0.37);

			//moon
			color += (moonlight*1+ambient_color*0.1+1*volumetric_cone3*0.3*(1.0-rainStrength)*(1.0-iswater*0.8))*TimeMidnight;
			}

	}
	return color;
}

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	int land = int(matflag < 0.03);
	int iswater = int(matflag > 0.04 && matflag < 0.07);
	int hand  = int(matflag > 0.75 && matflag < 0.85);

	vec3 moonlight = vec3(0.8,0.8,1.25) * 0.012;


#ifdef MOTIONBLUR

	vec4 depth  = texture2D(depthtex2, texcoord.st);

	vec4 currentPosition = vec4(texcoord.x * 2.0 - 1.0, texcoord.y * 2.0 - 1.0, 2.0 * depth.x - 1.0, 1.0);

	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;


	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;


	vec2 velocity = (currentPosition - previousPosition).st * MOTIONBLUR_AMOUNT;

	int samples = 1;

	vec2 coord = texcoord.st + velocity;
	for (int i = 0; i < 8; ++i, coord += velocity) {
		if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0) {
			break;
		}
            color += texture2D(composite, coord),color.rgb, iswater;
			++samples;
	}

	color = (color/1.0)/samples;

#endif

	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));

	float fresnel_pow = mix(pow(1.0-(specular.b+specular.g)/2.0,1.25+iswet*0.75)*3.5,3.0,iswater);
		float normalDotEye = dot(normal, normalize(fragpos));
		float fresnel = clamp(pow(1.0 + normalDotEye, fresnel_pow),0.0,1.0);
		vec4 reflection;
	if (iswater > 0.9) {
	#ifdef WATER_REFLECTIONS
		reflection = raytrace(fragpos, normal);
		reflection.rgb = mix(gl_Fog.color.rgb / 2.0, reflection.rgb, reflection.a);			//fake sky reflection, avoid empty spaces
		reflection.a = min(reflection.a + 1.0*sky_lightmap,0.2);
		color.rgb += reflection.rgb * mix(vec3(1.0/sqrt(3.0)),normalize(color.rgb),specular.rgb*0.5+0.05) *  (specmap+iswater)*fresnel*(1.5-isEyeInWater*-2.0) * 2.0 * REFLECTION_STRENGTH*reflection.a;
		color.rgb += color.a*(pow(sunlight,vec3(1.0/5.0)*(1.0-TimeMidnight)) + pow(moonlight,vec3(1.0*50.0)))*(1.0-rainStrength)*4.7;

    }

	#ifdef RAIN_REFLECTION
	if (iswater < 0.9) {
	reflection = raytrace(fragpos, normal);
	color.rgb += (reflection.rgb*fresnel*0.4*reflection.a)*iswet;
	}
	#endif

	 if (specmap > 0.9) {
  color.rgb += reflection.rgb * mix(vec3(1.0/sqrt(3.0)),normalize(color.rgb),specular.b*1+0.05) * (specmap+iswater)*fresnel*(1.5-isEyeInWater*-2.0) *reflection.a;
  }
	#endif

	vec3 colmult = mix(vec3(1.0),vec3(0.08,0.237,0.47)/1.2*(1.0-TimeMidnight*0.7),isEyeInWater);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*4,2.0),0.0,0.8);
	color.rgb = mix(color.rgb*colmult,vec3(0.025,0.05,0.078)/6.0,depth_diff*(1.0-TimeMidnight*-0.4)*isEyeInWater);

	color.rgb = getFog(color.rgb, land, texcoord.st, hand, iswater);

/* DRAWBUFFERS:5 */


		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 pos1 = tpos.xy/tpos.z;
		vec2 lightPos = pos1*0.5+0.5;

	#ifdef GODRAYS
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	if (truepos > 0.05) {
	    vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
    vec2 textCoord = texcoord.st;
    deltaTextCoord *= 0.0 /  float(NUM_SAMPLES) * density;
    float illuminationDecay = 1.0;
	vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
	float gr = 0.0;
	float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-lightPos.y);
            illuminationDecay = pow(max(1.0-sqrt(distx*distx+disty*disty),0.0),GODARYS_SIZE);
    for(int i=0; i < NUM_SAMPLES ; i++)
    {

            textCoord -= deltaTextCoord;




            float sample = texture2D(gdepth, textCoord + noise*grnoise, 2.25).r;
			gr += sample;

    }
	color.rgb = mix(color.rgb,pow(sunlight,vec3(1.0/4.0))*(1-TimeMidnight) + (moonlight*50.0 * TimeMidnight),(gr/NUM_SAMPLES)*exposure*length(pow(sunlight,vec3(1.0/4.0))*(1-TimeMidnight) + + (moonlight*50.0 * TimeMidnight))*(1.0 - rainStrength*0.5)*illuminationDecay*truepos/sqrt(3.0)*transition_fading);
	}
	#endif

float visiblesun = 0.0;
float temp;
int nb = 0;


//calculate sun occlusion (only on one pixel)
if (texcoord.x < pw && texcoord.x < ph) {
	for (int i = 0; i < 10;i++) {
		for (int j = 0; j < 10 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0)*1.0,ph*(j-5.0)*1.0)).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1;
		}
	}
	visiblesun /= nb;

}
		color = clamp(color,0.0,1.0);

	gl_FragData[0] = vec4(color.rgb,visiblesun);

}
