#version 120
#extension GL_ARB_shader_texture_lod : enable
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

//#define POM

#define NORMAL_MAP_MAX_ANGLE 1.0
#define POM_MAP_RES 64.0
#define POM_DEPTH (1.0/10.0)

/* Here, intervalMult might need to be tweaked per texture pack.
   The first two numbers determine how many samples are taken per fragment.  They should always be the equal to eachother.
   The third number divided by one of the first two numbers is inversely proportional to the range of the height-map. */

const vec3 intervalMult = vec3(1.0, 1.0, 1.0/POM_DEPTH)/POM_MAP_RES * 1.0;

const float MAX_OCCLUSION_DISTANCE = 22.0;
const float MIX_OCCLUSION_DISTANCE = 18.0;
const int   MAX_OCCLUSION_POINTS   = 50;


const int RGBA16 = 3;
const int RGB16 = 2;
const int RGBA8 = 1;
const int R8 = 0;

const int gdepthFormat = R8;
const int gnormalFormat = RGB16;
const int compositeFormat = RGBA16;
const int gaux2Format = RGBA16;
const int gcolorFormat = RGBA8;

const int GL_EXP = 2048;
const int GL_LINEAR = 9729;
const float bump_distance = 64.0;		//bump render distance: tiny = 32, short = 64, normal = 128, far = 256
const float pom_distance = 32.0;		//POM render distance: tiny = 32, short = 64, normal = 128, far = 256
const float fademult = 0.1;

varying vec2 lmcoord;
varying vec4 color;
varying float mat;
varying float dist;
varying vec2 texcoord;
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;

varying vec3 tangent;
varying vec3 normal;
varying vec3 binormal;
varying vec3 viewVector;

uniform sampler2D texture;
uniform sampler2D normals;
uniform sampler2D specular;
uniform sampler2D noisetex;

uniform float frameTimeCounter;

uniform float wetness;

const float mincoord = 1.0/4096.0;
const float maxcoord = 1.0-mincoord;

vec2 dcdx = dFdx(vtexcoord.st*vtexcoordam.pq);
vec2 dcdy = dFdy(vtexcoord.st*vtexcoordam.pq);

vec4 readTexture(in vec2 coord)
{
	return texture2DGradARB(texture,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

vec4 readNormal(in vec2 coord)
{
	return texture2DGradARB(normals,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

void main() {
	vec2 adjustedTexCoord = vtexcoord.st*vtexcoordam.pq+vtexcoordam.st;

#ifdef POM
if (dist < MAX_OCCLUSION_DISTANCE) {
		if ( viewVector.z < 0.0 && readNormal(vtexcoord.st).a < 0.99 && readNormal(vtexcoord.st).a > 0.01)
	{
		vec3 interval = viewVector.xyz * intervalMult;
		vec3 coord = vec3(vtexcoord.st, 1.0);
		for (int loopCount = 0;
				(loopCount < MAX_OCCLUSION_POINTS) && (readNormal(coord.st).a < coord.p);
				++loopCount) {
			coord = coord+interval;

		}
		if (coord.t < mincoord) {
			if (readTexture(vec2(coord.s,mincoord)).a == 0.0) {
				coord.t = mincoord;
				discard;
			}
		}
		adjustedTexCoord = mix(fract(coord.st)*vtexcoordam.pq+vtexcoordam.st , adjustedTexCoord , max(dist-MIX_OCCLUSION_DISTANCE,0.0)/(MAX_OCCLUSION_DISTANCE-MIX_OCCLUSION_DISTANCE));
	}

}
	#endif

	vec4 color = mix(color,vec4(1.0),float(mat > 0.58 && mat < 0.62));		//fix weird lightmap bug on emissive blocks
	vec4 colorAlbedo = texture2DGradARB(texture, adjustedTexCoord, dcdx, dcdy);

	vec4 frag2 = vec4(normal, 1.0f);
	vec3 bump = texture2DGradARB(normals, adjustedTexCoord, dcdx, dcdy).rgb*2.0-1.0;
	float bumpmult = NORMAL_MAP_MAX_ANGLE*(1.0-wetness*lmcoord.t*0.9);
	bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
	mat3 tbnMatrix = mat3(  tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);

	frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);

	float islava = float(mat > 0.67 && mat < 0.69);

vec4 noisetexture = texture2D(noisetex, texcoord.st/1024);
float emissivecolored = float(mat > 0.61 && mat < 0.64);


vec3 red = vec3(1.0, 0.0, 0.0);
vec3 blue = vec3(0.5, 0.5, 0.0);
vec3 TorchColor = vec3(1.0,0.48,0.1);

if (emissivecolored > 0.9){
	float ec = clamp(pow(length(colorAlbedo.rgb),1.4),0,2.2);
	colorAlbedo.rgb = clamp(ec*TorchColor*0.4+pow(ec,1.0)*0.4,vec3(0),vec3(2.2));
	}

if(islava > 0.9){
	float ec = clamp(pow(length(colorAlbedo.rgb),1.4),0,2.2);
//	colorAlbedo.rgb = clamp(ec*vec3(1, 0.97647058823, 0.76078431372)+ec*0.01,vec3(0),vec3(2.2));
//colorAlbedo.rgb = mix(colorAlbedo.rgb, vec3(1, 0.97647058823, 0.76078431372)*colorAlbedo.rgb, 0.8);
colorAlbedo.rgb = clamp(ec*vec3(1, 0.87647058823, 0.66078431372)*ec, 0.0, .70);
}


/* DRAWBUFFERS:0246 */

	gl_FragData[0] = colorAlbedo*color;
	gl_FragData[1] = frag2;
	gl_FragData[2] = vec4((lmcoord.t), mat, lmcoord.s, 1.0);
	gl_FragData[3] = texture2DGradARB(specular, adjustedTexCoord.st, dcdx, dcdy);
}
