#version 120

varying vec4 color;
varying vec4 texcoord;

varying vec3 normal;

varying float distance;

uniform int worldTime;

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);

void main() {


	float SMFixSunrise	= 0.0 * TimeSunrise;
	float SMFixNoon 	= 0.0 * TimeNoon;
	float SMFixSunset 	= 0.0 * TimeSunset;
	float SMFixMidnight = 1.0 * TimeMidnight;
	
	float SMFix = SMFixSunrise + SMFixNoon + SMFixSunset + SMFixMidnight;
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;


	color = gl_Color*SMFix;

	vec4 viewVertex = gl_ModelViewMatrix * gl_Vertex;

	distance = length(viewVertex);

	gl_Position = gl_ProjectionMatrix * viewVertex;
	
	gl_FogFragCoord = gl_Position.z;
	gl_FogFragCoord = distance;

	normal = normalize(gl_NormalMatrix * gl_Normal);
}
