#version 120

/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/


varying vec4 color;
varying vec2 texcoord;
varying vec4 ambientNdotL;
varying vec4 sunlightMat;

varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;




uniform sampler2D texture;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 cameraPosition;
uniform vec3 upPosition;
uniform int fogMode;
uniform int worldTime;
uniform float wetness;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform int heldBlockLightValue;


vec3 sunlight = sunlightMat.rgb;
float mat = sunlightMat.a;
float waterH(vec3 posxz,float time) {

float wave = 0.0;



const float amplitude = 0.2;

vec4 waveXYZW = vec4(posxz.xz,posxz.xz)/vec4(250.,50.,-250.,-150.)+vec4(50.,250.,50.,-250.);
vec2 fpxy = abs(fract(waveXYZW.xy*20.0)-0.5)*2.0;

float d = amplitude*length(fpxy);

wave = cos(waveXYZW.x*waveXYZW.y+time) + 0.5 * cos(2.0*waveXYZW.x*waveXYZW.y+time) + 0.25 * cos(4.0*waveXYZW.x*waveXYZW.y+time);

return d*wave + d*(cos(waveXYZW.z*waveXYZW.w+time) + 0.5 * cos(2.0*waveXYZW.z*waveXYZW.w+time) + 0.25 * cos(4.0*waveXYZW.z*waveXYZW.w+time));

}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	float iswater = ambientNdotL.a;
	float diffuse = dot(normalize(sunPosition),normal);
	diffuse = (worldTime > 12700 && worldTime < 23250)? -diffuse : diffuse;
		


	diffuse = max(diffuse,0.0);
	
	vec4 albedo = texture2D(texture, texcoord.xy)*color;
	vec3 colorrgb = pow(albedo.rgb,vec3(2.2));
	if (iswater > 0.9) colorrgb = mix(albedo.rgb,vec3(0.35,0.67,0.72),0.8)*0.4;
	
	vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
	fragposition /= fragposition.w;
	float mfp = clamp(length(fragposition.xyz/fragposition.w+vec3(-0.5,0.0,0.5)),2.4,16.0);		
	float handLight = (1.0/mfp/mfp-0.00390625)*heldBlockLightValue*heldBlockLightValue/256.0;


		
		vec4 worldposition = gbufferModelViewInverse * fragposition;
		vec3 wpos = worldposition.xyz;



	vec3 sunlight = sunlight*diffuse;
	
	vec4 frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);
	if (iswater > 0.45) {

			vec3 posxz = wpos+cameraPosition;
			float ft = iswater > 0.9? frameTimeCounter*4.0:0.0;
			
			posxz.x += sin(posxz.z+ft)*0.25;
			posxz.z += cos(posxz.x+ft*0.5)*0.25;
			posxz.xz += sin(-posxz.y);
			
			const float deltaPos = 0.4;
			float h0 = waterH(posxz,ft);
			float h1 = waterH(posxz - vec3(deltaPos,0.0,0.0),ft);
			float h2 = waterH(posxz - vec3(0.0,0.0,deltaPos),ft);
			
			vec2 dXY = h0-vec2(h1,h2);
			
			
			vec3 bump = normalize(vec3(dXY/deltaPos,1.0));
			
		
		float bumpmult = 0.055*(iswater+0.0);	
		
		bump = bump * vec3(bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);
		
		frag2 = vec4(normalize(bump * tbnMatrix)*(0.5-iswater*0.025) + 0.5, 1.0);
}

		
	
	vec3 fColor = pow(colorrgb*(sunlight*0.0 + ambientNdotL.rgb+handLight*vec3(1.0,0.45,0.09)*0.2),vec3(1./2.2));


/* DRAWBUFFERS:526 */
	gl_FragData[0] = vec4(fColor,mix(albedo.a,0.4,max(iswater*2.0-1.0,0.0)));
	gl_FragData[1] = frag2;
	gl_FragData[2] = vec4(pow(colorrgb,vec3(1./2.2)),mix(albedo.a,0.4,max(iswater*2.0-1.0,0.0)));
}