#version 120
	const float	sunPathRotation	= -40.0f;

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
#define VIGNETTE
#define VIGNETTE_STRENGTH 1. 
#define VIGNETTE_START 0.15	//distance from the center of the screen where the vignette effect start (0-1)
#define VIGNETTE_END 0.95		//distance from the center of the screen where the vignette effect end (0-1), bigger than VIGNETTE_START

#define GODRAYS
		const float density = 0.1;			
		const float grnoise = 0.9;			//amount of noise

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int maxf = 3;				//number of refinements
const float stp = 1.5;			//size of one step for raytracing algorithm
const float ref = 0.025;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step
/*--------------------------------*/
varying vec2 texcoord;
varying vec3 lightColor;
varying vec3 avgAmbient;
varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;
varying vec3 avgAmbient2;
varying vec3 sky1;
varying vec3 sky2;
varying vec3 cloudColor;
varying float tr;

varying vec4 lightS;
varying vec2 lightPos;

varying vec3 sunlight;
varying vec3 ambient_color;
varying vec3 nsunlight;

varying float handItemLight;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gdepthtex;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D gaux4;

uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D noisetex;
const int 		noiseTextureResolution  = 1024;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;

const vec3 moonlight = vec3(0.5, 0.9, 1.4) * 0.005;
const vec3 moonlightS = vec3(0.5, 0.9, 1.4) * 0.001;
float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;

const vec2 check_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);	
/*
vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = 1.0/mix(600.0,120,rainStrength);

	float d = length(fposition);


	float fog =  pow(1.0-exp(-d*density),2.2-rainStrength*1.2);

return color*(1.0-fog*(vec3(1.0,0.3,0.1)+rainStrength*vec3(0.0,0.7,0.9))) + fog*length(avgAmbient)*normalize(fogclr)*(1.0-rainStrength*0.85);	
}
*/
float getAirDensity (float h) {
return (max((h),60.0)-40.0)/2;
}
float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr,float yPosition,float d) {
	float tmult = mix(min(abs(worldTime-6000.0)/6000.0,1.0),1.0,rainStrength);
	float density = (8000.-tmult*tmult*2000.)*0.75;

	vec3 worldpos = (gbufferModelViewInverse*vec4(fposition,1.0)).rgb+cameraPosition;
	float height = mix(getAirDensity (worldpos.y),0.1,rainStrength*0.8);

	float fog =   clamp(14.0*exp(-getAirDensity (yPosition)/density) * (1.0-exp( -d*height/density ))/height-0.24+rainStrength*0.24,0.0,1.);
	vec3 fogC = fogclr*(0.7+0.3*tmult)*(2.0-rainStrength*1.0);
return mix(color,fogC*(1.0-isEyeInWater),fog);	
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}
/*--------------------------------*/
vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float getnoise(vec2 pos) {
	return fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f);
}
float invRain07 = 1.0-rainStrength*0.6;


vec3 getSkyColor(vec3 fposition) {
/*--------------------------------*/
vec3 sVector = normalize(fposition);
/*--------------------------------*/

float cosT = dot(sVector,upVec); 
float mCosT = max(cosT,0.0)+0.03;
float absCosT = 1.0-max(cosT*0.82+0.18,0.08);
float cosS = SdotU;			
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);	
/*--------------------------------*/
const float a = -1.;
const float b = -0.25;
float c = 1.0;
const float d = -3.;
const float e = 0.45;
/*--------------------------------*/
//luminance
float L =  (1.0+a*exp(b/(mCosT)));
float A = 1.0+e*cosY*cosY;

//gradient
vec3 grad1 = mix(sky1,sky2,absCosT*absCosT);
float sunscat = max(cosY,0.0);
vec3 grad3 = mix(grad1,nsunlight,sunscat*(1.0-sqrt(mCosT))*(1.0-rainStrength*0.5) +0.01);

float Y2 = 3.14159265359-Y;	
float L2 = L * (8.0*exp(d*Y2)+A);

const vec3 moonlight2 = pow(normalize(moonlight),vec3(3.0))*length(moonlight);
const vec3 moonlightRain = normalize(vec3(0.25,0.3,0.4))*length(moonlight);
vec3 gradN = mix(moonlight,moonlight2,1.-L2/2.0);
gradN = mix(gradN,moonlightRain,rainStrength);

return (1.4*grad3*pow(L*(c*exp(d*Y)+A),invRain07)*sunVisibility*vec3(0.85,0.88,1.0) *length(avgAmbient2)+ 0.05*gradN*pow(L2*1.2+1.5,invRain07)*moonVisibility);
}

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr,vec3 rvector) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
	
    vec3 vector = stp * rvector;
    fragpos += vector;
    float sr = 0.0;
	float i = 0.0;
	/*--------------------------------*/
    while (i<16.0) {
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;

        if(pos.x < 0.0 || pos.x > 1.0 || pos.y < 0.0 || pos.y > 1.0 || pos.z < 0.0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(fragpos.z-spos.z);
		if(err < pow(length(vector)*1.5,1.15)){
                sr += 1.0;
                if(sr == maxf){
					bool land = texture2D(depthtex1, pos.st).r < comp;
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    if (isEyeInWater == 0) color = pow(texture2D(gcolor, pos.st),vec4(2.2));
					else color = pow(texture2D(gdepth, pos.st),vec4(2.2));
					vec4 posY = gbufferModelViewInverse*vec4(spos,1.0);
					color.rgb = land ? calcFog(fragpos,color.rgb,fogclr,cameraPosition.y,length(fragpos)) : fogclr*(1.0-isEyeInWater);
					color.a = border;
                    break;
                }
				fragpos -= vector;
                vector *=ref;
				
        
}
else vector *= inc;
fragpos = fragpos + vector;
/*--------------------------------*/
	i += 1.0;
    }
    return color;
}


vec3 Uncharted2Tonemap(vec3 x) {
//tonemapping constants			
float A = 1.3;		
float B = 0.35;		
float C = 0.08;			
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	/*--------------------------------*/
	
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
	//return ((x*(A*x+0.025)+0.006)/(x*(A*x+B)+0.09))-0.06666666666;
}
float waterH(vec3 posxz,float time) {

float wave = 0.0;



const float amplitude = 0.2;

vec4 waveXYZW = vec4(posxz.xz,posxz.xz)/vec4(250.,50.,-250.,-150.)+vec4(50.,250.,50.,-250.);
vec2 fpxy = abs(fract(waveXYZW.xy*20.0)-0.5)*2.0;

float d = amplitude*length(fpxy);

wave = cos(waveXYZW.x*waveXYZW.y+time) + 0.5 * cos(2.0*waveXYZW.x*waveXYZW.y+time) + 0.25 * cos(4.0*waveXYZW.x*waveXYZW.y+time);

return d*wave + d*(cos(waveXYZW.z*waveXYZW.w+time) + 0.5 * cos(2.0*waveXYZW.z*waveXYZW.w+time) + 0.25 * cos(4.0*waveXYZW.z*waveXYZW.w+time));

}

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}
float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

vec3 drawCloud(vec3 fposition,vec3 color,vec3 vH) {
//const vec4 noiseWeights = 1.0/vec4(1.0,3.5,12.25,42.87)/1.4472;
const float r = 4.0;
const vec3 noiseC = vec3(1.0,r,r*r);
const vec3 noiseWeights = 1.0/vec3(1.0,r,r*r)/dot(1.0/vec3(1.0,r,r*r),vec3(1.0));
/*--------------------------------*/
vec3 sVector = normalize(fposition);
float cosT = max(dot(normalize(sVector),upVec),0.0);
float McosY = MdotU;
float cosY = SdotU;
vec3 tpos = vec3(gbufferModelViewInverse * vec4(sVector,0.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
/*--------------------------------*/
float totalcloud = 0.0;
/*--------------------------------*/


vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5))+vec2(0.5);
float iMult = 10.0*(0.5+0.4*(3.0-sqrt(cosT)*2.8)*(3.0-sqrt(cosT)*2.8));
float heightA = (400.0+300.0*sqrt(cosT))/(wVector.y);
/*--------------------------------*/	
for (int i = 0;i<7;i++) {
	vec3 intersection = wVector*(heightA-i*iMult); 			//curved cloud plane
	vec2 coord1 = (intersection.xz+abs(3.0-i)*normalize(wind)*3.5)/200000.+wind*0.07;
	vec2 coord = fract(coord1/2.0);
	/*--------------------------------*/
	vec3 noiseSample = vec3(texture2D(noisetex,coord).x,texture2D(noisetex,coord*noiseC.y).x,texture2D(noisetex,coord*noiseC.z).x);

	
	float noise = dot(noiseSample,noiseWeights);
	/*--------------------------------*/
	float cl = noise;
	float d1 = max(1.0-cl*(1.6-rainStrength*0.6),0.); 
	float density = d1*d1*(abs(i-3.0)+1.0)/19.0;  
	/*--------------------------------*/  

	/*--------------------------------*/
	totalcloud += density;

	/*--------------------------------*/
	if (totalcloud > 0.999) break;
}
totalcloud = min(totalcloud,1.0);
return mix(color.rgb,cloudColor,totalcloud*cosT*cosT);

}

vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}
float decodeTorch (float input){
return input<0.5?input*2.0:input*2.0-1.0;
}
//((48*(0.5*48+0.25*0.1)+0.006)/(48*(0.5*48+0.25)+0.3*0.3))-0.02/0.3
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {








float Depth = texture2D(depthtex1, texcoord).x;
vec4 albedo = texture2D(gcolor,texcoord);
vec3 color = pow(albedo.xyz,vec3(2.2));
vec3 normal = texture2DLod(gnormal,texcoord,0).xyz;
	normal = normal*2.0-1.0;
	bool iswater = (length(normal) > 0.94 && length(normal) < 0.96);		//material properties are stored into normal length
	bool isice = (length(normal) > 0.96 && length(normal) < 0.98);	
	
bool land = Depth < comp;

vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord,Depth,1.0) * 2.0 - 1.0);
fragpos /= fragpos.w;


if (land) {

vec3 normalT = decode(texture2D(gdepth,texcoord).xy);

float NdotL = dot(normalT,sunVec);
float NdotU = dot(normalT,upVec);

	float skyL = max(texture2D(gdepth,texcoord).w-2./16.0,0.0)*1.14285714286;
	float torch_lightmap = decodeTorch(texture2D(gdepth,texcoord).z)-1/255.0;
	//hand
	if (torch_lightmap < 0.0) {
	torch_lightmap = eyeBrightness.x/255.0+0.5/16.0;
	skyL = max(eyeBrightness.y/255.0-2./16.0,0.0)*1.14285714286;
	
	}



	torch_lightmap 		= 6.4 - min(torch_lightmap * 6.16,5.6);
	torch_lightmap 		= pow(0.1 / torch_lightmap / torch_lightmap - 0.002595f,0.9);


	bool translucent = texture2D(gdepth,texcoord,0).z < 0.5;


	vec3 ambientC = vec3(1.0,0.3,0.08)*torch_lightmap*0.6 + vec3(0.003,0.003,0.004)*sqrt(0.49*NdotU+0.51)*0.45 + vec3(0.004,0.00032,0.00004)*sqrt(0.49*-NdotU+0.51)*0.33;

color = color*(ambientC*(iswater||isice?2.0:1.0))*0.81;
}

float cosT = dot(normalize(fragpos.xyz),upVec);
float skyBoxFactor = moonVisibility*sqrt(max(cosT*0.24+0.01,0.0));


bool particle = albedo.a > 0.98999 && albedo.a < 0.99991;




//color = isice? vec3(0.0) : color;


if (rainStrength > 0.01){
	vec4 rain = pow(texture2D(gaux4,texcoord),vec4(2.2,2.2,2.2,1.0));
if (length(rain) > 0.001) {	
	vec3 rainRGB = mix(vec3(0.575),normalize(rain.rgb),0.35);
	float rainA = rain.a;
	
	
	vec3 rainC = (pow(max(dot(normalize(fragpos.xyz),sunVec)*0.1+0.9,0.0),6.0)*pow(sunlight,vec3(0.55))*sunVisibility+pow(max(dot(normalize(fragpos.xyz),-sunVec)*0.05+0.95,0.0),6.0)*10.0*moonlight*moonVisibility)*rainA*0.04 + 0.03*rainA*rainRGB*length(avgAmbient2);
	
	color = mix(color,(color*rainRGB)/length(rainRGB),rainA*0.3)*(1.0-rainA*0.3)+rainC*0.6;
	
	}
	
}




color = pow(color/2.0,vec3(1.0/2.2));
	//if (color.r > 1.0 || color.g > 1.0 || color.b > 1.0) color.rgb = vec3(1.0,0.0,1.0);
	//color = vec3(texture2D(gdepth,texcoord).w);

/* DRAWBUFFERS:4 */
	gl_FragData[0] = vec4(color,1.0);
}