#version 120

/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

	const float shadowMapResolution = 2048;		//shadowmap resolution
	
	
const vec2 check_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);	


#define SHADOW_MAP_BIAS 0.8
varying vec4 color;
varying vec2 texcoord;
varying vec4 ambientNdotL;
varying vec4 sunlightMat;

varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;


uniform sampler2D noisetex;
uniform sampler2D texture;
uniform sampler2DShadow shadow;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 cameraPosition;
uniform vec3 upPosition;
uniform int fogMode;
uniform int worldTime;
uniform float wetness;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform int heldBlockLightValue;


vec3 sunlight = sunlightMat.rgb;
float mat = sunlightMat.a;
float waterH(vec3 posxz,float time) {

float wave = 0.0;



const float amplitude = 0.2;

vec4 waveXYZW = vec4(posxz.xz,posxz.xz)/vec4(250.,50.,-250.,-150.)+vec4(50.,250.,50.,-250.);
vec2 fpxy = abs(fract(waveXYZW.xy*20.0)-0.5)*2.0;

float d = amplitude*length(fpxy);

wave = cos(waveXYZW.x*waveXYZW.y+time) + 0.5 * cos(2.0*waveXYZW.x*waveXYZW.y+time) + 0.25 * cos(4.0*waveXYZW.x*waveXYZW.y+time);

return d*wave + d*(cos(waveXYZW.z*waveXYZW.w+time) + 0.5 * cos(2.0*waveXYZW.z*waveXYZW.w+time) + 0.25 * cos(4.0*waveXYZW.z*waveXYZW.w+time));

}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	
	float diffuse = dot(normalize(sunPosition),normal);
	diffuse = (worldTime > 12700 && worldTime < 23250)? -diffuse : diffuse;
		



	
	vec4 albedo = texture2D(texture, texcoord.xy)*color;
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	vec3 colorrgb = albedo.rgb;
	
	vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
	fragposition /= fragposition.w;
	float mfp = clamp(length(fragposition.xyz/fragposition.w+vec3(-0.5,0.0,0.5)),2.4,16.0);		
	float handLight = (1.0/mfp/mfp-0.00390625)*heldBlockLightValue*heldBlockLightValue/256.0;


	
	vec4 worldposition = gbufferModelViewInverse * fragposition;
	vec3 wpos = worldposition.xyz;


	worldposition = shadowModelView * worldposition;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	vec2 pos = abs(worldposition.xy * 1.165);
	float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
	float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy /= distortFactor*0.97; 
	


	
	
	if (max(abs(worldposition.x),abs(worldposition.y)) < 0.99) {
			float diffthresh = mix(0.00035,distortFactor*distortFactor*(0.01*tan(acos(abs(diffuse))) + 0.001)*0.15,albedo.a);
			diffuse = max(diffuse,0.0);
			
			worldposition = worldposition * vec4(0.5,0.5,0.5/2.5,0.5) + vec4(0.5,0.5,0.5,0.5);
			float tw = 0.0;
			float shading = 0.0;
				for(int i = 0; i < 25; i++){
					vec2 offsetS = check_offsets[i];
					float w1 = dot(offsetS,offsetS);
					float weight = 1.0+sqrt(w1*(1.0+rainStrength*8.0))*1.412;
		
					shading += shadow2D(shadow,vec3(worldposition.st +  offsetS/shadowMapResolution*(rainStrength*8.0+1.412), worldposition.z-diffthresh*weight)).x;
					tw+=(1.0-w1*0.5);
				}
			diffuse = shading/25.*mix(1.4,diffuse,albedo.a);
	}
	


	vec3 sunlight = sunlight*diffuse;
	
	vec4 frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);


		

	vec3 fColor = pow(colorrgb*(sunlight*2.15+ambientNdotL.rgb*1.3)*0.63,vec3(1./2.2));

	
	
	float alpha = albedo.a;

/* DRAWBUFFERS:562 */
	gl_FragData[0] = vec4(fColor,alpha);
	gl_FragData[1] = vec4(normalize(pow(albedo.rgb,vec3(1./2.2))),alpha);
	gl_FragData[2] = vec4(0.0,0.0,0.0,1.0);
}