#version 120
#extension GL_ARB_shader_texture_lod : enable

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/

//disabling is done by adding "//" to the beginning of a line.
/*--------------------------------*/
const bool compositeMipmapEnabled = true;
/*--------------------------------*/

/*--------------------------------*/
varying vec2 texcoord;
varying vec3 sunlight;
varying vec3 ambient_color;
varying float eyeAdapt;

uniform sampler2D noisetex;
uniform sampler2D gdepth;
uniform sampler2D gnormal;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
vec3 sunPos = sunPosition;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;
/*--------------------------------*/

const int MAX_SAMPLES = 64;
int uSamples = 17;

const float uDispersal = 0.15*17/10;
const float uDistortion = 15.0;

float getnoise(vec2 pos) {
	return fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f);
}
float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}
vec3 textureDistorted(
	in sampler2D tex, 
	in vec2 texcoord, 
	in vec2 direction,
	in vec3 distortion 
) {

	vec3 sample = vec3(
		texture2DLod(tex, (texcoord + direction * distortion.r)/4.0,1).r,
		texture2DLod(tex, (texcoord + direction * distortion.g)/4.0,1).g,
		texture2DLod(tex, (texcoord + direction * distortion.b)/4.0,1).b
	);
	
	sample = max(sample-0.085*normalize(vec3(sample)),0.0);
	return pow(sample,vec3(8.2));
}


	float hash( float n ) {
		return fract(sin(n)*43758.5453);
	}
 
	float noise( in vec2 x ) {
	return texture2D(noisetex,x/1000.).x;
	}
 
 
	float fbm( vec2 p ) {
	const vec4 w = vec4(0.5,0.25,0.125,0.0625)/0.953125;
    	float f = dot(vec4(noise( p ),noise( p*2.02 ),noise( p *4.1006),noise( p *8.242206)),w);


		
    	return f;
	}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
if(texcoord.x<0.25 && texcoord.y<0.25){
	vec2 tc4 = texcoord.xy*4.0;
	vec2 ntc = 1.0-tc4; // flip ntcoords
	vec2 texelSize = 4.0 / vec2(viewWidth,viewHeight);
	
	vec2 ghostVec = (vec2(0.5) - ntc)/uSamples*1.41421356237;

	
	vec3 distortion = vec3(-texelSize.x * uDistortion, 0.0, texelSize.x * uDistortion);

// sample ghosts:
	vec3 result = vec3(0.0);
	for (int i = 0; i < uSamples; ++i) {
		vec2 offset = (ntc + ghostVec * float(i));
		
		float weight = min(length(vec2(0.5) - offset) / 0.70710678118,1.0);

		vec3 sresult = textureDistorted(
			gdepth,
			offset,
			normalize(ghostVec),
			distortion
		)*pow(1.0 - weight, 30.0);
		
		result += sresult*pow(weight, 4.0)*50.;

	}
	
	// Set up domain
	vec2 q = tc4 + tc4.x * 0.4;
	vec2 p = -1.0 + 3.0 * q;
	vec2 p2 = 9.0 + 3.0 * q ;
		
	// Create noise using fBm
	float f = fbm(5.0 * p);
	float f2 = fbm(20.0 * p2);
	 
	const float cover = 0.35f;
	const float sharpness = 0.09;	// Brightness
		
	float c = max(f - 1.0 + cover,0.0);
	f = 1.0 - pow(1.0 - sharpness, c);
				
			
	float c2 = max(f2 - 1.0 + cover,0.0);

	f2 = 1.0 - pow(1.0 - sharpness, c2);
				
	float dirtylens = f * 2.0 + f2;
	
	
	float weight = min(length(vec2(0.5) - ntc) / 0.70710678118,1.0);
	vec3 weight2 = sin(weight*vec3(1.5,2.,2.1)-vec3(1.2,3.96,2.3))*0.3+0.7;
	result *= (dirtylens*3.+0.12)*257.;
	result = result*normalize(weight2)/17*11.;
//	sample halo:

vec3 glow = texture2DLod(gdepth,tc4/4.0,0).rgb;
vec3 overglow = glow*pow(length(glow)*2.,3.0)*2.2;

/* DRAWBUFFERS:2 */
	gl_FragData[0] = vec4(pow(result.xyz,vec3(1./6.))/4.2+(overglow+glow)*(0.5*(1+pow(rainStrength,3.)*4./pow(eyeAdapt,1.0))+dirtylens*2.3)/5.,1.0);
	//gl_FragData[0] = vec4(vec3(dirtylens),1.0);
	} 
	//gl_FragData[0] = texture2DLod(gdepth,tc4.xy,1);
	/*else discard;*/
}
