#version 120
	const int shadowMapResolution = 2048;		//shadowmap resolution
	const float shadowDistance = 140.0;		//draw distance of shadows
	const bool 	shadowHardwareFiltering0 = true;
	const float	sunPathRotation	= -40.0f;
	#define SHADOW_MAP_BIAS 0.8
	

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
#define VIGNETTE
#define VIGNETTE_STRENGTH 1. 
#define VIGNETTE_START 0.15	//distance from the center of the screen where the vignette effect start (0-1)
#define VIGNETTE_END 0.95		//distance from the center of the screen where the vignette effect end (0-1), bigger than VIGNETTE_START

#define GODRAYS
		const float density = 0.1;			
		const float grnoise = 0.9;			//amount of noise

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int maxf = 3;				//number of refinements
const float stp = 1.5;			//size of one step for raytracing algorithm
const float ref = 0.025;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step
/*--------------------------------*/
varying vec2 texcoord;
varying vec3 lightColor;
varying vec3 avgAmbient;
varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;
varying vec3 avgAmbient2;
varying vec3 sky1;
varying vec3 sky2;
varying vec3 cloudColor;
varying float tr;

varying vec4 lightS;
varying vec2 lightPos;

varying vec3 sunlight;
varying vec3 ambient_color;
varying vec3 nsunlight;

varying float handItemLight;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D depthtex1;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2DShadow shadow;


const int 		noiseTextureResolution  = 1024;
uniform vec3 cameraPosition;
uniform float potato;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;

const vec3 moonlight = vec3(0.5, 0.9, 1.4) * 0.005;
const vec3 moonlightS = vec3(0.5, 0.9, 1.4) * 0.001;
float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;


const vec2 check_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);	
/*
vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = 1.0/mix(600.0,120,rainStrength);

	float d = length(fposition);


	float fog =  pow(1.0-exp(-d*density),2.2-rainStrength*1.2);

return color*(1.0-fog*(vec3(1.0,0.3,0.1)+rainStrength*vec3(0.0,0.7,0.9))) + fog*length(avgAmbient)*normalize(fogclr)*(1.0-rainStrength*0.85);	
}
*/
float getAirDensity (float h) {
return (max((h),60.0)-40.0)/2;
}
float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr,float yPosition,float d) {
	float tmult = mix(min(abs(worldTime-6000.0)/6000.0,1.0),1.0,rainStrength);
	float density = (8000.-tmult*tmult*2000.)*0.75;

	vec3 worldpos = (gbufferModelViewInverse*vec4(fposition,1.0)).rgb+cameraPosition;
	float height = mix(getAirDensity (worldpos.y),0.1,rainStrength*0.8);

	float fog =   clamp(14.0*exp(-getAirDensity (yPosition)/density) * (1.0-exp( -d*height/density ))/height-0.24+rainStrength*0.24,0.0,1.);
	vec3 fogC = fogclr*(0.7+0.3*tmult)*(2.0-rainStrength*1.0);
return mix(color,fogC*(1.0-isEyeInWater),fog);	
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}
/*--------------------------------*/
vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float getnoise(vec2 pos) {
	return fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f);
}
float invRain07 = 1.0-rainStrength*0.6;


vec3 getSkyColor(vec3 fposition) {
/*--------------------------------*/
vec3 sVector = normalize(fposition);
/*--------------------------------*/

float cosT = dot(sVector,upVec); 
float mCosT = max(cosT,0.0)+0.03;
float absCosT = 1.0-max(cosT*0.82+0.18,0.08);
float cosS = SdotU;			
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);	
/*--------------------------------*/
const float a = -1.;
const float b = -0.25;
float c = 1.0;
const float d = -3.;
const float e = 0.45;
/*--------------------------------*/
//luminance
float L =  (1.0+a*exp(b/(mCosT)));
float A = 1.0+e*cosY*cosY;

//gradient
vec3 grad1 = mix(sky1,sky2,absCosT*absCosT);
float sunscat = max(cosY,0.0);
vec3 grad3 = mix(grad1,nsunlight,sunscat*(1.0-sqrt(mCosT))*(1.0-rainStrength*0.5) +0.01);

float Y2 = 3.14159265359-Y;	
float L2 = L * (8.0*exp(d*Y2)+A);

const vec3 moonlight2 = pow(normalize(moonlight),vec3(3.0))*length(moonlight);
const vec3 moonlightRain = normalize(vec3(0.25,0.3,0.4))*length(moonlight);
vec3 gradN = mix(moonlight,moonlight2,1.-L2/2.0);
gradN = mix(gradN,moonlightRain,rainStrength);

return (1.6*grad3*pow(L*(c*exp(d*Y)+A),invRain07)*sunVisibility*vec3(0.85,0.88,1.0) *length(avgAmbient2)+ 0.05*gradN*pow(L2*1.2+1.5,invRain07)*moonVisibility);
}

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr,vec3 rvector) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
	
    vec3 vector = stp * rvector;
    fragpos += vector;
    float sr = 0.0;
	float i = 0.0;
	/*--------------------------------*/
    while (i<16.0) {
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;

        if(pos.x < 0.0 || pos.x > 1.0 || pos.y < 0.0 || pos.y > 1.0 || pos.z < 0.0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(fragpos.z-spos.z);
		if(err < pow(length(vector)*1.5,1.15)){
                sr += 1.0;
                if(sr == maxf){
					bool land = texture2D(depthtex1, pos.st).r < comp;
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    if (isEyeInWater == 0) color = pow(texture2D(gcolor, pos.st),vec4(2.2));
					else color = pow(texture2D(gdepth, pos.st),vec4(2.2));
					vec4 posY = gbufferModelViewInverse*vec4(spos,1.0);
					color.rgb = land ? calcFog(fragpos,color.rgb,fogclr,cameraPosition.y,length(fragpos)) : fogclr*(1.0-isEyeInWater);
					color.a = border;
                    break;
                }
				fragpos -= vector;
                vector *=ref;
				
        
}
else vector *= inc;
fragpos = fragpos + vector;
/*--------------------------------*/
	i += 1.0;
    }
    return color;
}


vec3 Uncharted2Tonemap(vec3 x) {
//tonemapping constants			
float A = 1.3;		
float B = 0.35;		
float C = 0.08;			
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	/*--------------------------------*/
	
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
	//return ((x*(A*x+0.025)+0.006)/(x*(A*x+B)+0.09))-0.06666666666;
}
float waterH(vec3 posxz,float time) {

float wave = 0.0;



const float amplitude = 0.2;

vec4 waveXYZW = vec4(posxz.xz,posxz.xz)/vec4(250.,50.,-250.,-150.)+vec4(50.,250.,50.,-250.);
vec2 fpxy = abs(fract(waveXYZW.xy*20.0)-0.5)*2.0;

float d = amplitude*length(fpxy);

wave = cos(waveXYZW.x*waveXYZW.y+time) + 0.5 * cos(2.0*waveXYZW.x*waveXYZW.y+time) + 0.25 * cos(4.0*waveXYZW.x*waveXYZW.y+time);

return d*wave + d*(cos(waveXYZW.z*waveXYZW.w+time) + 0.5 * cos(2.0*waveXYZW.z*waveXYZW.w+time) + 0.25 * cos(4.0*waveXYZW.z*waveXYZW.w+time));

}

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}
float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}



vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}


vec3 drawSun(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);

float angle = (1.0-max(dot(sVector,sunVec),0.0))*350.0;
float sun = exp(-angle*angle);
sun *= (1.0-rainStrength*0.9925)*sunVisibility;
vec3 sunlightB = mix(pow(sunlight,vec3(1.0/2.2)),vec3(0.25,0.3,0.4),rainStrength*0.8)*(1.0+SdotU*2.0);

return mix(color,sunlightB,sun);

}
vec3 YCoCg2RGB(vec3 c){
		c.y-=0.5;
		c.z-=0.5;
		return vec3(c.r+c.g-c.b, c.r + c.b, c.r - c.g - c.b);
	}
	
float edge_filter(vec2 center, vec2 a0, vec2 a1, vec2 a2, vec2 a3){ 
	  const float THRESH=30./255.;

	  vec4 lum = vec4(a0.x, a1.x , a2.x, a3.x);
	  vec4 w = 1.0-step(THRESH, abs(lum - center.x)); 
	  float W = w.x + w.y + w.z + w.w;
	  //Handle the special case where all the weights are zero.
	  //In HDR scenes it's better to set the chrominance to zero. 
	  //Here we just use the chrominance of the first neighbor.
	  w.x = (W==0.0)? 1.0:w.x;  W = (W==0.0)? 1.0:W;  

	  return (w.x*a0.y+w.y*a1.y+w.z*a2.y+w.w* a3.y)/W;
}
vec4 dssdo_accumulate(vec2 tex,vec3 fragpos)
{
const vec2 check_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);	

	const int num_samples = 25;

	vec2 noise_texture_size = vec2(4,4);
	vec3 center_pos  = fragpos.rgb;
	vec3 eye_pos = cameraPosition;

	float  center_depth  = fragpos.z;

	float radius = 0.3/ (center_depth);
	float max_distance_inv = 1.f / 10.0;
	float attenuation_angle_threshold = 0.1;

	vec3 noise = mix(vec3(getnoise(tex),getnoise(tex),getnoise(tex)),upVec,0.9);

	//radius = min(radius, 0.1);

	vec3 normal = decode(texture2DLod(gdepth,tex,0).xy);

	vec4 occlusion_sh2 = vec4(0.0);

	const float fudge_factor_l0 = 2.0;
	const float fudge_factor_l1 = 10.0;

	const float sh2_weight_l0 = 0.5*sqrt(1.0/3.14);
	const vec3 sh2_weight_l1 = vec3(0.5)*sqrt(3.0/3.14);

	const vec4 sh2_weight = vec4(sh2_weight_l1, sh2_weight_l0) / num_samples;

	
	for( int i=0; i<num_samples; ++i )
	{
	    vec2 textureOffset = pow(length((check_offsets[ i ].xy)),0.5)*radius*vec2(1.0,aspectRatio)*normalize(check_offsets[ i ].xy);
		vec2 sample_tex = tex + textureOffset;
		
		vec4 t0 = gbufferProjectionInverse*vec4(vec3(sample_tex,texture2D(depthtex1,sample_tex).x)*2.0-1.0,1.0);
		t0 /= t0.w;
		
		
		vec3 sample_pos = t0.rgb;
		vec3 center_to_sample = sample_pos - center_pos;
		
		float dist = length(center_to_sample);

		vec3 center_to_sample_normalized = center_to_sample / dist;
		float attenuation = 1.0-clamp(dist/6.0,0.0,1.);
		float dp = dot(normal, center_to_sample_normalized);
		
		attenuation = sqrt(max(dp,0.0))*attenuation*attenuation * step(attenuation_angle_threshold, dp);
		occlusion_sh2 += attenuation * sh2_weight*vec4(center_to_sample_normalized,1);
		

	}

	return occlusion_sh2;
}
float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {
//sample half-resolution buffer with correct texture coordinates
vec4 hr = pow(texture2D(composite,(floor(gl_FragCoord.xy/2.)*2+1.0)/vec2(viewWidth,viewHeight)/2.0),vec4(2.2,2.2,2.2,1.0))*vec4(257.,257,257,1.0);




float gr = hr.a;






float Depth = texture2D(depthtex1, texcoord).x;
vec4 albedo = texture2D(gcolor,texcoord);
bool land = !(dot(albedo.rgb,vec3(1.0))<0.00000000001 || (Depth > comp));
bool translucent = albedo.b > 0.69 && albedo.b < 0.71;
bool emissive = albedo.b > 0.59 && albedo.b < 0.61;
vec3 color = vec3(albedo.rg,0.0);


const ivec2 g4offsets[4] = ivec2[4] (ivec2(1,0),ivec2(-1,0),ivec2(0,1),ivec2(0,-1));
#extension GL_ARB_gpu_shader5 : enable

if (land && dot(albedo.rgb,vec3(1.0))>0.00000000001){
vec2 a0 = texture2D(gcolor,texcoord + vec2(1.0/viewWidth,0.0)).rg;
vec2 a1 = texture2D(gcolor,texcoord - vec2(1.0/viewWidth,0.0)).rg;
vec2 a2 = texture2D(gcolor,texcoord + vec2(0.0,1.0/viewHeight)).rg;
vec2 a3 = texture2D(gcolor,texcoord - vec2(0.0,1.0/viewHeight)).rg;	
vec4 lumas = vec4(a0.x,a1.x,a2.x,a3.x);
vec4 chromas = vec4(a0.y,a1.y,a2.y,a3.y);

const vec4 THRESH = vec4(30./255.);

vec4 w = 1.0-step(THRESH, abs(lumas - color.x)); 
float W = dot(w,vec4(1.0));

w.x = (W==0.0)? 1.0:w.x;  W = (W==0.0)? 1.0:W;  

float chroma = dot(w,chromas)/W;



bool pattern = (mod(gl_FragCoord.x,2.0)==mod(gl_FragCoord.y,2.0));
color.b= chroma;
color.rgb = (pattern)?color.rbg:color.rgb;
color.rgb = YCoCg2RGB(color.rgb);

color = pow(color,vec3(2.2));


/*
float avg = dot(color,vec3(1.0));
color = ((color - avg )*1.03+avg)/1.03;*/
vec3 normal = texture2DLod(gnormal,texcoord,0).xyz;

	bool iswater = normal.z < 0.2499 && dot(normal,normal) > 0.0;
	bool isice = normal.z > 0.2499 && normal.z < 0.4999 && dot(normal,normal) > 0.0;

vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord,Depth,1.0) * 2.0 - 1.0);
fragpos /= fragpos.w;


vec3 normalT = decode(texture2D(gdepth,texcoord).xy);
/*
//vec4 occlusion = dssdo_accumulate(texcoord,fragpos.xyz);
vec2 ntc = texcoord;
vec4 occlusion = texture2DLod(composite,ntc*0.5,1)*2.0-1.0;

//color *= 10*dot(cp,vec4(1.0));
float avgocc = pow(1.0-occlusion.a/0.48872640933,5.0);
//float avgocc = 1.0;
*/

float NdotL = dot(normalT,sunVec);
float NdotU = dot(normalT,upVec);

	float skyL = max(texture2D(gdepth,texcoord).w-2./16.0,0.0)*1.14285714286;
	float torch_lightmap = texture2D(gdepth,texcoord).z;




	torch_lightmap 		= 6.4 - min(torch_lightmap * 6.16,5.6);
	torch_lightmap 		= 0.1 / torch_lightmap / torch_lightmap - 0.002595;
	float emitted 		= emissive? clamp(dot(normalize(color.rgb),normalize(vec3(1.0,0.3,-1.0)))*40.0*torch_lightmap,0.0,1.2) : 0.0;

	const vec3 moonlight = vec3(0.4, 0.72, 1.3) * 0.006;


	vec2 visibility = vec2(sunVisibility,moonVisibility);


	
	float SkyL2 = skyL*skyL;
	float skyc2 = mix(1.0,SkyL2,skyL);
	
	
	vec4 bounced = vec4(NdotL,NdotL,NdotL,NdotU) * vec4(-0.15*skyL*skyL,0.34,0.7,0.14) + vec4(0.6,0.66,0.7,0.23);
	bounced *= vec4(skyc2,skyc2,visibility.x-tr*visibility.x,0.8);

	vec3 sun_ambient = bounced.w * (vec3(0.08, 0.35, 1.0)+rainStrength*vec3(0.05,-0.2,-0.8))*2.4+ 1.45*sunlight*(sqrt(bounced.w)*bounced.x*2.4 + bounced.z)*(1.0-rainStrength*0.98);
	vec3 moon_ambient = (moonlight*0.7 + moonlight*bounced.y)*(1.0-rainStrength*0.95)*4.0;
	
	
	vec3 LightC = mix(sunlight,moonlight,moonVisibility)*tr*(1.0-rainStrength*0.99);
	vec3 amb1 = (sun_ambient*visibility.x + moon_ambient*visibility.y)*SkyL2*(0.03+tr*0.17)*0.65;
	vec3 ambientC =  amb1 + vec3(1.0,0.4,0.04)*(emitted + torch_lightmap)*2.05 + vec3(0.002,0.002,0.002)*min(skyL+6/16.,9/16.)*normalize(amb1+0.0001)*2.0;
	
	
	
//1 + (FD90 − 1)(1 − cos θl)^5 + (FD90 − 1)(1 − cos θv)^5
//FD90 = 0.5 + 2 cos^2(θd) * roughnes
	NdotL = max((worldTime > 12700 && worldTime < 23250)? -NdotL : NdotL,0.0);
	float diffuse = mix(1.0,2.0,pow(1-NdotL,5.0))*NdotL; //modified diffuse sahding
	
/*
	vec3 hV= normalize(normalize(lightVector) + normalize(-fragpos.xyz));
	float NdotV = max(dot(normalT,normalize(-fragpos.xyz)),0.0);
	float NdotH = max(dot(hV,normalT),0.0);
	float LdotH = max(dot(lightVector,hV),0.0);
	float NdL = max(NdotL,0.0);
	
	

	
	float FL = pow(1.0-NdL,5.0);
    float FV = pow(1.0-NdotV,5.0);
    float Fd90 = 0.5f + 2.0f * LdotH * LdotH * 0.2;
    float Fd = mix(1.0f, Fd90, FL) * mix(1.0f, Fd90, FV);
	
	diffuse = NdL*Fd;
*/
	
	
	if (translucent) diffuse = abs(dot(sunVec,upVec))*0.2+NdotL*0.2+0.6;

	vec4 worldposition = gbufferModelViewInverse * vec4(fragpos);
	vec4 wpos = worldposition;
	if (diffuse > 0.00001){
	//color *= 500.;
	worldposition = shadowModelView * worldposition;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	vec2 pos = abs(worldposition.xy * 1.165);
	float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
	float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy /= distortFactor*0.97; 
	


	
	
	if (max(abs(worldposition.x),abs(worldposition.y)) < 0.99) {
			float diffthresh = translucent? 0.00017 : distortFactor*distortFactor*(0.01*tan(acos(max(NdotL,0.0))) + 0.001)*0.15;
			const float halfres = (0.25/shadowMapResolution);
			float offset = ((rainStrength*2.0+float(translucent))*halfres+halfres);
			
			worldposition = worldposition * vec4(0.5,0.5,0.2,0.5) + vec4(0.5,0.5,0.5,0.5);
			float tw = 0.0;
			float shading = 0.0;
				for(int i = 0; i < 25; i++){
					vec2 offsetS = check_offsets[i];
					float w1 = dot(offsetS,offsetS);
					float weight = 1.0+sqrt(w1*(1.0+rainStrength*8.0))*1.412;
		
					shading += shadow2D(shadow,vec3(worldposition.st +  offsetS/shadowMapResolution*(rainStrength*8.0+1.412), worldposition.z-diffthresh*weight)).x;
					tw+=(1.0-w1*0.5);
				}
			diffuse = shading*diffuse/25.;
	}
	}
	
bool isnsun = (iswater||isice) || ((!iswater||!isice) && isEyeInWater == 1);
float caustics = 1.0;
if (isnsun){
		
		vec3 pos2 = wpos.xyz+vec3(sin(wpos.z+cameraPosition.z+frameTimeCounter)*0.25,0.0,cos(wpos.x+cameraPosition.x+frameTimeCounter*0.5)*0.25)+cameraPosition+sin(wpos.y+cameraPosition.y);
		
		caustics = waterH((pos2.xyz)*2.0,frameTimeCounter*3.0)*0.2+1.1;			
}
color = vec3(color)*(diffuse*LightC*(isnsun?SkyL2*skyL:1.0)*2.08+ambientC*(isnsun?1.0/(SkyL2*skyL*0.5+0.5):1.0)*1.3)*0.63;

}




if (!land) {
color = hr.rgb;
}




//color = isice? vec3(0.0) : color;



color = pow(color/257.0,vec3(1.0/2.2));
	//if (color.r > 1.0 || color.g > 1.0 || color.b > 1.0) color.rgb = vec3(1.0,0.0,1.0);


/* DRAWBUFFERS:1 */
	gl_FragData[0] = vec4(color,gr);
}