#version 120
#extension GL_ARB_gpu_shader5 : enable
	
/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
#define VIGNETTE
#define VIGNETTE_STRENGTH 1. 
#define VIGNETTE_START 0.15	//distance from the center of the screen where the vignette effect start (0-1)
#define VIGNETTE_END 0.95		//distance from the center of the screen where the vignette effect end (0-1), bigger than VIGNETTE_START

#define GODRAYS
		const float density = 0.1;			
		const float grnoise = 0.9;			//amount of noise

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int maxf = 3;				//number of refinements
const float stp = 1.5;			//size of one step for raytracing algorithm
const float ref = 0.025;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step
/*--------------------------------*/
varying vec2 texcoord;
varying vec3 lightColor;
varying vec3 avgAmbient;
varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;
varying vec3 avgAmbient2;
varying vec3 sky1;
varying vec3 sky2;
varying vec3 cloudColor;
varying float tr;
varying vec3 rawAvg;
varying vec3 cloudColor2;

varying vec4 lightS;
varying vec2 lightPos;

varying vec3 sunlight;
varying vec3 ambient_color;
varying vec3 nsunlight;

varying float handItemLight;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gaux1;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D gaux4;
uniform sampler2DShadow shadow;
uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D noisetex;

const int 		noiseTextureResolution  = 1024;
uniform vec3 cameraPosition;
uniform float potato;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;

const vec3 moonlight = vec3(0.5, 0.9, 1.4) * 0.005;
const vec3 moonlightS = vec3(0.5, 0.9, 1.4) * 0.001;
float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;

const vec2 shadow_offsets[60] = vec2[60]  (  vec2(0.06120777f, -0.8370339f),
vec2(0.09790099f, -0.5829314f),
vec2(0.247741f, -0.7406831f),
vec2(-0.09391049f, -0.9929391f),
vec2(0.4241214f, -0.8359816f),
vec2(-0.2032944f, -0.70053f),
vec2(0.2894208f, -0.5542058f),
vec2(0.2610383f, -0.957112f),
vec2(0.4597653f, -0.4111754f),
vec2(0.1003582f, -0.2941186f),
vec2(0.3248212f, -0.2205462f),
vec2(0.4968775f, -0.6096044f),
vec2(0.770794f, -0.5416877f),
vec2(0.6429226f, -0.261653f),
vec2(0.6138752f, -0.7684944f),
vec2(-0.06001971f, -0.4079638f),
vec2(0.08106154f, -0.07295965f),
vec2(-0.1657472f, -0.2334092f),
vec2(-0.321569f, -0.4737087f),
vec2(-0.3698382f, -0.2639024f),
vec2(-0.2490126f, -0.02925519f),
vec2(-0.4394466f, -0.06632736f),
vec2(-0.6763983f, -0.1978866f),
vec2(-0.5428631f, -0.3784158f),
vec2(-0.3475675f, -0.9118061f),
vec2(-0.1321516f, 0.2153706f),
vec2(-0.3601919f, 0.2372792f),
vec2(-0.604758f, 0.07382818f),
vec2(-0.4872904f, 0.4500539f),
vec2(-0.149702f, 0.5208581f),
vec2(-0.6243932f, 0.2776862f),
vec2(0.4688022f, 0.04856517f),
vec2(0.2485694f, 0.07422727f),
vec2(0.08987152f, 0.4031576f),
vec2(-0.353086f, 0.7864715f),
vec2(-0.6643087f, 0.5534591f),
vec2(-0.8378839f, 0.335448f),
vec2(-0.5260508f, -0.7477183f),
vec2(0.4387909f, 0.3283032f),
vec2(-0.9115909f, -0.3228836f),
vec2(-0.7318214f, -0.5675083f),
vec2(-0.9060445f, -0.09217478f),
vec2(0.9074517f, -0.2449507f),
vec2(0.7957709f, -0.05181496f),
vec2(-0.1518791f, 0.8637156f),
vec2(0.03656881f, 0.8387206f),
vec2(0.02989202f, 0.6311651f),
vec2(0.7933047f, 0.4345242f),
vec2(0.3411767f, 0.5917205f),
vec2(0.7432346f, 0.204537f),
vec2(0.5403291f, 0.6852565f),
vec2(0.6021095f, 0.4647908f),
vec2(-0.5826641f, 0.7287358f),
vec2(-0.9144157f, 0.1417691f),
vec2(0.08989539f, 0.2006399f),
vec2(0.2432684f, 0.8076362f),
vec2(0.4476317f, 0.8603768f),
vec2(0.9842657f, 0.03520538f),
vec2(0.9567313f, 0.280978f),
vec2(0.755792f, 0.6508092f));
/*
vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = 1.0/mix(600.0,120,rainStrength);

	float d = length(fposition);


	float fog =  pow(1.0-exp(-d*density),2.2-rainStrength*1.2);

return color*(1.0-fog*(vec3(1.0,0.3,0.1)+rainStrength*vec3(0.0,0.7,0.9))) + fog*length(avgAmbient)*normalize(fogclr)*(1.0-rainStrength*0.85);	
}
*/
float getAirDensity (float h) {
return (max((h),60.0)-40.0)/2;
}
float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr,float yPosition,float d) {
	float tmult = mix(min(abs(worldTime-6000.0)/6000.0,1.0),1.0,rainStrength);
	float density = (8000.-tmult*tmult*2000.)*0.75;

	vec3 worldpos = (gbufferModelViewInverse*vec4(fposition,1.0)).rgb+cameraPosition;
	float height = mix(getAirDensity (worldpos.y),0.1,rainStrength*0.8);

	float fog =   clamp(14.0*exp(-getAirDensity (yPosition)/density) * (1.0-exp( -d*height/density ))/height-0.24+rainStrength*0.24,0.0,1.);
	vec3 fogC = fogclr*(0.7+0.3*tmult)*(2.0-rainStrength*1.0);
return mix(color,fogC*(1.0-isEyeInWater),fog);	
}

float cdist(vec2 coord) {
	return 1.0-pow(max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0,2.0);
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}
/*--------------------------------*/
vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float getnoise(vec2 pos) {
	return fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f);
}
float invRain07 = 1.0-rainStrength*0.6;


vec3 getSkyColor(vec3 fposition) {
/*--------------------------------*/
vec3 sVector = normalize(fposition);
/*--------------------------------*/

float cosT = dot(sVector,upVec); 
float mCosT = max(cosT,0.0);
float absCosT = 1.0-max(cosT*0.82+0.26,0.2);
float cosS = SdotU;			
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);	
/*--------------------------------*/
const float a = -1.;
const float b = -0.25;
float c = 4.0;
const float d = -2.5;
const float e = 0.3;
/*--------------------------------*/
//luminance
float L =  (1.0+a*exp(b/(mCosT)));
float A = 1.0+e*cosY*cosY;

//gradient
vec3 grad1 = mix(sky1,sky2,absCosT*absCosT);
float sunscat = max(cosY,0.0);
vec3 grad3 = mix(grad1,nsunlight,sunscat*sunscat*(1.0-mCosT)*(1.0-rainStrength*0.5)*(clamp(-(cosS)*4.0+3.0,0.0,1.0)*0.65+0.35)*0.9+0.1);
//if (clamp(-(cosS)*4.0+3.0,0.0,1.0) > 0.2) return vec3(1.0);
//return vec3(sunscat*sunscat*(1.0-sqrt(mCosT*0.9+0.1))*(1.0-rainStrength*0.5)*(clamp(-(cosS)*4.0+3.0,0.0,1.0)*0.8+0.2)*0.9+0.1)*0.1;

float Y2 = 3.14159265359-Y;	
float L2 = L * (8.0*exp(d*Y2)+A);

const vec3 moonlight2 = pow(normalize(moonlight),vec3(3.0))*length(moonlight);
const vec3 moonlightRain = normalize(vec3(0.25,0.3,0.4))*length(moonlight);
vec3 gradN = mix(moonlight,moonlight2,1.-L2/2.0);
gradN = mix(gradN,moonlightRain,rainStrength);

return (1.35*grad3*pow(L*(c*exp(d*Y)+A),invRain07)*sunVisibility*vec3(0.85,0.88,1.0) *pow(length(rawAvg),.4) * (1.0-rainStrength*0.5)+ 0.4*gradN*pow(L2*1.2+1.6,invRain07)*moonVisibility);
}

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr,vec3 rvector) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
	
    vec3 vector = stp * rvector;
    fragpos += vector;
    float sr = 0.0;
	float i = 0.0;
	/*--------------------------------*/
    while (i<16.0) {
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;

        if(pos.x < 0.0 || pos.x > 1.0 || pos.y < 0.0 || pos.y > 1.0 || pos.z < 0.0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(fragpos.z-spos.z);
		if(err < pow(length(vector)*1.5,1.15)){
                sr += 1.0;
                if(sr == maxf){
					bool land = texture2D(depthtex1, pos.st).r < comp;
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    if (isEyeInWater == 0) color = pow(texture2D(gaux1, pos.st),vec4(2.2));
					else color = pow(texture2D(gdepth, pos.st),vec4(2.2));
					vec4 posY = gbufferModelViewInverse*vec4(spos,1.0);
					color.rgb = land ? calcFog(fragpos,color.rgb,fogclr,cameraPosition.y,length(fragpos)) : fogclr*(1.0-isEyeInWater);
					color.a = border;
                    break;
                }
				fragpos -= vector;
                vector *=ref;
				
        
}
else vector *= inc;
fragpos = fragpos + vector;
/*--------------------------------*/
	i += 1.0;
    }
    return color;
}


vec3 Uncharted2Tonemap(vec3 x) {
//tonemapping constants			
float A = 1.3;		
float B = 0.35;		
float C = 0.08;			
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	/*--------------------------------*/
	
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
	//return ((x*(A*x+0.025)+0.006)/(x*(A*x+B)+0.09))-0.06666666666;
}
float waterH(vec3 posxz,float time) {

float wave = 0.0;



const float amplitude = 0.2;

vec4 waveXYZW = vec4(posxz.xz,posxz.xz)/vec4(250.,50.,-250.,-150.)+vec4(50.,250.,50.,-250.);
vec2 fpxy = abs(fract(waveXYZW.xy*20.0)-0.5)*2.0;

float d = amplitude*length(fpxy);

wave = cos(waveXYZW.x*waveXYZW.y+time) + 0.5 * cos(2.0*waveXYZW.x*waveXYZW.y+time) + 0.25 * cos(4.0*waveXYZW.x*waveXYZW.y+time);

return d*wave + d*(cos(waveXYZW.z*waveXYZW.w+time) + 0.5 * cos(2.0*waveXYZW.z*waveXYZW.w+time) + 0.25 * cos(4.0*waveXYZW.z*waveXYZW.w+time));

}

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}
float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

vec3 drawCloud(vec3 fposition,vec3 color,vec3 vH) {
//const vec4 noiseWeights = 1.0/vec4(1.0,3.5,12.25,42.87)/1.4472;
const float r = 3.2;
const vec4 noiseC = vec4(1.0,r,r*r,r*r*r);
const vec4 noiseWeights = 1.0/vec4(1.0,r,r*r,r*r*r)/dot(1.0/vec4(1.0,r,r*r,r*r*r),vec4(1.0));
/*--------------------------------*/
vec3 sVector = normalize(fposition);
float cosT = max(dot(normalize(sVector),upVec),0.0);
float McosY = MdotU;
float cosY = SdotU;
vec3 tpos = vec3(gbufferModelViewInverse * vec4(sVector,0.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
/*--------------------------------*/
vec3 totalcloud = color;
/*--------------------------------*/


vec2 wind = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5))+vec2(0.5);
float iMult = -log(cosT)*2.0+2.0;
float heightA = (400.0+300.0*sqrt(cosT))/(wVector.y);
float cloudC = (0.0);
/*--------------------------------*/	
for (int i = 1;i<22;i++) {
	vec3 intersection = wVector*(heightA-4.0*i*iMult); 			//curved cloud plane
	vec2 coord1 = (intersection.xz)/200000.+wind*0.05;
	vec2 coord = fract(coord1/1.5);
	/*--------------------------------*/
	vec4 noiseSample = vec4(texture2D(noisetex,coord).x,texture2D(noisetex,coord*noiseC.y).x,texture2D(noisetex,coord*noiseC.z).x,texture2D(noisetex,coord*noiseC.w).x);

	
	float noise = dot(noiseSample,noiseWeights);
	/*--------------------------------*/
	coord = vec2(i/22.+0.5,-i/22.+0.5)/noiseTextureResolution + coord.xy + sin(coord.xy*3.14*i/22.)/10. + wind*0.02*(i/21.+0.5);
	vec4 noiseSample2 = vec4(texture2D(noisetex,1.0-coord.yx).x,texture2D(noisetex,1.0-coord.yx*noiseC.y).x,texture2D(noisetex,1.0-coord.yx*noiseC.z).x,texture2D(noisetex,1.0-coord.yx*noiseC.w).x);

	
	float noise2 = dot(noiseSample2,noiseWeights);
	float cl = max((sqrt(noise*noise2*max(1.0-abs(i-11.0)/11*(0.45+rainStrength*0.5),0.0))-0.55*(1.0-rainStrength))/(0.35+rainStrength*2.65)*clamp(cosT*cosT*2.0,0.0,1.0),0.0);

	float cMult = max(pow(30.0-i+5*rainStrength,3.5)/pow(30.+5*rainStrength,3.5),0.0)*6.;

	totalcloud = totalcloud*(1.0-cl)+cl*cMult*mix(cloudColor2,cloudColor,min(cMult,1.0))/7.;
	
}
return totalcloud;

}

vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}


vec3 drawSun(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);

float angle = (1.0-max(dot(sVector,sunVec),0.0))*650;
float sun = exp(-angle*angle*angle);
sun *= (1.0-rainStrength*0.9925)*sunVisibility;
vec3 sunlightB = mix(pow(sunlight,vec3(1.0))*2.2*20.,vec3(0.25,0.3,0.4),rainStrength*0.8);

return mix(color,sunlightB,sun);

}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {


vec2 ntc = texcoord*2.0;
vec2 ntc2 = texcoord*2.0-1.0;
float gr = 0.0;
vec3 c = vec3(0.0);
if (ntc.x < 1.0 && ntc.y < 1.0 && ntc.x > 0.0 && ntc.y > 0.0) {


//remove sky calculations only if the the 4 subpixels at half-resolution are not sky
vec4 dCheck = textureGather(gcolor,ntc,2);
vec4 dCheck2 = textureGather(depthtex1,ntc,0);
bool sky = dot(step(dCheck,vec4(0.0001)),vec4(1.0)) > 0.1;
bool sky2 = dot(step(vec4(comp),dCheck2),vec4(1.0)) > 0.1;
	
if (sky||sky2) {
//supersample skybox
vec4 albedo = texture2D(gaux1,ntc);
vec3 color = pow(albedo.xyz,vec3(2.2));

//color *= albedo.a;

float Depth = texture2D(depthtex1, ntc).x;


vec4 fragpos = gbufferProjectionInverse * (vec4(ntc,Depth,1.0) * 2.0 - 1.0);
fragpos /= fragpos.w;

float cosT = dot(normalize(fragpos.xyz),upVec);
float skyBoxFactor = moonVisibility;


vec3 fogaux1 = getSkyColor(fragpos.xyz);

bool particle = albedo.a > 0.98999 && albedo.a < 0.99991;

 
	c = drawSun(fragpos.xyz,fogaux1+skyBoxFactor*color*0.75);
	if (cosT > 0.0 ) c = drawCloud(fragpos.xyz,c,cameraPosition);
}
		vec2 deltatexcoord = vec2(lightPos - ntc);
		deltatexcoord *= 0.9/20.0;
		vec2 noisetc = ntc + deltatexcoord.xy*getnoise(ntc*2.0);
			
			vec4 Samplee = textureGather(depthtex0, deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 2.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(2*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 3.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(3.*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 4.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(4*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 5.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(5*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 6.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(6*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 7.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(7*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 8.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(8*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 9*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(9*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 10*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(10*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 11*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(11*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 12.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(12*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 13*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(13*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 14.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(14*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 15*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(15*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 16*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(16*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 17*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(17*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 18.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(18*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 19*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(19*deltatexcoord + noisetc);
			
			Samplee = textureGather(depthtex0, 20.0*deltatexcoord + noisetc);
			gr += dot(step(vec4(comp),Samplee),vec4(0.25))*cdist(20*deltatexcoord + noisetc);
			

gr /= 20.0;

/* DRAWBUFFERS:3 */



gl_FragData[0] = vec4(pow(c/257.,vec3(1.0/2.2)),gr);
}







}