#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 worldposition;
varying float isWater;
varying float ambientNdotL;
varying float sunlightMat;
varying float weatherRatio;
varying float skyLightmap;
varying float torchLightmap;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform sampler2DShadow shadow;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform ivec2 eyeBrightnessSmooth;

uniform float frameTimeCounter;

uniform int worldTime;
uniform int isEyeInWater;

uniform float viewWidth;
uniform float viewHeight;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

float waterWaves(vec3 worldPos) {

	float waveSpeed = 0.75;

	vec2 coord = fract(vec2(worldPos.xz / 2000.0));

	float noise =  texture2D(noisetex, coord * 1.5 + vec2(frameTimeCounter / 1000.0 * waveSpeed)).x / 1.5;
		  noise += texture2D(noisetex, coord * 1.5 - vec2(frameTimeCounter / 1000.0 * waveSpeed)).x / 1.5;
		  noise += texture2D(noisetex, coord * 3.5 + vec2(frameTimeCounter / 600.0 * waveSpeed)).x / 3.5;
		  noise += texture2D(noisetex, coord * 3.5 - vec2(frameTimeCounter / 600.0 * waveSpeed)).x / 3.5;
		  noise += texture2D(noisetex, coord * 7.0 + vec2(frameTimeCounter / 300.0 * waveSpeed)).x / 7.0;
		  noise += texture2D(noisetex, coord * 7.0 - vec2(frameTimeCounter / 300.0 * waveSpeed)).x / 7.0;

	return noise;

}

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0);
float TimeMidnight		= ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0)
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));

void main() {

	// Code by Chocapic13.

	float deltaPos = 0.1;
	float h0 = waterWaves(worldposition);
	float h1 = waterWaves(worldposition + vec3(deltaPos,0.0,0.0));
	float h2 = waterWaves(worldposition + vec3(-deltaPos,0.0,0.0));
	float h3 = waterWaves(worldposition + vec3(0.0,0.0,deltaPos));
	float h4 = waterWaves(worldposition + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec3 newnormal = normalize(vec3(xDelta, yDelta, 1.0 - xDelta * xDelta - yDelta * yDelta));

	vec4 frag2 = vec4((normal) * (0.5 - isWater * 0.025) + 0.5, 1.0f);
	
	float NdotE = pow(abs(dot(normal, normalize(position.xyz))), 1.0);

	if (isWater > 0.9) {

		vec3 bump = newnormal;
		float bumpmult = 0.1 * NdotE;

		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);

		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							  tangent.y, binormal.y, normal.y,
							  tangent.z, binormal.z, normal.z);

		frag2 = vec4(normalize(bump * tbnMatrix) * (0.5 - isWater * 0.025) + 0.5, 1.0);

	}

	vec4 baseColor	= texture2D(texture, texcoord.st) * color;
	
	vec4 fragposition	= gbufferProjectionInverse * (vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
	vec4 worldposition	= gbufferModelViewInverse * fragposition;

	vec3 torchColor			= baseColor.rgb * vec3(1.0, 0.7, 0.4) * torchLightmap;
	vec3 newLightmap		= baseColor.rgb * skyLightmap + torchColor;

	baseColor.rgb = newLightmap;

	vec4 watercolor = vec4(0.1, 0.1, 0.1, 0.3);


/* DRAWBUFFERS:526 */

	gl_FragData[0] = mix(baseColor, vec4(baseColor.rgb, 1.0) * watercolor, max(isWater * 2.0 - 1.0, 0.0));
	gl_FragData[1] = frag2;

}
