#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/

#define smoothShadows
#define	useDynamicTonemapping

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 worldposition;
varying float isWater;
varying float ambientNdotL;
varying float sunlightMat;
varying float weatherRatio;
varying float skyLightmap;
varying float torchLightmap;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform sampler2DShadow shadow;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform ivec2 eyeBrightnessSmooth;

uniform float frameTimeCounter;

uniform int worldTime;
uniform int isEyeInWater;

uniform float viewWidth;
uniform float viewHeight;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

float waterWaves(vec3 worldPos) {

	float waveSpeed = 0.75;

	vec2 coord = fract(vec2(worldPos.xz / 2000.0));

	float noise =  texture2D(noisetex, coord * 1.5 + vec2(frameTimeCounter / 1000.0 * waveSpeed)).x / 1.5;
		  noise += texture2D(noisetex, coord * 1.5 - vec2(frameTimeCounter / 1000.0 * waveSpeed)).x / 1.5;
		  noise += texture2D(noisetex, coord * 3.5 + vec2(frameTimeCounter / 600.0 * waveSpeed)).x / 3.5;
		  noise += texture2D(noisetex, coord * 3.5 - vec2(frameTimeCounter / 600.0 * waveSpeed)).x / 3.5;
		  noise += texture2D(noisetex, coord * 7.0 + vec2(frameTimeCounter / 300.0 * waveSpeed)).x / 7.0;
		  noise += texture2D(noisetex, coord * 7.0 - vec2(frameTimeCounter / 300.0 * waveSpeed)).x / 7.0;

	return noise;

}

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight		= ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0)
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));
							  
const vec2 coordsOffsets4[4] = vec2[4](vec2(1.0, 0.0),
									   vec2(0.0, 1.0),

									   vec2(-1.0, 0.0),
									   vec2(0.0, -1.0));

float castShadows(vec4 worldPos) {

	const int shadowMapResolution = 4096;
	
	float shadowSmoothnessFactor	= 0.5;
	float shadowMapBias				= 0.75;	

	float shading	= 0.0;
	float step		= 1.0 / shadowMapResolution;

	if (ambientNdotL > 0.00001) {

		worldPos = shadowModelView * worldPos;
		worldPos = shadowProjection * worldPos;
		worldPos /= worldPos.w;

		float distb = length(worldPos.st);
		float distortFactor = mix(1.0, distb, shadowMapBias);

		worldPos.xy /= distortFactor;

		if (max(abs(worldPos.x), abs(worldPos.y)) < 0.99) {
		
			float diffthresh = sunlightMat > 0.9? 0.001 : distortFactor * distortFactor * (0.006 * tan(acos(ambientNdotL)) + 0.0006);

			worldPos = worldPos * 0.5f + vec4(0.5, 0.5, 0.5 - diffthresh, 0.5);

			#ifdef smoothShadows

				for(int i = 0; i < 4; i++) {	// Repeat the shading variable with different coords.

					shading += dot(shadow2D(shadow, vec3(worldPos.st + coordsOffsets4[i] * shadowSmoothnessFactor * step, worldPos.z)).x, pow(ambientNdotL, 0.5));

				}

				shading /= 4.0;

			#else

				shading = dot(shadow2D(shadow, vec3(worldPos.st, worldPos.z)).x, pow(ambientNdotL, 0.5));

			#endif


		} else {
		
			shading = dot(1.0, pow(ambientNdotL, 0.5));
		
		}
		
	}
	
	// Remove shadows, when the player is underwater.
	if (isEyeInWater > 0.9) shading = 0.0;

	return shading;

}

float dynamicTonemapping(float exposureStrength, bool reserveLightmap, bool addExposure, bool dayOnly) {

	float dTonemap = 1.0;

	#ifdef useDynamicTonemapping
	
		float dTlightmap	= pow(eyeBrightnessSmooth.y / 240.0, 2.0);		if (reserveLightmap)	dTlightmap 	= 1.0 - dTlightmap;
			  dTonemap		= dTlightmap * exposureStrength;				if (addExposure)		dTonemap	= 1.0 + dTonemap;		if (dayOnly)	dTonemap = mix(dTonemap, 1.0, TimeMidnight);	// Full exposure on midnight.

	#endif
	
	return dTonemap;

}

void main() {

	// Code by Chocapic13.

	float deltaPos = 0.1;
	float h0 = waterWaves(worldposition);
	float h1 = waterWaves(worldposition + vec3(deltaPos,0.0,0.0));
	float h2 = waterWaves(worldposition + vec3(-deltaPos,0.0,0.0));
	float h3 = waterWaves(worldposition + vec3(0.0,0.0,deltaPos));
	float h4 = waterWaves(worldposition + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec3 newnormal = normalize(vec3(xDelta, yDelta, 1.0 - xDelta * xDelta - yDelta * yDelta));

	vec4 frag2 = vec4((normal) * (0.5 - isWater * 0.025) + 0.5, 1.0f);
	
	float NdotE = pow(abs(dot(normal, normalize(position.xyz))), 1.0);

	if (isWater > 0.9) {

		vec3 bump = newnormal;
		float bumpmult = 0.1 * NdotE;

		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);

		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							  tangent.y, binormal.y, normal.y,
							  tangent.z, binormal.z, normal.z);

		frag2 = vec4(normalize(bump * tbnMatrix) * (0.5 - isWater * 0.025) + 0.5, 1.0);

	}

	vec4 baseColor = texture2D(texture, texcoord.xy) * color;


	vec4 fragposition	= gbufferProjectionInverse * (vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
	vec4 worldposition	= gbufferModelViewInverse * fragposition;

	// Adjustable variables.
	float ambientStrength		= 0.8;
	float sunlightStrength		= 1.3;

	// Set up colors.
	vec3 ambient_Color  = vec3(0.0);
		 ambient_Color += vec3(0.75, 0.8, 1.0)	* 0.6	* TimeSunrise;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeNoon;
		 ambient_Color += vec3(0.75, 0.8, 1.0)	* 0.6	* TimeSunset;
		 ambient_Color += vec3(0.6, 0.75, 1.0)	* 0.13	* TimeMidnight;

		 ambient_Color *= 1.0 - weatherRatio;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeSunrise	* weatherRatio;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeNoon		* weatherRatio;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeSunset	* weatherRatio;
		 ambient_Color += vec3(0.6, 0.75, 1.0)	* 0.13 	* TimeMidnight	* weatherRatio;

	vec3 sunlight_Color  = vec3(0.0);
		 sunlight_Color += vec3(1.0, 0.7, 0.5)	* 0.6	* TimeSunrise;
		 sunlight_Color += vec3(1.0, 0.9, 0.8)			* TimeNoon;
		 sunlight_Color += vec3(1.0, 0.7, 0.5)	* 0.6	* TimeSunset;
		 sunlight_Color += vec3(0.6, 0.75, 1.0)	* 0.05	* TimeMidnight;
		 sunlight_Color *= DayToNightFading;
		 sunlight_Color *= 1.0 - weatherRatio;
		 
	vec3 torch_Color = vec3(1.0, 0.65, 0.4);
	
	vec4 watercolor = vec4(0.1, 0.1, 0.1, 0.3);

	// Desature ambient color at nighttime.
	float saturation = (1.0 - TimeMidnight * 0.5) + (torchLightmap * TimeMidnight * 0.5);
	float luma = dot(baseColor.rgb, vec3(1.0));
	vec3 chroma = baseColor.rgb - luma;
	vec3 noLight = (chroma * saturation) + luma;

	vec3 newTorchLightmap	= baseColor.rgb * torch_Color * torchLightmap;
	vec3 ambientLightmap	= noLight.rgb * ambient_Color * ambientStrength;
	vec3 sunlightLightmap	= noLight.rgb * sunlight_Color * castShadows(worldposition) * sunlightStrength;

	ambientLightmap		   *= dynamicTonemapping(0.75, true, true, true);
	sunlightLightmap	   *= dynamicTonemapping(0.75, true, true, true);

	vec3 newLightmap		= (ambientLightmap + sunlightLightmap) * skyLightmap + newTorchLightmap;
	
/* DRAWBUFFERS:5267 */

	gl_FragData[0] = mix(vec4(newLightmap, baseColor.a), vec4(baseColor.rgb, 1.0) * watercolor, max(isWater * 2.0 - 1.0, 0.0));
	gl_FragData[1] = frag2;
	gl_FragData[2] = vec4(skyLightmap, 1.0, 1.0, 1.0);	// gaux3

}
