#version 120

uniform sampler2D texture;

uniform float frameTimeCounter;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;

varying vec3 tangent;
varying vec3 binormal;
varying vec3 normal;
varying vec3 worldpos;

varying float viewdistance;
varying float iswater;
varying float icewater;

vec3 stokes(in float ka, in vec3 k, in vec3 g) {
    // ka = wave steepness, k = displacements, g = gradients / wave number
    float theta = k.x + k.z + k.t;
    float s = ka * (sin(theta) + ka * sin(2.0 * theta));
    return vec3(s * g.x, s * g.z, g.t);  // (-deta/dx, -deta/dz, scale)
}

vec3 waves1() {
    float scale = 8.0 / (viewdistance * viewdistance);
    vec3 gg = vec3(scale, 3600.0, scale);
    vec3 gk = vec3(viewdistance * 6.0, frameTimeCounter * -6.0, 0.0);
    vec3 gwave = stokes(6.0, gk, gg);
    return normalize(gwave);
}

vec3 waves2() {
    vec3 gg = vec3(1.897, 320.0, 0.632 - 0.75 * 0.33 * cos(worldpos.z * 0.33));
    vec3 gk = vec3(worldpos.x * 1.897, frameTimeCounter * 4.0, worldpos.z * -0.632 - 0.75 * sin(worldpos.z * 0.33));
    vec3 gwave = stokes(2.0, gk, gg);
    
    vec3 cg = vec3(2.846 + 1.2 * cos(worldpos.x * 0.6), 540.0, 0.949);
    vec3 ck = vec3(worldpos.x * 2.846 + 2.0 * sin(worldpos.x * 0.6), frameTimeCounter * 5.0 + 0.2, worldpos.z * 0.949);
    vec3 cwave = stokes(1.6, ck, cg);
    
    return normalize(gwave + cwave);
}

vec3 waves3() {
    vec3 gg = vec3(0.949, 50.0, 0.316 + 0.75 * 0.33 * cos(worldpos.z * 0.33));
    vec3 gk = vec3(worldpos.x * 0.949, frameTimeCounter * 4.0, worldpos.z * -0.316 + 0.75 * sin(worldpos.z * 0.33));
    vec3 gwave = stokes(1.2, gk, gg);
    
    vec3 cg = vec3(1.423 + 0.7 * cos(worldpos.x * 0.7), 120.0, 0.474);
    vec3 ck = vec3(worldpos.x * 1.423 + 1.0 * sin(worldpos.x * 0.7), frameTimeCounter * 5.0 + 0.1, worldpos.z * 0.474);
    vec3 cwave = stokes(1.0, ck, cg);
    
    return normalize(gwave + cwave);
}

float smoothStep(in float edge0, in float edge1, in float x) {
    float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
    return t * t * (3.0 - 2.0 * t);
}

//////////////////////////////main//////////////////////////////

void main() {
    vec4 frag1 = vec4(normal * 0.5 + 0.5, 1.0);
    vec4 frag2;
    vec4 frag3 = frag2 = frag1;
    vec4 tex = texture2D(texture, texcoord.xy);
    if (iswater > 0.9) {
        tex = mix(tex, vec4(0.02, 0.03, 0.14, 0.85), 0.5); // Tint water texture with standard color
        mat3 tbnMatrix = mat3(tangent, binormal, normal);
        vec4 bump1 = vec4(tbnMatrix * waves1() * 0.5 + 0.5, 1.0);
        vec4 bump2 = vec4(tbnMatrix * waves2() * 0.5 + 0.5, 1.0);
        frag2 = mix(bump1, bump2, 0.5 + 0.5 * smoothStep(5.0, 10.0, viewdistance));
        vec3 bump3 = waves3();
        frag3 = vec4(tbnMatrix * bump3 * 0.5 + 0.5, 1.0);
    }
    
/* DRAWBUFFERS:01234 */
    gl_FragData[0] = vec4(vec3(clamp(lmcoord.t + lmcoord.s, 0.25, 1.0)), 1.0) * tex * color;
    gl_FragData[1] = frag1; // Reflection heavily bump normal
    gl_FragData[2] = mix(frag2, frag3, smoothStep(20.0, 36.0, viewdistance)); // frag3 - fewer waves
    gl_FragData[3] = gl_FragData[0];
    gl_FragData[4] = vec4(0.0, icewater, lmcoord.s, 1.0); // x = spec; y = basic, textured(0.0), shadow exit(0.1), lit(0.3), hand(0.4), entity(0.6), ice(0.9), water(1.0); z = torch lightmap; w = 1.0 opacity
}

//////////////////////////////main//////////////////////////////
