#version 120

uniform sampler2D texture;

uniform int fogMode;

varying vec4 color;
varying vec4 texcoord;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

//////////////////////////////main//////////////////////////////

void main() {
    gl_FragDepth = 1.0;

    float fogFactor = float(GL_EXP == fogMode) * (1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
    fogFactor += float(GL_LINEAR == fogMode) * clamp(1.0 * (gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
    
/* DRAWBUFFERS:034 */
    gl_FragData[0] = texture2D(texture, texcoord.xy) * color;
    gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, fogFactor);
    gl_FragData[1] = gl_FragData[0];
    gl_FragData[2] = vec4(0.0, 0.0, 0.0, 1.0); // x = spec; y = basic, textured(0.0), shadow exit(0.1), lit(0.3), hand(0.4), entity(0.6), ice(0.9), water(1.0); z = torch lightmap; w = opacity
}
