#version 120

varying vec4 texcoord;

varying vec3 whitelens;
varying vec3 redlens;
varying vec3 bluelens;

varying vec2 lightPos;
varying vec2 moonPos;

varying float sunTransition;
varying float moonTransition;
varying float lensTransition;

uniform mat4 gbufferProjection;

uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform float aspectRatio;
uniform float rainStrength;

uniform int worldTime;

//////////////////////////////main//////////////////////////////

void main() {
    gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
    
    texcoord = gl_MultiTexCoord0;
    
    vec4 tpos = vec4(sunPosition, 1.0) * gbufferProjection;
    lightPos = (tpos.xy / tpos.z) * 0.5 + 0.5;
    
    vec4 spos = vec4(moonPosition, 1.0) * gbufferProjection;
    moonPos = (spos.xy / spos.z) * 0.5 + 0.5;

    float wtime = float(worldTime);
    sunTransition = (1.0 - rainStrength * 0.95) * (clamp((14200.0 - wtime) / 600.0, 0.0, 1.0) + clamp((wtime - 22350.0) / 400.0, 0.0, 1.0));
    moonTransition = (1.0 - rainStrength * 0.95) * (clamp((600.0 - wtime) / 600.0, 0.0, 1.0) + clamp((wtime - 12050.0) / 400.0, 0.0, 1.0));
    lensTransition = clamp((12300.0 - wtime) / 300.0, 0.0, 1.0) + clamp((wtime - 23700.0) / 300.0, 0.0, 1.0);
    
    const float white = 0.75;
    whitelens = vec3(lightPos.x * aspectRatio * white, lightPos.y * white, white);

    const float red = 1.8;
    const float redPos = -0.523;
    redlens = vec3(((1.0 - lightPos.x) * (redPos + 1.0) - (redPos * 0.5)) * aspectRatio * red, ((1.0 - lightPos.y) * (redPos + 1.0) - (redPos * 0.5)) * red, red);

    const float blue = 1.4;
    const float bluePos = -0.123;
    bluelens = vec3(((1.0 - lightPos.x) * (bluePos + 1.0) - (bluePos * 0.5)) * aspectRatio * blue, ((1.0 - lightPos.y) * (bluePos + 1.0) - (bluePos * 0.5)) * blue, blue);
}

//////////////////////////////main//////////////////////////////
