#version 120

#define MOTIONBLUR
#define MOTIONBLUR_AMOUNT 0.1

#define DEPTH_OF_FIELD
#define USE_HIGH_QUALITY_BLUR

#define SUNRAYS
#define MOONRAYS

#define BLOOM
#define BLOOM_AMOUNT 12.0

#define LENS

#define CROSSPROCESS
#define CROSSPROCESS_AMOUNT 0.5

varying vec4 texcoord;

varying vec3 whitelens;
varying vec3 redlens;
varying vec3 bluelens;

varying vec2 lightPos;
varying vec2 moonPos;

varying float sunTransition;
varying float moonTransition;
varying float lensTransition;

uniform sampler2D gcolor;
uniform sampler2D gaux3;
uniform sampler2D depthtex0;

uniform vec3 moonPosition;  // used by moon rays
uniform vec3 sunPosition;   // used by lens and sun rays

uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;

uniform int worldTime;
uniform int isEyeInWater;

float pw = 1.0 / viewWidth;
float ph = 1.0 / viewHeight;

float getDepth(in vec2 coord) {
    return 2.0 * near * far / (far + near - (2.0 * texture2D(depthtex0, coord).x - 1.0f) * (far - near));
}

#ifdef DEPTH_OF_FIELD
// HYPERFOCAL = (Focal Distance ^ 2)/(Circle of Confusion * F Stop) + Focal Distance
const float HYPERFOCAL = 3.132;
const float PICONSTANT = 3.14159;
vec4 getBlurredColor();
#endif

const float GR_DENSITY = 0.7;
const float GR_EXPOSURE = 0.4;
const float GR_FREQUENCY = 0.05;

//////////////////////////////main//////////////////////////////

void main() {
	vec4 color = texture2D(gcolor, texcoord.st);
#ifdef MOTIONBLUR
    vec2 velocity = texture2D(gaux3, texcoord.st).xy;
    velocity.x = pow(velocity.x, 0.333333333) * 2.0 - 1.0;
    velocity.y = pow(velocity.y, 0.333333333) * 2.0 - 1.0;
    float speed = length(velocity * vec2(viewWidth, viewHeight)) * MOTIONBLUR_AMOUNT;
    int nsamples = int(clamp(speed, 1.00001, 20.00001));
    velocity = normalize(velocity) * vec2(pw, ph) * MOTIONBLUR_AMOUNT;
    vec2 limit = texcoord.st + velocity * (float(nsamples) * 0.5 + 0.5);
    float fade = 1.0;
    float weight = 1.0;
    for (int k = 1; k < nsamples; ++k) {
        vec2 offset = limit + velocity * float(k);
        color += texture2D(gcolor, offset) * fade;
        weight += fade;
        fade *= 0.9;
    }
    color /= weight;
#endif
#ifdef DEPTH_OF_FIELD
    float depth = getDepth(texcoord.st);
    float cursorDepth = getDepth(vec2(0.5, 0.5));
    
    // foreground blur = 1/2 background blur. Blur should follow exponential pattern until cursor = hyperfocal -- Cursor before hyperfocal
    // Blur should go from 0 to 1/2 hyperfocal then clear to infinity -- Cursor @ hyperfocal.
    // hyperfocal to inifity is clear though dof extends from 1/2 hyper to hyper -- Cursor beyond hyperfocal
    float mixAmount = 0.0;
    if (depth < cursorDepth) {
        mixAmount = clamp(2.0 * ((min(cursorDepth, HYPERFOCAL) - depth) / min(cursorDepth, HYPERFOCAL)), 0.0, 0.66);
    } else {
        mixAmount =  1.0 - clamp(2.0 - depth / cursorDepth + depth / HYPERFOCAL - cursorDepth / HYPERFOCAL, 0.0, 0.66);
    }
    color = mix(color, getBlurredColor(), mixAmount);
#endif
#ifdef SUNRAYS
    float skymask = texture2D(gcolor, vec2(1.0)).a;
    if ((worldTime > 22350 || worldTime < 14200) && sunPosition.z < 0.0 && skymask > 0.0) {
        vec2 tex = texcoord.st;
        vec2 delta = (lightPos - tex);
        float decay = max(1.0 - length(delta), 0.00001);
        delta *= GR_DENSITY * GR_FREQUENCY;
        vec3 rays = vec3(0.0);
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        
        color.rgb += rays * GR_FREQUENCY * GR_EXPOSURE * sunTransition * decay * decay;
    }
#endif
#ifdef MOONRAYS
    if ((worldTime > 12050 || worldTime < 600) && moonPosition.z < 0.0) {
        vec2 tex = texcoord.st;
        vec2 delta = (moonPos - tex);
        float decay = max(1.0 - length(delta), 0.00001);
        delta *= GR_DENSITY * GR_FREQUENCY;
        vec3 rays = vec3(0.0);
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        tex += delta;
        rays += texture2D(depthtex0, tex).x * texture2D(gcolor, tex).rgb;
        
        color.rgb += rays * 0.4 * GR_FREQUENCY * GR_EXPOSURE * moonTransition * decay * decay;
    }
#endif
#ifdef BLOOM
	vec4 sum = vec4(0.0);
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.016, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.016, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.016, 0.004), 0.0, 1.0));
    
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.012, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.012, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.012, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.012, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.012, 0.008), 0.0, 1.0));
    
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, -0.012), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, 0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.008, 0.012), 0.0, 1.0));

    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, -0.012), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, 0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(-0.004, 0.012), 0.0, 1.0));

    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, -0.012), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, 0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.0, 0.012), 0.0, 1.0));

    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, -0.012), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, 0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.004, 0.012), 0.0, 1.0));

    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, -0.012), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, 0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.008, 0.012), 0.0, 1.0));

    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.012, -0.008), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.012, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.012, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.012, 0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.012, 0.008), 0.0, 1.0));
    
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.016, -0.004), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.016, 0.0), 0.0, 1.0));
    sum += texture2D(gcolor, clamp(texcoord.st + vec2(0.016, 0.004), 0.0, 1.0));
    
    sum = sum * sum * 0.0003844675125 * BLOOM_AMOUNT; // divide by squared 51.0;
    color += sum * (0.012 - color.r * 0.006);
#endif
#ifdef LENS
    float white = distance(whitelens.xy, vec2(texcoord.s * aspectRatio * whitelens.z, texcoord.t * whitelens.z));
    float scale = 1.0 - white * 0.5;  // scale the blue/red lens effects down away from sun
    white = max(0.00001, 1.0 - white * 2.0);
    white *= white * white;
    white *= 0.2 * (1.0 - rainStrength) * lensTransition * step(0.0, moonPosition.z);    // remove moon dark circle
    color.rgb += mix(0.0, white, color.b) * (float(isEyeInWater) * 5.0 - 1.0);   // underwater shine

    float sunmask = texture2D(gcolor, vec2(0.0)).a;
    float red = distance(redlens.xy, vec2(texcoord.s * aspectRatio * redlens.z, texcoord.t * redlens.z));
    red = max(0.00001, 1.0 - red * 2.0);
    red *= red * red;
    red *= sunmask * scale;
    color.r += red * 0.8;
    color.g += red * 0.2;
    
    float blue = distance(bluelens.xy, vec2(texcoord.s * aspectRatio, texcoord.t) * bluelens.z);
    blue = max(0.00001, 1.0 - blue * 2.0);
    blue *= blue * blue;
    blue *= sunmask * 0.7 * scale;
    color.r += blue * 0.64;
    color.g += blue * 0.2;
    color.b += blue * 1.5;
#endif
#ifdef CROSSPROCESS
    color.r += CROSSPROCESS_AMOUNT * (color.r * 0.15 - 0.02);
    color.g += CROSSPROCESS_AMOUNT * (color.g * 0.15 - 0.02);
    color.b += CROSSPROCESS_AMOUNT * (color.b * -0.15 + 0.05);

    float lum = (0.299 * color.r) + (0.587 * color.g) + (0.114 * color.b);
    color.rgb = mix(vec3(lum), color.rgb, 0.75 + 0.25 * lensTransition - 0.1 * texture2D(depthtex0, texcoord.st).x * rainStrength);   // desaturate during night and rain
#endif
    gl_FragColor = vec4(color.rgb, 1.0);
}

//////////////////////////////main//////////////////////////////

#ifdef DEPTH_OF_FIELD
vec4 getBlurredColor() {
	vec4 blurredColor = vec4(0.0);
	float depth = getDepth(texcoord.xy);
	vec2 aspectCorrection = vec2(1.0f, aspectRatio) * 0.005;
	vec2 ac0_4 = 0.4 * aspectCorrection;	// 0.4
#ifdef USE_HIGH_QUALITY_BLUR
	vec2 ac0_4x0_4 = 0.4 * ac0_4;		// 0.16
	vec2 ac0_4x0_7 = 0.7 * ac0_4;		// 0.28
#endif
	vec2 ac0_29 = 0.29 * aspectCorrection;	// 0.29
#ifdef USE_HIGH_QUALITY_BLUR
	vec2 ac0_29x0_7 = 0.7 * ac0_29;	// 0.203
	vec2 ac0_29x0_4 = 0.4 * ac0_29;	// 0.116
#endif
	vec2 ac0_15 = 0.15 * aspectCorrection;	// 0.15
	vec2 ac0_37 = 0.37 * aspectCorrection;	// 0.37
#ifdef USE_HIGH_QUALITY_BLUR
	vec2 ac0_15x0_9 = 0.9 * ac0_15;	// 0.135
	vec2 ac0_37x0_9 = 0.37 * ac0_37;	// 0.1369
#endif
    blurredColor += texture2D(gcolor, texcoord.st + vec2(0.0, ac0_4.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_4.s, 0.0));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(0.0, -ac0_4.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_4.s, 0.0));
#ifdef USE_HIGH_QUALITY_BLUR
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_4x0_7.s, 0.0));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(0.0, -ac0_4x0_7.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_4x0_7.s, 0.0));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(0.0, ac0_4x0_7.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_4x0_4.s, 0.0));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(0.0, -ac0_4x0_4.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_4x0_4.s, 0.0));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(0.0, ac0_4x0_4.t));
#endif
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_29.s, -ac0_29.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_29.s, ac0_29.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_29.s, ac0_29.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_29.s, -ac0_29.t));
#ifdef USE_HIGH_QUALITY_BLUR
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_29x0_7.s, ac0_29x0_7.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_29x0_7.s, -ac0_29x0_7.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_29x0_7.s, ac0_29x0_7.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_29x0_7.s, -ac0_29x0_7.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_29x0_4.s, ac0_29x0_4.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_29x0_4.s, -ac0_29x0_4.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_29x0_4.s, ac0_29x0_4.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_29x0_4.s, -ac0_29x0_4.t));
#endif
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_15.s, ac0_37.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_37.s, ac0_15.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_37.s, -ac0_15.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_15.s, -ac0_37.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_15.s, ac0_37.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_37.s, ac0_15.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_37.s, -ac0_15.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_15.s, -ac0_37.t));
#ifdef USE_HIGH_QUALITY_BLUR
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_15x0_9.s, ac0_37x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_37x0_9.s, ac0_15x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_37x0_9.s, -ac0_15x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_15x0_9.s, -ac0_37x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_15x0_9.s, ac0_37x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_37x0_9.s, ac0_15x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(-ac0_37x0_9.s, -ac0_15x0_9.t));
    blurredColor += texture2D(gcolor, texcoord.st + vec2(ac0_15x0_9.s, -ac0_37x0_9.t));
#endif
#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor *= 0.02439;	// /= 41.0;
#else
		blurredColor *= 0.0625;	// /= 16.0;
#endif
	return blurredColor;
}
#endif
