#version 120

varying vec4 texcoord;

varying vec4 lightVector;
varying vec3 sunlight;

varying vec3 caustics;

varying float transition_fading;
varying float fog_level;
varying float groundFog_level;
varying float gp00;
varying float gp11;
varying float gp22;
varying float gp32;
varying float gp2232;
varying float igp00;
varying float igp11;

uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;

uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform int worldTime;

//////////////////////////////main//////////////////////////////

void main() {
    gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
    
    texcoord = gl_MultiTexCoord0;
    
    float wtime = float(worldTime);
    transition_fading = 1.0 - (clamp((wtime - 12100.0) / 300.0, 0.0, 1.0) - clamp((wtime - 13200.0) / 300.0, 0.0, 1.0) + clamp((wtime - 22500.0) / 300.0, 0.0, 1.0) - clamp((wtime - 23600.0) / 300.0, 0.0, 1.0));
    
    if (worldTime < 12800 || worldTime > 23200) {
        lightVector.xyz = normalize(sunPosition);
        lightVector.a = 0.5;   // distance fog
    }
    else {
        lightVector.xyz = normalize(moonPosition);
        lightVector.a = 1.0;   // moon glow
    }
    lightVector.a = mix(1.5, lightVector.a, transition_fading);

    float hour = wtime / 1000.0 + 6.0;
    if (hour > 24.0) hour = hour - 24.0;
    
    ////////////////////sunlight color////////////////////
    const ivec4 ToD[25] = ivec4[25](ivec4(0,15,30,70), //hour,r,g,b
                                    ivec4(1,15,30,70),
                                    ivec4(2,15,30,70),
                                    ivec4(3,15,30,70),
                                    ivec4(4,15,30,70),
                                    ivec4(5,50,60,80),
                                    ivec4(6,245,190,70),
                                    ivec4(7,255,195,80),
                                    ivec4(8,255,200,97),
                                    ivec4(9,255,210,110),
                                    ivec4(10,255,215,125),
                                    ivec4(11,255,225,140),
                                    ivec4(12,255,235,150),
                                    ivec4(13,255,225,140),
                                    ivec4(14,255,215,125),
                                    ivec4(15,255,210,110),
                                    ivec4(16,255,200,97),
                                    ivec4(17,255,195,80),
                                    ivec4(18,245,190,70),
                                    ivec4(19,77,67,194),
                                    ivec4(20,15,30,70),
                                    ivec4(21,15,30,70),
                                    ivec4(22,15,30,70),
                                    ivec4(23,15,30,70),
                                    ivec4(24,15,30,70));
    ivec4 temp = ToD[int(floor(hour))];
    ivec4 temp2 = ToD[int(floor(hour)) + 1];
    
    sunlight = mix(vec3(temp.yzw), vec3(temp2.yzw), (hour - float(temp.x)) / float(temp2.x - temp.x)) / 255.0;
//    sunlight *= pow(abs(hour - 18.8) * abs(hour - 5.2), 0.3) * 0.12;     // dawn and dusk
    
    vec4 clight = gbufferModelView * vec4(50.0, 1.0, 0.0, 1.0);
    clight /= clight.w;
    caustics = normalize(clight.xyz);
    
    fog_level = 0.75 + sin(hour / 12.0 * 3.141597) * 0.25;
    groundFog_level = 0.75 + sin((hour + 6.0) / 12.0 * 3.141597) * 0.25;
    
    gp00 = gbufferProjection[0][0] * -0.5;
    gp11 = gbufferProjection[1][1] * -0.5;
    gp22 = gbufferProjection[2][2] * 0.5;
    gp32 = gbufferProjection[3][2] * 0.5;
    gp2232 = -gp22 - gp32;
    igp00 = -1.0 / gp00;
    igp11 = -1.0 / gp11;
}

//////////////////////////////main//////////////////////////////
