#version 120

#define PERLIN_CLOUD

const int gcolorFormat = 1; // Internal - RGB8
const int gdepthFormat = 1; // Internal - RGB8
const int gnormalFormat = 2; // Internal - RGB16
const int compositeFormat = 1; // Internal - RGB8
const float	ambientOcclusionLevel = 0.1;   // Internal
const float	sunPathRotation	= -23.4;   // Internal

const int shadowMapResolution = 4096;   // Internal
const float shadowDistance = 128.0; // Internal
const bool shadowHardwareFiltering = true;
const float shadowIntervalSize = 4.0f;
const int noiseTextureResolution = 64;

#define SUNLIGHTAMOUNT 1.1

const vec3 torchcolor = vec3(1.2,0.39,0.02);

#define TORCH_POWER 4.0
#define TORCH_INTENSITY 2.0

varying vec4 texcoord;
varying vec4 lmcoord;

varying vec3 lightVector;
varying vec3 lightOffset0;
varying vec3 lightOffset3;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying vec3 heldLightSpecMultiplier;

varying float heldLightMagnitude;
varying float transition_fading;
varying float ambient_transition;

uniform sampler2D gcolor;
uniform sampler2D gdepth;   // specularity - red green blue gloss
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex2;
uniform sampler2DShadow shadow;
uniform sampler2D watershadow;
uniform sampler2D shadowcolor;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform vec3 upPosition;
uniform vec3 cameraPosition;

uniform float far;
uniform float near;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;

uniform int isEyeInWater;

float gp22 = gbufferProjection[2][2] * 0.5;
float gp32 = gbufferProjection[3][2] * 0.5;
float igp00 = 2.0 / gbufferProjection[0][0];
float igp11 = 2.0 / gbufferProjection[1][1];

vec3 invproj(in vec3 p) {
    vec3 pos = p - 0.5;
    float z = gp32 / (pos.z + gp22);
    return vec3(pos.x * igp00, pos.y * igp11, -1.0) * z;
}

float nspec(in vec3 pos, in vec3 lvector, in vec3 normal) {
    
    // half vector
    vec3 cHalf = normalize(lvector + pos);
    float normalDotHalf = dot(normal, cHalf);
    
    // beckmann's distribution function D
    float normalDotHalf2 = normalDotHalf * normalDotHalf;
    float roughness2 = 0.25;
    float exponent = -(1.0 - normalDotHalf2) / (normalDotHalf2 * roughness2);
    float D = exp(exponent) / (roughness2 * normalDotHalf2 * normalDotHalf2);
	
    // fresnel term F
    float halfDotEye = dot(cHalf, pos);
    float F = clamp(pow(1.0 - halfDotEye, 5.0), 0.0, 1.0);
    
    // self shadowing term G
    float normalDotEye = dot(normal, pos);
    float normalDotLight = dot(normal, lvector);
    float X = 2.0 * normalDotHalf / halfDotEye;
    float G = min(1.0, min(X * normalDotLight, X * normalDotEye));
    const float pi = 3.1415927;
    float CookTorrance = (D * F * G) / (pi * normalDotEye);
	
    return max(CookTorrance / pi, 0.00001);
}

float ld(in float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

//////////////////////////////main//////////////////////////////

void main() {
    vec3 color = texture2D(gcolor, texcoord.st).rgb;
    vec3 compo = texture2D(composite, texcoord.st).rgb;
    float spec = 0.0;

    vec4 aux = texture2D(gaux1, texcoord.st);
    float no_hand = float(aux.g < 0.35 || aux.g > 0.45);
    
    if (isEyeInWater < 1) {
        const float fland = 0.05;
        if (aux.g > fland) {
            vec3 total_effect = mix(vec3(0.22), ambient_color, 0.22); // sky and indoor ambient light

            vec3 shading = vec3(1.0);
            vec3 eye = invproj(vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r));
            float dist = length(eye);
            vec4 wpos = gbufferModelViewInverse * vec4(eye, 1.0);
            vec4 warp = shadowModelView * wpos;
            float comparedepth = -warp.z;
            warp = shadowProjection * warp;
//            warp.x = mix(warp.x, sin(1.5708f * warp.x), 0.5);   // shadow bias
//            warp.y = mix(warp.y, sin(1.5708f * warp.y), 0.5);   // shadow bias
            warp /= warp.w;
            vec2 shadowPos = warp.st * 0.5 + 0.5;
            const float fshadow = 0.15;
            float translucent = float(aux.g > 0.25 && aux.g < 0.35);
            if (dist < shadowDistance && comparedepth > 0.0 && aux.g > fshadow && shadowPos.s < 1.0 && shadowPos.s > 0.0 && shadowPos.t < 1.0 && shadowPos.t > 0.0) {
                const vec2 circle_offset0 = vec2(-0.875, 0.875);  // shadow sampling
                const vec2 circle_offset1 = vec2(-0.5, 0.125);
                const vec2 circle_offset2 = vec2(-0.125, -0.75);
                const vec2 circle_offset3 = vec2(0.375, 0.5);
                const vec2 circle_offset4 = vec2(0.75, -0.375);
                float offset = 0.5 / float(shadowMapResolution);
                float diffthresh = warp.z * 0.5 + 0.5 - 0.1 / far;
                
                float shadingwater = 0.0f;
                shadingwater += clamp(comparedepth - (0.05f + texture2D(watershadow, shadowPos + circle_offset0 * offset).z * 255.95f), 0.0f, 1.0f);
                shadingwater += clamp(comparedepth - (0.05f + texture2D(watershadow, shadowPos + circle_offset1 * offset).z * 255.95f), 0.0f, 1.0f);
                shadingwater += clamp(comparedepth - (0.05f + texture2D(watershadow, shadowPos + circle_offset2 * offset).z * 255.95f), 0.0f, 1.0f);
                shadingwater += clamp(comparedepth - (0.05f + texture2D(watershadow, shadowPos + circle_offset3 * offset).z * 255.95f), 0.0f, 1.0f);
                shadingwater += clamp(comparedepth - (0.05f + texture2D(watershadow, shadowPos + circle_offset4 * offset).z * 255.95f), 0.0f, 1.0f);
                shadingwater = max(0.0f, 1.0f - shadingwater * 0.4f);
                
                float shadingsharp = 0.0;
                shadingsharp += shadow2D(shadow, vec3(shadowPos + circle_offset0 * offset, diffthresh)).r;
                shadingsharp += shadow2D(shadow, vec3(shadowPos + circle_offset1 * offset, diffthresh)).r;
                shadingsharp += shadow2D(shadow, vec3(shadowPos + circle_offset2 * offset, diffthresh)).r;
                shadingsharp += shadow2D(shadow, vec3(shadowPos + circle_offset3 * offset, diffthresh)).r;
                shadingsharp += shadow2D(shadow, vec3(shadowPos + circle_offset4 * offset, diffthresh)).r;
                shadingsharp = shadingsharp * 0.2;
                
                vec3 shadowColorSample = mix(texture2D(shadowcolor, shadowPos).rgb, vec3(1.2), 0.25);
                shading = shadowColorSample * (shadingsharp - shadingwater) + shadingwater;
            }
            shading = clamp(shading, 0.0, 1.0);
            vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;
            float NdotL = dot(normal, lightVector);
            float sss_transparency = 0.75 * translucent; //subsurface scattering amount
            vec3 neye = normalize(eye);
            float sss = pow(max(dot(neye, lightVector), 0.00001), 20.0) * sss_transparency * clamp(-NdotL, 0.0, 1.0) * 4.0;
            float distof2 = clamp(1.0 - dist / (shadowDistance * 0.75), 0.0, 1.0);
            float sss_fade = pow(distof2, 0.2);
            sss = mix(0.0, sss, min(sss_fade + 0.5, 1.0));
            total_effect += sss * sunlight_color * shading * (1.0 - rainStrength * 0.9) * ambient_transition; // sub surface scattering light
            
            float shadow_fade = clamp(12.0 * (1.0 - dist / shadowDistance), 0.0, 1.0);
            float sunlight_direct = max(NdotL, 0.00001);
            total_effect += sunlight_color * (1.0 - wetness * 0.1 - rainStrength * 0.9) * mix(vec3(1.0), shading, shadow_fade) * SUNLIGHTAMOUNT * transition_fading * mix(sunlight_direct, 0.75, translucent);   // direct sun light
            
            vec3 nnormal = normalize(normal);
            total_effect += max(dot(nnormal, -neye), 0.00001) * heldLightSpecMultiplier * heldLightMagnitude / dist * no_hand;    // held light

            // spectral reflection on water - for sun and moon only
            const float fspec = 0.85;
            if (aux.g > fspec) {
                if (transition_fading > 0.999) {
                    spec = nspec(-neye, lightVector, nnormal);
                }
                else {
                    spec = nspec(-neye, lightOffset0, nnormal) + nspec(-neye, lightOffset3, nnormal);
                }
                spec *= (1.0 - rainStrength);
            }
            else {
                vec4 specularity = mix(texture2D(gdepth, texcoord.st), vec4(ambient_color, 2.0), 0.5);
                total_effect += (1.0 - rainStrength) * pow(nspec(-neye, lightVector, nnormal), specularity.a) * specularity.rgb * shading * no_hand * transition_fading;
            }
            vec3 compo_effect = total_effect;
            compo_effect += pow(aux.b * (1.0 - sss_transparency), TORCH_POWER) * TORCH_INTENSITY * torchcolor;
            compo *= mix(vec3(1.0), compo_effect, no_hand);
            total_effect += pow(aux.b, TORCH_POWER) * TORCH_INTENSITY * torchcolor;    // torch light
            color *= total_effect;
        }
        else {
            // sky and raining
            color = mix(color, gl_Fog.color.rgb, rainStrength * 0.1);
            compo = mix(compo, gl_Fog.color.rgb, rainStrength * 0.1);

#ifdef PERLIN_CLOUD
            vec3 eye = invproj(vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r));
            vec4 wpos = gbufferModelViewInverse * vec4(eye, 1.0);
            vec2 ncoord = (wpos.xz + cameraPosition.xz) * 0.033;
            ncoord.x += frameTimeCounter * 0.0165 - wpos.y * 0.011;
            ncoord.y -= wpos.y * 0.011;
            float noise = texture2D(noisetex, fract(ncoord * 0.03125)).r;
            noise += texture2D(noisetex, fract(ncoord * 0.0625)).r * 0.5;
            noise += texture2D(noisetex, fract(ncoord * 0.125)).r * 0.25;
            noise += texture2D(noisetex, fract(ncoord * 0.25)).r * 0.125;
            noise += texture2D(noisetex, fract(ncoord * 0.5)).r * 0.0625;
            noise += texture2D(noisetex, fract(ncoord * 1.0)).r * 0.03125;
            noise += texture2D(noisetex, fract(ncoord * 2.0)).r * 0.015625;
            float prob = (1.0 - aux.w) * clamp(noise, 0.0, 1.0);
            noise = noise * 0.25 + 1.0 - 0.5 * rainStrength;
            color = mix(compo, vec3(noise) * color, prob * 0.67);
            compo = mix(compo, vec3(noise) * color, prob * 0.67);
#endif
        }
    }
    else {  // eye in water
        vec3 watercolor = vec3(0.0225, 0.075, 0.135) * (ambient_color.r + ambient_color.g + ambient_color.b) * 1.5;
        float log_depth = ld(texture2D(depthtex2, texcoord.st).r) * 1.2;
        float depth_diff = min(log_depth * log_depth, 1.0) * no_hand;
        color = watercolor * mix(color, vec3(1.0), depth_diff);
    }

    color = clamp(color, 0.0, 1.0);
    compo = clamp(compo, 0.0, 1.0);

/* DRAWBUFFERS:03 */
    gl_FragData[0] = vec4(color, spec);	// gcolor in composite1.fsh
    gl_FragData[1] = vec4(compo, spec);	// composite in composite1.fsh
}

//////////////////////////////main//////////////////////////////
