#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##	
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/

//#define		wavingWater		// Warning! Could be very buggy!

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 worldposition;
varying float isWater;
varying float ambientNdotL;
varying float sunlightMat;
varying float weatherRatio;
varying float skyLightmap;
varying float torchLightmap;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;

uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform vec3 upPosition;

uniform int worldTime;

uniform float frameTimeCounter;
uniform float rainStrength;

attribute vec4 mc_Entity;

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0);
float TimeMidnight		= ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0) 
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));

float calcWaterWave(vec3 wPos) {

	const float waveHeight 		= 0.04;
	const float waveSpeed		= 2.0;
	const float waveResolution	= 5.0;

	float wave = 0.0; 
	
	#ifdef wavingWater
	
		vec3 coord = wPos * waveResolution;

		wave += waveHeight * sin(frameTimeCounter * waveSpeed + coord.x);
		wave += waveHeight * cos(frameTimeCounter * waveSpeed + coord.z);
		
	#endif
	
	return wave;

}

float dynamicWeather(float speed) {
	
	float value = 1.0;
		  value *= abs(sin(frameTimeCounter * speed * 1.2));
		  value *= abs(cos(frameTimeCounter * speed * 0.5));
		  value *= abs(sin(frameTimeCounter * speed * 2.0));
	
	// Raining.
	value = mix(value, 1.0, rainStrength);
		  
	return value;
	
}

float getSkyLightmap(vec2 coord) {

	float minLight = 0.07;

	return clamp(minLight + max(coord.t - 2.0 / 16.0, 0.0) * 1.14285714286, 0.0, 1.0);

}

float getTorchLightmap(vec2 coord, float skyL) {

	float torchlightDistance = 0.6;	// Higher means lower.
	float torchlightExposure = 5.0;
	
	torchlightDistance = mix(torchlightDistance, torchlightDistance * 2.0, skyL * TimeDay);
	torchlightExposure = mix(torchlightExposure, torchlightExposure / 2.0, skyL * TimeDay);

	float modlmap = 16.0 - coord.s * 15.7; 

	return clamp(pow(0.75 / (modlmap * modlmap) - 0.00315, torchlightDistance), 0.0, 1.0) * torchlightExposure;

}

void main() {

	isWater = 0.0;
	tangent = vec3(0.0);
	binormal = vec3(0.0);
	
	position 	= gl_ModelViewMatrix * gl_Vertex;
	texcoord	= gl_TextureMatrix[0] * gl_MultiTexCoord0;
	lmcoord		= gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	vec4 viewpos = gbufferModelViewInverse * position;
	vec3 worldPos = viewpos.xyz + cameraPosition;
	worldposition = worldPos;
	
	color = gl_Color;
	
	normal = normalize(gl_NormalMatrix * normalize(gl_Normal));
	
	if (mc_Entity.x == 8.0 || mc_Entity.x == 9.0) {
	
		viewpos.y += calcWaterWave(worldPos);
	
		isWater = 1.0;
	
	}
	
	viewpos = gbufferModelView * viewpos;
	
	gl_Position = gl_ProjectionMatrix * viewpos;
	
	float NdotL = dot(normal, normalize(sunPosition));

	ambientNdotL	= (worldTime > 12700 && worldTime < 23250)? -NdotL : NdotL;
	sunlightMat		= 0.0;

	ambientNdotL = max(ambientNdotL, 0.0);
	
	#ifdef enableDynamicWeather
		weatherRatio = dynamicWeather(weatherRatioSpeed);
	#else
		weatherRatio = rainStrength;
	#endif
	
	skyLightmap = getSkyLightmap(lmcoord.st);
	torchLightmap = getTorchLightmap(lmcoord.st, skyLightmap);

	
	if (gl_Normal.y > 0.5) {
		//  0.0,  1.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	} else if (gl_Normal.x > 0.5) {
		//  1.0,  0.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.x < -0.5) {
		// -1.0,  0.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.z > 0.5) {
		//  0.0,  0.0,  1.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.z < -0.5) {
		//  0.0,  0.0, -1.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.y < -0.5) {
		//  0.0, -1.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
						  tangent.y, binormal.y, normal.y,
						  tangent.z, binormal.z, normal.z);
	
}