#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/

#define tonemapping
//#define cinematicMode
//#define depthOfField
//#define bloom					// Not done yet. Dynamic tonemapping needs to be enabled!
#define jitter					// An effect, that is only active in the Nether or End.
//#define cameraNoise
#define	chromaticAberration

uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gaux1;
uniform sampler2D gaux4;
uniform sampler2D depthtex0;
uniform sampler2D depthtex2;
uniform sampler2D noisetex;

uniform vec3 sunPosition;

varying vec4 texcoord;
varying vec3 lightVector;
varying float weatherRatio;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;

uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float centerDepthSmooth;
uniform float frameTimeCounter;
uniform float rainStrength;

uniform int isEyeInWater;
uniform int worldTime;

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0);
float TimeMidnight		= ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0)
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));


float	getDepth		= texture2D(depthtex0, texcoord.xy).x;
vec2	texel			= vec2(1.0 / viewWidth, 1.0 / viewHeight);

float linearDepth(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float vec3ToFloat(vec3 vec3Input) {

	float floatValue  = 0.0;
		  floatValue += vec3Input.x;
		  floatValue += vec3Input.y;
		  floatValue += vec3Input.z;

		  floatValue /= 3.0;

	return floatValue;

}

const vec2 coordsOffsets28[28] = vec2[28](vec2(1.0, 0.0),
										  vec2(0.0, 1.0),

										  vec2(-1.0, 0.0),
										  vec2(0.0, -1.0),

										  vec2(0.5, 0.0),
										  vec2(0.0, 0.5),

										  vec2(-0.5, 0.0),
										  vec2(0.0, -0.5),

										  vec2(0.25, 0.0),
										  vec2(0.0, 0.25),

										  vec2(-0.25, 0.0),
										  vec2(0.0, -0.25),

										  vec2(1.0, 0.5),
										  vec2(0.5, 1.0),

										  vec2(-1.0, 0.5),
										  vec2(0.5, -1.0),

										  vec2(-0.5, 1.0),
										  vec2(1.0, -0.5),

										  vec2(-1.0, -0.5),
										  vec2(-0.5, -1.0),

										  vec2(0.5, 0.25),
										  vec2(0.25, 0.5),

										  vec2(-0.5, 0.25),
										  vec2(0.25, -0.5),

										  vec2(-0.25, 0.5),
										  vec2(0.5, -0.25),

										  vec2(-0.25, -0.5),
										  vec2(-0.5, -0.25));

vec3 doTonemapping(vec3 clr) {

	float gamma			= 1.0;
	float exposure		= 1.1;
	float darkness		= 0.03;
	float brightness	= 0.03;
	float saturation	= 1.07;		// Exposure should have the same value like saturation.
	
	#ifdef tonemapping

		clr = pow(clr, vec3(gamma));
		clr *= exposure;
		clr = max(clr - darkness, 0.0);
		clr = clr + brightness;

		float luma = dot(clr, vec3(1.0));
		vec3 chroma = clr - luma;
		clr = (chroma * saturation) + luma;
	
	#endif

	return clr;

}

vec3 doVignette(vec3 clr) {

	float vignetteStrength	= 3.0;
	float vignetteSharpness	= 5.0;

	float dist  = 1.0 - pow(distance(texcoord.st, vec2(0.5)), vignetteSharpness) * vignetteStrength;

	clr *= dist;

	return clr;

}

vec3 doCinematicMode(vec3 clr) {

	#ifdef cinematicMode

		if (texcoord.t > 0.9 || texcoord.t < 0.1) clr.rgb = vec3(0.0);

	#endif

	return clr;

}

vec3 doCameraNoise(vec3 clr) {

	float	noiseStrength	= 0.025;
	float	noiseResoltion	= 0.2;

	#ifdef cameraNoise

		vec2 aspectcorrect = vec2(aspectRatio, 1.0);

		vec3 rgbNoise = texture2D(noisetex, texcoord.st * noiseResoltion * aspectcorrect + vec2(frameTimeCounter)).rgb;

		clr = mix(clr, rgbNoise, vec3ToFloat(rgbNoise) * noiseStrength);

	#endif

	return clr;

}

vec3 doChromaticAberration(vec3 clr, vec2 coord) {

	float offsetMultiplier = 0.02;
	
	#ifdef jitter
		offsetMultiplier *= abs(sin(frameTimeCounter * 25) + cos(frameTimeCounter * 50));
	#endif

	#ifdef chromaticAberration

		float dist = pow(distance(coord.st, vec2(0.5)), 3.0);

		float rChannel = texture2D(gaux1, coord.st + vec2(offsetMultiplier * dist, 0.0)).r;
		float gChannel = texture2D(gaux1, coord.st).g;
		float bChannel = texture2D(gaux1, coord.st - vec2(offsetMultiplier * dist, 0.0)).b;

		clr = vec3(rChannel, gChannel, bChannel);

	#endif

	return clr;

}

vec3 renderDOF(vec3 clr, vec2 coord) {

	float		blurFactor			= 0.075;
	float		gaux2Mipmapping		= 25.0;		// Has to be tweaked manualy.

	vec3 blurSample = clr;

	#ifdef depthOfField

		vec2 aspectcorrect	= vec2(1.0, aspectRatio);

		float getDepth	= texture2D(depthtex2, coord.st).x;
		float focus		= getDepth - centerDepthSmooth;
		float factor	= focus * blurFactor;

		#ifdef chromaticAberration

			vec2 chromAberation = vec2(factor * 0.75, 0.0);
			
			#ifdef jitter
				chromAberation *= abs(sin(frameTimeCounter * 25) + cos(frameTimeCounter * 50));
			#endif

			for(int i = 0; i < 28; i++) {

				blurSample.r += texture2D(gaux1, coord.st + coordsOffsets28[i] * aspectcorrect * factor + chromAberation,	gaux2Mipmapping * abs(focus)).r;
				blurSample.g += texture2D(gaux1, coord.st + coordsOffsets28[i] * aspectcorrect * factor,					gaux2Mipmapping * abs(focus)).g;
				blurSample.b += texture2D(gaux1, coord.st + coordsOffsets28[i] * aspectcorrect * factor - chromAberation,	gaux2Mipmapping * abs(focus)).b;

			}

		#else

			for(int i = 0; i < 28; i++) {

				blurSample += texture2D(gaux1, coord.st + coordsOffsets28[i] * aspectcorrect * factor, gaux2Mipmapping * abs(focus)).rgb;

			}

		#endif

		blurSample /= 28.0;

	#endif


	return blurSample;

}

vec3 calcNaturalBloom(vec3 clr, vec2 coord) {

	float bloomIntensity	= 0.6;
	float bloomCover		= 0.3;
	
	#ifdef bloom

		vec2 aspectcorrect = vec2(1.0, aspectRatio);

		vec3 bloomColor  = vec3(0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 4.0).rgb - bloomCover, 0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 4.5).rgb - bloomCover, 0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 5.0).rgb - bloomCover, 0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 5.5).rgb - bloomCover, 0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 6.0).rgb - bloomCover, 0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 6.5).rgb - bloomCover, 0.0);
			 bloomColor += max(texture2D(gaux1, coord.st, 7.0).rgb - bloomCover, 0.0);

		bloomColor /= 7.0;

		// Desature bloom color.
		float luma = dot(bloomColor, vec3(1.0));
		vec3 chroma = bloomColor - luma;
		bloomColor = (chroma * (1.0 - bloomCover)) + luma;

		clr *= 1.0 - vec3ToFloat(bloomColor) * bloomIntensity;
		clr += bloomColor * bloomIntensity;

	#endif

	return clr;

}

vec2 doJitter(vec2 coord) {

	float jitterAmount = 0.002;
	
	float jitterX = 0.0;
	
	#ifdef jitter

		float dist			= distance(coord.st, vec2(0.5));
		float sinOffset		= 0.0;
		float cosOffset		= 0.0;
		float jitterFactor	= 0.0;

		float wave1 = sin(coord.y * 50.0	+ frameTimeCounter * 10.0);
		float wave2	= cos(coord.y * 100.0	+ frameTimeCounter * 5.0);
		float wave3	= sin(coord.y * 20.0	+ frameTimeCounter * 25.0) + cos(coord.y * 20.0 - frameTimeCounter * 50.0);
		
		if (wave1 > 0.1)	sinOffset		= 1.0;
		if (wave1 > -0.1)	sinOffset		= -1.0;
		
		if (wave2 > 0.1)	cosOffset		= 1.0;
		if (wave2 > -0.1)	cosOffset		= -1.0;
		
		if (wave3 > 0.7)	jitterFactor	= 1.0;
		if (wave3 < -0.7)	jitterFactor	= 0.0;
		
		jitterX = (sinOffset * jitterFactor + cosOffset * jitterFactor) * dist * jitterAmount;
	
	#endif
	
	return vec2(coord.x + jitterX, coord.y);

}

void main() {

	// Set up the basics.
	const bool gaux1MipmapEnabled		= true;			// For godrays.
	
	vec2 newTexcoord = doJitter(texcoord.st);

	// Get main color.
	vec4 color = texture2D(gaux1, newTexcoord.xy);

	// Set up positions.
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * getDepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;

	color.rgb = doChromaticAberration(color.rgb, newTexcoord.st);
	color.rgb = renderDOF(color.rgb, newTexcoord.st);
	color.rgb = calcNaturalBloom(color.rgb, newTexcoord.st);
	color.rgb = doCameraNoise(color.rgb);
	color.rgb = doTonemapping(color.rgb);
	color.rgb = doVignette(color.rgb);
	color.rgb = doCinematicMode(color.rgb);

   	gl_FragColor = color;

}
