#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##	
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/

//#define shakingCamera
#define	windyTerrain

float shadowMapBias = 0.75;	

varying vec4 texcoord;
varying vec4 color;


attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

uniform mat4 shadowProjectionInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

uniform vec3 cameraPosition;

uniform float frameTimeCounter;

float vec3ToFloat(vec3 vec3Input) {

	float floatValue  = 0.0;
		  floatValue += vec3Input.x;
		  floatValue += vec3Input.y;
		  floatValue += vec3Input.z;

		  floatValue /= 3.0;

	return floatValue;

}

vec3 calcMove(vec3 pos, float mcID, bool isWeldedToGround, float strength, float posRes) {

	#ifdef windyTerrain

		float onGround 	= 0.0;
		if (gl_MultiTexCoord0.t < mc_midTexCoord.t) onGround = 1.0;
		
		float speed = 4.0;
		
		float movementX = sin(frameTimeCounter * speed + pos.z * posRes + cameraPosition.z * posRes);
		float movementY = sin(frameTimeCounter * speed + pos.z * posRes + cameraPosition.z * posRes);
		float movementZ = sin(frameTimeCounter * speed + pos.x * posRes + cameraPosition.x * posRes);
		
		float windfallX = sin(frameTimeCounter * speed * 1.5 + pos.z * posRes + cameraPosition.z * posRes) * 1.5 * (1.0 - sin(frameTimeCounter * 0.6));
		float windfallZ = sin(frameTimeCounter * speed * 1.5 + pos.x * posRes + cameraPosition.x * posRes) * 1.5 * (1.0 - sin(frameTimeCounter * 0.6));
		
		if (isWeldedToGround) {
		
			if (mc_Entity.x == mcID && onGround > 0.9) {
			
				pos.x += (movementX + windfallX) * strength;
				pos.z += movementZ * strength;
				
			}
		
		} else {
		
			if (mc_Entity.x == mcID) {
			
				pos.x += (movementX + windfallX) * strength;
				pos.y += movementY * strength;
				pos.z += (movementZ + windfallZ) * strength;
			
			}
		
		}
	
	#endif
	
	return pos;

}

void main() {

	color = gl_Color;

	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;
	
	vec4 position = gl_Position;
		 position = shadowProjectionInverse * position;
		 position = shadowModelViewInverse * position;
	
	texcoord = gl_MultiTexCoord0;
	
	// Windy terrain.
	position.xyz = calcMove(position.xyz, 6.0, false, 0.01, 5.0);		// Saplings.
	position.xyz = calcMove(position.xyz, 18.0, false, 0.005, 10.0);		// Oak leaves.
	position.xyz = calcMove(position.xyz, 31.0, true, 0.03, 5.0);		// Grass.
	position.xyz = calcMove(position.xyz, 37.0, true, 0.01, 5.0);		// Yellow flower.
	position.xyz = calcMove(position.xyz, 38.0, true, 0.01, 5.0);		// Red flower and others.
	position.xyz = calcMove(position.xyz, 59.0, true, 0.02, 5.0);		// Wheat Crops.
	position.xyz = calcMove(position.xyz, 141.0, true, 0.01, 5.0);		// Carrots.
	position.xyz = calcMove(position.xyz, 142.0, true, 0.01, 5.0);		// Potatoes.
	position.xyz = calcMove(position.xyz, 161.0, false, 0.005, 10.0);	// Acacia leaves.
	
	#ifdef shakingCamera
		position.xy += vec2(0.01 * sin(frameTimeCounter * 2.0), 0.01 * cos(frameTimeCounter * 3.0));
	#endif
	
	position = shadowModelView * position;
	position = shadowProjection * position;
	
	gl_Position = position;
	
	float dist = sqrt(gl_Position.x * gl_Position.x + gl_Position.y * gl_Position.y);
	float distortFactor = (1.0f - shadowMapBias) + dist * shadowMapBias;
	gl_Position.xy *= 1.0f / distortFactor;
	

	if (mc_Entity.x == 79.0 || mc_Entity.x == 95.0 || mc_Entity.x == 160.0) gl_Position.xy *= 0.0;
	
	// Make it possible, to cast shadows underwater.
	if (mc_Entity.x == 8.0 || mc_Entity.x == 9.0) gl_Position.xy *= 0.0;

	gl_FrontColor = gl_Color;
	
}
