#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/

#define smoothShadows
//#define volumetricFog
#define	useDynamicTonemapping

varying vec4 color;
varying vec3 normal;
varying vec2 texcoord;
varying float ambientNdotL;
varying float sunlightMat;
varying float weatherRatio;
varying float skyLightmap;
varying float torchLightmap;
varying float emissiveLight;

uniform sampler2D texture;
uniform sampler2DShadow shadow;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform int fogMode;
uniform int worldTime;
uniform float wetness;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float near;
uniform float far;

uniform int heldBlockLightValue;
uniform int isEyeInWater;

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight		= ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0)
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));
										  
const vec2 coordsOffsets4[4] = vec2[4](vec2(1.0, 0.0),
									   vec2(0.0, 1.0),

									   vec2(-1.0, 0.0),
									   vec2(0.0, -1.0));
									   
float vec3ToFloat(vec3 vec3Input) {

	float floatValue  = 0.0;
		  floatValue += vec3Input.x;
		  floatValue += vec3Input.y;
		  floatValue += vec3Input.z;

		  floatValue /= 3.0;

	return floatValue;

}

float castShadows(vec4 worldPos, bool useNdotL) {

	const int shadowMapResolution = 2048;
	
	float shadowSmoothnessFactor	= 0.5;
	float shadowMapBias				= 0.75;	
	
	float NdotL = 1.0;
	if (useNdotL) NdotL = ambientNdotL;

	float shading	= 0.0;
	float step		= 1.0 / shadowMapResolution;

	if (NdotL > 0.00001) {

		worldPos = shadowModelView * worldPos;
		worldPos = shadowProjection * worldPos;
		worldPos /= worldPos.w;

		float distb = length(worldPos.st);
		float distortFactor = mix(1.0, distb, shadowMapBias);

		worldPos.xy /= distortFactor;

		if (max(abs(worldPos.x), abs(worldPos.y)) < 0.99) {

			float diffthresh = sunlightMat > 0.9? 0.001 : distortFactor * distortFactor * (0.006 * tan(acos(NdotL)) + 0.0006);

			worldPos = worldPos * 0.5f + vec4(0.5, 0.5, 0.5 - diffthresh, 0.5);

			#ifdef smoothShadows

				for(int i = 0; i < 4; i++) {	// Repeat the shading variable with different coords.

					shading += dot(shadow2D(shadow, vec3(worldPos.st + coordsOffsets4[i] * shadowSmoothnessFactor * step, worldPos.z)).x, pow(NdotL, 0.5));

				}

				shading /= 4.0;

			#else

				shading = dot(shadow2D(shadow, vec3(worldPos.st, worldPos.z)).x, pow(NdotL, 0.5));

			#endif


		} else {
		
			shading = dot(1.0,  pow(NdotL, 0.5));
		
		}
		
	}
	
	// Remove shadows, when the player is underwater.
	if (isEyeInWater > 0.9) shading = 0.0;

	return shading;

}

float volumetricRays() {

	float	vlRenderQuality			= 2.5;	// Lower means better.
	float	vlDensity				= 75.0;

	float vlRays = 0.0;
	float result = 1.0;
	
	#ifdef volumetricFog
	
		result = 0.0;
	
		for (vlRays; vlRays < distance(texcoord.x, vlDensity);) {
			
			float getDepth = (far * ((vlRays + 1.0) - near)) / ((vlRays + 1.0) * (far - near));

			vec4 fragpos	= gbufferProjectionInverse * (vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), getDepth * gl_FragCoord.z, 1.0) * 2.0 - 1.0);
			vec4 worldPos	= gbufferModelViewInverse * fragpos;
			
			result += castShadows(worldPos, false);
			vlRays += vlRenderQuality;

		}
		
		result /= vlDensity / vlRenderQuality;
	
	#endif
	
	return result;
	
}

float dynamicTonemapping(float exposureStrength, bool reserveLightmap, bool addExposure, bool dayOnly) {

	float dTonemap = 1.0;

	#ifdef useDynamicTonemapping
	
		float dTlightmap	= pow(eyeBrightnessSmooth.y / 240.0, 2.0);		if (reserveLightmap)	dTlightmap 	= 1.0 - dTlightmap;
			  dTonemap		= dTlightmap * exposureStrength;				if (addExposure)		dTonemap	= 1.0 + dTonemap;		if (dayOnly)	dTonemap = mix(dTonemap, 1.0, TimeMidnight);	// Full exposure on midnight.

	#endif
	
	return dTonemap;

}

vec3 doEmissiveLight(vec3 clr, vec3 originalClr) {

	float exposure	= 2.5;
	float cover		= 0.3;
	
	if (emissiveLight > 0.9) clr = mix(clr.rgb, originalClr.rgb * exposure, vec3ToFloat(max(originalClr.rgb - cover, 0.0)));
	
	return clr;

}


void main() {

	vec4 baseColor = texture2D(texture, texcoord.xy) * color;


	vec4 fragposition	= gbufferProjectionInverse * (vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
	vec4 worldposition	= gbufferModelViewInverse * fragposition;

	// Adjustable variables.
	float ambientStrength		= 0.8;
	float sunlightStrength		= 1.3;

	// Set up colors.
	vec3 ambient_Color  = vec3(0.0);
		 ambient_Color += vec3(0.75, 0.8, 1.0)	* 0.6	* TimeSunrise;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeNoon;
		 ambient_Color += vec3(0.75, 0.8, 1.0)	* 0.6	* TimeSunset;
		 ambient_Color += vec3(0.6, 0.75, 1.0)	* 0.13	* TimeMidnight;

		 ambient_Color *= 1.0 - weatherRatio;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeSunrise	* weatherRatio;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeNoon		* weatherRatio;
		 ambient_Color += vec3(0.75, 0.8, 1.0)			* TimeSunset	* weatherRatio;
		 ambient_Color += vec3(0.6, 0.75, 1.0)	* 0.13 	* TimeMidnight	* weatherRatio;

	vec3 sunlight_Color  = vec3(0.0);
		 sunlight_Color += vec3(1.0, 0.7, 0.5)	* 0.6	* TimeSunrise;
		 sunlight_Color += vec3(1.0, 0.9, 0.8)			* TimeNoon;
		 sunlight_Color += vec3(1.0, 0.7, 0.5)	* 0.6	* TimeSunset;
		 sunlight_Color += vec3(0.6, 0.75, 1.0)	* 0.05	* TimeMidnight;
		 sunlight_Color *= DayToNightFading;
		 sunlight_Color *= 1.0 - weatherRatio;
		 
	vec3 torch_Color = vec3(1.0, 0.65, 0.4);

	// Desature ambient color at nighttime.
	float saturation = (1.0 - TimeMidnight * 0.5) + (torchLightmap * TimeMidnight * 0.5);
	float luma = dot(baseColor.rgb, vec3(1.0));
	vec3 chroma = baseColor.rgb - luma;
	vec3 noLight = (chroma * saturation) + luma;

	vec3 newTorchLightmap	= baseColor.rgb * torch_Color * torchLightmap;
	vec3 ambientLightmap	= noLight.rgb * ambient_Color * ambientStrength;
	vec3 sunlightLightmap	= noLight.rgb * sunlight_Color * castShadows(worldposition, true) * sunlightStrength;

	ambientLightmap		   *= dynamicTonemapping(0.75, true, true, true);
	sunlightLightmap	   *= dynamicTonemapping(0.75, true, true, true);

	vec3 newLightmap		= (ambientLightmap + sunlightLightmap) * skyLightmap + newTorchLightmap;
		 newLightmap		= doEmissiveLight(newLightmap.rgb, baseColor.rgb);

/* DRAWBUFFERS:01 */

	gl_FragData[0] = vec4(newLightmap, baseColor.a);
	gl_FragData[1] = vec4(skyLightmap, volumetricRays(), 1.0, 1.0);	// gdepth


}
