#version 120

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
uniform int isEyeInWater;
	//#define USE_WATER_TEXTURE
	vec4 watercolor = vec4(0.01,0.02,0.05,0.6)*(1.0-isEyeInWater*0.7); 	//water color and opacity (r,g,b,opacity)

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 viewVector;
varying vec3 wpos;
varying float iswater;
varying float reflectiveObjects;
varying float viewdistance;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform int worldTime;
uniform float rainStrength;
uniform float frameTimeCounter;

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 25000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

float waterH(vec2 posxz) {

	vec2 movement = vec2(-abs(frameTimeCounter/2000.-0.5),-abs(frameTimeCounter/2000.-0.5));
	vec2 movement2 = vec2(abs(frameTimeCounter/2000.-0.5),abs(frameTimeCounter/2000.-0.5));

	vec2 coord = (posxz/600)+(movement);
	vec2 coord1 = (posxz/599)+(movement2);
	vec2 coord2 = (posxz/598)+(movement);
	vec2 coord3 = (posxz/597)+(movement2);

	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x/8;
			noise += texture2D(noisetex,fract(coord1.xy)).x/16.0;
			noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/8;
			noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/8;

return noise;
}

vec3 stokes(in float ka, in vec3 k, in vec3 g) {
    // ka = wave steepness, k = displacements, g = gradients / wave number
    float theta = k.x + k.z + k.t;
    float s = ka * (sin(theta) + ka * sin(2.0f * theta));
    return vec3(s * g.x, s * g.z, g.t);  // (-deta/dx, -deta/dz, scale)
}

vec3 waves1(in float bumpmult) {
    float scale = 8.0f / (viewdistance * viewdistance);
    vec3 gg = vec3(scale, 3600.0f, scale);
    vec3 gk = vec3(viewdistance * 6.0f, frameTimeCounter * -6.0f, 0.0f);
    vec3 gwave = stokes(10.0f*bumpmult*10.0, gk, gg);
    return normalize(gwave);
}

float smoothStep(in float edge0, in float edge1, in float x) {
    float t = clamp((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
    return t * t * (3.0f - 2.0f * t);
}

vec3 getWaveHeight(vec3 posxz){

	vec2 coord = (posxz.xz + posxz.y);

		float deltaPos = 0.3;

		//float fc = (find_closest(texcoord.st,deltaPos));
		float h0 = waterH(coord);
		float h1 = waterH(coord + vec2(deltaPos,0.0));
		float h2 = waterH(coord + vec2(-deltaPos,0.0));
		float h3 = waterH(coord + vec2(0.0,deltaPos));
		float h4 = waterH(coord + vec2(0.0,-deltaPos));

		float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
		float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

		vec3 wave = normalize(vec3(xDelta,yDelta,1.0-pow(abs(xDelta+yDelta),2.0)));

		return wave;
}


//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	vec4 tex = vec4((watercolor*length(texture2D(texture, texcoord.xy).rgb*color.rgb)*color).rgb,watercolor.a);
	#ifdef USE_WATER_TEXTURE
	if (iswater > 0.9)  tex = texture2D(texture, texcoord.xy)*color;
	#else
	if (iswater < 0.9)  tex = texture2D(texture, texcoord.xy)*color;
	#endif

	vec3 posxz = wpos.xyz;

	vec4 frag2;
		frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);
	vec4 frag3;
		frag3 = vec4((normal) * 0.5f + 0.5f, 1.0f);


		float bumpmult = 0.05;

		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);

		vec3 bump = getWaveHeight(posxz);
			bump = bump;

		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
	if (iswater > 0.9) {
		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
		frag3 = vec4(normalize(waves1(0.05) * tbnMatrix) * 0.5 + 0.5, 1.0);
	}


/* DRAWBUFFERS:0245 */
	gl_FragData[0] = tex;
	gl_FragData[1] = vec4(frag2);
	gl_FragData[2] = vec4(lmcoord.t, mix(1.0,0.05,iswater), lmcoord.s, 1.0);
	gl_FragData[3] = vec4(mix(1.0,0.32,reflectiveObjects),0,0,1);
}
