#version 120
#extension GL_ARB_shader_texture_lod : enable

#define MAX_COLOR_RANGE 48.0

//disabling is done by adding "//" to the beginning of a line.

//***************************ADJUSTABLE VARIABLES***************************//
//***************************ADJUSTABLE VARIABLES***************************//
//***************************ADJUSTABLE VARIABLES***************************//

//***************************VISUALS***************************//

#define VIGNETTE
	#define VIGNETTE_STRENGTH 1.0
	#define VIGNETTE_SIZE 0.85

#define LENS_EFFECTS
	#define LENS_STRENGTH 0.25
	//#define DIRTY_LENS


//***************************BLOOM***************************//

#define BLOOM
	#define B_TRESH 0.2
	#define B_RAD 5.0					//sampling circle size multiplier, don't affect performance
	#define B_INTENSITY 1.0		//basic multiplier

//***************************DOF***************************//

const bool DOF = false; 		//If you want to enable this, also uncomment uniform float centerDepthSmooth; to use it and, remove the /* and the */ from the DoF function.

	#define DOF_MULT 1.0
//#define TILT_SHIFT 					//to let everything look small. more for cinematic purposes
	#define TILT_SHIFT_MULT 1.0		//simple multiplier
#define FRINGE_DOF						//to give the dof a rainbow look
	#define FRINGE_AMOUNT 1.0		//the amound of fringe
//#define DISTANCE_BLUR					//to let the background fade out
	#define DISTANCE_BLUR_MULT 1.0	//simple multiplier
	#define DISTANCE_BLUR_DIST 1.0	//distance

//***************************COLORS***************************//


#define DYNAMIC_EXPOSURE					//Makes brighter inside and turned off outside
	#define DYNAMIC_EXPOSURE_AMOUNT 1.0		//Strength

//***************************EFFECTS***************************//

//#define TV_SCREEN_EFFECT		//Just for fun. Enable to get like an old screen effect.


//#define MOVIE_BORDER


#define CALCULATE_EXPOSURE					//Makes darker spots in the water darker. How deeper, the darker it gets.


//#define POSTERIZE							//Limits the amount of tints in the RGB channels. Looks like 8 bit if you put POSTERIZE_NUM on 8
	#define POSTERIZE_NUM 8					//Amount of Tints


//#define CHROMATIC_ABBORATION				//Not compatible with dof
	#define ABBORATION_STRENGHT 1.0
	
#define RAIN_DROP

//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//

const bool		gcolorMipmapEnabled		= 	true; //gcolor texture mipmapping

varying vec4 texcoord;
varying vec3 sunlight;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
varying vec3 ambient_color;
varying vec3 lightVector;

varying vec2 getHeadBob;

uniform sampler2D gaux1;
uniform sampler2D gcolor;
uniform sampler2D noisetex;
uniform sampler2D gdepthtex;
uniform sampler2D gnormal;
uniform sampler2D composite;

uniform mat4 gbufferProjection;

uniform ivec2 eyeBrightnessSmooth;

uniform int isEyeInWater;
uniform int worldTime;

uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;

//uniform float centerDepthSmooth; //For DoF

uniform vec3 upPosition;

vec3 sunPos = sunPosition;

uniform int fogMode;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

float comp = 1.0-near/far/far;			//distance above that are considered as sky

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float matflag = texture2D(gaux1,texcoord.xy).g;
float matflaga = texture2D(gaux1,texcoord.xy).a;

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;

vec4 aux = texture2D(gaux1, texcoord.xy);

vec4 Tc = texcoord;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}


#ifdef TILT_SHIFT
const float focal = 2.0;
float aperture = 0.6;
const float sizemult = 0.25*TILT_SHIFT_MULT;
#else
const float focal = 0.005;
float aperture = 0.009;
const float sizemult = 100.0*DOF_MULT;
#endif

const vec2 circle_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);

int iswater = int(matflag > 0.04 && matflag < 0.07);
int land = int(matflag < 0.03);
bool land2 = texture2D(gdepthtex, texcoord.st).r < comp;

float hand = float(matflag > 0.75 && matflag < 0.85);

float islava = float(matflaga > 0.50 && matflaga < 0.55);

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;

vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

return sqrt(xvect*xvect + yvect*yvect);
}


vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}


	float smoothCircleDist (in float lensDist) {

		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
			 tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 lightPos = tpos.xy/tpos.z*lensDist;
			 lightPos = (lightPos + 1.0f)/2.0f;

		return distratio(lightPos.xy, texcoord.xy, aspectRatio);

	}


vec3 genlens(vec3 lenscolor, float dist, float size, vec4 tpos, float sun) {

	vec2 lightPos = tpos.xy/tpos.z*dist; lightPos = (lightPos + 1.0f)/2.0f;
    float lensFlare = max(pow(max(1 - pow(min(distratio(lightPos.xy, texcoord.xy, aspectRatio),size)/size,10.0)/1,0.1),5.0)-0.1,0);
    return clamp(lensFlare, 0.0, 1.0) * lenscolor * 0.5 * sun * (1.0-rainStrength);
}


vec3 genlensFloatingAna(vec3 lenscolor, float dist, float size, float stretch, vec4 tpos, float sun) {

	vec2 lightPos = tpos.xy/tpos.z*dist; lightPos = (lightPos + 1.0f)/2.0f;
    float lensFlare = max(pow(max(1 - pow(min(distratio(lightPos.xy, texcoord.xy, aspectRatio/(stretch/size)),size)/size,10.0)/1,0.1),5.0)-0.1,0);
    return clamp(lensFlare, 0.0, 1.0) * lenscolor * 0.5 * sun * (1.0-rainStrength);
}


vec3 calcExposure(vec3 color) {
         float maxx = 0.25;
         float minx = 2.0;

         float exposure = max(pow(aux.r + aux.g * iswet, -0.4), 0.0)*maxx + minx;

         color.rgb /= vec3(exposure);

         return color.rgb;
}

vec3 dynamicExposure(vec3 color) {
		return color.rgb * clamp((-eyeBrightnessSmooth.y+230)/100.0,0.0,1.0)*0.5*(1-TimeMidnight)*(1-rainx)*DYNAMIC_EXPOSURE_AMOUNT;
}

vec3 getVignette(vec3 color, float size) {

	float dv = distance(Tc.st, vec2(0.5, 0.5));

	dv *= VIGNETTE_STRENGTH;

	dv = size - dv;

	dv = pow(dv, 0.25);

	dv *= 2.3;
	dv -= 0.9;

	color *= dv;

	return color;
}


vec3 getTvScreen(vec3 color, vec2 pos) {

	vec2 poss = (texcoord.st);
	vec3 posscolor = vec3(1);

	poss *= 500.0;
	poss -= (1.0* (frameTimeCounter/0.5) / pos.y);

	color *= vec3(sin(cos(poss.y-0.5) * 3.14259)) + normalize(vec3(posscolor))*1.0;

	return color;
}

#ifdef DIRTY_LENS
float getDirtyLensPattern(vec2 Pos) {

	vec2 coord = (Pos.xy);

	float Lens = texture2D(noisetex,(coord)/2).x;
	Lens += texture2D(noisetex,(coord)).x/2;
	Lens += texture2D(noisetex,(coord)*2).x/4;
	Lens += texture2D(noisetex,(coord)*4).x/8;
	Lens += texture2D(noisetex,(coord)).x/2;
	Lens += texture2D(noisetex,(coord)*2).x/4;
	Lens += texture2D(noisetex,(coord)*4).x/8;

	float strength = max(Lens-1.6,0.0);
	float dL = 0.5;
	float L = (1.0 - (pow(dL,strength)));

	return L;
}
#endif

/*
float getShine(vec2 Pos, vec2 lP) {

	vec2 movement = vec2(0.0,fract(frameTimeCounter/1000.0));
	movement += lP;

	vec2 coord = (Pos.xy/60);

	float Lens = texture2D(noisetex,(coord+movement)/2).x;

	float strength = max(Lens-0.5,0.0);
	float dL = 0.5;
	float L = (1.0 - (pow(dL,strength)));

	return L;
}
*/

float getShine2(vec2 Pos) {

	vec2 coord = (Pos.xy/3);

	float Lens = texture2D(noisetex,(coord)/2).x;

	return Lens;
}


vec3 alphablend(vec3 c, vec3 ac, float a) {

	vec3 n_ac = normalize(ac)*(1/sqrt(3.));
	vec3 nc = sqrt(c*n_ac);
	return mix(c,nc,a);
}

#ifdef RAIN_DROP
float waterDrop (vec2 tc) {
	vec2 drop = vec2(0.0,fract(frameTimeCounter/750.0));
	tc.x *= 10;
	float noise = texture2D(noisetex,(tc+drop)/2).x;
	noise += texture2D(noisetex,(tc+drop)).x/2;
	noise += texture2D(noisetex,(tc+drop)*2).x/4;
	noise += texture2D(noisetex,(tc+drop)*4).x/8;
	noise += texture2D(noisetex,(tc+drop*0.5)).x/2;
	noise += texture2D(noisetex,(tc+drop*0.5)*2).x/4;
	noise += texture2D(noisetex,(tc+drop*0.5)*4).x/8;
	float dropstrength = max(noise-1.8,0.0);
	float wdrop = 0.1;
	float waterD = (1.0 - (pow(wdrop,dropstrength)));
	waterD *= clamp((eyeBrightnessSmooth.y-220)/15.0,0.0,1.0)*rainStrength;
	return waterD;
}
#endif


vec3 getPosterize(vec3 color, float numPos) {
	return floor((color)*numPos)/numPos;
}

vec3 getBorder(vec3 color) {

	if (texcoord.t > 0.9 || texcoord.t < 0.1 )
				color.rgb = color.rgb*0;
	return color;
}

void getExposure(inout vec3 color){
	color *= 1.25;
}


void convertFinalToHDR(inout vec3 color){

	vec3 MaxExp = color * 4.0;
	vec3 MinExp = color / 8.0;


	vec3 getHDR = mix(MinExp,MaxExp,color.rgb);

	color = getHDR;
}

void tonemap(inout vec3 color){

	color = color / (color + 1.0) * (2.0 + 1.0);
	color.r = pow(color.r, 1.0);
	color.g = pow(color.g, 1.0);
	color.b = pow(color.b, 1.0);

}

void Uncharted2Tonemap(inout vec3 color, vec3 lim) {
	float D = 0.05;
	float E = 0.05;
	float F = 1.5;
	float W = MAX_COLOR_RANGE;
	vec3 tonemap = ((color*(1.75*color+0.5*1.0)+D*E)/(color*(1.75*color+1.0)+D*F))-E/F;
	vec3 tonemap2 = ((lim*(1.75*lim+0.5*1.0)+D*E)/(lim*(1.75*lim+1.0)+D*F))-E/F;

	vec3 curr = tonemap;
	vec3 whiteScale = 0.9f / tonemap2;
	color = curr*whiteScale;
}

void TonemapReinhardLum(inout vec3 color) {

	color.rgb *= 1.0f;

	float lum = dot(color.rgb, vec3(0.2125f, 0.7154f, 0.0721f));

	float white = 21.0f;
	float lumTonemap = (lum * (1.0f + (lum / white))) / (1.0f + lum);


	float factor = lumTonemap / lum;

	color.rgb *= factor;

	color.rgb = pow(color.rgb, vec3(1.0f / 2.2f)); //Put color into gamma space for correct display
	color.rgb *= 1.1f;
}

void burghessTonemap(inout vec3 color){

   vec3 x = color-0.004;
   vec3 retColor = (x*(6.2*x+.7))/(x*(6.2*x+1.7)+0.12);
   color = retColor;
}

void simpleReinhardToneMapping(inout vec3 color)
{
	float exposure = 1.5;
	color *= exposure/(1. + color / exposure);
	color = pow(color, vec3(1. / 2.2));
}

void linTonemap(inout vec3 color) {

	color = pow(color, vec3(1.5));
   vec3 texColor = color;
   vec3 retColor = pow(texColor,vec3(1/2.2));
   color = vec3(retColor);
}

void robobo1221sTonemap(inout vec3 color){

	vec3 x = (color - 0.02);
	vec3 cout = ((3.7*x+0.2) / (3.7*x+0.6));
		cout = pow(cout, vec3(2.2));

	color = cout;

}

void simpleRobobosTonemap(inout vec3 color){

	vec3 x = color;
	vec3 cout = (2.0 * x) / (x + 0.25) * 0.5;

	color = cout;

}

void BarteropeTonemap(inout vec3 color){
 vec3 V = (color - 0.08);
 vec3 cMult = vec3(3);
 float curve= 2.2;

 float R = 1.0;
 float G = 1.0;
 float B = 1.0;


 color.r = (color.r*R);
 color.g = (color.g*G);
 color.b = (color.b*B);

 color = ((2.45*V+0.154)/(2.45*V+1.0));

 color = pow(color ,vec3(curve));


color = color*cMult;
}

void tonemapBurgessLum(inout vec3 color) {

 vec3 x = max(vec3(0.0), color - 0.001);
 vec3 retColor = (x * (6.4 * x + 0.55)) / (x * (6.4 * x + 1.5) + 0.1);
 color = retColor;
}

#ifdef BLOOM

vec3 calcBloom(inout vec3 color, in vec2 fake_refract, in vec2 fake_refract2){

	vec3 csample;
	float weight;
	
	float plum = luma(color.rgb);
	float underCover = clamp((-eyeBrightnessSmooth.y+230)/100.0,0.0,1.0);
	
	float b_exp = B_INTENSITY * ( 1. - ((rainStrength) + ( TimeMidnight))* -1.25 );
	float b_tresh = B_TRESH * 1.0;
	float b_rad = B_RAD * 2.0;

	float lod_rad = b_rad;
	
			for ( int i = 0; i < 6; i++ ) {
					csample += texture2DLod(gcolor,Tc.xy + (fake_refract * 0.001 + (fake_refract2 * 0.001)),lod_rad*0.125*(1.0 + (i))).rgb;
					weight += 1.0;
			}

		float csampleVisibility = length(max((csample/weight*b_exp*(1.0-TimeMidnight*-1))-plum*0.75-b_tresh,0.0));
		color = mix(color,csample,csampleVisibility/weight);

		return color;
}

#endif

#ifdef CHROMATIC_ABBORATION

vec3 getAbboration(vec2 fake_refract, vec2 fake_refract2, in vec3 col){

	float alpha = distance(texcoord.st, vec2(0.5));
	alpha = pow(alpha, 6.0);

	vec3 color;
	color.r = texture2D(gcolor,texcoord.st + vec2(0.1,0.0)*(alpha/aspectRatio)*ABBORATION_STRENGHT + (fake_refract * 0.001 + (fake_refract2 * 0.001))).r;
	color.g = texture2D(gcolor,texcoord.st + vec2(0.0)*(alpha/aspectRatio)*ABBORATION_STRENGHT + (fake_refract * 0.001 + (fake_refract2 * 0.001))).g;
	color.b = texture2D(gcolor,texcoord.st + vec2(-0.1,0.0)*(alpha/aspectRatio)*ABBORATION_STRENGHT + (fake_refract * 0.001 + (fake_refract2 * 0.001))).b;

	col = color;

	return col;
}

#endif

#ifdef LENS_EFFECTS

	void getLensFlare(inout vec3 color){
		float time = float(worldTime);
		float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));

		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 pos1 = tpos.xy/tpos.z;
		vec2 lightPos = pos1*0.5+0.5;


			vec3 lightVector;
		if (worldTime < 12700 || worldTime > 23250) {
			lightVector = normalize(sunPosition);
		} else {
			lightVector = normalize(moonPosition);
		}

		float xdist = abs(lightPos.x-texcoord.x);
		float ydist = abs(lightPos.y-texcoord.y);
		float xydist = distance(lightPos.xy,Tc.xy);

		float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
		float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

		float sunvisibility = min(texture2D(gcolor,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;

		float truepos = 1-clamp(lightVector.z/abs(lightVector.z),0.0,1.0);

		float centerdist = distance(lightPos.xy,vec2(0.5))/1.0;
		float sizemult = 2.0 + centerdist;
		float noise = fract(sin(dot(Tc.st ,vec2(18.9898f,28.633f))) * 4378.5453f)*0.1 + 0.9;

		float sun = sunvisibility;
		float h = TimeMidnight;
		float r = rainStrength;
		float uW = isEyeInWater;

		float visibility = max(pow(max(1.0 - smoothCircleDist(1)/.75,.1),2)-.1,0);

		float visibility2 = max(pow(max(1.0 - smoothCircleDist(1)/.7,.1),2)-.1,0);
		float visibility3 = max(pow(max(1.0 - smoothCircleDist(1)/.2,.1),2)-.1,0);

			if (sun < 0.05) {
				} else if (isEyeInWater > 0.9) {
					} else if (rainStrength > 0.9) {
						} else {

							float anamorphic_lens = exp(-ydist*ydist/(0.0001*(1-(visibility))))*exp(-xdist*xdist/0.1)*sun*(1-TimeMidnight*0.9) * (1-rainStrength);
							float anamorphic_lens2 = exp(-ydist*ydist/(0.00001))*exp(-xdist*xdist/0.1)*sun*(1-TimeMidnight*0.9) * (1-rainStrength) * visibility;
							float glow = exp(-ydist*ydist/0.06)*exp(-xdist*xdist/0.06)*sun * (1-rainStrength);

							color.rgb += (vec3(0.0,0.2,1.0)*anamorphic_lens*LENS_STRENGTH)* truepos;
							color.rgb += (vec3(1+sunlight)*clamp(anamorphic_lens2, 0.0, 0.9)*LENS_STRENGTH)* truepos;

							//glow
							//color.rgb += (vec3(sunlight*2)*glow*(1-TimeNoon)*LENS_STRENGTH)* truepos;

							//dirty lens
							#ifdef DIRTY_LENS
							color += ((((sunlight+ambient_color)*8+2)*(getDirtyLensPattern(texcoord.xy/25)*visibility)*sun)*truepos)*0.15*(1-r)*(1-TimeNoon*0.75)*(1-TimeMidnight*0.9)*(1-TimeSunrise*0.5)*(1-TimeSunset*0.5);
							#endif

							//fake rays
							//color.rgb += color.rgb*(((sunlight+ambient_color)*4+8)*clamp(getShine(normalize(texcoord.xy - lightPos.xy), lightPos/150),0.0, 0.9)*visibility2*(1.0-visibility3)) * sun * truepos * (1-TimeMidnight) * (1-r);

							////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

							vec3 c1 = vec3(0.1,0.3,0.4)/3 * (1-h) * (1-uW) * LENS_STRENGTH * truepos, c2 = vec3(0.0,0.0,0.02) * (1-h) * (1-uW) * LENS_STRENGTH * truepos;
							vec3 c3 = vec3(0.0,0.06,0.06) * (1-h) * (1-uW) * LENS_STRENGTH * truepos, c4 = vec3(0.0,0.4,0.2) * (1-h) * (1-uW) * LENS_STRENGTH * truepos;
							vec3 c5 = vec3(0.0,0.07,0.2) 	* (1-h) * (1-uW) * LENS_STRENGTH * truepos;

							vec3 c6 = vec3(0.05,0.25,1)/4 * h * LENS_STRENGTH * truepos;

							vec3 cr = vec3(2,.0,.0)*4*(1-(1-land)*0.5) * (1-h) * (1-uW) * LENS_STRENGTH * truepos;
							vec3 cb = vec3(.0,.0,2)*4*(1-(1-land)*0.5) * (1-h) * (1-uW) * LENS_STRENGTH * truepos;
							vec3 cg = vec3(.0,2,.0)*4*(1-(1-land)*0.5) * (1-h) * (1-uW) * LENS_STRENGTH * truepos;


							//day

							//front

							color += genlens(c3*4, 0.246, 0.032*1, tpos, sun * (1-r));
							color += genlens(c3*4, 0.273, 0.025*1, tpos, sun * (1-r));
							color += genlens(c3*4, 0.282, 0.020*1, tpos, sun * (1-r));
							color += genlens(c3*4, 0.291, 0.015*1, tpos, sun * (1-r));
							color += genlens(c3*4, 0.3, 0.013*1, tpos, sun * (1-r));
							color += genlens(c3*4, 0.31, 0.012*1, tpos, sun * (1-r));
							color += genlens(c3*4, 0.32, 0.011*1, tpos, sun * (1-r));


							color += genlens(c1, -0.255, 0.014, tpos, sun * (1-r));
							color += genlens(c1, -0.26, 0.014, tpos, sun * (1-r));
							color += genlens(c1, -0.265, 0.014, tpos, sun * (1-r));
							color += genlens(c1, -0.27, 0.015, tpos, sun * (1-r));
							color += genlens(c1, -0.275, 0.016, tpos, sun * (1-r));
							color += genlens(c1, -0.28, 0.017, tpos, sun * (1-r));
							color += genlens(c1, -0.285, 0.018, tpos, sun * (1-r));
							color += genlens(c1, -0.29, 0.019, tpos, sun * (1-r));
							color += genlens(c1, -0.295, 0.021, tpos, sun * (1-r));
							color += genlens(c1, -0.3, 0.025, tpos, sun * (1-r));
							color += genlens(c1, -0.305, 0.029, tpos, sun * (1-r));
							color += genlens(c1, -0.315, 0.034, tpos, sun * (1-r));

							color += genlens(c2*2, -0.300, 0.14, tpos, sun * (1-r));
							color += genlens(c3*2, -0.320, 0.14, tpos, sun * (1-r));

							color += genlens(c1, -0.44, 0.008, tpos, sun * (1-r));
							color += genlens(c1, -0.45, 0.01, tpos, sun * (1-r));
							color += genlens(c4, -0.46, 0.013, tpos, sun * (1-r));
							color += genlens(c4, -0.47, 0.015, tpos, sun * (1-r));
							color += genlens(c4, -0.48, 0.018, tpos, sun * (1-r));
							color += genlens(c4, -0.49, 0.024, tpos, sun * (1-r));
							color += genlens(c4, -0.50, 0.03, tpos, sun * (1-r));

							color += genlens(c2*3, -0.55, 0.1, tpos, sun * (1-r));

							color += genlens(c3+c5*5, -1.0, 0.02, tpos, sun * (1-r));

							//moonshapes

							//////////////////////////////////////////////////////////////

							vec3 L1 = genlens(c3, -0.90, 0.31/2, tpos, sun * (1-r));
							vec3 L2 = genlens(c3, -1.00, 0.30/2, tpos, sun * (1-r));

							vec3 mL = clamp(L2 - L1, 0.0, 1.0);
							color += mL * sun * (1.0-rainStrength*1.0)*16;

							//////////////////////////////////////////////////////////////

							vec3 L11 = genlens(cr+(cg*0.5), -0.80, 0.11, tpos, sun * (1-r));
							vec3 L21 = genlens(cr+(cg*0.5), -0.86, 0.10, tpos, sun * (1-r));

							vec3 mL0 = clamp(L21 - L11, 0.0, 1.0);
							color += mL0 * sun * (1.0-rainStrength*1.0)*0.2;

							//////////////////////////////////////////////////////////////

							vec3 L3 = genlens(cr, -0.9, 0.505/3, tpos, sun * (1-r));
							vec3 L3s = genlens(cr, -0.91, 0.50/3, tpos, sun * (1-r));

							vec3 L4 = genlens(cg, -0.92, 0.505/3, tpos, sun * (1-r));
							vec3 L4s = genlens(cg, -0.93, 0.50/3, tpos, sun * (1-r));

							vec3 L5 = genlens(cb, -0.94, 0.505/3, tpos, sun * (1-r));
							vec3 L5s = genlens(cb, -0.95, 0.50/3, tpos, sun * (1-r));

							vec3 mL1 = clamp(L3s - L3, 0.0, 1.0);
							vec3 mL2 = clamp((L4s - L4) - mL1, 0.0, 1.0);
							vec3 mL3 = clamp((L5s - L5) - mL2, 0.0, 1.0);

							color += mL1 * sun * (1.0-rainStrength*1.0)*2;
							color += mL2 * sun * (1.0-rainStrength*1.0)*2;
							color += mL3 * sun * (1.0-rainStrength*1.0)*2;

							//////////////////////////////////////////////////////////////

							vec3 L6 = genlens(cr, 0.20, 0.31, tpos, sun * (1-r));
							vec3 L6s = genlens(cr, 0.18, 0.30, tpos, sun * (1-r));

							vec3 L7 = genlens(cg, 0.16, 0.30, tpos, sun * (1-r));
							vec3 L7s = genlens(cg, 0.14, 0.29, tpos, sun * (1-r));

							vec3 L8 = genlens(cb, 0.12, 0.29, tpos, sun * (1-r));
							vec3 L8s = genlens(cb, 0.1, 0.28, tpos, sun * (1-r));

							vec3 mL4 = clamp(L6s - L6, 0.0, 1.0);
							vec3 mL5 = clamp(L7s - L7, 0.0, 1.0);
							vec3 mL6 = clamp(L8s - L8, 0.0, 1.0);

							color += mL4 * sun * (1.0-rainStrength*1.0)*4;
							color += mL5 * sun * (1.0-rainStrength*1.0)*4;
							color += mL6 * sun * (1.0-rainStrength*1.0)*4;

							//////////////////////////////////////////////////////////////

							vec3 L9 = genlensFloatingAna((c3*8)+(cb*.5), -1.40, 0.025, 1.7, tpos, sun * (1-r)) * 2;
							vec3 L9s = genlens((c3*8)+(cb*.5), 1.5, 2.50, tpos, sun * (1-r)) * 2;

							vec3 mL7 = clamp(L9 - L9s, 0.0, 1.0);
							color += mL7 * sun * (1.0-rainStrength*1.0)*4;

							//////////////////////////////////////////////////////////////


							vec3 aL1 = genlens(cg + cb, -0.9 / 3, 0.50/6, tpos, sun * (1-r));
							vec3 aL1s = genlens(cg + cb, -0.94 / 3, 0.505/6, tpos, sun * (1-r));

							vec3 amL2 = max(aL1 - aL1s, 0.0);

							vec3 aL2 = genlens(cr + cg, -0.9 / 5, 0.50/7, tpos, sun * (1-r));
							vec3 aL2s = genlens(cr + cg, -0.94 / 5, 0.505/7, tpos, sun * (1-r));

							vec3 amL3 = max(aL2 - aL2s, 0.0);

							color += amL2 * sun * (1.0-rainStrength*1.0)*1.5;
							color += amL3 * sun * (1.0-rainStrength*1.0)*3;

							//////////////////////////////////////////////////////////////

							//back

							//color += genlensFloatingAna(vec3(0.0,0.1,0.5),  1.95, 0.01, 0.1, tpos, sun * (1-r) * (1-h) * (1-uW) * truepos);
							//color += genlensFloatingAna(vec3(0.0,0.1,0.5),  1.65, 0.01, 0.1, tpos, sun * (1-r) * (1-h) * (1-uW) * truepos);
							//color += genlensFloatingAna(vec3(0.0,0.1,0.5),  1.25, 0.01, 0.1, tpos, sun * (1-r) * (1-h) * (1-uW) * truepos);

							//rings
							float ringsSize = 0.25;
							float ringsExp = 0.25;

							color += (genlens(cr*5*ringsExp, 1.0, 1.0*ringsSize, tpos, sun * (1-r)) + -genlens(cr*5*ringsExp, 1.0, 0.97*ringsSize, tpos, sun * (1-r)))*getShine2(normalize(texcoord.xy*1.0 - lightPos.xy));
							color += (genlens(cg*5*ringsExp, 1.0, 1.05*ringsSize, tpos, sun * (1-r))+ -genlens(cg*5*ringsExp, 1.0, 1.025*ringsSize, tpos, sun * (1-r)))*getShine2(normalize(texcoord.xy*1.0 - lightPos.xy));
							color += (genlens(cb*5*ringsExp, 1.0, 1.1*ringsSize, tpos, sun * (1-r)) + -genlens(cb*5*ringsExp, 1.0, 1.075*ringsSize, tpos, sun * (1-r)))*getShine2(normalize(texcoord.xy*1.0 - lightPos.xy));


							//night
							color += genlens(c6, -0.4, 0.01, tpos, sun * (1-r));
							color += genlens(c6, -0.9, 0.05, tpos, sun * (1-r));
							color += genlens(c6, -1.7, 0.1, tpos, sun * (1-r));




						}

	}
#endif

//VOID MAIN//

void main() {
	vec2 fake_refract;
	vec2 fake_refract2;

	fake_refract = vec2(sin(frameTimeCounter*2.0 + Tc.x*0.0 + Tc.y*25.0),cos(frameTimeCounter*2.0 + Tc.y*0.0 + Tc.x*50.0)) *isEyeInWater;
	#ifdef RAIN_DROP
		fake_refract2 = vec2(sin(frameTimeCounter*1.0 + Tc.x*0.0 + Tc.y*100.0),cos(frameTimeCounter*1.0 + Tc.y*0.0 + Tc.x*200.0))*waterDrop(texcoord.xy/300)*10 ;
	#endif

	const float lifetime = 3.0;
	float ftime = frameTimeCounter*2.0/lifetime;

	vec2 pos = (noisepattern(vec2(-0.94386347*floor(ftime*0.5+0.25),floor(ftime*0.5+0.25)))-0.5)*0.85+0.5;

	vec3 color = texture2D(gcolor,texcoord.st + (fake_refract * 0.001 + (fake_refract2 * 0.001))).rgb;

#ifdef CHROMATIC_ABBORATION
	color = getAbboration(fake_refract, fake_refract2, color);
#endif

#ifdef BLOOM
	color = (calcBloom(color, fake_refract, fake_refract2));
#endif

	/* // remove for enable
	if (DOF) {
		if (hand > 0.9) {
			} else {
				//Calculate pixel Circle of Confusion that will be used for bokeh depth of field
				float z = ld(texture2D(gdepthtex, Tc.st).r)*far;
				float focus = ld(centerDepthSmooth)*far;
				float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*10.0);
				vec4 sample = vec4(0.0);
				vec3 bcolor = vec3(0.0);
				float nb = 0.0;
				vec2 bcoord = vec2(0.0);
				float disblur = 1-(exp(-pow(ld(texture2D(gdepthtex, Tc.st).r)/(256.0*DISTANCE_BLUR_DIST)*far,4.0)*4.0));
				#ifdef DISTANCE_BLUR
				pcoc += min(disblur*pw*20.0*DISTANCE_BLUR_MULT,pw*20.0*DISTANCE_BLUR_MULT);
				#endif

				for ( int i = 0; i < 20; i++) {
					#ifdef FRINGE_DOF

					sample.r = texture2D(gcolor, Tc.xy + circle_offsets[i]*pcoc*vec2(1.0,aspectRatio) + vec2(0.75*FRINGE_AMOUNT*pcoc) + (fake_refract * 0.001 + (fake_refract2 * 0.001))).r;
					sample.g = texture2D(gcolor, Tc.xy + circle_offsets[i]*pcoc*vec2(1.0,aspectRatio) + (fake_refract * 0.001 + (fake_refract2 * 0.001))).g;
					sample.b = texture2D(gcolor, Tc.xy + circle_offsets[i]*pcoc*vec2(1.0,aspectRatio) - vec2(0.75*FRINGE_AMOUNT*pcoc) + (fake_refract * 0.001 + (fake_refract2 * 0.001))).b;
					#else
					sample = texture2D(gcolor, Tc.xy + circle_offsets[i]*pcoc*vec2(1.0,aspectRatio) + (fake_refract * 0.001 + (fake_refract2 * 0.001)));

					#endif


					bcolor += sample.rgb;
					bcolor *= (1-hand);
				}
				color.rgb = bcolor/20.0;
			}
	}
	*/ // remove for enable


	#ifdef VIGNETTE
		color.rgb = getVignette(color, VIGNETTE_SIZE);
	#endif


	#ifdef CALCULATE_EXPOSURE
		if (isEyeInWater < 0.9) {
			} else if (!land2){
				} else {
					color.rgb = calcExposure(color);
				}
	#endif


	#ifdef DYNAMIC_EXPOSURE
		color.rgb += dynamicExposure(color);
	#endif

	convertFinalToHDR(color);
	getExposure(color);
	//simpleReinhardToneMapping(color);
	//TonemapReinhardLum(color);
	//Uncharted2Tonemap(color, vec3(MAX_COLOR_RANGE));
	//burghessTonemap(color);
	//tonemapBurgessLum(color);
	robobo1221sTonemap(color);
	//BarteropeTonemap(color); //Not Compatible With convertFinalToHDR
	//simpleRobobosTonemap(color);
	//linTonemap(color);
	//tonemap(color);
	
	#ifdef LENS_EFFECTS
		getLensFlare(color);
	#endif


	#ifdef TV_SCREEN_EFFECT
		color = getTvScreen(color, pos.xy);
	#endif


	#ifdef MOVIE_BORDER
	color = getBorder(color);
	#endif


	#ifdef POSTERIZE
		color = getPosterize(color, POSTERIZE_NUM);
	#endif


/////////////////////////////////////////////////////////////////////////////////////

	color = clamp(color,0.0,1.0);

/////////////////////////////////////////////////////////////////////////////////////

	gl_FragColor = vec4(color.rgb, 1.0);

}
